/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.IValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportCommonValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.BatchExtendValidator;

public class OrgAddImportValidator
implements IValidator<ImportValidationModel> {
    private ImportCommonValidator importCommonValidator;
    private List<BatchExtendValidator> batchExtendValidators;

    public OrgAddImportValidator(ImportCommonValidator importCommonValidator, List<BatchExtendValidator> batchExtendValidators) {
        this.importCommonValidator = importCommonValidator;
        this.batchExtendValidators = batchExtendValidators;
    }

    @Override
    public List<CalibratorBean> validate(ImportValidationModel importValidationModel, Object ... args) {
        DynamicObject adminorgHrDy;
        boolean cudeRule;
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        List<CalibratorBean> calibratorBeanList = this.importCommonValidator.validateNotNullableProp(curRowData, Arrays.asList("name", "number", "adminorgtype", "establishmentdate", "adminorg", "parentorg"));
        DynamicObject opEntity = curRowData.getOpEntity();
        String orgNumber = opEntity.getString("number");
        if (HRStringUtils.isEmpty((String)orgNumber) && !(cudeRule = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)(adminorgHrDy = AdminOrgBatchChgHelper.getAdminorgHrDy((DynamicObject)opEntity)), (String)String.valueOf(importValidationModel.getOrg())))) {
            String displayName = ((IDataEntityProperty)opEntity.getDynamicObjectType().getProperties().get((Object)"number")).getDisplayName().getLocaleValue();
            calibratorBeanList.add(new CalibratorBean("OrgAddImportValidator_0", ResManager.loadKDString((String)"\u6570\u636e\u884c\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff1a%s", (String)"OrgAddImportValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[]{displayName}));
        }
        calibratorBeanList.addAll(this.importCommonValidator.baseDataWithBuCheck(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.orgNameAndNumberCheck(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.doParentOrgCheck(importValidationModel, ImportConstants.CHANGE_TYPE_ADD_NEW));
        calibratorBeanList.addAll(this.importCommonValidator.validateCoopRelLoop(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateEstablishmentDate(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateOrg4LayerModel(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateChangeInfo(importValidationModel, ImportConstants.CHANGE_TYPE_ADD_NEW));
        calibratorBeanList.addAll(this.importCommonValidator.validateCompanyAreaCity(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateIndex());
        calibratorBeanList.addAll(this.importCommonValidator.validateFiledTextLength(ImportCommonValidator.getTextLenNeedCheckProps()));
        this.executeExtendValidator(importValidationModel, this.batchExtendValidators, calibratorBeanList, BatchExtendValidator.ADD_SCENE);
        return calibratorBeanList;
    }
}

