/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.common.model.CoopInfoModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationHelper;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;

public class OrgCoopRelLoopValidator {
    private static final Log LOG = LogFactory.getLog(OrgCoopRelLoopValidator.class);
    private Map<String, List<CoopInfoModel<String>>> affiliationRelFromMainData;
    private Map<String, List<CoopInfoModel<String>>> affiliationRelFromApplyingChg;
    private Map<String, List<CoopInfoModel<String>>> affiliationRelInCurExcel;
    private int curBatchNo = Integer.MAX_VALUE;
    private boolean inited = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ImportValidationModel importValidationModel) {
        if (this.curBatchNo != importValidationModel.curBatchNo) {
            this.curBatchNo = importValidationModel.curBatchNo;
            this.affiliationRelInCurExcel = importValidationModel.curExcelAffiliationRelInfos;
        }
        if (this.inited) {
            return;
        }
        Object object = importValidationModel.lock;
        synchronized (object) {
            if (this.inited) {
                return;
            }
            this.affiliationRelFromMainData = this.getAffiliationRelationInfoFromMainData(importValidationModel.getEffDate());
            this.affiliationRelFromApplyingChg = this.getAffiliationRelationInfoFromApplyingOrg();
            this.inited = true;
        }
    }

    public List<CalibratorBean> validate(ImportValidationModel importValidationModel) {
        this.init(importValidationModel);
        String curOrgNumber = ImportValidationHelper.getCurOrgNumber(importValidationModel);
        String curParentOrgNumber = ImportValidationHelper.getParentOrgNumber(importValidationModel);
        if (HRStringUtils.isNotEmpty((String)curOrgNumber) && HRStringUtils.isNotEmpty((String)curParentOrgNumber)) {
            return this.orgAffiliationLoopCheck(importValidationModel, curOrgNumber, curParentOrgNumber);
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    private List<CalibratorBean> orgAffiliationLoopCheck(ImportValidationModel importValidationModel, String curOrgNumber, String curParentOrgNumber) {
        ArrayList calibratorBeanList = Lists.newArrayListWithCapacity((int)2);
        AtomicBoolean existLoop = new AtomicBoolean(false);
        if (HRStringUtils.equalsIgnoreCase((String)curOrgNumber, (String)"null") || HRStringUtils.equalsIgnoreCase((String)curParentOrgNumber, (String)"null")) {
            return calibratorBeanList;
        }
        LOG.info(String.format(Locale.ROOT, "curOrgNumber = %s, curParentOrgNumber = %s", curOrgNumber, curParentOrgNumber));
        HashSet alreadyCheckedOrgNumbers = Sets.newHashSet((Object[])new String[]{curOrgNumber});
        String loopedOrgNumber = this.loopCheckUseDFS(alreadyCheckedOrgNumbers, curParentOrgNumber, existLoop, importValidationModel.getEffDate(), OrgChgUtil.getDefaultBsled(), false);
        if (existLoop.get() && HRStringUtils.equals((String)loopedOrgNumber, (String)curOrgNumber)) {
            calibratorBeanList.add(new CalibratorBean("OrgCoopRelLoopValidator_0", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"OrgCoopRelLoopValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            return calibratorBeanList;
        }
        LOG.info(String.format(Locale.ROOT, "checking applying loop curOrgNumber = %s, curParentOrgNumber = %s", curOrgNumber, curParentOrgNumber));
        alreadyCheckedOrgNumbers.clear();
        alreadyCheckedOrgNumbers.add(curOrgNumber);
        loopedOrgNumber = this.loopCheckUseDFS(alreadyCheckedOrgNumbers, curParentOrgNumber, existLoop, importValidationModel.getEffDate(), OrgChgUtil.getDefaultBsled(), true);
        if (existLoop.get() && HRStringUtils.equals((String)loopedOrgNumber, (String)curOrgNumber)) {
            calibratorBeanList.add(new CalibratorBean("OrgCoopRelLoopValidator_1", ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u5728\u9014\u5355\u636e\u4e2d\u81ea\u5df1\u7684\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"OrgCoopRelLoopValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        return calibratorBeanList;
    }

    private String loopCheckUseDFS(Set<String> alreadyCheckedOrgNumbers, String parentOrgNumber, AtomicBoolean existLoop, Date bsed, Date bsled, boolean isCheckApplying) {
        if (existLoop.get() || HRStringUtils.isEmpty((String)parentOrgNumber)) {
            return null;
        }
        if (!alreadyCheckedOrgNumbers.add(parentOrgNumber)) {
            existLoop.set(true);
            return parentOrgNumber;
        }
        List<CoopInfoModel<String>> coopInfoModels = null;
        if (this.affiliationRelInCurExcel.containsKey(parentOrgNumber)) {
            coopInfoModels = this.affiliationRelInCurExcel.get(parentOrgNumber);
        } else if (isCheckApplying) {
            if (this.affiliationRelFromApplyingChg.containsKey(parentOrgNumber)) {
                coopInfoModels = this.affiliationRelFromApplyingChg.get(parentOrgNumber);
            } else if (this.affiliationRelFromMainData.containsKey(parentOrgNumber)) {
                coopInfoModels = this.affiliationRelFromMainData.get(parentOrgNumber);
            }
        } else if (this.affiliationRelFromMainData.containsKey(parentOrgNumber)) {
            coopInfoModels = this.affiliationRelFromMainData.get(parentOrgNumber);
        }
        if (coopInfoModels != null) {
            for (CoopInfoModel<String> coopInfoModel : coopInfoModels) {
                if (HRStringUtils.equals((String)((String)coopInfoModel.getOrg()), (String)((String)coopInfoModel.getCoopOrg()))) {
                    return (String)coopInfoModel.getOrg();
                }
                Date coopBsed = coopInfoModel.getBsed();
                Date coopBsled = coopInfoModel.getBsled();
                if (coopBsed.compareTo(bsled) > 0 || coopBsled.compareTo(bsed) < 0) continue;
                return this.loopCheckUseDFS(alreadyCheckedOrgNumbers, (String)coopInfoModel.getCoopOrg(), existLoop, coopBsed, coopBsled, isCheckApplying);
            }
        }
        return null;
    }

    private Map<String, List<CoopInfoModel<String>>> getAffiliationRelationInfoFromApplyingOrg() {
        Object[] applyingChangeBill = ImportValidationHelper.queryApplyingChangeBill();
        if (ObjectUtils.isEmpty((Object[])applyingChangeBill)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, Date> billIdEffDateMap = Arrays.stream(applyingChangeBill).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDate("effdt")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter qFilter = new QFilter("billid", "in", billIdEffDateMap.keySet());
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id,billid,adminorg.number,parentorg.number", new QFilter[]{qFilter});
        ArrayList coopInfos = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            CoopInfoModel coopInfoModel = new CoopInfoModel();
            String number = dynamicObject.getString("adminorg.number");
            String parentNumber = dynamicObject.getString("parentorg.number");
            if (StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)parentNumber)) continue;
            coopInfoModel.setOrg((Object)number);
            coopInfoModel.setCoopOrg((Object)parentNumber);
            coopInfoModel.setCooprelType(Long.valueOf(1010L));
            Date bsed = billIdEffDateMap.get(dynamicObject.getLong("billid"));
            if (bsed == null) continue;
            coopInfoModel.setBsed(bsed);
            coopInfoModel.setBsled(OrgChgUtil.getDefaultBsled());
            coopInfos.add(coopInfoModel);
        }
        return this.sortCoopInfoModelByBsed(coopInfos);
    }

    private Map<String, List<CoopInfoModel<String>>> getAffiliationRelationInfoFromMainData(Date queryDate) {
        long startTimeStamp = System.currentTimeMillis();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter hisQFilter = AdminOrgHisServiceHelper.queryHisQFilter((Date)queryDate, (boolean)true);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("boid,number,parentorg.number,bsed,bsled", new QFilter[]{hisQFilter, enableFilter});
        List<CoopInfoModel<String>> coopInfos = ((Stream)Stream.of(dynamicObjects).parallel()).map(object -> {
            CoopInfoModel coopInfoModel = new CoopInfoModel();
            coopInfoModel.setOrg((Object)object.getString("number"));
            coopInfoModel.setCoopOrg((Object)object.getString("parentorg.number"));
            coopInfoModel.setCooprelType(Long.valueOf(1010L));
            coopInfoModel.setBsed(object.getDate("bsed"));
            coopInfoModel.setBsled(object.getDate("bsled"));
            return coopInfoModel;
        }).collect(Collectors.toList());
        LOG.info(String.format(Locale.ROOT, "OrgCoopRelLoopValidator.getAffiliationRelationInfoFromMainData() cost %s milliseconds, and the size of coopInfoModel is %s", System.currentTimeMillis() - startTimeStamp, coopInfos.size()));
        return this.sortCoopInfoModelByBsed(coopInfos);
    }

    private Map<String, List<CoopInfoModel<String>>> sortCoopInfoModelByBsed(List<CoopInfoModel<String>> coopInfos) {
        Map<String, List<CoopInfoModel<String>>> coopInfoModelMap = coopInfos.stream().collect(Collectors.groupingBy(CoopInfoModel::getOrg));
        coopInfoModelMap.values().forEach(coopInfoModels -> coopInfoModels.sort(Comparator.comparing(CoopInfoModel::getBsed)));
        return coopInfoModelMap;
    }
}

