/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.validcommon.OrgBatchCheckConstants;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.common.model.CalibratorBean;
import kd.hr.homs.formplugin.web.impo.impvalidator.IValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportCommonValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.BatchExtendValidator;

public class OrgInfoChgImportValidator
implements IValidator<ImportValidationModel> {
    private ImportCommonValidator importCommonValidator;
    private List<BatchExtendValidator> batchExtendValidators;

    public OrgInfoChgImportValidator(ImportCommonValidator importCommonValidator, List<BatchExtendValidator> batchExtendValidators) {
        this.importCommonValidator = importCommonValidator;
        this.batchExtendValidators = batchExtendValidators;
    }

    @Override
    public List<CalibratorBean> validate(ImportValidationModel importValidationModel, Object ... args) {
        List<CalibratorBean> calibratorBeanList = this.importCommonValidator.validateOrg(importValidationModel, ImportConstants.CHANGE_TYPE_INFO);
        calibratorBeanList.addAll(this.importCommonValidator.validateNotNullableProp(ImportValidationModel.rowData.get(), Arrays.asList("name", "number", "adminorgtype", "adminorg", "parentorg")));
        calibratorBeanList.addAll(this.importCommonValidator.baseDataWithBuCheck(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.orgNameAndNumberCheck(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateEstablishmentDate(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateOrg4LayerModel(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateChangeInfo(importValidationModel, ImportConstants.CHANGE_TYPE_INFO));
        calibratorBeanList.addAll(this.importCommonValidator.validateCompanyAreaCity(importValidationModel));
        calibratorBeanList.addAll(this.importCommonValidator.validateIndex());
        calibratorBeanList.addAll(this.importCommonValidator.validateFiledTextLength(ImportCommonValidator.getTextLenNeedCheckProps()));
        calibratorBeanList.addAll(this.doParentOrgCheck(importValidationModel));
        calibratorBeanList.addAll(this.doRootOrgTypeCheck(importValidationModel));
        this.executeExtendValidator(importValidationModel, this.batchExtendValidators, calibratorBeanList, BatchExtendValidator.INFO_SCENE);
        return calibratorBeanList;
    }

    private List<CalibratorBean> doParentOrgCheck(ImportValidationModel importValidationModel) {
        DynamicObject parentOrg = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("parentorg");
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        if (parentOrg != null) {
            long oldParentOrgId;
            long parentOrgId = parentOrg.getLong("id");
            DynamicObject curOrg = ImportValidationModel.rowData.get().getOpEntity().getDynamicObject("adminorg");
            if (curOrg != null && parentOrgId != (oldParentOrgId = importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id")).getLong("parentorg.id"))) {
                errorList.add(new CalibratorBean("OrgInfoChgImportValidator_1", ResManager.loadKDString((String)"\u53d8\u66f4\u4fe1\u606f\u4e0d\u5141\u8bb8\u8c03\u6574\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"OrgInfoChgImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
        return errorList;
    }

    private List<CalibratorBean> doRootOrgTypeCheck(ImportValidationModel importValidationModel) {
        Long orgTypeId;
        DynamicObject dynamicObject;
        DynamicObject opEntity = ImportValidationModel.rowData.get().getOpEntity();
        ArrayList errorList = Lists.newArrayListWithCapacity((int)1);
        long orgID = opEntity.getLong("adminorg.id");
        if (orgID != 0L && (dynamicObject = importValidationModel.curBatchChgOrgInfoInDB.get(orgID)) != null && dynamicObject.getString("parentorg") == null && !OrgBatchCheckConstants.LEVEL4_COMPANY_GROPU.contains(orgTypeId = Long.valueOf(opEntity.getLong("adminorgtype.id")))) {
            errorList.add(new CalibratorBean("OrgChgFeasibleCheckServiceImpl_11", ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u53ea\u80fd\u4e3a\u201c%s\u201d", (String)"OrgChgFeasibleCheckServiceImpl_11", (String)"odc-homs-business", (Object[])new Object[0]), new Object[]{OrgBatchBillCheckHelper.groupCompanyStr()}));
        }
        return errorList;
    }
}

