/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.impo.impvalidator;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.common.constants.MultiLangEnum;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.CoopInfoModel;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.constants.impo.ImportConstants;
import kd.hr.homs.formplugin.web.impo.MultiSheetImportHelper;
import kd.hr.homs.formplugin.web.impo.importdata.MultiSheetRowData;
import kd.hr.homs.formplugin.web.impo.impvalidator.DisableChgImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.IValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportCommonValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationHelper;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationModel;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidationService;
import kd.hr.homs.formplugin.web.impo.impvalidator.ImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.MergeOrgImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.Org4LayerModelValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgAddImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgCoopRelLoopValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.OrgInfoChgImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ParentChgImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.SplitOrgImportValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.BatchExtendValidator;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.DefaultImportValidatorExtend;
import kd.hr.homs.formplugin.web.impo.impvalidator.ext.IImportValidatorExtend;
import kd.sdk.odc.homs.service.IOrgBatchBillServiceExtend;

public class OrgMultiSheetImportValidator
implements ImportValidator {
    private static final Log LOG = LogFactory.getLog(OrgMultiSheetImportValidator.class);
    private static final Integer MULTI_THREAD_THRESHOLD = 100;
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"OrgMultiSheetImportValidatorThreadPool", (int)1, (int)4);
    final Object lock = new Object();
    Map<String, Integer> maxIndexUnderOrgMap = Maps.newHashMapWithExpectedSize((int)16);
    private ImportValidationModel importValidationModel;
    private Map<String, IValidator<ImportValidationModel>> validatorCache = Maps.newHashMapWithExpectedSize((int)4);
    private boolean inited = false;
    private Set<String> basicCopyIgnoreKeys;
    private Map<Long, DynamicObject> orgTypeMap = Maps.newHashMapWithExpectedSize((int)4);
    private List<MultiSheetRowData> cachedStopUseRowData = Lists.newArrayListWithCapacity((int)16);
    private List<MultiSheetRowData> cachedAllRowData = Lists.newArrayListWithCapacity((int)16);
    private PatternUtil patternUtil = new PatternUtil();
    private NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();

    private void init(Map<String, Object> customParams) {
        this.importValidationModel = new ImportValidationModel();
        this.importValidationModel.setOrg(Long.parseLong(customParams.get("org") + ""));
        this.importValidationModel.setOrgName(String.valueOf(customParams.get("org.name")));
        this.importValidationModel.setChangeTypeInfo(ImportValidationHelper.queryBaseDataInfo("haos_orgchangetype", "id,name", this.importValidationModel.getOrg(), false));
        ImportValidationHelper.constructApplyingChgInfos(this.importValidationModel.applyingOrgNumbers, this.importValidationModel.applyingOrgNameUnderParent, this.importValidationModel.applyingChgTypeOrgMap, this.importValidationModel.billNoOrgMap, this.importValidationModel.applyingChgOrgMap, this.importValidationModel.inWayOrgBoIdMap);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgentityadd", ImportConstants.CHANGE_TYPE_ADD_NEW);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgentityparent", ImportConstants.CHANGE_TYPE_PARENT);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgentityinfo", ImportConstants.CHANGE_TYPE_INFO);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgentitydisab", ImportConstants.CHANGE_TYPE_DISABLE);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgmerge", ImportConstants.CHANGE_TYPE_MERGE);
        this.importValidationModel.getEntryNumberChgTypeMap().put("homs_batchorgsplit", ImportConstants.CHANGE_TYPE_SPLIT);
        ImportValidationHelper.orgTypeAndTypeStdMap(this.importValidationModel.orgTypeAndTypeStdMap, this.importValidationModel.orgTypeStdIdAndTypeNameMap, this.orgTypeMap, this.importValidationModel.getOrg());
        ImportCommonValidator importCommonValidator = new ImportCommonValidator(new OrgCoopRelLoopValidator(), new Org4LayerModelValidator());
        List<BatchExtendValidator> extendValidators = this.getExtendValidator();
        this.validatorCache.put("homs_batchorgentityadd", new OrgAddImportValidator(importCommonValidator, extendValidators));
        this.validatorCache.put("homs_batchorgentityparent", new ParentChgImportValidator(importCommonValidator, extendValidators));
        this.validatorCache.put("homs_batchorgentityinfo", new OrgInfoChgImportValidator(importCommonValidator, extendValidators));
        this.validatorCache.put("homs_batchorgentitydisab", new DisableChgImportValidator(importCommonValidator, extendValidators));
        this.validatorCache.put("homs_batchorgmerge", new MergeOrgImportValidator(importCommonValidator, extendValidators));
        this.validatorCache.put("homs_batchorgsplit", new SplitOrgImportValidator(importCommonValidator, extendValidators));
        String effDate = (String)customParams.get("effDate");
        try {
            this.importValidationModel.setEffDate(HRDateTimeUtils.parseDate((String)effDate, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
        }
        this.inited = true;
    }

    private List<BatchExtendValidator> getExtendValidator() {
        PluginProxy importValidatorExtendPluginProxy = PluginProxy.create((Object)new DefaultImportValidatorExtend(), IImportValidatorExtend.class, (String)"kd.hr.homs.formplugin.web.impo.impvalidator.ext.importvalid");
        ArrayList batchExtendValidators = Lists.newArrayListWithCapacity((int)16);
        importValidatorExtendPluginProxy.callReplace(plugin -> {
            LOG.info(String.format("proxy plugin: %s", plugin.getClass()));
            LOG.info("before callReplace getExtendValidator");
            List<BatchExtendValidator> extendValidators = plugin.getExtendValidator();
            if (extendValidators != null) {
                batchExtendValidators.addAll(extendValidators);
            }
            LOG.info("after callReplace getExtendValidator");
            return null;
        });
        return batchExtendValidators;
    }

    @Override
    public void doValidate(List<MultiSheetRowData> curBatchData, Map<String, ImportLogger> importLoggerMap, Map<String, Object> customParams) {
        if (CollectionUtils.isEmpty(curBatchData)) {
            return;
        }
        this.beforeValidateDataProcess(curBatchData, customParams, importLoggerMap);
        this.doValidationAndAfterValidationProcess(curBatchData, importLoggerMap, customParams);
    }

    private void doValidationAndAfterValidationProcess(List<MultiSheetRowData> curBatchData, Map<String, ImportLogger> importLoggerMap, Map<String, Object> customParams) {
        if (CollectionUtils.isEmpty(curBatchData)) {
            return;
        }
        if (curBatchData.size() < MULTI_THREAD_THRESHOLD) {
            new ImportValidationService(curBatchData, this.importValidationModel, importLoggerMap, this.validatorCache, this.lock).validate();
        } else {
            this.multiThreadValidate(curBatchData, importLoggerMap);
        }
        if (MultiSheetImportHelper.isValidationPass(importLoggerMap)) {
            this.setBasicCopyIgnoreKeysAndTransKey();
            this.afterDataValidatePassProcess(curBatchData, customParams);
        }
    }

    private void multiThreadValidate(List<MultiSheetRowData> curBatchData, Map<String, ImportLogger> importLoggerMap) {
        int batchSize = curBatchData.size();
        int threadCount = batchSize < 200 ? 2 : (batchSize < 300 ? 3 : 4);
        int numPerBatch = batchSize / threadCount;
        ArrayList futures = Lists.newArrayListWithCapacity((int)threadCount);
        for (int i = 0; i < threadCount; ++i) {
            List<MultiSheetRowData> perBatchData = i == threadCount - 1 ? curBatchData.subList(i * numPerBatch, batchSize) : curBatchData.subList(i * numPerBatch, (i + 1) * numPerBatch);
            futures.add(threadPool.submit((Callable)new ImportValidationService(perBatchData, this.importValidationModel, importLoggerMap, this.validatorCache, this.lock)));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public List<MultiSheetRowData> finalStopUseChgValidate(Map<String, ImportLogger> importLoggerMap, Map<String, Object> customParams) {
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)4);
        this.cachedStopUseRowData.forEach(rowData -> {
            DynamicObject curOrg = rowData.getOpEntity().getDynamicObject("adminorg");
            if (curOrg != null && !this.importValidationModel.curBatchChgOrgInfoInDB.containsKey(curOrg.getLong("id"))) {
                orgIds.add(curOrg.getLong("id"));
            }
        });
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            this.importValidationModel.curBatchChgOrgInfoInDB.putAll(ImportValidationHelper.batchQueryOrgInfoByIds(orgIds));
        }
        this.doValidationAndAfterValidationProcess(this.cachedStopUseRowData, importLoggerMap, customParams);
        return this.cachedStopUseRowData;
    }

    public List<MultiSheetRowData> finalTobeDisabledValidate(Map<String, ImportLogger> importLoggerMap, Map<String, Object> customParams) {
        HashSet newNameSet = Sets.newHashSet();
        HashSet newNumberSet = Sets.newHashSet();
        HashSet orgIdSet = Sets.newHashSet();
        HashSet cityIds = Sets.newHashSet();
        HashSet parentBoIds = Sets.newHashSet();
        for (MultiSheetRowData curRowData : this.cachedAllRowData) {
            this.parseData(curRowData, newNameSet, newNumberSet, orgIdSet, cityIds, parentBoIds, importLoggerMap.get(curRowData.getMainEntity()));
        }
        this.prepareDataForValidation(newNameSet, newNumberSet, orgIdSet, cityIds, parentBoIds);
        this.doValidationAndAfterValidationProcess(this.cachedAllRowData, importLoggerMap, customParams);
        return this.cachedAllRowData;
    }

    private void afterDataValidatePassProcess(List<MultiSheetRowData> curBatchData, Map<String, Object> customParams) {
        this.completeOpEntityForSave(curBatchData, customParams);
    }

    private void beforeValidateDataProcess(List<MultiSheetRowData> curBatchData, Map<String, Object> customParams, Map<String, ImportLogger> importLoggerMap) {
        if (!this.inited) {
            this.init(customParams);
        }
        ++this.importValidationModel.curBatchNo;
        HashSet newNameSet = Sets.newHashSet();
        HashSet newNumberSet = Sets.newHashSet();
        HashSet orgIdSet = Sets.newHashSet();
        HashSet cityIds = Sets.newHashSet();
        HashSet parentBoIds = Sets.newHashSet();
        for (MultiSheetRowData curRowData : curBatchData) {
            String entityNumber = curRowData.getMainEntity();
            if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgmerge")) {
                this.parseMergeData(curRowData, orgIdSet, importLoggerMap.get(curRowData.getMainEntity()));
                continue;
            }
            if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgsplit")) {
                this.parseSplitData(curRowData, orgIdSet, importLoggerMap.get(curRowData.getMainEntity()));
                continue;
            }
            this.parseData(curRowData, newNameSet, newNumberSet, orgIdSet, cityIds, parentBoIds, importLoggerMap.get(curRowData.getMainEntity()));
        }
        this.prepareDataForValidation(newNameSet, newNumberSet, orgIdSet, cityIds, parentBoIds);
        Iterator<MultiSheetRowData> iterator = curBatchData.iterator();
        while (iterator.hasNext()) {
            MultiSheetRowData curRowData;
            curRowData = iterator.next();
            ImportValidationModel.rowData.set(curRowData);
            this.addCoopInfoModelAndParentChildRelation(this.importValidationModel);
            this.orgNameAndNumberExistInCurExcelCheck(curRowData, importLoggerMap.get(curRowData.getMainEntity()));
            this.validateInChg(this.importValidationModel, importLoggerMap.get(curRowData.getMainEntity()));
            if (HRStringUtils.equals((String)"homs_batchorgentitydisab", (String)curRowData.getMainEntity())) {
                this.cachedStopUseRowData.add(curRowData);
                iterator.remove();
                continue;
            }
            this.cachedAllRowData.add(curRowData);
            iterator.remove();
        }
    }

    private void prepareDataForValidation(Set<String> newNameSet, Set<String> newNumberSet, Set<Long> orgIdSet, Set<Long> cityIds, Set<Long> parentBoIds) {
        this.importValidationModel.curBatchNewNumberExistInDb.putAll(ImportValidationHelper.queryExistNumber(newNumberSet));
        this.importValidationModel.curBatchUnderParentOrgNameSetMap = ImportValidationHelper.queryExistName(newNameSet, this.importValidationModel.getEffDate());
        this.importValidationModel.curBatchChgOrgInfoInDB = ImportValidationHelper.batchQueryOrgInfoByIds(orgIdSet);
        this.importValidationModel.curBatchOrgChildrenMap = ImportValidationHelper.queryChildrenOrgSpecInfo(orgIdSet);
        this.importValidationModel.cityCompanyareaMapDB.putAll(ImportValidationHelper.queryCityCompanyareaMap(cityIds));
        this.importValidationModel.bosOrgNumbers.addAll(ImportValidationHelper.queryBosOrgNumbers(newNumberSet));
        this.importValidationModel.setEntity2BaseData(MultiSheetImportHelper.getBaseDataIdsByHrOrgBuID(MultiSheetImportHelper.baseDataEntityType, this.importValidationModel.getOrg()));
        this.importValidationModel.parentBoIdToDyn.putAll(ImportValidationHelper.queryAdminOrgByBoId(parentBoIds));
    }

    private void parseData(MultiSheetRowData curRowData, Set<String> newNameSet, Set<String> newNumberSet, Set<Long> orgIdSet, Set<Long> cityIds, Set<Long> parentBoIds, ImportLogger importLogger) {
        DynamicObject org;
        DynamicObject parentOrg;
        DynamicObject orgDyn;
        DynamicObject city;
        String entityNumber = curRowData.getMainEntity();
        DynamicObject opEntity = curRowData.getOpEntity();
        if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgmerge")) {
            this.parseMergeData(curRowData, orgIdSet, importLogger);
            return;
        }
        if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgsplit")) {
            this.parseSplitData(curRowData, orgIdSet, importLogger);
            return;
        }
        ILocaleString localeString = opEntity.getLocaleString("name");
        localeString.forEach((code, value) -> {
            if (HRStringUtils.isEmpty((String)value)) {
                return;
            }
            newNameSet.add((String)value);
        });
        String newName = localeString.getLocaleValue();
        String newNumber = opEntity.getString("number");
        if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityadd") && HRStringUtils.isNotEmpty((String)newNumber)) {
            this.importValidationModel.newAddOrgNumberNamePairMap.put((Pair<String, String>)new Pair((Object)newNumber, (Object)newName), curRowData);
            this.importValidationModel.curExcelOrgCache.put(newNumber, curRowData);
        }
        if (newNumber != null && !HRStringUtils.equalsIgnoreCase((String)"null", (String)newNumber)) {
            newNumberSet.add(newNumber);
        }
        if ((city = opEntity.getDynamicObject("city")) != null && city.getLong("id") != 0L && !this.importValidationModel.cityCompanyareaMapDB.containsKey(city.getLong("id"))) {
            cityIds.add(city.getLong("id"));
        }
        if ((orgDyn = opEntity.getDynamicObject("adminorg")) != null) {
            orgIdSet.add(orgDyn.getLong("id"));
            this.importValidationModel.curExcelOrgCache.put(orgDyn.getString("number"), curRowData);
        }
        if ((parentOrg = opEntity.getDynamicObject("parentorg")) != null) {
            parentBoIds.add(parentOrg.getLong("id"));
            orgIdSet.add(parentOrg.getLong("id"));
        } else if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityadd") || HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityparent")) {
            JSONObject importData = curRowData.getBillData().getData().getJSONObject("data").getJSONObject(entityNumber);
            JSONObject parentData = importData.getJSONObject("parentorg");
            Optional.ofNullable(parentData).ifPresent(data -> {
                if (HRStringUtils.equals((String)data.getString("importprop"), (String)"name")) {
                    if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityadd")) {
                        importLogger.log(curRowData.getRownum(), ResManager.loadKDString((String)"\u82e5\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u4e3a\u672c\u6a21\u677f\u4e2d\u7684\u65b0\u589e\u7ec4\u7ec7\uff0c\u9700\u586b\u5199\u65b0\u589e\u7ec4\u7ec7\u7684\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", (String)"OrgMultiSheetImportValidator_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    } else {
                        importLogger.log(curRowData.getRownum(), ResManager.loadKDString((String)"\u82e5\u7ec4\u7ec7\u8c03\u6574\u540e\u7684\u4e0a\u7ea7\u4e3a\u672c\u6a21\u677f\u4e2d\u7684\u65b0\u589e\u7ec4\u7ec7\uff0c\u5219\u8c03\u6574\u540e\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u9700\u586b\u5199\u65b0\u589e\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u7f16\u7801", (String)"OrgMultiSheetImportValidator_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    }
                }
            });
        }
        if (HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentitydisab") && (org = opEntity.getDynamicObject("adminorg")) != null) {
            this.importValidationModel.stopUseOrgInCurExcel.add(org.getLong("id"));
        }
        if ((HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityinfo") || HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityparent")) && (org = opEntity.getDynamicObject("adminorg")) != null && opEntity.getBoolean("tobedisableflag")) {
            this.importValidationModel.inCurCellTobeDiSabledOrg.add(org.getLong("id"));
        }
    }

    private void parseMergeData(MultiSheetRowData curRowData, Set<Long> orgIdSet, ImportLogger importLogger) {
        DynamicObject opEntity = curRowData.getOpEntity();
        DynamicObject afterMergeOrg = opEntity.getDynamicObject("aftermerge_org");
        DynamicObjectCollection beforeMergeOrgs = opEntity.getDynamicObjectCollection("beforemerge_org");
        if (afterMergeOrg != null) {
            orgIdSet.add(afterMergeOrg.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)beforeMergeOrgs)) {
            for (DynamicObject beforeMergeOrg : beforeMergeOrgs) {
                orgIdSet.add(beforeMergeOrg.getLong("id"));
            }
        }
    }

    private void parseSplitData(MultiSheetRowData curRowData, Set<Long> orgIdSet, ImportLogger importLogger) {
        DynamicObject opEntity = curRowData.getOpEntity();
        DynamicObject beforeSplitOrg = opEntity.getDynamicObject("beforesplit_org");
        DynamicObjectCollection afterSplitOrgs = opEntity.getDynamicObjectCollection("aftersplit_org");
        if (beforeSplitOrg != null) {
            orgIdSet.add(beforeSplitOrg.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)afterSplitOrgs)) {
            for (DynamicObject afterSplitOrg : afterSplitOrgs) {
                orgIdSet.add(afterSplitOrg.getLong("id"));
            }
        }
    }

    private void validateInChg(ImportValidationModel importValidationModel, ImportLogger importLogger) {
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        String mainEntity = curRowData.getMainEntity();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge") || HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgsplit")) {
            this.validateInChgMergeAndSplit(importValidationModel, importLogger);
            this.inThisImportRowCheck(curRowData, importLogger);
        } else {
            DynamicObject curOrg = curRowData.getOpEntity().getDynamicObject("adminorg");
            if (!HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgentityadd") && curOrg != null) {
                Long orgId = curOrg.getLong("id");
                Long sceneTypeId = this.getSceneTypeByChgSceneOrg(importValidationModel.getCurExcelChgTypeOrgMap(), orgId, Boolean.FALSE);
                if (!sceneTypeId.equals(0L)) {
                    importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u591a\u79cd\u53d8\u52a8\u64cd\u4f5c", (String)"OrgMultiSheetImportValidator_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), curOrg.getString("number") + "/" + curOrg.getString("name"), importValidationModel.changeTypeInfo.get(sceneTypeId).getString("name")));
                } else {
                    Long changeTypeId = importValidationModel.getEntryNumberChgTypeMap().get(mainEntity);
                    HashSet orgIdSet = importValidationModel.getCurExcelChgTypeOrgMap().get(changeTypeId);
                    if (orgIdSet == null) {
                        orgIdSet = Sets.newHashSetWithExpectedSize((int)4);
                    }
                    orgIdSet.add(orgId);
                    importValidationModel.curExcelChgTypeOrgMap.put(changeTypeId, orgIdSet);
                }
            }
        }
    }

    private void validateInChgMergeAndSplit(ImportValidationModel importValidationModel, ImportLogger importLogger) {
        Long orgId;
        MultiSheetRowData curRowData = ImportValidationModel.rowData.get();
        String mainEntity = curRowData.getMainEntity();
        DynamicObjectCollection orgDyCollection = new DynamicObjectCollection();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge")) {
            DynamicObjectCollection beforeMergeOrgS = curRowData.getOpEntity().getDynamicObjectCollection("beforemerge_org");
            DynamicObject afterMergeOrg = curRowData.getOpEntity().getDynamicObject("aftermerge_org");
            if (!CollectionUtils.isEmpty((Collection)beforeMergeOrgS)) {
                orgDyCollection.addAll((Collection)beforeMergeOrgS);
            }
            if (afterMergeOrg != null) {
                orgDyCollection.add((Object)afterMergeOrg);
            }
        } else {
            DynamicObjectCollection afterSplitOrgS = curRowData.getOpEntity().getDynamicObjectCollection("aftersplit_org");
            DynamicObject beforeSplitOrg = curRowData.getOpEntity().getDynamicObject("beforesplit_org");
            if (!CollectionUtils.isEmpty((Collection)afterSplitOrgS)) {
                orgDyCollection.addAll((Collection)afterSplitOrgS);
            }
            if (beforeSplitOrg != null) {
                orgDyCollection.add((Object)beforeSplitOrg);
            }
        }
        Long changeTypeId = importValidationModel.getEntryNumberChgTypeMap().get(mainEntity);
        for (DynamicObject orgDy : orgDyCollection) {
            orgId = orgDy.getLong("id");
            Long existsChangeTypeId = this.getSceneTypeByChgSceneOrg(importValidationModel.getCurExcelChgTypeOrgMap(), orgId, Boolean.TRUE);
            if (!existsChangeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE) && !existsChangeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT)) continue;
            if (changeTypeId.equals(existsChangeTypeId) && existsChangeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE)) {
                importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u5408\u5e76", (String)"OrgMultiSheetImportValidator_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgDy.getString("number") + "/" + orgDy.getString("name"), importValidationModel.changeTypeInfo.get(existsChangeTypeId).getString("name")));
                continue;
            }
            if (changeTypeId.equals(existsChangeTypeId) && existsChangeTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT)) {
                importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u540c\u4e00\u4e2a\u7ec4\u7ec7\u5728\u4e00\u4e2a\u7533\u8bf7\u5355\u4e2d\u53ea\u80fd\u505a\u4e00\u6b21\u62c6\u5206", (String)"OrgMultiSheetImportValidator_9", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgDy.getString("number") + "/" + orgDy.getString("name"), importValidationModel.changeTypeInfo.get(existsChangeTypeId).getString("name")));
                continue;
            }
            importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b58\u5728\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u5408\u5e76\u62c6\u5206", (String)"OrgMultiSheetImportValidator_10", (String)"odc-homs-formplugin", (Object[])new Object[0]), orgDy.getString("number") + "/" + orgDy.getString("name"), importValidationModel.changeTypeInfo.get(existsChangeTypeId).getString("name")));
        }
        for (DynamicObject orgDy : orgDyCollection) {
            orgId = orgDy.getLong("id");
            HashSet orgIdSet = importValidationModel.getCurExcelChgTypeOrgMap().get(changeTypeId);
            if (orgIdSet == null) {
                orgIdSet = Sets.newHashSetWithExpectedSize((int)4);
            }
            orgIdSet.add(orgId);
            importValidationModel.curExcelChgTypeOrgMap.put(changeTypeId, orgIdSet);
        }
    }

    private void inThisImportRowCheck(MultiSheetRowData curRowData, ImportLogger importLogger) {
        String mainEntity = curRowData.getMainEntity();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge")) {
            DynamicObjectCollection beforeMergeOrgS = curRowData.getOpEntity().getDynamicObjectCollection("beforemerge_org");
            DynamicObject afterMergeOrg = curRowData.getOpEntity().getDynamicObject("aftermerge_org");
            if (beforeMergeOrgS.size() == 1 && afterMergeOrg != null) {
                Long beforeMergeId = ((DynamicObject)beforeMergeOrgS.get(0)).getLong("id");
                Long afterMergeId = afterMergeOrg.getLong("id");
                String afterMergeName = afterMergeOrg.getString("name");
                if (beforeMergeId.equals(afterMergeId)) {
                    importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u5408\u5e76\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u586b\u5199\u66f4\u591a\u5408\u5e76\u524d\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_22", (String)"odc-homs-business", (Object[])new Object[0]), afterMergeName));
                }
            }
        } else if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgsplit")) {
            DynamicObjectCollection afterSplitOrgS = curRowData.getOpEntity().getDynamicObjectCollection("aftersplit_org");
            DynamicObject beforeSplitOrg = curRowData.getOpEntity().getDynamicObject("beforesplit_org");
            if (afterSplitOrgS.size() == 1 && beforeSplitOrg != null) {
                Long afterSplitId = ((DynamicObject)afterSplitOrgS.get(0)).getLong("id");
                Long beforeSplitId = beforeSplitOrg.getLong("id");
                String beforeSplitName = beforeSplitOrg.getString("name");
                if (afterSplitId.equals(beforeSplitId)) {
                    importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u62c6\u5206\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u586b\u5199\u66f4\u591a\u62c6\u5206\u540e\u7ec4\u7ec7\u3002", (String)"OrgBatchChgFeasibleCheckServiceImpl_23", (String)"odc-homs-business", (Object[])new Object[0]), beforeSplitName));
                }
            }
        }
    }

    private Long getSceneTypeByChgSceneOrg(Map<Long, Set<Long>> chgSceneOrgMap, Long orgId, boolean mergeOrSplit) {
        Long sceneTypeId = 0L;
        if (CollectionUtils.isEmpty(chgSceneOrgMap)) {
            return sceneTypeId;
        }
        for (Map.Entry<Long, Set<Long>> entry : chgSceneOrgMap.entrySet()) {
            if (!entry.getValue().contains(orgId)) continue;
            sceneTypeId = entry.getKey();
            if (mergeOrSplit && !sceneTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT) && !sceneTypeId.equals(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE)) continue;
            break;
        }
        return sceneTypeId;
    }

    private void orgNameAndNumberExistInCurExcelCheck(MultiSheetRowData curRowData, ImportLogger importLogger) {
        String mainEntity = ImportValidationModel.rowData.get().getMainEntity();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge") || HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgsplit")) {
            return;
        }
        String newNumber = curRowData.getOpEntity().getString("number");
        if (HRStringUtils.isNotEmpty((String)newNumber) && !this.importValidationModel.getCurExcelNewNumbers().add(newNumber)) {
            importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"OrgMultiSheetImportValidator_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), newNumber));
        }
        this.orgNameExistInCurExcelCheck(curRowData, importLogger);
    }

    private void orgNameExistInCurExcelCheck(MultiSheetRowData curRowData, ImportLogger importLogger) {
        DynamicObject opEntity = curRowData.getOpEntity();
        ILocaleString nameLocaleString = opEntity.getLocaleString("name");
        Pair<String, String> parentNumberNamePair = this.getOrgParentNumberAndNamePair(curRowData);
        String parentNumber = (String)parentNumberNamePair.getKey();
        String parentName = (String)parentNumberNamePair.getValue();
        if (HRStringUtils.isEmpty((String)parentNumber)) {
            return;
        }
        nameLocaleString.forEach((code, nameVal) -> {
            Set nameSet;
            if (HRStringUtils.isEmpty((String)nameVal) || HRStringUtils.equalsIgnoreCase((String)"GLang", (String)code)) {
                return;
            }
            HashMap nameMultiLangMap = this.importValidationModel.getCurExcelUnderParentOrgNameSetMap().get(parentNumber);
            if (nameMultiLangMap == null) {
                nameMultiLangMap = Maps.newHashMapWithExpectedSize((int)4);
            }
            if ((nameSet = (Set)nameMultiLangMap.get(code)) == null) {
                nameSet = Sets.newHashSetWithExpectedSize((int)4);
            }
            if (!nameSet.add(nameVal)) {
                importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u540d\u79f0\u201c%3$s\u201d\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539", (String)"OrgMultiSheetImportValidator_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), parentName, MultiLangEnum.getName((String)code), nameVal));
            }
            nameMultiLangMap.put(code, nameSet);
            this.importValidationModel.getCurExcelUnderParentOrgNameSetMap().put(parentNumber, nameMultiLangMap);
            if (this.patternUtil.validName4Config(nameVal)) {
                importLogger.log(curRowData.getRownum(), String.format(Locale.ROOT, ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u201c%1$s\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26\uff08%2$s\uff09\uff0c\u8bf7\u4fee\u6539", (String)"OrgMultiSheetImportValidator_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), MultiLangEnum.getName((String)code), this.nameSeparatorTipsUtil.getAllSeparator()));
            }
        });
    }

    private Pair<String, String> getOrgParentNumberAndNamePair(MultiSheetRowData curRowData) {
        DynamicObject opEntity = curRowData.getOpEntity();
        DynamicObject parentOrg = opEntity.getDynamicObject("parentorg");
        String parentNumber = "";
        String parentName = "";
        if (parentOrg == null) {
            DynamicObject curOrgFromDb;
            DynamicObject parent;
            DynamicObject curOrg;
            String entityNumber = curRowData.getMainEntity();
            JSONObject importData = curRowData.getBillData().getData().getJSONObject("data").getJSONObject(entityNumber);
            JSONObject parentJsonObject = importData.getJSONObject("parentorg");
            if (parentJsonObject != null) {
                parentNumber = parentJsonObject.getString("number");
                MultiSheetRowData parentRowData = this.importValidationModel.curExcelOrgCache.get(parentNumber);
                parentName = parentJsonObject.getString("name");
                if (HRStringUtils.isEmpty((String)parentName) && parentRowData != null) {
                    parentName = parentRowData.getOpEntity().getString("name");
                }
            } else if (!HRStringUtils.equals((String)entityNumber, (String)"homs_batchorgentityadd") && (curOrg = opEntity.getDynamicObject("adminorg")) != null && (parent = (curOrgFromDb = this.importValidationModel.curBatchChgOrgInfoInDB.get(curOrg.getLong("id"))).getDynamicObject("parentorg")) != null) {
                parentNumber = parent.getString("number");
                parentName = parent.getString("name");
            }
        } else {
            parentNumber = parentOrg.getString("number");
            parentName = parentOrg.getString("name");
        }
        return new Pair((Object)parentNumber, (Object)parentName);
    }

    private void addCoopInfoModelAndParentChildRelation(ImportValidationModel importValidationModel) {
        String mainEntity = ImportValidationModel.rowData.get().getMainEntity();
        if (HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgentitydisab") || HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgmerge") || HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgsplit")) {
            return;
        }
        String curOrgNumber = ImportValidationHelper.getCurOrgNumber(importValidationModel);
        String parentOrgNumber = ImportValidationHelper.getParentOrgNumber(importValidationModel);
        if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)curOrgNumber) && !HRStringUtils.equalsIgnoreCase((String)"null", (String)parentOrgNumber) && HRStringUtils.isNotEmpty((String)curOrgNumber) && HRStringUtils.isNotEmpty((String)parentOrgNumber)) {
            if (!HRStringUtils.equals((String)mainEntity, (String)"homs_batchorgentityinfo")) {
                CoopInfoModel coopInfoModel = new CoopInfoModel();
                coopInfoModel.setOrg((Object)curOrgNumber);
                coopInfoModel.setCoopOrg((Object)parentOrgNumber);
                coopInfoModel.setCooprelType(Long.valueOf(1010L));
                coopInfoModel.setBsed(importValidationModel.getEffDate());
                coopInfoModel.setBsled(OrgChgUtil.getDefaultBsled());
                importValidationModel.curExcelAffiliationRelInfos.computeIfAbsent(curOrgNumber, key -> Lists.newArrayListWithCapacity((int)1)).add(coopInfoModel);
            }
            importValidationModel.getParentNumberAndChildrenNumberMapInExcel().computeIfAbsent(parentOrgNumber, key -> Sets.newHashSetWithExpectedSize((int)4)).add(curOrgNumber);
        }
    }

    public void completeOpEntityForSave(List<MultiSheetRowData> rowDataList, Map<String, Object> customParams) {
        this.setFieldsValueForNewAddOrg(rowDataList, customParams);
        this.setFieldsValueForChgOrg(rowDataList, customParams);
        this.setFieldsValueForMergeOrSplit(rowDataList);
        this.setFieldsValueForExt(rowDataList, customParams);
    }

    private void setFieldsValueForExt(List<MultiSheetRowData> rowDataList, Map<String, Object> customParams) {
        PluginProxy extendPluginProxy = PluginProxy.create((Object)new DefaultOrgBatchBillServiceExtend(), IOrgBatchBillServiceExtend.class, (String)"kd.hr.homs.business.service.ext.function.DefaultOrgBatchBillServiceExtend");
        ArrayList entityNames = Lists.newArrayListWithExpectedSize((int)16);
        extendPluginProxy.callReplace(plugin -> {
            Map entityParamMap = plugin.getBatchBillExtendParam();
            if (!CollectionUtils.isEmpty((Map)entityParamMap)) {
                entityNames.addAll(entityParamMap.keySet());
            }
            return null;
        });
        List opEntities = rowDataList.stream().filter(rowData -> entityNames.contains(rowData.getMainEntity())).map(MultiSheetRowData::getOpEntity).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(opEntities)) {
            extendPluginProxy.callReplace(plugin -> {
                plugin.importCompleteOpEntityForExt(opEntities, customParams);
                return null;
            });
        }
    }

    private void setFieldsValueForChgOrg(List<MultiSheetRowData> rowDataList, Map<String, Object> customParams) {
        Map<Long, MultiSheetRowData> changingOrgDynMap = rowDataList.stream().filter(rowData -> !StringUtils.equals((CharSequence)"homs_batchorgentityadd", (CharSequence)rowData.getMainEntity()) && !StringUtils.equals((CharSequence)"homs_batchorgsplit", (CharSequence)rowData.getMainEntity()) && !StringUtils.equals((CharSequence)"homs_batchorgmerge", (CharSequence)rowData.getMainEntity())).filter(rowData -> rowData.getOpEntity().getDynamicObject("adminorg") != null).collect(Collectors.toMap(rowData -> rowData.getOpEntity().getDynamicObject("adminorg").getLong("id"), rowData -> rowData));
        rowDataList.stream().filter(rowData -> StringUtils.equals((CharSequence)"homs_batchorgsplit", (CharSequence)rowData.getMainEntity()) || StringUtils.equals((CharSequence)"homs_batchorgmerge", (CharSequence)rowData.getMainEntity())).forEach(rowData -> {
            rowData.getOpEntity().set("billid", customParams.get("billid"));
            rowData.getOpEntity().set("importbatch", customParams.get("importbatch"));
        });
        if (changingOrgDynMap.isEmpty()) {
            return;
        }
        HashSet propSet = new HashSet();
        Optional<DynamicObject> optional = this.importValidationModel.curBatchChgOrgInfoInDB.values().stream().findAny();
        optional.ifPresent(dynamicObject -> {
            DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                propSet.add(property.getName());
            }
        });
        HashSet orgCurHisIds = Sets.newHashSetWithExpectedSize((int)changingOrgDynMap.size());
        changingOrgDynMap.forEach((orgId, rowData) -> {
            DynamicObject dynamicObject = this.importValidationModel.curBatchChgOrgInfoInDB.get(orgId);
            MultiSheetRowData entityRowData = (MultiSheetRowData)changingOrgDynMap.get(orgId);
            JSONObject columnData = entityRowData.getBillData().getData().getJSONObject("data").getJSONObject(entityRowData.getMainEntity());
            DynamicObject opEntity = entityRowData.getOpEntity();
            this.setBackEndFieldsValue(entityRowData, customParams);
            this.setOldOrClearPropValue(columnData, opEntity, propSet, dynamicObject);
            opEntity.set("orgoriname", dynamicObject.get("name"));
            orgCurHisIds.add(dynamicObject.getLong("sourcevid"));
            Optional.ofNullable(dynamicObject.getDynamicObject("parentorg")).ifPresent(p -> orgCurHisIds.add(p.getLong("sourcevid")));
            long parentOrgId = opEntity.getLong("parentorg.id");
            DynamicObject newParentDyn = this.importValidationModel.curBatchChgOrgInfoInDB.get(parentOrgId);
            if (newParentDyn != null) {
                orgCurHisIds.add(newParentDyn.getLong("sourcevid"));
            }
        });
        Map orgHisData = AdminOrgHisServiceHelper.batchQueryOrgHisData((Set)orgCurHisIds);
        Map<Long, List<DynamicObject>> orgCoopInfoMap = ImportValidationHelper.batchGetOrgCoopInfo(changingOrgDynMap.keySet());
        changingOrgDynMap.forEach((orgId, rowData) -> {
            DynamicObject dynamicObject = this.importValidationModel.curBatchChgOrgInfoInDB.get(orgId);
            DynamicObject opEntity = ((MultiSheetRowData)changingOrgDynMap.get(orgId)).getOpEntity();
            opEntity.set("adminorg", orgHisData.get(opEntity.getLong("adminorg.id")));
            long parentOrgId = opEntity.getLong("parentorg.id");
            if (orgHisData.containsKey(parentOrgId)) {
                opEntity.set("parentorg", orgHisData.get(parentOrgId));
            }
            opEntity.set("oriparentorg", orgHisData.get(dynamicObject.getLong("parentorg.id")));
            if (orgCoopInfoMap.containsKey(orgId)) {
                DynamicObjectCollection collection = opEntity.getDynamicObjectCollection("cooprelentryentity");
                List coopInfoList = (List)orgCoopInfoMap.get(orgId);
                int i = 0;
                for (DynamicObject coopInfo : coopInfoList) {
                    DynamicObjectType dynamicObjectType = collection.getDynamicObjectType();
                    DynamicObject object = new DynamicObject(dynamicObjectType);
                    object.set("coopreltyp", (Object)coopInfo.getDynamicObject("coopreltype"));
                    DynamicObject orgTeam = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgteam"));
                    orgTeam.set("id", (Object)coopInfo.getLong("cooporgteam.sourcevid"));
                    object.set("cooporgteam", (Object)orgTeam);
                    object.set("cooprelid", (Object)coopInfo.getLong("sourcevid"));
                    object.set("seq", (Object)i++);
                    collection.add((Object)object);
                }
            }
        });
    }

    private void setFieldsValueForMergeOrSplit(List<MultiSheetRowData> rowDataList) {
        JSONObject columnData;
        List mergeList = rowDataList.stream().filter(rowData -> StringUtils.equals((CharSequence)"homs_batchorgmerge", (CharSequence)rowData.getMainEntity())).collect(Collectors.toList());
        List splitList = rowDataList.stream().filter(rowData -> StringUtils.equals((CharSequence)"homs_batchorgsplit", (CharSequence)rowData.getMainEntity())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mergeList)) {
            for (MultiSheetRowData multiSheetRowData : mergeList) {
                columnData = multiSheetRowData.getBillData().getData().getJSONObject("data").getJSONObject(multiSheetRowData.getMainEntity());
                this.setNewOrgToMergeOrSplit(multiSheetRowData, columnData, OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
            }
        }
        if (!CollectionUtils.isEmpty(splitList)) {
            for (MultiSheetRowData multiSheetRowData : splitList) {
                columnData = multiSheetRowData.getBillData().getData().getJSONObject("data").getJSONObject(multiSheetRowData.getMainEntity());
                this.setNewOrgToMergeOrSplit(multiSheetRowData, columnData, OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
            }
        }
    }

    private void setFieldsValueForNewAddOrg(List<MultiSheetRowData> rowDataList, Map<String, Object> customParams) {
        for (MultiSheetRowData sheetRowData : rowDataList) {
            DynamicObject opEntity = sheetRowData.getOpEntity();
            opEntity.set("org", (Object)this.importValidationModel.getOrg());
        }
        List newAddOrg = rowDataList.stream().filter(rowData -> StringUtils.equals((CharSequence)"homs_batchorgentityadd", (CharSequence)rowData.getMainEntity())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newAddOrg)) {
            return;
        }
        Map<String, Long> needQueryParentHisOrg = newAddOrg.stream().map(MultiSheetRowData::getOpEntity).filter(dy -> dy.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dy -> dy.getString("name") + dy.getLong("parentorg.id"), dy -> {
            long parentOrgId = dy.getLong("parentorg.id");
            return this.importValidationModel.curBatchChgOrgInfoInDB.get(parentOrgId).getLong("sourcevid");
        }));
        Map orgHisData = AdminOrgHisServiceHelper.batchQueryOrgHisData((Set)Sets.newHashSet(needQueryParentHisOrg.values()));
        HashMap orgIdParentNumberMap = Maps.newHashMapWithExpectedSize((int)newAddOrg.size());
        HashSet needQueryMaxIndexOrgId = Sets.newHashSetWithExpectedSize((int)4);
        long[] orgIds = ORM.create().genLongIds("haos_adminorgdetail", newAddOrg.size());
        int idx = 0;
        for (MultiSheetRowData sheetRowData : newAddOrg) {
            DynamicObject corporateOrg;
            String parentOrgNumber;
            DynamicObject opEntity = sheetRowData.getOpEntity();
            long orgId = orgIds[idx++];
            opEntity.set("adminorg", (Object)orgId);
            DynamicObject parentOrg = opEntity.getDynamicObject("parentorg");
            if (parentOrg != null) {
                parentOrgNumber = parentOrg.getString("number");
                if (!this.maxIndexUnderOrgMap.containsKey(parentOrgNumber)) {
                    needQueryMaxIndexOrgId.add(parentOrg.getLong("id"));
                }
            } else {
                JSONObject importData = sheetRowData.getBillData().getData().getJSONObject("data").getJSONObject(sheetRowData.getMainEntity());
                parentOrgNumber = importData.getJSONObject("parentorg").getString("number");
                if (!this.maxIndexUnderOrgMap.containsKey(parentOrgNumber)) {
                    this.maxIndexUnderOrgMap.put(parentOrgNumber, 1);
                }
            }
            if ((corporateOrg = opEntity.getDynamicObject("corporateorg")) != null) continue;
            orgIdParentNumberMap.put(orgId, parentOrgNumber);
        }
        Map<Long, DynamicObject> orgMap = newAddOrg.stream().map(MultiSheetRowData::getOpEntity).collect(Collectors.toMap(dy -> dy.getLong("adminorg"), dy -> dy));
        Map maxIndexUnderOrg = AdminOrgHisServiceHelper.batchGetMaxIndexUnderOrg((Set)needQueryMaxIndexOrgId);
        for (MultiSheetRowData rowData2 : newAddOrg) {
            this.setBackEndFieldsValue(rowData2, customParams);
            DynamicObject opEntity = rowData2.getOpEntity();
            if (opEntity.get("index") == null) {
                DynamicObject parentOrg = opEntity.getDynamicObject("parentorg");
                long parentOrgId = parentOrg.getLong("id");
                String parentOrgNumber = parentOrg.getString("number");
                Integer index = 1;
                if (this.maxIndexUnderOrgMap.containsKey(parentOrgNumber)) {
                    index = this.maxIndexUnderOrgMap.get(parentOrgNumber);
                } else if (maxIndexUnderOrg.containsKey(parentOrgId)) {
                    index = (Integer)maxIndexUnderOrg.get(parentOrgId);
                }
                if (index > AdminOrgConstants.MAX_INDEX) {
                    index = AdminOrgConstants.MAX_INDEX;
                }
                opEntity.set("index", (Object)index);
                this.maxIndexUnderOrgMap.put(parentOrgNumber, index + 1);
            }
            long parentOrgId = opEntity.getLong("parentorg.id");
            opEntity.set("adminorgboid", (Object)parentOrgId);
            if (this.importValidationModel.getCurExcelNewNumbers().contains(opEntity.getDynamicObject("parentorg").getString("number")) || !needQueryParentHisOrg.containsKey(opEntity.getString("name") + opEntity.getLong("parentorg.id"))) continue;
            opEntity.set("parentorg", orgHisData.get(opEntity.getLong("parentorg.id")));
        }
    }

    private void findParentCorporateOrg(Map<Long, DynamicObject> orgMap, Map<Long, String> orgIdParentNumberMap, Map<String, DynamicObject> parentOrgCorporateOrgMap, int recursionDepth) {
        if (CollectionUtils.isEmpty(orgIdParentNumberMap)) {
            return;
        }
        if (recursionDepth > AdminOrgConstants.MAX_ORG_LEVEL) {
            LOG.info(String.format(Locale.ROOT, "The following org don't have corporateorg %s", orgIdParentNumberMap.values()));
            return;
        }
        Iterator<Map.Entry<Long, String>> iterator = orgIdParentNumberMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, String> next = iterator.next();
            Long orgId = next.getKey();
            String parentOrgNumber = next.getValue();
            DynamicObject corporateOrg = parentOrgCorporateOrgMap.get(parentOrgNumber);
            if (!parentOrgCorporateOrgMap.containsKey(parentOrgNumber)) {
                MultiSheetRowData sheetRowData = this.importValidationModel.curExcelOrgCache.get(parentOrgNumber);
                if (sheetRowData != null) {
                    corporateOrg = sheetRowData.getOpEntity().getDynamicObject("corporateorg");
                    if (corporateOrg != null) {
                        parentOrgCorporateOrgMap.put(parentOrgNumber, corporateOrg);
                    } else if (!HRStringUtils.equals((String)"homs_batchorgentityadd", (String)sheetRowData.getMainEntity())) {
                        long parentOrgId = sheetRowData.getOpEntity().getLong("adminorg.id");
                        corporateOrg = this.importValidationModel.curBatchChgOrgInfoInDB.get(parentOrgId).getDynamicObject("corporateorg");
                        parentOrgCorporateOrgMap.put(parentOrgNumber, corporateOrg);
                    }
                } else {
                    DynamicObject curOrgDyn = orgMap.get(orgId);
                    long parentOrgId = curOrgDyn.getLong("parentorg.id");
                    corporateOrg = this.importValidationModel.curBatchChgOrgInfoInDB.get(parentOrgId).getDynamicObject("corporateorg");
                    parentOrgCorporateOrgMap.put(parentOrgNumber, corporateOrg);
                }
            }
            if (corporateOrg == null) continue;
            orgMap.get(orgId).set("corporateorg", (Object)corporateOrg);
            iterator.remove();
        }
        this.findParentCorporateOrg(orgMap, orgIdParentNumberMap, parentOrgCorporateOrgMap, recursionDepth + 1);
    }

    private void setOldOrClearPropValue(JSONObject columnData, DynamicObject opEntity, Set<String> propSet, DynamicObject oldEntity) {
        DataEntityPropertyCollection properties = opEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (this.basicCopyIgnoreKeys.contains(propertyName) || !propSet.contains(propertyName) || propertyName.contains("_id") || "multilanguagetext".equals(propertyName)) continue;
            Object excelData = columnData.get((Object)propertyName);
            if (excelData != null) {
                if (!HRStringUtils.equalsIgnoreCase((String)"null", (String)String.valueOf(excelData))) continue;
                opEntity.set(property, null);
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                ILocaleString oldLocaleString = oldEntity.getLocaleString(propertyName);
                ILocaleString curOrgLocalString = opEntity.getLocaleString(propertyName);
                oldLocaleString.forEach((arg_0, arg_1) -> ((ILocaleString)curOrgLocalString).setItem(arg_0, arg_1));
                continue;
            }
            if (property instanceof MulBasedataProp) {
                DynamicObjectCollection oldMulBaseData = oldEntity.getDynamicObjectCollection(propertyName);
                if (CollectionUtils.isEmpty((Collection)oldMulBaseData)) continue;
                DynamicObjectCollection curMulBaseData = opEntity.getDynamicObjectCollection(propertyName);
                for (DynamicObject oldMulBaseDatum : oldMulBaseData) {
                    DynamicObject curMulBaseDatum = new DynamicObject(curMulBaseData.getDynamicObjectType());
                    curMulBaseDatum.set("fbasedataid", oldMulBaseDatum.get("fbasedataid"));
                    curMulBaseData.add((Object)curMulBaseDatum);
                }
                continue;
            }
            opEntity.set(propertyName, oldEntity.get(propertyName));
        }
        Object cityImportData = columnData.get((Object)"city");
        Object countryImportData = columnData.get((Object)"companyarea");
        if (cityImportData == null && countryImportData == null) {
            opEntity.set("city", oldEntity.get("city"));
            opEntity.set("companyarea", oldEntity.get("companyarea"));
        }
    }

    private void setBackEndFieldsValue(MultiSheetRowData entityRowData, Map<String, Object> customParams) {
        DynamicObject country;
        DynamicObject city;
        long parentOrgId;
        DynamicObject opEntity = entityRowData.getOpEntity();
        opEntity.set("bsed", (Object)this.importValidationModel.getEffDate());
        JSONObject columnData = entityRowData.getBillData().getData().getJSONObject("data").getJSONObject(entityRowData.getMainEntity());
        if (HRStringUtils.equals((String)"homs_batchorgentityadd", (String)entityRowData.getMainEntity())) {
            opEntity.set("orgid", (Object)opEntity.getLong("adminorg"));
            opEntity.set("bsed", (Object)opEntity.getDate("establishmentdate"));
        }
        opEntity.set("adminorgtype", (Object)this.orgTypeMap.get(opEntity.getLong("adminorgtype.id")));
        opEntity.set("bsled", (Object)OrgChgUtil.getDefaultBsled());
        opEntity.set("billid", customParams.get("billid"));
        opEntity.set("importbatch", customParams.get("importbatch"));
        opEntity.set("sequence", (Object)(entityRowData.getRownum() - 4));
        opEntity.set("createtime", (Object)new Date());
        opEntity.set("creator", (Object)RequestContext.get().getCurrUserId());
        opEntity.set("issyspreset", (Object)0);
        opEntity.set("changetype", (Object)this.importValidationModel.getEntryNumberChgTypeMap().get(entityRowData.getMainEntity()));
        DynamicObject parentOrg = opEntity.getDynamicObject("parentorg");
        if (parentOrg == null && columnData.getJSONObject("parentorg") != null) {
            this.setParentOrg(entityRowData, columnData);
        }
        if ((parentOrgId = opEntity.getLong("parentorg.id")) != 0L && this.importValidationModel.curBatchChgOrgInfoInDB.containsKey(parentOrgId)) {
            opEntity.set("parentorg", (Object)this.importValidationModel.curBatchChgOrgInfoInDB.get(parentOrgId));
        }
        if ((city = opEntity.getDynamicObject("city")) != null && (country = opEntity.getDynamicObject("companyarea")) == null) {
            country = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_country"));
            country.set("id", (Object)this.importValidationModel.cityCompanyareaMapDB.get(city.getLong("id")));
            opEntity.set("companyarea", (Object)country);
        }
    }

    private void setBasicCopyIgnoreKeysAndTransKey() {
        if (CollectionUtils.isEmpty(this.basicCopyIgnoreKeys)) {
            this.basicCopyIgnoreKeys = Sets.newHashSet((Object[])new String[]{"id", "bsed", "bsled", "billid", "importbatch", "sequence", "createtime", "creator", "issyspreset", "modifytime", "modifier", "changedescription", "city", "companyarea", "cooprelentryentity"});
        }
    }

    private void setParentOrg(MultiSheetRowData entityRowData, JSONObject columnData) {
        ImportValidationModel.rowData.set(entityRowData);
        String parentOrgNumber = columnData.getJSONObject("parentorg").getString("number");
        MultiSheetRowData parentRowData = this.importValidationModel.curExcelOrgCache.get(parentOrgNumber);
        DynamicObject parentOpEntity = parentRowData.getOpEntity();
        DynamicObject parentOrgDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
        parentOrgDyn.set("id", (Object)parentOpEntity.getLong("adminorg"));
        parentOrgDyn.set("number", (Object)parentOpEntity.getString("number"));
        parentOrgDyn.set("boid", (Object)parentOpEntity.getLong("adminorg"));
        parentOrgDyn.set("adminorgtype", (Object)parentOpEntity.getDynamicObject("adminorgtype"));
        entityRowData.getOpEntity().set("parentorg", (Object)parentOrgDyn);
    }

    private void setNewOrgToMergeOrSplit(MultiSheetRowData entityRowData, JSONObject columnData, Long changeType) {
        String singleName = "";
        String multipleName = "";
        if (OrgBatchChgBillConstants.CHANGE_TYPE_MERGE.equals(changeType)) {
            singleName = "aftermerge_org";
            multipleName = "beforemerge_org";
        } else {
            singleName = "beforesplit_org";
            multipleName = "aftersplit_org";
        }
        ImportValidationModel.rowData.set(entityRowData);
        String singleOrgNumber = columnData.getJSONObject(singleName).getString("number");
        MultiSheetRowData singleRowData = this.importValidationModel.curExcelOrgCache.get(singleOrgNumber);
        if (singleRowData != null && entityRowData.getOpEntity().getDynamicObject(singleName) == null) {
            DynamicObject singleOpEntity = singleRowData.getOpEntity();
            DynamicObject singleOrgDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
            HRDynamicObjectUtils.copy((DynamicObject)singleOpEntity, (DynamicObject)singleOrgDyn);
            singleOrgDyn.set("id", singleOpEntity.get("adminorg"));
            entityRowData.getOpEntity().set(singleName, (Object)singleOrgDyn);
        }
        String multipleOrgNumber = columnData.getJSONObject(multipleName).getString("number");
        String[] orgNumberArr = multipleOrgNumber.split(",");
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (String orgNumber : orgNumberArr) {
            MultiSheetRowData addRowData = this.importValidationModel.curExcelOrgCache.get(orgNumber);
            if (addRowData == null) continue;
            DynamicObject addOpEntity = addRowData.getOpEntity();
            DynamicObject addOrgDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
            HRDynamicObjectUtils.copy((DynamicObject)addOpEntity, (DynamicObject)addOrgDyn);
            addOrgDyn.set("id", addOpEntity.get("adminorg"));
            dynamicObjects.add((Object)addOrgDyn);
        }
        DynamicObjectCollection multipleDys = entityRowData.getOpEntity().getDynamicObjectCollection(multipleName);
        for (DynamicObject dynamicObject : multipleDys) {
            DynamicObject chgOrgDyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgdetail"));
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)chgOrgDyn);
            chgOrgDyn.set("id", (Object)dynamicObject.getLong("id"));
            dynamicObjects.add((Object)chgOrgDyn);
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            entityRowData.getOpEntity().set(multipleName, (Object)dynamicObjects);
        }
    }
}

