/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.newcardstyle;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.RuleCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.haos.common.util.protype.IProType;
import kd.hr.haos.common.util.protype.imp.ProType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.OrgChartPolicyService;
import kd.hr.homs.common.model.ColorSchemaBo;

public class ColorSchemaPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String RULECONDITIONAP = "ruleconditionap";
    private static final String SELECT_COLOR_CONTROL_KEY = "select_color_control_key";
    private static final String KEY_COLOR_USER_INPUT = "coloruserinput";
    private static final String KEY_PREFIX_COLOR_LABEL = "colorlabelap";
    private static final String KEY_COLOR_LABEL_USER = "colorlabelap100";
    private static final String KEY_COLOR_LABEL_SELECTED = "colorlabelap200";
    private static final String KEY_CUSTOM_COLOR_CHECKBOX = "customcolorcheckbox";
    private IProType<Map<String, String>> apVsColorMap = new ProType();

    private Map<String, String> getApVsColorMap() {
        return (Map)this.apVsColorMap.get(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("colorlabelap1", "#276ff5");
            map.put("colorlabelap2", "#16b8b1");
            map.put("colorlabelap3", "#1ba854");
            map.put("colorlabelap4", "#ff991c");
            map.put("colorlabelap5", "#e65e67");
            return map;
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button okButton = (Button)this.getView().getControl(BTN_OK);
        okButton.addClickListener((ClickListener)this);
        for (int i = 1; i < 6; ++i) {
            Label colorLabel = (Label)this.getControl(KEY_PREFIX_COLOR_LABEL + i);
            colorLabel.addClickListener((ClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String colorDimension = (String)this.getView().getFormShowParameter().getCustomParam("colordimension");
        if (colorDimension != null) {
            long ruleSceneId = 0L;
            if (colorDimension.equals("1")) {
                ruleSceneId = 1891380309275109376L;
            } else if (colorDimension.equals("2")) {
                ruleSceneId = 1898666026321598464L;
            }
            this.initControl(ruleSceneId, null);
        }
    }

    private void initControl(long ruleScene, String rule) {
        RuleCondition ruleControl = this.getRuleCondition();
        ruleControl.setBizApp("217WYC/L9U7E");
        ruleControl.setScene(String.valueOf(ruleScene));
        if (StringUtils.isNotEmpty((CharSequence)rule)) {
            ruleControl.setValue(rule);
        }
    }

    private RuleCondition getRuleCondition() {
        return (RuleCondition)this.getControl(RULECONDITIONAP);
    }

    public void click(EventObject evt) {
        boolean customColorCheckbox;
        super.click(evt);
        String itemKey = ((Button)evt.getSource()).getKey();
        if (BTN_OK.equals(itemKey)) {
            boolean check = this.checkAndShowTips();
            if (check) {
                this.closeAndReturnData();
            }
        } else if (itemKey != null && itemKey.contains(KEY_PREFIX_COLOR_LABEL) && !(customColorCheckbox = this.getCustomColorCheckbox())) {
            this.getView().getPageCache().put(SELECT_COLOR_CONTROL_KEY, itemKey);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("bc", this.getSelectColor());
            this.getView().updateControlMetadata(KEY_COLOR_LABEL_SELECTED, param);
        }
    }

    private boolean checkAndShowTips() {
        RuleCondition ruleCondition = this.getRuleCondition();
        String conditionJson = ruleCondition.getValue();
        RuleValidateInfo conditionInfo = RuleValidateUtil.validCondition((String)conditionJson);
        if (!conditionInfo.isSuccess()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u914d\u8272\u65b9\u6848\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"ColorSchemaPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isColorCodeMatchesAll(String userInputColor) {
        return userInputColor.matches("#[a-f|0-9|A-F]{6}");
    }

    private boolean isColorCodeMatches(String userInputColor) {
        return userInputColor.matches("#[a-f|0-9|A-F]{0,6}");
    }

    private void closeAndReturnData() {
        String filterCondition = this.getRuleCondition().getValue();
        OrgChartPolicyService orgChartPolicyService = new OrgChartPolicyService();
        Long policyId = orgChartPolicyService.addPolicy(this.getRuleCondition().getValue());
        ColorSchemaBo colorSchemaBo = new ColorSchemaBo();
        colorSchemaBo.setRuleId(policyId.longValue());
        colorSchemaBo.setRule(filterCondition);
        colorSchemaBo.setColor(this.getSelectColor());
        this.getView().returnDataToParent((Object)colorSchemaBo);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (KEY_COLOR_USER_INPUT.equals(key)) {
            boolean customColorCheckbox;
            ChangeData changeData = e.getChangeSet()[0];
            if (!this.isColorCodeMatches(this.getUserInputColor())) {
                this.getModel().getDataEntity().set(KEY_COLOR_USER_INPUT, changeData.getOldValue());
            }
            if (customColorCheckbox = this.getCustomColorCheckbox()) {
                HashMap<String, String> param = new HashMap<String, String>();
                String userColor = this.getUserInputColor();
                param.put("bc", userColor);
                this.getView().updateControlMetadata(KEY_COLOR_LABEL_SELECTED, param);
            }
        }
    }

    private String getUserInputColor() {
        String userInputColorCode = this.getModel().getDataEntity().getString(KEY_COLOR_USER_INPUT);
        String afterConcat = !userInputColorCode.startsWith("#") ? "#" + userInputColorCode : userInputColorCode;
        return afterConcat;
    }

    private boolean getCustomColorCheckbox() {
        return this.getModel().getDataEntity().getBoolean(KEY_CUSTOM_COLOR_CHECKBOX);
    }

    private String getSelectColor() {
        boolean customColorCheckbox = this.getCustomColorCheckbox();
        if (customColorCheckbox) {
            String userColor = this.getUserInputColor();
            if (HRStringUtils.isBlank((CharSequence)userColor)) {
                userColor = "#276ff5";
            }
            return userColor;
        }
        String selectControlKey = this.getView().getPageCache().get(SELECT_COLOR_CONTROL_KEY);
        return this.getApVsColorMap().getOrDefault(selectControlKey, "#276ff5");
    }
}

