/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.newcardstyle;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgCardConfigRepository;
import kd.hr.homs.business.service.orgchart.ColorSchemaRuleServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.enums.orgchart.CompareEnum;
import kd.hr.homs.common.enums.orgchart.FieldDataTypeEnum;
import kd.hr.homs.common.model.colorschema.ChangeDimensionReq;
import kd.hr.homs.common.model.colorschema.ColorSchemaConditionVo;
import kd.hr.homs.common.model.colorschema.ColorSchemaDimensionVo;
import kd.hr.homs.common.model.colorschema.ColorSchemaRuleKeyValVo;
import kd.hr.homs.common.model.colorschema.ColorSchemaRuleOpenF7Req;
import kd.hr.homs.common.model.colorschema.ColorSchemaRuleVo;
import kd.hr.homs.common.model.colorschema.ColorSchemaVo;
import kd.hr.homs.common.model.colorschema.DeleteColorSchemaRuleReq;
import kd.hr.homs.formplugin.web.newcardstyle.service.ColorSchemaServiceHelper;
import kd.hr.homs.formplugin.web.newcardstyle.service.NewCardStyleHelper;
import kd.hr.homs.formplugin.web.neworgchart.vo.ResultDataHelper;

public class NewCardStyleColorSchemaPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(NewCardStyleColorSchemaPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initColorSchemaControlAp();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            String message;
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
            if (colorSchemaEntry.isEmpty()) {
                return;
            }
            int ruleSize = colorSchemaEntry.size();
            HashSet<String> conditionsTagJsonSet = new HashSet<String>(ruleSize);
            boolean isComplete = true;
            for (DynamicObject rule : colorSchemaEntry) {
                String conditionsTag = rule.getString("conditions_tag");
                if (HRStringUtils.isEmpty((String)conditionsTag)) {
                    isComplete = false;
                    break;
                }
                conditionsTagJsonSet.add(conditionsTag);
                List conditions = JSONObject.parseArray((String)conditionsTag, ColorSchemaConditionVo.class);
                List values = ((ColorSchemaConditionVo)conditions.get(0)).getValues();
                if (CollectionUtils.isEmpty((Collection)values)) {
                    isComplete = false;
                    break;
                }
                if (!values.contains(null) && !values.contains("")) continue;
                isComplete = false;
                break;
            }
            if (HRStringUtils.isNotEmpty((String)(message = !isComplete ? ResManager.loadKDString((String)"\u914d\u8272\u65b9\u6848\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"NewCardStyleColorSchemaPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]) : (conditionsTagJsonSet.size() < ruleSize ? ResManager.loadKDString((String)"\u914d\u8272\u65b9\u6848\u5b58\u5728\u76f8\u540c\u89c4\u5219\uff0c\u8bf7\u4fdd\u75591\u6761\u3002", (String)"NewCardStyleColorSchemaPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]) : null)))) {
                this.getView().showTipNotification(message);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"modify")) {
            ColorSchemaVo colorSchemaVo = new ColorSchemaVo();
            colorSchemaVo.setEdit(true);
            this.setDateToColorSchemaCustomControlAp(colorSchemaVo, operateKey, "update");
        }
    }

    public void customEvent(CustomEventArgs args) {
        String eventArgs = args.getEventArgs();
        String eventName = args.getEventName();
        IFormView formView = this.getView();
        IDataModel dataModel = this.getModel();
        ResultDataHelper.showLoading(formView);
        try {
            switch (eventName) {
                case "changeDimension": {
                    ChangeDimensionReq changeDimensionReq = (ChangeDimensionReq)JSONObject.parseObject((String)eventArgs, ChangeDimensionReq.class);
                    ColorSchemaRuleVo defaultRule = this.changeDimension(changeDimensionReq.getDimensionId());
                    this.setDateToColorSchemaCustomControlAp(defaultRule, eventName, "update");
                    break;
                }
                case "addRule": {
                    ColorSchemaRuleVo addRule = this.addColorSchemaRule();
                    this.setDateToColorSchemaCustomControlAp(addRule, eventName, "update");
                    break;
                }
                case "saveRule": {
                    ColorSchemaRuleVo colorSchemaRuleVo = (ColorSchemaRuleVo)JSONObject.parseObject((String)eventArgs, ColorSchemaRuleVo.class);
                    String error = this.saveColorSchemaRuleValidate(colorSchemaRuleVo);
                    if (HRStringUtils.isEmpty((String)error)) {
                        this.saveColorSchemaRule(colorSchemaRuleVo);
                        this.setDateToColorSchemaCustomControlAp(null, eventName, "update");
                        break;
                    }
                    CustomControl customControl = this.getColorSchemaCustomControlAp();
                    DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
                    int index = colorSchemaRuleVo.getIndex();
                    DynamicObject colorSchema = (DynamicObject)colorSchemaEntry.get(index);
                    ColorSchemaRuleVo colorSchemaRule = ColorSchemaServiceHelper.buildColorSchemaRuleVo(colorSchema);
                    colorSchemaRule.setIndex(Integer.valueOf(index));
                    customControl.setData(NewCardStyleHelper.buildErrorResultData(error, eventName, "update", colorSchemaRule));
                    break;
                }
                case "deleteRule": {
                    DeleteColorSchemaRuleReq deleteRuleReq = (DeleteColorSchemaRuleReq)JSONObject.parseObject((String)eventArgs, DeleteColorSchemaRuleReq.class);
                    this.deleteColorSchemaEntry(deleteRuleReq.getIndex());
                    this.setDateToColorSchemaCustomControlAp(null, eventName, "update");
                    break;
                }
                case "openF7": {
                    ColorSchemaRuleOpenF7Req openF7Req = (ColorSchemaRuleOpenF7Req)JSONObject.parseObject((String)eventArgs, ColorSchemaRuleOpenF7Req.class);
                    this.openF7(openF7Req.getIndex());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("eventName:{},eventArgs:{}", (Object)eventName, (Object)eventArgs);
            LOGGER.error("customEvent error", (Throwable)e);
        }
        ResultDataHelper.hideLoading(formView);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (HRStringUtils.isNotEmpty((String)actionId) && actionId.startsWith("openF7")) {
            String[] actionIdSplit = actionId.split("_");
            if (actionIdSplit.length != 2) {
                LOGGER.error("Incorrect actionId:{}", (Object)actionId);
            }
            int index = Integer.parseInt(actionIdSplit[1]);
            Object returnData = event.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            List ruleF7Vos = Collections.emptyList();
            ArrayList values = new ArrayList(selectedRows.size());
            if (!selectedRows.isEmpty()) {
                ruleF7Vos = selectedRows.stream().map(row -> {
                    String primaryKeyValue = row.getPrimaryKeyValue().toString();
                    ColorSchemaRuleKeyValVo ruleF7Vo = new ColorSchemaRuleKeyValVo(primaryKeyValue, row.getName());
                    values.add(primaryKeyValue);
                    return ruleF7Vo;
                }).collect(Collectors.toList());
            }
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
            DynamicObject rule = (DynamicObject)colorSchemaEntry.get(index);
            String conditionTag = rule.getString("conditions_tag");
            List conditions = JSONObject.parseArray((String)conditionTag, ColorSchemaConditionVo.class);
            ((ColorSchemaConditionVo)conditions.get(0)).setValues(values);
            dataModel.setValue("conditions_tag", (Object)JSONObject.toJSONString((Object)conditions), index);
            this.setDateToColorSchemaCustomControlAp(ruleF7Vos, "openF7", "update");
        }
    }

    private String getOpenF7CloseCallBackId(int index) {
        return String.format("openF7_%s", index);
    }

    private ColorSchemaRuleVo changeDimension(String dimensionId) {
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("colorschemaentry");
        long colorSchemaDimensionId = Long.parseLong(dimensionId);
        ColorSchemaRuleVo defaultRule = null;
        if (colorSchemaDimensionId != 0L) {
            dataModel.setValue("colorschemadimension", (Object)dimensionId);
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            DynamicObject colorSchemaDimension = dataEntity.getDynamicObject("colorschemadimension");
            String fieldDataType = colorSchemaDimension.getString("fielddatatype");
            defaultRule = this.getDefaultRule(fieldDataType);
            if (defaultRule != null) {
                ((ColorSchemaConditionVo)defaultRule.getConditions().get(0)).setDimensionId(dimensionId);
                defaultRule.setIndex(Integer.valueOf(0));
                this.saveColorSchemaRule(defaultRule);
            }
        } else {
            dataModel.setValue("colorschemadimension", null);
        }
        return defaultRule;
    }

    private String saveColorSchemaRuleValidate(ColorSchemaRuleVo colorSchemaRuleVo) {
        DynamicObjectCollection colorSchemaEntry;
        List conditions = colorSchemaRuleVo.getConditions();
        if (CollectionUtils.isEmpty((Collection)conditions)) {
            return null;
        }
        ColorSchemaConditionVo condition = (ColorSchemaConditionVo)conditions.get(0);
        List values = condition.getValues();
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        String compare = condition.getCompare();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject dimension = dataEntity.getDynamicObject("colorschemadimension");
        String fieldDataType = dimension.getString("fielddatatype");
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.BETWEEN.getValue())) {
            List numbers;
            String valuesJson = JSONObject.toJSONString((Object)values);
            List strValues = JSONObject.parseArray((String)valuesJson, String.class);
            List notEmptyValues = strValues.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
            String notEmptyValuesJson = JSONObject.toJSONString(notEmptyValues);
            if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.NUMBER.getCode()) && (numbers = JSONObject.parseArray((String)notEmptyValuesJson, BigDecimal.class)).size() >= 2 && ((BigDecimal)numbers.get(0)).compareTo((BigDecimal)numbers.get(1)) > 0) {
                return ResManager.loadKDString((String)"\u89c4\u5219\u6761\u4ef6\u503c\u8bbe\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"NewCardStyleColorSchemaPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            }
        }
        if ((colorSchemaEntry = this.getModel().getEntryEntity("colorschemaentry")).isEmpty() || colorSchemaEntry.size() == 1) {
            return null;
        }
        String curConditionsTag = JSONObject.toJSONString((Object)colorSchemaRuleVo.getConditions());
        for (int i = 0; i < colorSchemaEntry.size(); ++i) {
            String conditionsTag;
            DynamicObject rule = (DynamicObject)colorSchemaEntry.get(i);
            if (i == colorSchemaRuleVo.getIndex() || HRStringUtils.isEmpty((String)(conditionsTag = rule.getString("conditions_tag"))) || !HRStringUtils.equals((String)curConditionsTag, (String)conditionsTag)) continue;
            return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u89c4\u5219", (String)"NewCardStyleColorSchemaPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private void saveColorSchemaRule(ColorSchemaRuleVo colorSchemaRuleVo) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
        Integer index = colorSchemaRuleVo.getIndex();
        if (index == null) {
            index = colorSchemaEntry.size();
        }
        if (index > colorSchemaEntry.size() - 1) {
            dataModel.createNewEntryRow("colorschemaentry");
        }
        dataModel.setValue("colorcode", (Object)colorSchemaRuleVo.getColor(), index.intValue());
        List conditions = colorSchemaRuleVo.getConditions();
        if (!CollectionUtils.isEmpty((Collection)conditions)) {
            dataModel.setValue("conditions_tag", (Object)JSONObject.toJSONString((Object)conditions), index.intValue());
        }
    }

    private void deleteColorSchemaEntry(int index) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
        if (index < colorSchemaEntry.size()) {
            dataModel.deleteEntryRow("colorschemaentry", index);
        }
    }

    private void setDateToColorSchemaCustomControlAp(Object data, String eventName, String eventStatus) {
        CustomControl customControl = this.getColorSchemaCustomControlAp();
        customControl.setData(NewCardStyleHelper.buildSuccessResultData(data, eventName, eventStatus));
    }

    private CustomControl getColorSchemaCustomControlAp() {
        return (CustomControl)this.getView().getControl("colorschemacontrolap");
    }

    private void initColorSchemaControlAp() {
        try {
            List conditions;
            ColorSchemaVo colorSchemaVo = new ColorSchemaVo();
            ArrayList<ColorSchemaDimensionVo> dimensions = new ArrayList<ColorSchemaDimensionVo>(16);
            ColorSchemaDimensionVo emptyDimension = new ColorSchemaDimensionVo();
            emptyDimension.setId("0");
            emptyDimension.setName(ResManager.loadKDString((String)"\u65e0", (String)"NewCardStyleColorSchemaPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            dimensions.add(emptyDimension);
            DynamicObject[] cardConfigs = OrgCardConfigRepository.getInstance().queryColorSchemaDimensions();
            if (cardConfigs.length != 0) {
                dimensions.addAll(Arrays.stream(cardConfigs).map(cardConfig -> {
                    ColorSchemaDimensionVo dimension = new ColorSchemaDimensionVo();
                    dimension.setId(cardConfig.getString("id"));
                    dimension.setName(cardConfig.getString("name"));
                    String fieldDataType = cardConfig.getString("fielddatatype");
                    dimension.setType(fieldDataType);
                    if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.ENUM.getCode())) {
                        String fieldIdentifier = cardConfig.getString("fieldidentifier");
                        DynamicProperty property = ColorSchemaRuleServiceHelper.getDynamicProperty((DynamicObject)cardConfig, (String)fieldIdentifier);
                        if (property instanceof ComboProp) {
                            ComboProp comboProp = (ComboProp)property;
                            List comboItems = comboProp.getComboItems();
                            dimension.setEnums(comboItems.stream().map(comboItem -> new ColorSchemaRuleKeyValVo(comboItem.getValue(), comboItem.getName().getLocaleValue())).collect(Collectors.toList()));
                        } else if (property instanceof BooleanProp) {
                            ArrayList<ColorSchemaRuleKeyValVo> enums = new ArrayList<ColorSchemaRuleKeyValVo>(2);
                            enums.add(new ColorSchemaRuleKeyValVo("1", ResManager.loadKDString((String)"\u662f", (String)"NewCardStyleColorSchemaPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0])));
                            enums.add(new ColorSchemaRuleKeyValVo("0", ResManager.loadKDString((String)"\u5426", (String)"NewCardStyleColorSchemaPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0])));
                            dimension.setEnums(enums);
                        }
                    }
                    return dimension;
                }).collect(Collectors.toList()));
            }
            colorSchemaVo.setDimensions(dimensions);
            IDataModel dataModel = this.getModel();
            DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
            List<ColorSchemaRuleVo> rules = null;
            if (!colorSchemaEntry.isEmpty()) {
                rules = colorSchemaEntry.stream().map(ColorSchemaServiceHelper::buildColorSchemaRuleVo).collect(Collectors.toList());
            }
            colorSchemaVo.setRules(rules);
            String selectedDimensionId = "0";
            if (rules != null && rules.size() > 0 && !CollectionUtils.isEmpty((Collection)(conditions = ((ColorSchemaRuleVo)rules.get(0)).getConditions()))) {
                selectedDimensionId = ((ColorSchemaConditionVo)conditions.get(0)).getDimensionId();
                dataModel.setValue("colorschemadimension", (Object)selectedDimensionId);
                dataModel.setDataChanged(false);
                DynamicObject selectedDimension = dataModel.getDataEntity().getDynamicObject("colorschemadimension");
                String fieldDataType = selectedDimension.getString("fielddatatype");
                if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode())) {
                    HashSet ids = new HashSet(16);
                    rules.forEach(rule -> {
                        List values = ((ColorSchemaConditionVo)rule.getConditions().get(0)).getValues();
                        ids.addAll(values.stream().map(Long::parseLong).collect(Collectors.toList()));
                    });
                    String entityName = ColorSchemaRuleServiceHelper.getEntityName((DynamicObject)selectedDimension);
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    if (!collection.isEmpty()) {
                        colorSchemaVo.setKeyValMap(collection.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getString("name"), (v1, v2) -> v1)));
                    }
                }
            }
            colorSchemaVo.setDimensionId(selectedDimensionId);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            colorSchemaVo.setEdit(status != OperationStatus.VIEW);
            Map compareMap = ColorSchemaRuleServiceHelper.getCompareMap();
            colorSchemaVo.setCompareMap(compareMap);
            this.setDateToColorSchemaCustomControlAp(colorSchemaVo, "initColorSchemaControlAp", "init");
        }
        catch (Exception e) {
            LOGGER.error("initColorSchemaControlAp error", (Throwable)e);
        }
    }

    private ColorSchemaRuleVo addColorSchemaRule() {
        IDataModel dataModel = this.getModel();
        DynamicObject colorSchemaDimension = dataModel.getDataEntity().getDynamicObject("colorschemadimension");
        String fieldDataType = colorSchemaDimension.getString("fielddatatype");
        ColorSchemaRuleVo addRule = this.getDefaultRule(fieldDataType);
        if (addRule != null) {
            String dimensionId = colorSchemaDimension.getString("id");
            ((ColorSchemaConditionVo)addRule.getConditions().get(0)).setDimensionId(dimensionId);
            this.saveColorSchemaRule(addRule);
        }
        return addRule;
    }

    private void openF7(int index) {
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection colorSchemaEntry = dataModel.getEntryEntity("colorschemaentry");
        if (index > colorSchemaEntry.size() - 1) {
            return;
        }
        DynamicObject dataEntity = dataModel.getDataEntity();
        DynamicObject dimension = dataEntity.getDynamicObject("colorschemadimension");
        String fieldDataType = dimension.getString("fielddatatype");
        if (!HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode())) {
            return;
        }
        String entityName = ColorSchemaRuleServiceHelper.getEntityName((DynamicObject)dimension);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId(entityName);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        showParameter.getOpenStyle().setInlineStyleCss(cssValue);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setCaption(dimension.getString("name"));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setListFilterParameter(listFilterParameter);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        long currUserId = RequestContext.get().getCurrUserId();
        switch (entityName) {
            case "haos_adminorgtype": {
                filter.and(OrgChartServiceHelper.getAdminOrgTypeFilter());
                break;
            }
            case "haos_adminorgteam": 
            case "haos_adminorgf7": {
                filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
                AuthorizedOrgResultWithSub authorizedOrgResultWithSub = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsF7WithSub", (Object[])new Object[]{currUserId, "homs", this.getView().getEntityId(), "47150e89000000ac", "adminorg", HAOSPermUtils.getStructProjectCustomInParam((String)"adminorg", (long)1010L)});
                if (authorizedOrgResultWithSub.isHasAllOrgPerm()) break;
                QFilter permFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)authorizedOrgResultWithSub, (String)"id");
                filter.and(permFilter);
                break;
            }
            default: {
                HasPermOrgResult permOrgResult;
                if (!BaseDataServiceHelper.checkBaseDataCtrl((String)entityName).booleanValue() || (permOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"21", (String)"homs", (String)entityName, (String)"47150e89000000ac", (boolean)false)).hasAllOrgPerm()) break;
                filter.and(BaseDataServiceHelper.getBaseDataFilter((String)entityName, (List)permOrgResult.getHasPermOrgs(), (boolean)true));
            }
        }
        listFilterParameter.setFilter(filter);
        DynamicObject rule = (DynamicObject)colorSchemaEntry.get(index);
        String conditionsTag = rule.getString("conditions_tag");
        if (HRStringUtils.isNotEmpty((String)conditionsTag)) {
            List conditions = JSONObject.parseArray((String)conditionsTag, ColorSchemaConditionVo.class);
            List values = ((ColorSchemaConditionVo)conditions.get(0)).getValues();
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityName, (String)String.join((CharSequence)",", "id", "name"), (QFilter[])new QFilter[]{new QFilter("id", "in", values.stream().map(Long::parseLong).collect(Collectors.toList()))});
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (DynamicObject dyn : collection) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)Long.parseLong(dyn.getString("id")));
                row.setName(dyn.getString("name"));
                listSelectedRows.add((Object)row);
            }
            showParameter.setListSelectedRowCollection(listSelectedRows);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getOpenF7CloseCallBackId(index)));
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ColorSchemaRuleVo getDefaultRule(String fieldDataType) {
        ColorSchemaRuleVo colorSchemaRule = null;
        if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.NUMBER.getCode()) || HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DATE.getCode())) {
            colorSchemaRule = NewCardStyleColorSchemaPlugin.buildColorSchemaRuleVo(Collections.emptyList(), CompareEnum.BETWEEN.getValue());
        } else if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode()) || HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.ENUM.getCode()) || HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.STRING.getCode())) {
            colorSchemaRule = NewCardStyleColorSchemaPlugin.buildColorSchemaRuleVo(Collections.emptyList(), CompareEnum.IN.getValue());
        } else {
            LOGGER.error("Unsupported fieldDataType:{}", (Object)fieldDataType);
        }
        return colorSchemaRule;
    }

    private static ColorSchemaRuleVo buildColorSchemaRuleVo(List<String> values, String compare) {
        ColorSchemaRuleVo colorSchemaRuleVo = new ColorSchemaRuleVo();
        colorSchemaRuleVo.setColor("#276FF5");
        ColorSchemaConditionVo condition = new ColorSchemaConditionVo();
        condition.setCompare(compare);
        condition.setValues(values);
        colorSchemaRuleVo.setConditions((List)Lists.newArrayList((Object[])new ColorSchemaConditionVo[]{condition}));
        return colorSchemaRuleVo;
    }
}

