/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.newcardstyle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.homs.business.service.orgchart.OrgChartNewServiceHelper;
import kd.hr.homs.formplugin.web.orgchart.ChartHelper;

public class NewCardStyleListPlugin
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(NewCardStyleListPlugin.class);
    private static final Long VIRTUAL_ORG_TYPE_ID = 1010L;

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter permissionFilter;
        List filters = setFilterEvent.getQFilters();
        super.setFilter(setFilterEvent);
        if (HRStringUtils.equals((String)"bos_list", (String)this.getView().getFormShowParameter().getFormId()) && !HRObjectUtils.isEmpty((Object)(permissionFilter = ChartHelper.buildPermissionFilter(this.getView().getFormShowParameter(), "carddimension", "adminorg")))) {
            filters.add(permissionFilter);
        }
        filters.add(new QFilter("id", "!=", (Object)VIRTUAL_ORG_TYPE_ID));
        if (OrgChartNewServiceHelper.isUseNewStructureChart()) {
            filters.add(new QFilter("cardstyleflag", "in", Arrays.asList("1", "2")));
        } else {
            filters.add(new QFilter("cardstyleflag", "!=", (Object)"1"));
        }
        filters.add(new QFilter("carddimension", "=", (Object)Long.parseLong("1010")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("enable".equals(operateKey) || "audit".equals(operateKey)) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds.isEmpty()) {
                return;
            }
            Set idSet = successPkIds.stream().map(pkId -> (Long)pkId).collect(Collectors.toSet());
            DynamicObject[] newChartStyleById = OrgChartNewServiceHelper.getNewChartStyleById(idSet);
            ArrayList<DynamicObject> needSaveObject = new ArrayList<DynamicObject>(newChartStyleById.length);
            for (DynamicObject dyn : newChartStyleById) {
                String message = OrgChartNewServiceHelper.checkChartStyle((DynamicObject)dyn, (boolean)true, (boolean)"audit".equals(operateKey));
                if (message != null) {
                    if ("".equals(message)) continue;
                    this.getView().showTipNotification(message);
                    continue;
                }
                needSaveObject.add(dyn);
            }
            needSaveObject.stream().forEach(OrgChartNewServiceHelper::saveChartStyleFromChartCard);
        }
    }
}

