/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.newcardstyle;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.OrgChartNewServiceHelper;
import kd.hr.homs.business.service.utils.RulePreviewUtil;
import kd.hr.homs.common.model.ColorSchemaBo;
import kd.hr.homs.formplugin.web.newcardstyle.service.NewCardStyleHelper;
import kd.hr.homs.formplugin.web.newcardstyle.vo.CardStyleStdlibVo;
import kd.hr.homs.formplugin.web.newcardstyle.vo.ExampleTreeData;
import kd.hr.homs.formplugin.web.newcardstyle.vo.NewCardConfig;
import kd.hr.homs.formplugin.web.newcardstyle.vo.NewCardStyleConstant;
import kd.hr.homs.formplugin.web.newcardstyle.vo.NewCardStyleInitData;
import kd.hr.homs.formplugin.web.newcardstyle.vo.PresetFieldGroup;
import kd.hr.homs.formplugin.web.neworgchart.vo.NewChartHelper;
import kd.hr.homs.formplugin.web.orgchart.ChartHelper;

public class NewCardStylePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
NewCardStyleConstant {
    private static final Log LOG = LogFactory.getLog(NewCardStylePlugin.class);
    private static final String BELONGS_ADMINORG = "adminorg";
    private static final String APPLY_ADMINORG = "adminorgid";
    private static final String CARDDIMENSION_ID = "carddimension.id";
    private static final String ORGENTRYENTITY = "orgentryentity";
    private static final String ORGTEAMTOENTRY = "orgteamtoentry";
    private static final String COLOR_RULE_CALL_BACK_ID = "color_rule_call_back_id";
    private static final String SELECTED_ALL_FIELDS = "selectedAllFields";
    private static final String SELECTED_DEFAULT_FIELDS = "selectedDefaultFields";
    private static final String IS_EDITED_CARD_STYLE = "is_edited_cardstyle";
    private static final List<Long> CARD_SELECTED_FIELD_IDS = Arrays.asList(1010L, 1040L, 1050L, 1060L, 1070L, 1210L);
    private static final List<Long> TEMPLATE_ONE_ID = Collections.singletonList(1010L);
    private static final List<Long> TEMPLATE_THREE_IDS = Arrays.asList(1010L, 1150L, 1190L, 1110L, 1120L);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OperationStatus status = e.getFormShowParameter().getStatus();
        if (this.isPageStatusNew(status)) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5361\u7247\u6837\u5f0f", (String)"CardStylePlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (OperationStatus.EDIT == status) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle_new");
            DynamicObject dy = helper.queryOne("name", ((BaseShowParameter)e.getSource()).getPkId());
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5361\u7247\u6837\u5f0f-%s", (String)"CardStylePlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), dy.getString("name"));
            e.getFormShowParameter().setCaption(message);
        }
    }

    private boolean isPageStatusNew(OperationStatus status) {
        return OperationStatus.ADDNEW == status;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(BELONGS_ADMINORG);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminorgscopeEdit = (BasedataEdit)this.getView().getControl(APPLY_ADMINORG);
        adminorgscopeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar orgtoolbar = (Toolbar)this.getView().getControl("orgadvcontoolbarap");
        orgtoolbar.addItemClickListener((ItemClickListener)this);
        Toolbar colorToolBar = (Toolbar)this.getView().getControl("advcontoolbarap");
        colorToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long pkValue = this.getModel().getDataEntity().getLong("id");
        if (pkValue == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"carddimension"});
            CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
            customcontrolap.setData(NewCardStyleHelper.buildSuccessResultData(this.initCustomControlData(), "addCardStyle", "init"));
        }
    }

    private NewCardStyleInitData initCustomControlData() {
        NewCardStyleInitData initData = new NewCardStyleInitData();
        ExampleTreeData exampleTreeData = new ExampleTreeData("test1001");
        kd.hr.homs.formplugin.web.neworgchart.vo.ExampleTreeData exampleTreeData1 = NewChartHelper.getExampleTreeData();
        exampleTreeData.setShowFields(exampleTreeData1.getShowFields());
        List<CardStyleStdlibVo> presetCardStyleRuleList = this.getPresetCardStyleRule();
        List<NewCardConfig> cardSelectedFields = this.getCardSelectedFields(CARD_SELECTED_FIELD_IDS);
        List<PresetFieldGroup> presetFieldsGroup = this.getPresetFieldGroup();
        initData.setExampleTreeData(exampleTreeData);
        initData.setPresetCardStyleRuleList(presetCardStyleRuleList);
        initData.setCardSelectedFields(cardSelectedFields);
        initData.setPresetFieldsGroup(presetFieldsGroup);
        this.setSelectedFields(initData);
        return initData;
    }

    private void setSelectedFields(NewCardStyleInitData initData) {
        List selectAllFieldList;
        List<String> selectDefaultFieldList;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardconfig");
        long carddimensionid = this.getModel().getDataEntity(true).getLong(CARDDIMENSION_ID);
        QFilter cardDimensionFilter = new QFilter("carddimension", "=", (Object)carddimensionid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] allFieldConfig = helper.queryOriginalArray("id,name,fieldidentifier,fieldtype,fieldgroup,iconcode,iconclassname,iconurl,index,sampledate", new QFilter[]{cardDimensionFilter, enableFilter}, "index");
        List<NewCardConfig> allFieldList = Arrays.stream(allFieldConfig).map(dy -> {
            NewCardConfig cardConfig = new NewCardConfig();
            cardConfig.setId(dy.getString("id"));
            cardConfig.setName(dy.getString("name"));
            cardConfig.setKey(dy.getString("fieldidentifier"));
            cardConfig.setRender(Integer.parseInt(dy.getString("fieldtype")));
            cardConfig.setFieldSort(dy.getString("fieldgroup"));
            cardConfig.setIndex(dy.getInt("index"));
            cardConfig.setIconClassName(dy.getString("iconclassname"));
            cardConfig.setIconCode(dy.getString("iconcode"));
            cardConfig.setIconUrl(dy.getString("iconurl"));
            if ("name".equals(dy.getString("fieldidentifier"))) {
                cardConfig.setIsEdit(0);
            } else {
                cardConfig.setIsEdit(1);
            }
            return cardConfig;
        }).collect(Collectors.toList());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (this.isPageStatusNew(status) && !this.isCopy()) {
            selectDefaultFieldList = Arrays.stream(allFieldConfig).filter(field -> CARD_SELECTED_FIELD_IDS.contains(field.getLong("id"))).map(field -> field.getString("id")).collect(Collectors.toList());
            selectAllFieldList = allFieldList.stream().map(NewCardConfig::getId).collect(Collectors.toList());
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("cardentryentity");
            Map isDefaultVsSelectedFieldList = entryEntity.stream().collect(Collectors.groupingBy(row -> "1".equals(row.getString("isdefault")), Collectors.mapping(row -> {
                DynamicObject field = row.getDynamicObject("cardcontentid");
                return field.getString("id");
            }, Collectors.toList())));
            selectDefaultFieldList = isDefaultVsSelectedFieldList.getOrDefault(Boolean.TRUE, Collections.emptyList());
            selectAllFieldList = isDefaultVsSelectedFieldList.getOrDefault(Boolean.FALSE, new ArrayList());
            selectAllFieldList.addAll(selectDefaultFieldList);
            selectAllFieldList = selectAllFieldList.stream().distinct().collect(Collectors.toList());
        }
        initData.setAllFields(allFieldList);
        initData.setSelectedAllFields(selectAllFieldList);
        initData.setSelectedDefaultFields(selectDefaultFieldList);
    }

    private boolean isCopy() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)formShowParameter.getCustomParam("iscopy");
        return isCopy != null && isCopy != false;
    }

    private Map<String, Object> getExampleTreeData() {
        HashMap<String, Object> exampleDataMap = new HashMap<String, Object>(16);
        exampleDataMap.put("name", ResManager.loadKDString((String)"\u4eba\u529b\u8d44\u6e90\u90e8", (String)"NewCardStylePlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        exampleDataMap.put("personname", ResManager.loadKDString((String)"\u97e9\u4e3d\u4e3d", (String)"NewCardStylePlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        exampleDataMap.put("personavtor", "/images/pc/other/hr_kptx1_200_200.png");
        exampleDataMap.put("positionname", ResManager.loadKDString((String)"\u4eba\u529b\u8d44\u6e90\u603b\u76d1", (String)"NewCardStylePlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        exampleDataMap.put("personcount", 30);
        exampleDataMap.put("positioncount", 5);
        exampleDataMap.put("establishmentdate", "2012-08-02");
        exampleDataMap.put("adminorgfunction.name", ResManager.loadKDString((String)"\u4eba\u529b\u8d44\u6e90", (String)"NewCardStylePlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        exampleDataMap.put("companyarea.name", ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"NewCardStylePlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        exampleDataMap.put("city.name", ResManager.loadKDString((String)"\u6df1\u5733", (String)"NewCardStylePlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        return exampleDataMap;
    }

    private List<CardStyleStdlibVo> getPresetCardStyleRule() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_cardstylestdlib");
        long carddimensionid = this.getModel().getDataEntity(true).getLong(CARDDIMENSION_ID);
        QFilter cardDimensionFilter = new QFilter("carddimension", "=", (Object)carddimensionid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] dynamicObjects = serviceHelper.queryOriginalArray("id,number,name,issyspreset,cardstyle_tag", new QFilter[]{cardDimensionFilter, enableFilter});
        if (HRArrayUtils.isEmpty((Object[])(dynamicObjects = (DynamicObject[])Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getString("number"))).toArray(DynamicObject[]::new)))) {
            return new ArrayList<CardStyleStdlibVo>(0);
        }
        return Arrays.stream(dynamicObjects).map(dynamicObject -> {
            CardStyleStdlibVo stdlibVo = new CardStyleStdlibVo();
            stdlibVo.setId(dynamicObject.getString("id"));
            stdlibVo.setName(dynamicObject.getString("name"));
            stdlibVo.setCardStyle(dynamicObject.getString("cardstyle_tag"));
            return stdlibVo;
        }).collect(Collectors.toList());
    }

    private List<NewCardConfig> getNewCardConfig() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardconfig");
        long carddimensionid = this.getModel().getDataEntity(true).getLong(CARDDIMENSION_ID);
        QFilter cardDimensionFilter = new QFilter("carddimension", "=", (Object)carddimensionid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Object[] dynamicObjects = helper.queryOriginalArray("id,name,fieldidentifier,fieldtype,fieldgroup,iconcode,iconclassname,iconurl,index,sampledate", new QFilter[]{cardDimensionFilter, enableFilter});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new ArrayList<NewCardConfig>(0);
        }
        return Arrays.stream(dynamicObjects).map(dy -> {
            NewCardConfig cardConfig = new NewCardConfig();
            cardConfig.setId(dy.getString("id"));
            cardConfig.setName(dy.getString("name"));
            cardConfig.setKey(dy.getString("fieldidentifier"));
            cardConfig.setRender(Integer.parseInt(dy.getString("fieldtype")));
            cardConfig.setFieldSort(dy.getString("fieldgroup"));
            cardConfig.setIndex(dy.getInt("index"));
            cardConfig.setIconClassName(dy.getString("iconclassname"));
            cardConfig.setIconCode(dy.getString("iconcode"));
            cardConfig.setIconUrl(dy.getString("iconurl"));
            String sampleData = dy.getString("sampledate");
            if (!StringUtils.isEmpty((String)sampleData)) {
                cardConfig.setSampleData(sampleData.split("!")[0]);
            }
            if ("name".equals(dy.getString("fieldidentifier"))) {
                cardConfig.setIsEdit(0);
            }
            return cardConfig;
        }).sorted(Comparator.comparingInt(NewCardConfig::getIndex)).collect(Collectors.toList());
    }

    private List<NewCardConfig> getCardSelectedFields(List<Long> ids) {
        List<NewCardConfig> newCardConfig = this.getNewCardConfig();
        return newCardConfig.stream().filter(data -> ids.contains(Long.parseLong(data.getId()))).collect(Collectors.toList());
    }

    private List<PresetFieldGroup> getPresetFieldGroup() {
        ArrayList<PresetFieldGroup> presetFieldsGroup = new ArrayList<PresetFieldGroup>();
        PresetFieldGroup presetFieldGroup1 = new PresetFieldGroup("sf001", ResManager.loadKDString((String)"\u4ec5\u5c55\u793a\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u65f6", (String)"NewCardStylePlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]), 28);
        presetFieldGroup1.setList(this.getCardSelectedFields(TEMPLATE_ONE_ID));
        PresetFieldGroup presetFieldGroup2 = new PresetFieldGroup("sf002", ResManager.loadKDString((String)"\u5f53\u5c55\u793a\u8d1f\u8d23\u4eba\u4e0e\u6570\u5b57\u4fe1\u606f\u65f6", (String)"NewCardStylePlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), 136);
        presetFieldGroup2.setList(this.getCardSelectedFields(CARD_SELECTED_FIELD_IDS));
        PresetFieldGroup presetFieldGroup3 = new PresetFieldGroup("sf003", ResManager.loadKDString((String)"\u5f53\u5c55\u793a\u6587\u672c\u4fe1\u606f\u65f6", (String)"NewCardStylePlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), 104);
        presetFieldGroup3.setList(this.getCardSelectedFields(TEMPLATE_THREE_IDS));
        presetFieldsGroup.add(presetFieldGroup1);
        presetFieldsGroup.add(presetFieldGroup2);
        presetFieldsGroup.add(presetFieldGroup3);
        return presetFieldsGroup;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long pkValue = (Long)this.getModel().getDataEntity(true).getPkValue();
        Boolean iscopy = (Boolean)((BaseView)e.getSource()).getFormShowParameter().getCustomParam("iscopy");
        if (pkValue == 0L && iscopy == null) {
            this.getPageCache().put(ORGTEAMTOENTRY, "1");
        } else {
            this.getPageCache().put(ORGTEAMTOENTRY, "0");
            this.getPageCache().put(IS_EDITED_CARD_STYLE, "1");
            this.initColorEntry();
            this.updateCSColorEntry();
            this.updateOrgEntryNumber();
        }
        if (this.isCopy(iscopy)) {
            return;
        }
        if (pkValue > 0L) {
            this.getView().setStatus(OperationStatus.VIEW);
            CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
            NewCardStyleInitData initData = this.initCustomControlData();
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardstyle_new");
            DynamicObject dynamicObject = helper.queryOne("cardstyle_tag", (Object)pkValue);
            initData.setCardStyleRule(dynamicObject.getString("cardstyle_tag"));
            customcontrolap.setData(NewCardStyleHelper.buildSuccessResultData(initData, "initCardStyle", "init"));
        }
        this.getModel().setDataChanged(false);
    }

    private void initColorEntry() {
        DynamicObjectCollection colorEntry = this.getModel().getEntryEntity("colorschemaentry");
        for (DynamicObject row : colorEntry) {
            DynamicObjectCollection entryrulelist;
            row.set("color", (Object)"\u2587\u2587");
            DynamicObject policy = row.getDynamicObject("policy");
            if (HRObjectUtils.isEmpty((Object)policy) || CollectionUtils.isEmpty((Collection)(entryrulelist = policy.getDynamicObjectCollection("entryrulelist")))) continue;
            row.set("rule", (Object)this.getConditionPreviewStr(((DynamicObject)entryrulelist.get(0)).getString("filtercondition")));
        }
    }

    private boolean isCopy(Boolean iscopy) {
        if (iscopy != null && iscopy.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"carddimension"});
            this.updateOrgEntryNumber();
            CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
            NewCardStyleInitData initData = this.initCustomControlData();
            String cardstyle = this.getModel().getDataEntity(true).getString("cardstyle_tag");
            initData.setCardStyleRule(cardstyle);
            customcontrolap.setData(NewCardStyleHelper.buildSuccessResultData(initData, "copyCardStyle", "init"));
            this.getModel().setDataChanged(false);
            return true;
        }
        return false;
    }

    private void updateOrgEntryNumber() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ORGENTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getModel().beginInit();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)dynamicObjectCollection.get(i);
                this.getModel().setValue("adminorgnumber", (Object)entryDy.getString("adminorgid.number").substring(4), i);
            }
            this.getModel().endInit();
            this.getView().updateView(ORGENTRYENTITY);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.deleteBlankRow();
        Long pkValue = (Long)this.getModel().getDataEntity(true).getPkValue();
        if (pkValue > 0L) {
            this.setStatus();
        }
    }

    private void setStatus() {
        boolean isSysPreSet = this.getModel().getDataEntity(true).getBoolean("issyspreset");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        if (isSysPreSet) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify", "bar_enable"});
        } else if ("1".equals(this.getModel().getDataEntity(true).getString("enable"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_enable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        Object newValue;
        ChangeData[] changeSet;
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)BELONGS_ADMINORG, (String)name)) {
            String orgteamToEntry = this.getPageCache().get(ORGTEAMTOENTRY);
            if (HRStringUtils.isNotEmpty((String)orgteamToEntry) && HRStringUtils.equals((String)"1", (String)orgteamToEntry)) {
                DynamicObject orgTeam = this.getModel().getDataEntity().getDynamicObject(BELONGS_ADMINORG);
                DynamicObjectCollection orgentryentity = this.getModel().getEntryEntity(ORGENTRYENTITY);
                if (!HRObjectUtils.isEmpty((Object)orgTeam) && orgentryentity.size() == 0) {
                    this.getModel().createNewEntryRow(ORGENTRYENTITY);
                    this.getModel().setValue(APPLY_ADMINORG, (Object)orgTeam, 0);
                    this.getModel().setValue("adminorgnumber", (Object)orgTeam.getString("number").substring(4));
                    this.getPageCache().put(ORGTEAMTOENTRY, "0");
                }
            }
        } else if (HRStringUtils.equals((String)APPLY_ADMINORG, (String)name) && (changeSet = e.getChangeSet()) != null && changeSet.length != 0 && (newValue = (changeData = changeSet[0]).getNewValue()) instanceof DynamicObject) {
            DynamicObject dataEntity = changeData.getDataEntity();
            dataEntity.set("adminorgnumber", (Object)((DynamicObject)newValue).getString("number").substring(4));
            this.getView().updateView(ORGENTRYENTITY);
        }
    }

    private void deleteBlankRow() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ORGENTRYENTITY);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ORGENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection) && entryCurrentRowIndex > 0) {
            this.getModel().deleteEntryRow(ORGENTRYENTITY, entryCurrentRowIndex);
        } else {
            for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
                DynamicObject dy = (DynamicObject)dynamicObjectCollection.get(index);
                if (dy.getDynamicObject(APPLY_ADMINORG) != null && dy.getLong("adminorgid.id") != 0L) continue;
                this.getModel().deleteEntryRow(ORGENTRYENTITY, index);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowParameter;
        String key = beforeF7SelectEvent.getProperty().getName();
        long carddimensionId = this.getModel().getDataEntity().getLong(CARDDIMENSION_ID);
        ChartHelper helper = new ChartHelper();
        if (BELONGS_ADMINORG.equals(key)) {
            formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            beforeF7SelectEvent.getCustomQFilters().add(helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter()));
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7", (String)"CardStylePlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (APPLY_ADMINORG.equals(key)) {
            formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setFormId("bos_listf7");
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"CardStylePlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            QFilter permFilter = helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter());
            QFilter orgIdFilter = this.getAlreadyChooseOrg();
            beforeF7SelectEvent.getCustomQFilters().add(permFilter);
            beforeF7SelectEvent.getCustomQFilters().add(orgIdFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dataEntity;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            Object cardstyleflag = this.getModel().getValue("cardstyleflag");
            boolean checkColorDimensionFail = this.checkColorDimension();
            if (checkColorDimensionFail) {
                String msg = ResManager.loadKDString((String)"\u914d\u8272\u65b9\u6848\u4fe1\u606f\u4e2d\u7684\u663e\u793a\u7ef4\u5ea6\u4e0e\u89c4\u5219\u4e2d\u7684\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NewChartOrgChartPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            String editFlag = this.getPageCache().get(IS_EDITED_CARD_STYLE);
            if (!"1".equals(editFlag)) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u201c\u5361\u7247\u6837\u5f0f\u201d\u7684\u201c\u5b8c\u6210\u201d\uff0c\u518d\u4fdd\u5b58\u3002", (String)"NewChartOrgChartPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                args.setCancel(true);
                return;
            }
            List<String> checkRuleResult = this.checkRule();
            if (!CollectionUtils.isEmpty(checkRuleResult)) {
                this.getView().showTipNotification(checkRuleResult.get(0));
                args.setCancel(true);
                return;
            }
        }
        if (("disable".equals(operateKey) || "enable".equals(operateKey) || "modify".equals(operateKey)) && !ChartHelper.checkOrgTeamPerm(dataEntity = this.getModel().getDataEntity(), this.getView().getFormShowParameter(), "carddimension", BELONGS_ADMINORG)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6570\u636e\u7684\u6240\u5c5e\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgChartStyleEditPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("number")}));
        }
    }

    private boolean checkColorDimension() {
        DynamicObjectCollection colorEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("colorschemaentry");
        String colorDimension = this.getModel().getDataEntity().getString("colordimension");
        Set ruleParamSet = colorEntry.stream().filter(OrgChartNewServiceHelper.validEntryValue()).map(row -> {
            DynamicObject policy = row.getDynamicObject("policy");
            DynamicObjectCollection entryrulelist = policy.getDynamicObjectCollection("entryrulelist");
            return ((DynamicObject)entryrulelist.get(0)).getString("filtercondition");
        }).map(conditionJson -> (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class)).map(ruleConditionInfo -> (ConditionInfo)ruleConditionInfo.getConditionList().get(0)).map(ConditionInfo::getParam).map(param -> {
            if ("type.haos_adminorgtype.id".equals(param)) {
                return "1";
            }
            if ("layer.haos_adminorglayer.id".equals(param)) {
                return "2";
            }
            return "0";
        }).collect(Collectors.toSet());
        return ruleParamSet.stream().anyMatch(entryColorDimension -> !colorDimension.equals(entryColorDimension));
    }

    private List<String> checkRule() {
        DynamicObjectCollection colorEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("colorschemaentry");
        Map colorVsRuleJsonList = colorEntry.stream().filter(OrgChartNewServiceHelper.validEntryValue()).collect(Collectors.groupingBy(row -> row.getString("colorcode"), Collectors.mapping(row -> {
            DynamicObject policy = row.getDynamicObject("policy");
            DynamicObjectCollection entryrulelist = policy.getDynamicObjectCollection("entryrulelist");
            return ((DynamicObject)entryrulelist.get(0)).getString("filtercondition");
        }, Collectors.toList())));
        return OrgChartNewServiceHelper.validRule(colorVsRuleJsonList);
    }

    public void itemClick(ItemClickEvent evt) {
        String colorDimension;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tb_neworgentry".equals(itemKey)) {
            long carddimensionId = this.getModel().getDataEntity().getLong(CARDDIMENSION_ID);
            ChartHelper helper = new ChartHelper();
            QFilter permFilter = helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter());
            QFilter idFilter = this.getAlreadyChooseOrg();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(permFilter);
            filters.add(idFilter);
            filters.add(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter listShowParameter = this.getF7ListShowParameter(filters);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("advconbaritemap".equals(itemKey) && HRStringUtils.isNotEmpty((String)(colorDimension = this.getModel().getDataEntity().getString("colordimension"))) && !"0".equals(colorDimension)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("homs_colorschema");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("colordimension", (Object)colorDimension);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COLOR_RULE_CALL_BACK_ID));
            this.getView().showForm(showParameter);
        }
    }

    private QFilter getAlreadyChooseOrg() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ORGENTRYENTITY);
        List ids = dynamicObjectCollection.stream().map(dy -> dy.getLong("adminorgid.id")).collect(Collectors.toList());
        return new QFilter("id", "not in", ids);
    }

    private ListShowParameter getF7ListShowParameter(List<QFilter> filters) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setMultiSelect(true);
        listShowParameter.setBillFormId("haos_adminorgteam");
        listShowParameter.setFormId("bos_listf7");
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("900px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        listShowParameter.setOpenStyle(style);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"CardStylePlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        if (filters != null && !filters.isEmpty()) {
            listShowParameter.getListFilterParameter().setQFilters(filters);
        }
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showOrgCallbackId"));
        listShowParameter.setHasRight(true);
        return listShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "showOrgCallbackId": {
                this.fillOrgEntryEntity(closedCallBackEvent);
                break;
            }
            case "color_rule_call_back_id": {
                this.fillColorEntry(closedCallBackEvent);
                break;
            }
        }
    }

    private void fillColorEntry(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            ColorSchemaBo colorSchemaBo = (ColorSchemaBo)closedCallBackEvent.getReturnData();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("rule", new Object[]{this.getConditionPreviewStr(colorSchemaBo.getRule())});
            vs.addField("color", new Object[]{"\u2587\u2587"});
            vs.addField("colorcode", new Object[]{colorSchemaBo.getColor()});
            vs.addField("policy", new Object[]{colorSchemaBo.getRuleId()});
            model.batchCreateNewEntryRow("colorschemaentry", vs);
            model.endInit();
            this.getView().updateView("colorschemaentry");
            this.updateCSColorEntry();
        }
    }

    private String getConditionPreviewStr(String ruleJson) {
        return RulePreviewUtil.getConditionPreviewStr((String)ruleJson);
    }

    private void updateCSColorEntry() {
        DynamicObjectCollection colorEntry = this.getModel().getEntryEntity("colorschemaentry");
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(colorEntry.size());
        for (int i = 0; i < colorEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)colorEntry.get(i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey("color");
            cellStyle.setForeColor(row.getString("colorcode"));
            cellStyleList.add(cellStyle);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("colorschemaentry");
        entryGrid.setCellStyle(cellStyleList);
    }

    private void fillOrgEntryEntity(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            listSelectedRows.forEach(selectedRow -> {
                vs.addField(APPLY_ADMINORG, new Object[]{selectedRow});
                vs.addField("adminorgnumber", new Object[]{selectedRow.getNumber()});
            });
            model.batchCreateNewEntryRow(ORGENTRYENTITY, vs);
            model.endInit();
            this.getView().updateView(ORGENTRYENTITY);
            this.getPageCache().put(ORGTEAMTOENTRY, "0");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String eventName;
        switch (eventName = customEventArgs.getEventName()) {
            case "submitCardStyle": {
                this.dealWithCardDatas(customEventArgs);
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_save"});
                this.getPageCache().put(IS_EDITED_CARD_STYLE, "1");
                break;
            }
            case "editStatus": {
                this.editCardStyle(customEventArgs);
                break;
            }
        }
    }

    private void dealWithCardDatas(CustomEventArgs customEventArgs) {
        String returnData = customEventArgs.getEventArgs();
        if (HRStringUtils.isNotEmpty((String)returnData)) {
            HashMap returnMap = (HashMap)JSONObject.parseObject((String)returnData, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            String cardstylestdlibid = (String)returnMap.get("cardstylestdlibid");
            Object cardStyleRule = returnMap.get("cardStyleRule");
            List selectedAllFieldList = returnMap.getOrDefault(SELECTED_ALL_FIELDS, new ArrayList());
            List selectedDefaultFieldList = returnMap.getOrDefault(SELECTED_DEFAULT_FIELDS, new ArrayList());
            this.getModel().setValue("cardstylestdlibid", (Object)Long.parseLong(cardstylestdlibid));
            this.getModel().setValue("cardstyle_tag", cardStyleRule);
            this.getModel().setValue("cardstyleflag", (Object)"1");
            this.getView().updateView("cardstylestdlibid");
            this.getView().updateView("cardstyle_tag");
            this.getView().updateView("cardstyleflag");
            this.setFieldEntry(selectedAllFieldList, selectedDefaultFieldList);
        }
    }

    private void editCardStyle(CustomEventArgs customEventArgs) {
        this.getPageCache().put(IS_EDITED_CARD_STYLE, "0");
    }

    private void setFieldEntry(List<String> selectedAllFieldList, List<String> selectedDefaultFieldList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("cardentryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        selectedAllFieldList.forEach(id -> {
            vs.addField("cardcontentid", new Object[]{id});
            vs.addField("isdefault", new Object[]{Character.valueOf('0')});
        });
        selectedDefaultFieldList.forEach(field -> {
            vs.addField("cardcontentid", new Object[]{field});
            vs.addField("isdefault", new Object[]{Character.valueOf('1')});
        });
        model.batchCreateNewEntryRow("cardentryentity", vs);
        model.endInit();
        this.getView().updateView("cardentryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)afterDoOperationEventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "modify": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"carddimension"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable", "bar_disable", "bar_modify"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
                customcontrolap.setData(NewCardStyleHelper.buildSuccessResultData(null, "editCardStyle", "update"));
                break;
            }
            case "enable": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable", "bar_modify"});
                if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                    String message = OrgChartNewServiceHelper.checkChartStyle((DynamicObject)this.getModel().getDataEntity(), (boolean)true, (boolean)false);
                    if (message == null) {
                        OrgChartNewServiceHelper.saveChartStyleFromChartCard((DynamicObject)this.getModel().getDataEntity());
                    } else if (this.getView().getParentView() != null && !"".equals(message)) {
                        this.getView().getParentView().showTipNotification(message);
                    }
                }
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
                break;
            }
            case "disable": {
                boolean success;
                if (afterDoOperationEventArgs.getOperationResult() == null || !(success = afterDoOperationEventArgs.getOperationResult().isSuccess())) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_enable"});
                this.getView().setStatus(OperationStatus.VIEW);
                break;
            }
            case "deleteentryorg": 
            case "save": {
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if ("save".equals(operateKey) && operationResult.isSuccess()) {
                    String message = OrgChartNewServiceHelper.checkChartStyle((DynamicObject)this.getModel().getDataEntity(), (boolean)false, (boolean)false);
                    if (message == null) {
                        OrgChartNewServiceHelper.saveChartStyleFromChartCard((DynamicObject)this.getModel().getDataEntity());
                    } else if (this.getView().getParentView() != null && !"".equals(message)) {
                        this.getView().getParentView().showTipNotification(message);
                    }
                }
                this.getView().setStatus(status);
                break;
            }
        }
    }

    private boolean validateCardStyleIsUsing() {
        long cardid = this.getModel().getDataEntity(true).getLong("id");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select fcardstyleid from t_homs_chartstyleentry where fcardstyleid = ? ");
        DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_chartstyleentry", (DBRoute)new DBRoute("haos"), (String)selectSql.toString(), (Object[])new Long[]{cardid});
        if (!rs.isEmpty()) {
            String message = ResManager.loadKDString((String)"\u8be5\u5361\u7247\u6837\u5f0f\u5df2\u88ab\u7ed3\u6784\u56fe\u6837\u5f0f\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u5361\u7247\u6837\u5f0f\u3002", (String)"CardStylePlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
        }
        return !rs.isEmpty();
    }
}

