/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.newcardstyle.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.domain.repository.OrgCardConfigRepository;
import kd.hr.homs.business.domain.repository.OrgCardStyleNewRepository;
import kd.hr.homs.common.enums.orgchart.CompareEnum;
import kd.hr.homs.common.enums.orgchart.FieldDataTypeEnum;
import kd.hr.homs.common.model.colorschema.ColorSchemaConditionVo;
import kd.hr.homs.common.model.colorschema.ColorSchemaRuleVo;
import kd.hr.homs.formplugin.web.neworgchart.vo.OrgChartData;

public class ColorSchemaServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ColorSchemaServiceHelper.class);

    public static Map<String, String> getOrgChartColorMap(OrgChartData orgChartData, String chartStyleId) {
        try {
            LOGGER.info("getOrgChartColorMap start chartStyleId:{}", (Object)chartStyleId);
            if (HRStringUtils.isEmpty((String)chartStyleId)) {
                LOGGER.error("chartStyleId is empty");
                return Collections.emptyMap();
            }
            DynamicObject chartStyle = OrgCardStyleNewRepository.getInstance().queryByPk(String.join((CharSequence)",", "colorschemaentry.conditions_tag", "colorschemaentry.colorcode"), (Object)Long.parseLong(chartStyleId));
            if (HRObjectUtils.isEmpty((Object)chartStyle)) {
                LOGGER.error("chartStyle is empty");
                return Collections.emptyMap();
            }
            if (orgChartData == null) {
                return Collections.emptyMap();
            }
            DynamicObjectCollection colorSchemaEntry = chartStyle.getDynamicObjectCollection("colorschemaentry");
            if (colorSchemaEntry.isEmpty()) {
                LOGGER.info("colorSchemaEntry is empty");
                return Collections.emptyMap();
            }
            String conditionsTag = ((DynamicObject)colorSchemaEntry.get(0)).getString("conditions_tag");
            if (HRStringUtils.isEmpty((String)conditionsTag)) {
                LOGGER.error("conditionsTag is empty");
                return Collections.emptyMap();
            }
            List conditionVos = JSON.parseArray((String)conditionsTag, ColorSchemaConditionVo.class);
            ColorSchemaConditionVo conditionVo = (ColorSchemaConditionVo)conditionVos.get(0);
            String dimensionId = conditionVo.getDimensionId();
            DynamicObject dimension = OrgCardConfigRepository.getInstance().queryByPk(String.join((CharSequence)",", "fieldidentifier", "fielddatatype"), (Object)Long.parseLong(dimensionId));
            String fieldName = dimension.getString("fieldidentifier");
            String fieldDataType = dimension.getString("fielddatatype");
            List<ColorSchemaRuleVo> rules = colorSchemaEntry.stream().map(ColorSchemaServiceHelper::buildColorSchemaRuleVo).collect(Collectors.toList());
            HashMap<String, String> orgColorMap = new HashMap<String, String>(16);
            ColorSchemaServiceHelper.matchOrgChartColor(orgColorMap, orgChartData, fieldName, fieldDataType, rules);
            LOGGER.info("orgColorMap:{}", orgColorMap);
            return orgColorMap;
        }
        catch (Exception e) {
            LOGGER.error("getOrgColorMap error", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static ColorSchemaRuleVo buildColorSchemaRuleVo(DynamicObject colorSchema) {
        ColorSchemaRuleVo rule = new ColorSchemaRuleVo();
        rule.setColor(colorSchema.getString("colorcode"));
        String conditionsTag = colorSchema.getString("conditions_tag");
        if (HRStringUtils.isNotEmpty((String)conditionsTag)) {
            List conditions = JSONObject.parseArray((String)conditionsTag, ColorSchemaConditionVo.class);
            rule.setConditions(conditions);
        }
        return rule;
    }

    private static void matchOrgChartColor(Map<String, String> orgChartColors, OrgChartData orgChartData, String fieldName, String fieldDataType, List<ColorSchemaRuleVo> rules) {
        List<OrgChartData> children;
        if (orgChartData == null) {
            return;
        }
        Map<String, Object> showFields = orgChartData.getShowFields();
        HashMap<String, Object> fieldData = new HashMap<String, Object>(showFields.size() + 1);
        fieldData.putAll(showFields);
        fieldData.put("isvirtualorg", orgChartData.getIsvirtualorg());
        String color = ColorSchemaServiceHelper.matchColorSchemaColor(fieldData, fieldName, fieldDataType, rules);
        if (!StringUtils.isEmpty((Object)color)) {
            orgChartColors.put(orgChartData.getId(), color);
        }
        if (CollectionUtils.isEmpty(children = orgChartData.getChildren())) {
            return;
        }
        children.forEach(child -> ColorSchemaServiceHelper.matchOrgChartColor(orgChartColors, child, fieldName, fieldDataType, rules));
    }

    private static String matchColorSchemaColor(Map<String, Object> fieldData, String fieldName, String fieldDataType, List<ColorSchemaRuleVo> rules) {
        String color = "";
        try {
            ColorSchemaConditionVo condition;
            List conditionValues;
            ColorSchemaRuleVo rule;
            List conditions;
            Object value;
            if (fieldData == null) {
                return color;
            }
            if (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode())) {
                fieldName = String.format("%s.id", fieldName.substring(0, fieldName.lastIndexOf(".")));
            }
            if ((value = fieldData.get(fieldName)) == null) {
                return color;
            }
            Iterator<ColorSchemaRuleVo> iterator = rules.iterator();
            while (iterator.hasNext() && !CollectionUtils.isEmpty((Collection)(conditions = (rule = iterator.next()).getConditions())) && conditions.size() >= 1 && !CollectionUtils.isEmpty((Collection)(conditionValues = (condition = (ColorSchemaConditionVo)conditions.get(0)).getValues()))) {
                String compare = condition.getCompare();
                if (!(HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.NUMBER.getCode()) ? ColorSchemaServiceHelper.numberMatch(conditionValues, value, compare) : (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DATE.getCode()) ? ColorSchemaServiceHelper.dateMatch(conditionValues, value, compare) : (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.DYNAMIC_OBJECT.getCode()) ? ColorSchemaServiceHelper.dynamicObjectMatch(conditionValues, value, compare) : (HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.ENUM.getCode()) ? ColorSchemaServiceHelper.enumMatch(conditionValues, value, compare) : HRStringUtils.equals((String)fieldDataType, (String)FieldDataTypeEnum.STRING.getCode()) && ColorSchemaServiceHelper.stringMatch(conditionValues, value, compare)))))) continue;
                return rule.getColor();
            }
        }
        catch (Exception e) {
            LOGGER.error("fieldData:{},fieldName:{},fieldDataType:{},rules:{}", rules);
            LOGGER.error("matchColorSchemaColor error", (Throwable)e);
        }
        return color;
    }

    private static boolean numberMatch(List<String> conditionValues, Object valueObj, String compare) {
        List values = conditionValues.stream().map(BigDecimal::new).collect(Collectors.toList());
        BigDecimal value = new BigDecimal(valueObj.toString());
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.BETWEEN.getValue())) {
            return value.compareTo((BigDecimal)values.get(0)) >= 0 && value.compareTo((BigDecimal)values.get(1)) <= 0;
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.EQUALS.getValue())) {
            return value.equals(values.get(0));
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.NOT_EQUALS.getValue())) {
            return !value.equals(values.get(0));
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.LESS_THAN.getValue())) {
            return value.compareTo((BigDecimal)values.get(0)) < 0;
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.LESS_EQUALS.getValue())) {
            return value.compareTo((BigDecimal)values.get(0)) <= 0;
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.LARGE_THAN.getValue())) {
            return value.compareTo((BigDecimal)values.get(0)) > 0;
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.LARGE_EQUALS.getValue())) {
            return value.compareTo((BigDecimal)values.get(0)) >= 0;
        }
        LOGGER.error("Unsupported number compare:{}", (Object)compare);
        return false;
    }

    private static boolean dateMatch(List<String> conditionValues, Object valueObj, String compare) throws Exception {
        ArrayList<Date> values = new ArrayList<Date>(conditionValues.size());
        for (String conditionValue : conditionValues) {
            if (HRStringUtils.isEmpty((String)conditionValue)) {
                return false;
            }
            values.add(HRDateTimeUtils.parseDate((String)conditionValue));
        }
        Date value = HRDateTimeUtils.parseDate((String)valueObj.toString());
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.BETWEEN.getValue())) {
            return !HRDateTimeUtils.dayBefore((Date)value, (Date)((Date)values.get(0))) && !HRDateTimeUtils.dayAfter((Date)value, (Date)((Date)values.get(1)));
        }
        LOGGER.error("Unsupported date compare:{}", (Object)compare);
        return false;
    }

    private static boolean dynamicObjectMatch(List<String> conditionValues, Object valueObj, String compare) {
        String value = valueObj.toString();
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.IN.getValue())) {
            return conditionValues.contains(value);
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.NOT_IN.getValue())) {
            return !conditionValues.contains(value);
        }
        LOGGER.error("Unsupported dynamic object compare:{}", (Object)compare);
        return false;
    }

    private static boolean enumMatch(List<String> conditionValues, Object valueObj, String compare) {
        String value = valueObj.toString();
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.IN.getValue())) {
            return conditionValues.contains(value);
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.NOT_IN.getValue())) {
            return !conditionValues.contains(value);
        }
        LOGGER.error("Unsupported enum compare:{}", (Object)compare);
        return false;
    }

    private static boolean stringMatch(List<String> conditionValues, Object valueObj, String compare) {
        String value = valueObj.toString();
        String conditionValue = conditionValues.get(0);
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.IN.getValue())) {
            return value.contains(conditionValue);
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.NOT_IN.getValue())) {
            return !value.contains(conditionValue);
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.EQUALS.getValue())) {
            return HRStringUtils.equals((String)value, (String)conditionValue);
        }
        if (HRStringUtils.equals((String)compare, (String)CompareEnum.NOT_EQUALS.getValue())) {
            return !HRStringUtils.equals((String)value, (String)conditionValue);
        }
        LOGGER.error("Unsupported string compare:{}", (Object)compare);
        return false;
    }
}

