/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.neworgchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.model.ChartFilterConfig;
import kd.hr.homs.common.model.OrgChartQueryParam;
import kd.hr.homs.formplugin.web.neworgchart.vo.NewChartHelper;
import kd.hr.homs.formplugin.web.neworgchart.vo.ResultDataHelper;

public class NewOrgChartSchemePlugin
extends AbstractTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(NewOrgChartSchemePlugin.class);

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "saveScheme": {
                this.saveScheme(operateName, eventArgs, null);
                break;
            }
            case "updateScheme": {
                this.updateScheme(eventArgs, operateName);
                break;
            }
            case "reNameScheme": {
                this.reNameScheme(eventArgs, operateName);
                break;
            }
            case "deleteScheme": {
                this.deleteScheme(eventArgs, operateName);
                break;
            }
            case "defaultScheme": {
                this.defaultScheme(eventArgs, operateName);
                break;
            }
        }
    }

    private void defaultScheme(String eventArgs, String operateName) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_adminorgchart_new");
        filterContainer.setDefaultScheme(jsonObject.getString("schemeId"), jsonObject.getInteger("isDefault") == 1);
        CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrolap.setData(ResultDataHelper.buildSuccessResultData(null, operateName));
    }

    private void deleteScheme(String eventArgs, String operateName) {
        FilterScheme filterScheme = new SchemeQuery().getScheme(eventArgs);
        if (filterScheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"CommonOrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]));
            return;
        }
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_adminorgchart_new");
        filterContainer.deleteScheme(eventArgs);
        HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
        structureSchemeHelper.deleteByFilter(new QFilter[]{new QFilter("scheme", "=", (Object)eventArgs)});
        CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrolap.setData(ResultDataHelper.buildSuccessResultData(null, operateName));
    }

    private void reNameScheme(String eventArgs, String operateName) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        this.saveScheme(operateName, jsonObject.getString("newName"), jsonObject.getString("schemeId"));
    }

    private void updateScheme(String eventArgs, String operateName) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        FilterScheme filterScheme = new SchemeQuery().getScheme(jsonObject.getString("schemeId"));
        if (filterScheme == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u65b9\u6848\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"CommonOrgChartServiceHelper_10", (String)"odc-homs-business", (Object[])new Object[0]));
            return;
        }
        this.saveScheme(operateName, filterScheme.getSchemeName(), jsonObject.getString("schemeId"));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveScheme(String operateName, String schemeName, String id) {
        HashMap<String, Object> filterSchemeMap = new HashMap<String, Object>();
        filterSchemeMap.put("schemeName", schemeName);
        filterSchemeMap.put("entryEntity", "homs_adminorgchart_new");
        ArrayList schemeRows = new ArrayList();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        schemeRows.add(map);
        OrgChartQueryParam orgChartQueryParam = new OrgChartQueryParam();
        orgChartQueryParam.setStructProjectId(this.getPageCache().get("STRUCT_PROJECT_KEY"));
        orgChartQueryParam.setAdminOrgTypes(JSONObject.parseArray((String)this.getPageCache().get("queryAdminOrgTypes"), String.class));
        orgChartQueryParam.setQueryDate(this.getPageCache().get("datefield"));
        orgChartQueryParam.setOrgs(JSONObject.parseArray((String)this.getPageCache().get("queryOrgId"), String.class));
        orgChartQueryParam.setCurrentOrgChartRootNodeId(this.getPageCache().get("CURRENT_NODE_ID"));
        orgChartQueryParam.setCoopRelTypes(JSONObject.parseArray((String)this.getPageCache().get("queryCooprelTypes"), String.class));
        List<ChartFilterConfig> chartFilterConfigList = NewChartHelper.getChartFilterConfigList(1010L);
        chartFilterConfigList.stream().filter(filterConfig -> !ChartFilterConfig.DEFAULT_FILTER_NUMBERS.contains(filterConfig.getNumber())).forEach(config -> {
            String value = this.getPageCache().get(config.getNumber());
            if (value == null || value.length() == 0) {
                return;
            }
            orgChartQueryParam.getExtSearchData().put(config.getNumber(), JSONObject.parseArray((String)value, String.class));
        });
        map.put("FieldName", Collections.singletonList(JSONObject.toJSONString((Object)orgChartQueryParam)));
        map.put("Compare", Lists.newArrayList((Object[])new Object[]{""}));
        map.put("Value", new ArrayList());
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_adminorgchart_new");
        filterSchemeMap.put("scheme", schemeRows);
        if (id != null) {
            filterSchemeMap.put("id", id);
        }
        boolean checkResult = this.checkSchemeContent(orgChartQueryParam, schemeName);
        CustomControl customcontrolap = (CustomControl)this.getView().getControl("customcontrolap");
        Object schemeId = null;
        if (checkResult) {
            customcontrolap.setData(ResultDataHelper.buildErrorResultData("", operateName, "update"));
            return;
        }
        String structProjectId = this.getPageCache().get("STRUCT_PROJECT_KEY");
        boolean adminOrgExist = NewOrgChartSchemePlugin.orgTeamExist(orgChartQueryParam, this.getView());
        if (!adminOrgExist) {
            this.getView().hideLoading();
            customcontrolap.setData(ResultDataHelper.buildErrorResultData("", operateName, "update"));
            return;
        }
        if (NewOrgChartSchemePlugin.schemeCheck(filterSchemeMap, this.getView(), "homs_adminorgchart_new")) {
            this.getView().hideLoading();
            customcontrolap.setData(ResultDataHelper.buildErrorResultData("", operateName, "update"));
            return;
        }
        filterContainer.saveScheme(filterSchemeMap);
        schemeId = filterSchemeMap.get("id");
        long userId = RequestContext.get().getCurrUserId();
        HRBaseServiceHelper structureSchemeHelper = new HRBaseServiceHelper("homs_strprotofilter");
        if (HRStringUtils.isNotEmpty((String)structProjectId)) {
            boolean isExistsScheme = structureSchemeHelper.isExists(new QFilter("scheme", "=", schemeId));
            if (isExistsScheme) return;
            DynamicObject structureScheme = structureSchemeHelper.generateEmptyDynamicObject();
            structureScheme.set("scheme", schemeId);
            structureScheme.set("structproject", (Object)Long.parseLong(structProjectId));
            structureScheme.set("user", (Object)userId);
            structureSchemeHelper.saveOne(structureScheme);
            customcontrolap.setData(ResultDataHelper.buildSuccessResultData(schemeId, operateName));
            return;
        }
        this.getView().hideLoading();
        customcontrolap.setData(ResultDataHelper.buildErrorResultData("", operateName, "update"));
    }

    public static boolean orgTeamExist(OrgChartQueryParam orgChartQueryParam, IFormView formView) {
        String queryDate = orgChartQueryParam.getQueryDate();
        Date dateField = new Date();
        try {
            dateField = HRDateTimeUtils.parseDate((String)queryDate);
        }
        catch (ParseException exception) {
            LOG.error("adminOrgExist exception", (Throwable)exception);
        }
        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u4e3a\u201c%s\u201d\u65f6\uff0c\u5bf9\u5e94\u7684\u67e5\u8be2\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CommonOrgChartServiceHelper_5", (String)"odc-homs-business", (Object[])new Object[0]), queryDate);
        String currentOrgChartRootNodeId = orgChartQueryParam.getCurrentOrgChartRootNodeId();
        if (HRStringUtils.equals((String)currentOrgChartRootNodeId, (String)"notInit100000")) {
            formView.showTipNotification(message);
            return false;
        }
        Long orgTeamBoId = Long.parseLong(currentOrgChartRootNodeId);
        DynamicObject dy = CommonOrgChartServiceHelper.getHisOrgTeam((Date)dateField, (Long)orgTeamBoId);
        if (HRObjectUtils.isEmpty((Object)dy)) {
            formView.showTipNotification(message);
            return false;
        }
        return true;
    }

    public static boolean schemeCheck(Map<String, Object> filterSchemeMap, IFormView formView, String formId) {
        Object schemeNameObject = filterSchemeMap.get("schemeName");
        String defaultSchemeName = ResManager.loadKDString((String)"\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4", (String)"CommonOrgChartServiceHelper_1", (String)"odc-homs-business", (Object[])new Object[0]);
        if (HRStringUtils.equals((String)defaultSchemeName, (String)schemeNameObject.toString().trim())) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u201c\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonOrgChartServiceHelper_2", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        if (schemeNameObject.toString().length() > 100) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u65b9\u6848\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]", (String)"CommonOrgChartServiceHelper_3", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        List schemes = OrgChartServiceHelper.getScheme((String)formId, (String)RequestContext.get().getUserId(), (boolean)true);
        for (FilterScheme scheme : schemes) {
            if (!schemeNameObject.toString().equalsIgnoreCase(scheme.getSchemeName()) || filterSchemeMap.get("id") != null) continue;
            formView.showErrorNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CommonOrgChartServiceHelper_4", (String)"odc-homs-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkSchemeContent(OrgChartQueryParam orgChartQueryParam, String schemeName) {
        StringBuilder builder = new StringBuilder();
        boolean errorMessage = false;
        String schemeNameFiled = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u3001", (String)"OrgChartPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeDateFiled = ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u3001", (String)"OrgChartPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeAdminOrgTypeFiled = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3001", (String)"OrgChartPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeOrgFiled = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"OrgChartPlugin_22", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeRootNode = ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7\u3001", (String)"OrgChartPlugin_23", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)schemeName)) {
            builder.append(schemeNameFiled);
            errorMessage = true;
        }
        if (HRObjectUtils.isEmpty((Object)orgChartQueryParam.getQueryDate())) {
            builder.append(schemeDateFiled);
            errorMessage = true;
        }
        if (CollectionUtils.isEmpty((Collection)orgChartQueryParam.getAdminOrgTypes())) {
            builder.append(schemeAdminOrgTypeFiled);
            errorMessage = true;
        }
        if (CollectionUtils.isEmpty((Collection)orgChartQueryParam.getOrgs())) {
            builder.append(schemeOrgFiled);
            errorMessage = true;
        }
        if (HRStringUtils.isEmpty((String)orgChartQueryParam.getCurrentOrgChartRootNodeId())) {
            builder.append(schemeRootNode);
            errorMessage = true;
        }
        if (errorMessage) {
            String error = builder.substring(0, builder.length() - 1);
            String tipMessage = ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgChartPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[]{error});
            this.getView().showErrorNotification(tipMessage);
        }
        return errorMessage;
    }
}

