/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.formplugin.web.orgbatch.AdminorgBatchBillPlugin;
import org.apache.commons.lang3.time.DateUtils;

public class AdminOrgBatchBasePlugin
extends HRDataBaseEdit
implements ClickListener,
BeforeF7SelectListener,
OrgBatchChgBillConstants {
    private static final Log LOG = LogFactory.getLog(AdminOrgBatchBasePlugin.class);
    public static String prefix;
    private static final String IS_CHANGE_ORG = "isChangeOrg";
    private static final String IS_CHANGE_ORG_TYPE = "isChangeOrgType";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long orgId = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("orgid"));
        this.setInfoFromDb(orgId, false);
        this.setInfoFromEntry();
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long billId = (Long)this.getView().getFormShowParameter().getCustomParam("billid");
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            String ids = this.getView().getFormShowParameter().getCustomParam("id").toString();
            this.getModel().setValue("id", (Object)Long.valueOf(ids));
        }
        this.getModel().setValue("billid", (Object)billId);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        List<String> beforeF7ListenerControlList = this.getRegisterBeforeF7ListenerControlList();
        for (String registerBeforeF7Listener : beforeF7ListenerControlList) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(registerBeforeF7Listener);
            if (basedataEdit == null) continue;
            basedataEdit.setF7BatchFill(false);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private List<String> getRegisterBeforeF7ListenerControlList() {
        return Arrays.asList("adminorgtype", "parentorg", "adminorgtype");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("adminorg".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setFormId("haos_orgbatchtreelistf7");
            AuthorizedOrgResult authorizedOrgResult = AdminOrgBatchChgHelper.getOrgAuth((IFormView)this.getView());
            if (!authorizedOrgResult.isHasAllOrgPerm()) {
                List hasPermOrgList = authorizedOrgResult.getHasPermOrgs();
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("boid", "in", (Object)hasPermOrgList));
            }
            if (prefix.startsWith("parent")) {
                QFilter rootFilter = new QFilter("boid", "!=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getView().getParentView(), (BeforeF7SelectEvent)beforeF7SelectEvent, (QFilter)rootFilter);
            } else {
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getView().getParentView(), (BeforeF7SelectEvent)beforeF7SelectEvent, null);
            }
            QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(((DynamicObject)this.getModel().getValue("org")).getLong("id")));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchdate", (Object)new Date());
            beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
            this.getPageCache().put(IS_CHANGE_ORG, "true");
        } else if ("parentorg".equals(fieldKey)) {
            Long orgId = this.getModel().getDataEntity().getLong("orgid");
            List orgIds = AdminOrgBatchChgHelper.getOrgAndChildren((Long)orgId);
            if (!orgIds.isEmpty()) {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", (Object)orgIds));
            }
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Date date = DateUtils.truncate((Date)new Date(), (int)5);
            showParameter.getCustomParams().put("searchdate", date);
        } else if ("adminorgtype".equals(fieldKey)) {
            this.getPageCache().put(IS_CHANGE_ORG_TYPE, "true");
        }
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey;
        switch (fieldKey = changedArgs.getProperty().getName()) {
            case "adminorg": {
                this.adminOrgChanged(changedArgs);
                break;
            }
            case "adminorgtype": {
                this.adminOrgTypeChanged(changedArgs);
                break;
            }
        }
    }

    private void adminOrgTypeChanged(PropertyChangedArgs changedArgs) {
        if ("true".equals(this.getPageCache().get(IS_CHANGE_ORG_TYPE))) {
            this.getPageCache().put(IS_CHANGE_ORG_TYPE, "false");
            DynamicObject newValue = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue("adminorgtype", changedArgs.getChangeSet()[0].getOldValue());
                return;
            }
            DynamicObject orgType = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
            if (orgType == null || orgType.getLong("adminorgtypestd.id") != newValue.getLong("adminorgtypestd.id")) {
                Long orgTypeOld = orgType != null ? orgType.getLong("id") : 0L;
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("adminorgtype", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u7ec4\u7ec7\u7684\u6240\u5c5e\u516c\u53f8\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminOrgBatchBasePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, String.valueOf(orgTypeOld));
            }
        }
    }

    private void adminOrgChanged(PropertyChangedArgs changedArgs) {
        if ("true".equals(this.getPageCache().get(IS_CHANGE_ORG))) {
            Long orgIdNew;
            this.getPageCache().put(IS_CHANGE_ORG, "false");
            if (changedArgs.getChangeSet()[0].getNewValue() == null) {
                this.getModel().setValue("adminorg", changedArgs.getChangeSet()[0].getOldValue());
                return;
            }
            DynamicObject org = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
            DynamicObject newOrg = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
            Long orgIdOld = org != null ? Long.valueOf(org.getLong("id")) : null;
            Long l = orgIdNew = newOrg != null ? Long.valueOf(newOrg.getLong("id")) : null;
            if (newOrg != null) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("adminorg", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u5f53\u524d\u5df2\u4fee\u6539\u7684\u5185\u5bb9\u5c06\u4f1a\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, orgIdOld + "#" + orgIdNew);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        this.getView().getFormShowParameter();
        switch (event.getCallBackId()) {
            case "adminorgtype": {
                if (result == MessageBoxResult.Yes.getValue()) {
                    this.setOrgTypeInfo(this.getModel().getDataEntity().getDynamicObject("adminorgtype").getInt("adminorgtypestd.id"));
                    break;
                }
                long orgTypeId = Long.parseLong(event.getCustomVaule());
                this.getModel().setValue("adminorgtype", (Object)(orgTypeId == 0L ? null : Long.valueOf(orgTypeId)));
                break;
            }
            case "adminorg": {
                if (result == MessageBoxResult.Yes.getValue()) {
                    String orgIdNew = event.getCustomVaule().split("#")[1];
                    this.getPageCache().put(IS_CHANGE_ORG_TYPE, "false");
                    this.setInfoFromDb(Long.parseLong(orgIdNew), true);
                    DynamicObject orgType = this.getModel().getDataEntity().getDynamicObject("adminorgtype");
                    if (orgType == null) break;
                    AdminOrgBatchChgHelper.setOrgInfoViewByType((Long)orgType.getLong("adminorgtypestd.id"), (IFormView)this.getView());
                    AdminOrgBatchChgHelper.anchorCtlByType((int)orgType.getInt("adminorgtypestd.id"), (IFormView)this.getView());
                    break;
                }
                String orgIdOld = event.getCustomVaule().split("#")[0];
                this.getModel().setValue("adminorg", (Object)("null".equals(orgIdOld) ? null : orgIdOld));
                break;
            }
        }
    }

    private void setOrgTypeInfo(int orgType) {
        AdminOrgBatchChgHelper.anchorCtlByType((int)orgType, (IFormView)this.getView());
        AdminOrgBatchChgHelper.setOrgInfoViewByType((Long)Long.valueOf(orgType), (IFormView)this.getView());
        this.getModel().setValue("companytype", null);
        this.getModel().setValue("industrytype", null);
        this.getModel().setValue("groupvision", null);
        this.getModel().setValue("groupmission", null);
        this.getModel().setValue("departmenttype", null);
    }

    protected void setInfoFromEntry() {
        DynamicObject orgTypeDy;
        String isCardStr = (String)this.getView().getFormShowParameter().getCustomParam("iscard");
        if (!"isCardTrue".equals(isCardStr)) {
            Object selectObject = this.getView().getFormShowParameter().getCustomParam("selectObject");
            Map map = (Map)SerializationUtils.fromJsonString((String)selectObject.toString(), Map.class);
            Map noPrefixMap = map.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(((String)v.getKey()).replace(prefix + "_", ""), v.getValue()), HashMap::putAll);
            ArrayList<String> props = new ArrayList<String>();
            props.addAll(Arrays.asList("adminorg", "number", "name", "simplename", "adminorgtype", "establishmentdate", "corporateorg", "tobedisableflag", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "oriparentorg_name", "companyarea", "city", "workplace", "org"));
            for (String prop : noPrefixMap.keySet()) {
                if (!PatternUtil.isExProperty((String)prop)) continue;
                props.add(prop);
            }
            Stream<String> fields = Stream.of(props.toArray(new String[0]));
            fields.forEach(s -> this.setValue((String)s, noPrefixMap.get(s)));
            this.setValue("billid", this.getView().getFormShowParameter().getCustomParam("billid"));
            if (prefix.startsWith("parent")) {
                this.setValue("parentorg", noPrefixMap.get("parentorg"));
                this.setValue("parentorg_name", noPrefixMap.get("parentorg_name"));
            }
        }
        if ((orgTypeDy = this.getModel().getDataEntity().getDynamicObject("adminorgtype")) != null) {
            AdminOrgBatchChgHelper.anchorCtlByType((int)orgTypeDy.getInt("adminorgtypestd.id"), (IFormView)this.getView());
        }
    }

    protected void setInfoFromDb(Long orgId, boolean orgChange) {
        if (orgId == 0L) {
            return;
        }
        Object entryId = this.getView().getFormShowParameter().getCustomParam("id");
        HRBaseServiceHelper orgChgBillEntryDAO = new HRBaseServiceHelper("homs_batchorgentity");
        boolean entryIdExists = orgChgBillEntryDAO.isExists(entryId);
        if (!orgChange && entryIdExists) {
            DynamicObjectCollection structProjectEntry = this.getModel().getEntryEntity("struct_project_entry");
            if (structProjectEntry == null || structProjectEntry.size() == 0) {
                AdminOrgBatchChgHelper.setStructView((IFormView)this.getView());
            }
            return;
        }
        this.getModel().deleteEntryData("cooprelentryentity");
        DynamicObject orgMasterInfo = AdminOrgBatchChgHelper.getOrgDyById((Long)orgId);
        long orgBoId = orgMasterInfo.getLong("boid");
        DynamicObject orgDeptInfo = AdminOrgBatchChgHelper.getDepartment((Long)orgBoId);
        DynamicObject orgCompanyInfo = AdminOrgBatchChgHelper.getCompany((Long)orgBoId);
        DynamicObject orgGroupInfo = AdminOrgBatchChgHelper.getGroup((Long)orgBoId);
        DynamicObject[] orgCoopInfoArr = AdminOrgBatchChgHelper.getOldOrgCoopArr((Long)orgBoId);
        this.setCoopInfo(orgCoopInfoArr);
        this.getModel().setValue("adminorg", (Object)orgId);
        this.getModel().setValue("orgid", (Object)orgId);
        this.getModel().setValue("adminorgtype", (Object)orgMasterInfo.getLong("adminorgtype.id"));
        if (prefix.startsWith("parent")) {
            this.getModel().setValue("parentorg", null);
        } else {
            this.getModel().setValue("parentorg", (Object)AdminOrgBatchChgHelper.getHisId((Long)orgMasterInfo.getLong("parentorg.id")));
        }
        OrgChgUtil.setValue((IDataModel)this.getModel(), (DynamicObject)orgMasterInfo, (String)"", (String)"name");
        this.getModel().setValue("orgoriname", orgMasterInfo.get("name"));
        this.getModel().setValue("number", orgMasterInfo.get("number"));
        this.getModel().setValue("simplename", (Object)orgMasterInfo.getLocaleString("simplename"));
        this.getModel().setValue("oriparentorg", (Object)orgMasterInfo.getLong("parentorg.id"));
        Date modifyTime = OrgChgUtil.getView((IFormView)this.getView()).getModel().getDataEntity().getDate("modifytime");
        this.getModel().setValue("oriparentorg_name", (Object)OrgBatchBillHelper.getOrgLongName((Long)orgMasterInfo.getLong("parentorg.id"), (Date)modifyTime, null));
        this.getModel().setValue("parentorg_name", null);
        this.getModel().setValue("establishmentdate", orgMasterInfo.get("establishmentdate"));
        this.getModel().setValue("corporateorg", orgMasterInfo.get("corporateorg"));
        this.getModel().setValue("tobedisableflag", orgMasterInfo.get("tobedisableflag"));
        this.getModel().setValue("tobedisabledate", orgMasterInfo.get("tobedisabledate"));
        this.getModel().setValue("adminorglayer", orgMasterInfo.get("adminorglayer"));
        this.getModel().setValue("adminorgfunction", orgMasterInfo.get("adminorgfunction"));
        this.getModel().setValue("companyarea", orgMasterInfo.get("companyarea"));
        this.getModel().setValue("city", orgMasterInfo.get("city"));
        this.getModel().setValue("workplace", orgMasterInfo.get("workplace"));
        this.getModel().setValue("detailaddress", orgMasterInfo.get("detailaddress"));
        this.getModel().setValue("index", (Object)this.getOrgIndex(orgMasterInfo.getInt("index"), orgMasterInfo));
        this.getModel().setValue("description", orgMasterInfo.get("description"));
        this.getModel().setValue("positioning", orgMasterInfo.get("positioning"));
        this.getModel().setValue("mainduty", orgMasterInfo.get("mainduty"));
        this.getModel().setValue("safelevel", orgMasterInfo.get("safelevel"));
        this.getModel().setValue("safetype", orgMasterInfo.get("safetype"));
        this.getModel().setValue("safedescription", orgMasterInfo.get("safedescription"));
        if (orgCompanyInfo != null) {
            this.getModel().setValue("companytype", orgCompanyInfo.get("companytype"));
            this.getModel().setValue("industrytype", orgCompanyInfo.get("industrytype"));
        } else {
            this.getModel().setValue("companytype", null);
            this.getModel().setValue("industrytype", null);
        }
        if (orgGroupInfo != null) {
            this.getModel().setValue("groupvision", orgGroupInfo.get("groupvision"));
            this.getModel().setValue("groupmission", orgGroupInfo.get("groupmission"));
        } else {
            this.getModel().setValue("groupvision", null);
            this.getModel().setValue("groupmission", null);
        }
        if (orgDeptInfo != null) {
            this.getModel().setValue("departmenttype", orgDeptInfo.get("departmenttype"));
        } else {
            this.getModel().setValue("departmenttype", null);
        }
        Object orgParam = this.getView().getFormShowParameter().getCustomParam("org");
        if (orgParam != null) {
            this.getModel().setValue("org", orgParam);
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Map allFields = ((MainEntityType)orgMasterInfo.getDataEntityType()).getAllFields();
        for (IDataEntityProperty property : properties) {
            if (!PatternUtil.isExProperty((String)property.getName()) || !allFields.containsKey(property.getName())) continue;
            this.getModel().setValue(property.getName(), orgMasterInfo.get(property.getName()));
        }
        this.getModel().deleteEntryData("struct_project_entry");
        AdminOrgBatchChgHelper.setStructProjectEntry((IFormView)this.getView(), (boolean)orgChange, (boolean)true);
    }

    private void setValue(String key, Object value) {
        if (this.getModel().getProperty(key) == null) {
            return;
        }
        Class propertyType = this.getModel().getDataEntityType().getProperty(key).getPropertyType();
        DynamicProperty dynamicProperty = this.getModel().getDataEntityType().getProperty(key);
        if (value == null) {
            return;
        }
        if (propertyType.equals(DynamicObject.class) && dynamicProperty instanceof BasedataProp) {
            Object id = ((Map)value).get("id");
            if (id != null && !HRStringUtils.equals((String)value.toString(), (String)"0")) {
                this.getModel().setValue(key, id);
            }
        } else if (propertyType.equals(DynamicObject.class) && dynamicProperty instanceof MulBasedataProp && value instanceof List) {
            MulBasedataProp property = (MulBasedataProp)this.getModel().getDataEntityType().getProperty(key);
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(property.getBaseEntityId());
            LOG.info("set MulBasedataProp value [{}]", value);
            ((List)value).forEach(map -> {
                DynamicObject dy = new DynamicObject(property.getDynamicCollectionItemPropertyType());
                if ((Long)((Map)map).get("fbasedataid_id") != null) {
                    dy.set("fbasedataid_id", (Object)((Long)((Map)map).get("fbasedataid_id")));
                    DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
                    emptyDynamicObject.set("id", (Object)((Long)((Map)map).get("fbasedataid_id")));
                    dy.set("fbasedataid", (Object)emptyDynamicObject);
                    dynamicObjectCollection.add((Object)dy);
                } else {
                    Object fbasedataid = ((Map)map).get("fbasedataid");
                    if (fbasedataid instanceof Map && ((Map)fbasedataid).get("id") instanceof Long) {
                        Long id = (Long)((Map)fbasedataid).get("id");
                        dy.set("fbasedataid_id", (Object)id);
                        DynamicObject emptyDynamicObject = serviceHelper.generateEmptyDynamicObject();
                        emptyDynamicObject.set("id", (Object)id);
                        dy.set("fbasedataid", (Object)emptyDynamicObject);
                        dynamicObjectCollection.add((Object)dy);
                    }
                }
            });
            this.getModel().setValue(key, dynamicObjectCollection.size() != 0 ? dynamicObjectCollection : null);
        } else {
            this.getModel().setValue(key, value);
        }
    }

    private int getOrgIndex(Integer index, DynamicObject orgMasterInfo) {
        if (index == null || index < 1 || index > 99999) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            QFilter qFilter = new QFilter("parentorg", "=", (Object)orgMasterInfo.getLong("parentorg.id")).and("id", "!=", (Object)orgMasterInfo.getLong("id")).and("iscurrentversion", "=", (Object)true);
            DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection("id,parentorg.id,index", qFilter.toArray());
            index = 1;
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dy : dynamicObjects) {
                    if (dy.getInt("index") < index || index >= 100000) continue;
                    index = dy.getInt("index") + 1;
                }
            }
        }
        return index;
    }

    private void setCoopInfo(DynamicObject[] orgCoopInfoArr) {
        if (orgCoopInfoArr.length > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("coopreltyp", new Object[0]);
            vs.addField("cooporgteam", new Object[0]);
            vs.addField("cooprelid", new Object[0]);
            for (DynamicObject coop : orgCoopInfoArr) {
                if (coop.getLong("coopreltype.id") == 1010L) continue;
                vs.addRow(new Object[]{coop.getDynamicObject("coopreltype") != null ? Long.valueOf(coop.getLong("coopreltype.id")) : null, coop.getDynamicObject("cooporgteam") != null ? Long.valueOf(coop.getLong("cooporgteam.id")) : null, coop.get("id")});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("cooprelentryentity", vs);
            model.endInit();
            this.getView().updateView("cooprelentryentity");
        }
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (HRStringUtils.equals((String)key, (String)"save") && result.isSuccess()) {
            DynamicObject data = this.getModel().getDataEntity();
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            Stream<String> entryEntity = Stream.of("adminorg", "number", "name", "simplename", "adminorgtype", "corporateorg", "tobedisableflag", "changescene", "changereason", "changedescription", "adminorglayer", "adminorgfunction", "companyarea", "city", "workplace", "org", "safelevel", "safetype");
            entryEntity.forEach(s -> map.put((String)s, OrgChgUtil.getValue((IDataModel)this.getModel(), (String)s)));
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (!PatternUtil.isExProperty((String)property.getName())) continue;
                map.put(property.getName(), data.get(property.getName()));
            }
            if (prefix.startsWith("parent")) {
                map.put("parentorg", data.getDynamicObject("parentorg"));
                map.put("parentorg_name", data.getLocaleString("parentorg_name"));
            } else {
                map.put("parentorg", data.getDynamicObject("parentorg"));
                map.put("oriparentorg_name", data.getString("oriparentorg_name"));
                map.put("establishmentdate", data.getDate("establishmentdate"));
            }
            Map prefixMap = map.entrySet().stream().collect(HashMap::new, (m, v) -> m.put(prefix + "_" + (String)v.getKey(), v.getValue()), HashMap::putAll);
            prefixMap.put("id", data.getLong("id"));
            this.getView().returnDataToParent((Object)prefixMap);
            this.getView().close();
        }
    }

    public static void entryEntityMore(IDataModel iDataModel, IFormView iFormView, String tag, OperationStatus status) {
        EntryGrid entryEntity = (EntryGrid)iFormView.getControl("entryentity_" + tag);
        int row = entryEntity.getEntryState().getFocusRow();
        DynamicObject dynamicObject = (DynamicObject)iDataModel.getDataEntity(true).getDynamicObjectCollection("entryentity_" + tag).get(row);
        Map map = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject);
        long id = dynamicObject.getLong("id");
        BillShowParameter formShowParameter = new BillShowParameter();
        if ("parent".equals(tag)) {
            formShowParameter.setFormId("homs_batchorgentityparent");
        } else if ("info".equals(tag)) {
            formShowParameter.setFormId("homs_batchorgentityinfo");
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_batchorgentity");
        boolean exists = helper.isExists((Object)id);
        if (exists) {
            formShowParameter.setPkId((Object)id);
        } else {
            formShowParameter.setCustomParam("id", (Object)id);
        }
        formShowParameter.setStatus(status);
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("selectObject", (Object)SerializationUtils.toJsonString((Object)map));
        formShowParameter.setCustomParam("billid", iDataModel.getValue("id"));
        formShowParameter.setCustomParam("orgid", (Object)String.valueOf(dynamicObject.getLong(tag + "_" + "adminorg" + "." + "id")));
        formShowParameter.setCustomParam("iscard", (Object)"isCardFalse");
        formShowParameter.setCustomParam("org", (Object)iDataModel.getDataEntity().getLong("org.id"));
        int sequence = AdminOrgBatchChgHelper.getEntrySeq((IDataModel)iDataModel, (Long)BillEntryHelperEnum.getChangeTypeIdByPrefix((String)tag));
        formShowParameter.setCustomParam("sequence", (Object)sequence);
        formShowParameter.setCloseCallBack(new CloseCallBack(AdminorgBatchBillPlugin.class.getName(), "entryentity_" + tag));
        iFormView.showForm((FormShowParameter)formShowParameter);
    }
}

