/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.haos.common.util.tree.Node;
import kd.hr.haos.common.util.tree.Tree;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;
import kd.hr.homs.common.model.OrgCubeTreeNode;

public abstract class AdminOrgBatchChartBasePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CLOSE_CONFIRM = "close_confirm";

    protected void initData(Long changeTypeId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long changeSceneId = 0L;
        Object changeSceneParam = formShowParameter.getCustomParam("changescene");
        if (changeSceneParam != null) {
            changeSceneId = Long.valueOf(changeSceneParam.toString());
        }
        Long changeReasonId = 0L;
        Object changeReasonParam = formShowParameter.getCustomParam("changereason");
        if (changeReasonParam != null) {
            changeReasonId = Long.valueOf(changeReasonParam.toString());
        }
        String changeDes = (String)formShowParameter.getCustomParam("changedescription");
        this.getModel().beginInit();
        this.initData(changeTypeId, changeSceneId, changeReasonId, changeDes);
        this.getView().updateView("changescene");
        this.getView().updateView("changereason");
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    protected void initData(Long changeTypeId, Long changeSceneId, Long changeReasonId, String changeDes) {
        this.getModel().setValue("changescene", (Object)changeSceneId);
        this.getModel().setValue("changereason", (Object)changeReasonId);
        this.getModel().setValue("changedescription", (Object)changeDes);
        this.getModel().setValue("changetype", (Object)changeTypeId);
        Long orgId = this.getView().getParentView().getModel().getDataEntity().getDynamicObject("org").getLong("id");
        this.getModel().setValue("org", (Object)orgId);
        AdminOrgBatchChartBaseHelper.initChangeSceneAndReason((IFormView)this.getView(), (Long)changeTypeId, (Long)orgId);
    }

    public void registerListener(EventObject e) {
        BasedataEdit changeScene = (BasedataEdit)this.getView().getControl("changescene");
        changeScene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changeReason = (BasedataEdit)this.getView().getControl("changereason");
        changeReason.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("changescene".equals(fieldKey)) {
            this.getModel().setValue("changereason", null);
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"changereason"});
                return;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"changereason"});
            Long orgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
            AdminOrgBatchChartBaseHelper.initChangeReasonByChangeScene((IDataModel)this.getModel(), (DynamicObject)newValue, (Long)orgId);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "changescene": {
                QFilter filter = new QFilter("orgchangetype.id", "=", (Object)this.getModel().getDataEntity().getLong("changetype.id")).and("id", "!=", (Object)OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE);
                beforeF7SelectEvent.getCustomQFilters().add(filter);
                break;
            }
            case "changereason": {
                AdminOrgBatchChgHelper.setChangeReasonF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel(), (String)"", (Boolean)Boolean.FALSE);
                break;
            }
        }
    }

    protected void commonCustomEvent(String eventName, List<ChgOrgInfoDto> orgList, AbstractFormPlugin plugin) {
        Long orgId = CollectionUtils.isEmpty(orgList) ? Long.valueOf(0L) : orgList.get(0).getOrgId();
        IFormView parentView = this.getView().getParentView();
        String billPageId = (String)this.getView().getFormShowParameter().getCustomParam("billPageId");
        switch (eventName) {
            case "add_org": {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("homs_batchorgentityadd");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("mergeSplit", (Object)"1");
                parameter.setCustomParam("billid", (Object)parentView.getModel().getDataEntity().getLong("id"));
                parameter.setCustomParam("billBsed", (Object)parentView.getModel().getDataEntity().getDate("effdt"));
                parameter.setCustomParam("billPageId", (Object)billPageId);
                parameter.setCloseCallBack(new CloseCallBack(plugin.getPluginName(), "add_org"));
                parameter.setCustomParam("org", (Object)parentView.getModel().getDataEntity().getLong("org.id"));
                int sequence = AdminOrgBatchChgHelper.getEntrySeq((IDataModel)parentView.getModel(), (Long)OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
                parameter.setCustomParam("sequence", (Object)sequence);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "merge_parent_chg": 
            case "info_chg": {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setCustomParam("iscard", (Object)"isCardTrue");
                if (HRStringUtils.equals((String)eventName, (String)"info_chg")) {
                    formShowParameter.setFormId("homs_batchorgentityinfo");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "add_orgInfo"));
                } else {
                    formShowParameter.setFormId("homs_batchorgentityparent");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "entryentity_parent"));
                }
                AdminOrgBatchChartBaseHelper.setFormShowParameter((Long)orgId, (long)0L, (String)"1", (BillShowParameter)formShowParameter, (IFormView)parentView);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "edit_detail": {
                this.openChartEditInfo(orgId);
                break;
            }
        }
    }

    private void openChartEditInfo(Long orgId) {
        Long billId = (Long)this.getView().getParentView().getModel().getValue("id");
        DynamicObject dynamicObject = AdminOrgBatchChartBaseHelper.getTeBeSaveDataByOrgId((Long)billId, (Long)orgId, (String)"id,adminorg,changetype,mergesplitstatus");
        IFormView parentView = this.getView().getParentView();
        BillShowParameter formShowParameter = new BillShowParameter();
        if (dynamicObject != null) {
            long changeTypeId = dynamicObject.getLong("changetype.id");
            if (changeTypeId == ChangeTypeEnum.ADD.getId()) {
                formShowParameter = AdminOrgBatchChartBaseHelper.openEditAddPageForChart((Long)dynamicObject.getLong("id"), (IFormView)parentView, (String)this.getPluginName(), (String)"1");
            } else {
                formShowParameter.setCustomParam("iscard", (Object)"isCardTrue");
                formShowParameter.setPkId((Object)dynamicObject.getLong("id"));
                if (changeTypeId == ChangeTypeEnum.PARENT.getId()) {
                    formShowParameter.setFormId("homs_batchorgentityparent");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "entryentity_parent"));
                } else if (changeTypeId == ChangeTypeEnum.INFO.getId()) {
                    formShowParameter.setFormId("homs_batchorgentityinfo");
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add_orgInfo"));
                }
                AdminOrgBatchChartBaseHelper.setFormShowParameter((Long)orgId, (long)dynamicObject.getLong("id"), (String)"1", (BillShowParameter)formShowParameter, (IFormView)parentView);
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
            return;
        }
        formShowParameter = AdminOrgBatchChartBaseHelper.showPageWithEntry((Long)orgId, (IFormView)parentView, (String)this.getPluginName(), (String)"1");
        formShowParameter.setPkId(null);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    protected OrgCubeTreeNode buildClosedBackNode(Map<String, Object> map, String prefix) {
        long orgId = ((DynamicObject)map.get(prefix + "_adminorg")).getLong("id");
        String oldName = ((DynamicObject)map.get(prefix + "_adminorg")).getString("name");
        Long billId = (Long)this.getView().getParentView().getModel().getValue("id");
        AdminOrgBatchChartBaseHelper.deleteToDeleteEntity((Long)billId, (long)orgId);
        String orgName = Optional.ofNullable(map.get(prefix + "_" + "name")).map(name -> {
            String orgNameTemp = (String)((Map)name).get(RequestContext.get().getLang().name());
            if (StringUtils.isEmpty((String)orgNameTemp) && StringUtils.isEmpty((String)(orgNameTemp = (String)((Map)name).get(Lang.zh_CN.name()))) && StringUtils.isEmpty((String)(orgNameTemp = (String)((Map)name).get(Lang.en_US.name())))) {
                orgNameTemp = (String)((Map)name).get(Lang.zh_TW.name());
            }
            return orgNameTemp;
        }).orElse("");
        OrgCubeTreeNode node = new OrgCubeTreeNode(String.valueOf(orgId), orgName);
        node.setHasPermission("1");
        node.setChangeType("info".equals(prefix) ? ChangeTypeEnum.INFO.getNumber() : ChangeTypeEnum.PARENT.getNumber());
        node.setOldName(oldName);
        return node;
    }

    protected void undoAdjustmentCallBack(Collection<Long> orgCol) {
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity();
        Long billId = billDy.getLong("id");
        AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgCol);
        AdminOrgBatchChartBaseHelper.addToDeleteDataList((Long)billId, orgCol);
    }

    protected void undoAdjustment(Set<Long> selectOrgSet) {
        int size = selectOrgSet.size();
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity(true);
        Map<Long, Long> billOrgMap = this.getBillOrgMap(billDy);
        this.transformMap(billOrgMap, billDy.getLong("id"));
        for (long id : selectOrgSet) {
            if (billOrgMap.containsKey(id)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8c03\u6574\u8fc7\u7684\u7ec4\u7ec7\u518d\u64cd\u4f5c\u3002", (String)"AdminOrgBatchChartBasePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        Tree tree = new Tree(billOrgMap);
        boolean containsFlag = false;
        HashSet orgSet = Sets.newHashSet(selectOrgSet);
        for (Long orgId : orgSet) {
            Set<Long> sub;
            Node node = tree.findNode(orgId.longValue());
            if (node == null || CollectionUtils.isEmpty(sub = this.getSubSet(node)) || !selectOrgSet.addAll(sub)) continue;
            containsFlag = true;
        }
        String param = JSONObject.toJSONString(selectOrgSet);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("undoMergeSplit", (IFormPlugin)this);
        if (containsFlag) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u4e2a\u7ec4\u7ec7\uff0c\u5c06\u540c\u65f6\u64a4\u9500\u9009\u4e2d\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u8c03\u6574\u8bb0\u5f55\uff0c\u64a4\u9500\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminOrgBatchChartBasePlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[]{size}), null, MessageBoxOptions.OKCancel, null, confirmCallBackListener, null, param);
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4f60\u5df2\u9009\u4e2d%s\u4e2a\u7ec4\u7ec7\uff0c\u5c06\u64a4\u9500\u672c\u5355\u4e2d\u8fd9\u4e9b\u7ec4\u7ec7\u7684\u8c03\u6574\u8bb0\u5f55\uff0c\u64a4\u9500\u540e\u5c06\u4e0d\u53ef\u6062\u590d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminOrgBatchChartBasePlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[]{size}), null, MessageBoxOptions.OKCancel, null, confirmCallBackListener, null, param);
        }
    }

    private void transformMap(Map<Long, Long> billOrgMap, Long billId) {
        DynamicObjectCollection col = AdminOrgBatchChartBaseHelper.getEntryCol((Long)billId, null, (String)"adminorg.id,parentorg.id,mergesplitstatus", Arrays.asList("1", "0"));
        for (DynamicObject dy : col) {
            if ("1".equals(dy.getString("mergesplitstatus"))) {
                billOrgMap.remove(dy.getLong("adminorg.id"));
                continue;
            }
            billOrgMap.put(dy.getLong("adminorg.id"), dy.getLong("parentorg.id"));
        }
    }

    private Map<Long, Long> getBillOrgMap(DynamicObject billDy) {
        List<String> list = Arrays.asList("entryentity_add", "entryentity_info", "entryentity_parent", "entryentity_disable");
        HashMap<Long, Long> billOrgMap = new HashMap<Long, Long>(16);
        for (String propertyName : list) {
            boolean newFlag = "entryentity_add".equals(propertyName);
            String prefix = propertyName.substring(propertyName.indexOf("_") + 1);
            String idIdentify = prefix + "_" + (newFlag ? "adminorg" : "adminorg.id");
            String parentPropertyName = prefix + "_" + "parentorg.id";
            billDy.getDynamicObjectCollection(propertyName).forEach(dy -> billOrgMap.put(dy.getLong(idIdentify), dy.getLong(parentPropertyName)));
        }
        return billOrgMap;
    }

    private Set<Long> getSubSet(Node node) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)16);
        ArrayDeque<Node> queue = new ArrayDeque<Node>(node.getChildList());
        queue.offer(node);
        while (!queue.isEmpty()) {
            Node parentNode = (Node)queue.poll();
            List subNodeList = parentNode.getChildList();
            subNodeList.forEach(sub -> {
                if (!set.add(sub.getId())) {
                    queue.offer((Node)sub);
                }
            });
        }
        return set;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if ("1".equals(this.getView().getPageCache().get(CLOSE_CONFIRM))) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, null);
            return;
        }
        if (this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CLOSE_CONFIRM, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AdminorgRevisePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), this.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CLOSE_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, "1");
            this.getView().close();
        }
    }
}

