/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartHelper;
import kd.hr.homs.business.service.helper.AdminOrgMagicHelper;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;
import kd.hr.homs.common.model.OrgChartCheckVO;
import kd.hr.homs.common.model.OrgChartChgRequest;
import kd.hr.homs.common.model.OrgCubeTreeNode;
import kd.hr.homs.formplugin.web.orgbatch.AdminOrgBatchChartBasePlugin;

public class AdminOrgBatchChartSplitPlugin
extends AdminOrgBatchChartBasePlugin {
    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        DynamicObject billDy = parentView.getModel().getDataEntity(true);
        Long splitOrgId = this.getLongValue("splitOrgId");
        Long splitOriginId = this.getLongValue("split_origin_id");
        this.getModel().beginInit();
        if (splitOriginId == null) {
            this.initNew(splitOrgId, billDy);
        } else {
            this.initEdit(splitOriginId, billDy);
        }
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    private Long getLongValue(String name) {
        Long value = null;
        Object obj = this.getView().getFormShowParameter().getCustomParam(name);
        if (obj == null) {
            return value;
        }
        value = obj instanceof Long ? (Long)obj : Long.valueOf(obj.toString());
        return value;
    }

    private void initNew(Long splitOrgId, DynamicObject billDy) {
        this.initData(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT, null, null, null);
        if (splitOrgId == null) {
            this.setDataForCustomControl(this.buildData(null, new ArrayList<OrgCubeTreeNode>()), "init", "split");
            return;
        }
        DynamicObjectCollection col = AdminOrgBatchChartBaseHelper.queryOrgDetail((String)"id,name", (QFilter[])new QFilter("id", "=", (Object)splitOrgId).toArray());
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        DynamicObject splitOrgDy = (DynamicObject)col.get(0);
        this.getModel().setValue("to_split_org", (Object)splitOrgId);
        OrgCubeTreeNode toSplit = this.buildOrgCube(billDy, splitOrgDy.getLong("id"), splitOrgDy.getString("name"));
        ArrayList<OrgCubeTreeNode> targetList = new ArrayList<OrgCubeTreeNode>(1);
        this.setDataForCustomControl(this.buildData(toSplit, targetList), "init", "split");
    }

    private void initEdit(Long splitOriginId, DynamicObject billDy) {
        DynamicObjectCollection splitCol = billDy.getDynamicObjectCollection("entryentity_split");
        Optional<DynamicObject> optional = splitCol.stream().filter(splitDy -> splitDy.getLong("split_origin_id") == splitOriginId.longValue()).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        DynamicObject splitDy2 = optional.get();
        String idPropertyName = ".id";
        this.initData(OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT, splitDy2.getLong("split_changescene" + idPropertyName), splitDy2.getLong("split_changereason" + idPropertyName), splitDy2.getString("split_changedescription"));
        DynamicObject toSplitOrg = splitDy2.getDynamicObject("to_split_org");
        OrgCubeTreeNode toSplit = null;
        if (toSplitOrg != null) {
            this.getModel().setValue("to_split_org", (Object)toSplitOrg);
            toSplit = this.buildOrgCube(billDy, toSplitOrg.getLong("id"), toSplitOrg.getString("name"));
        }
        DynamicObjectCollection col = splitDy2.getDynamicObjectCollection("split_target_org");
        List<OrgCubeTreeNode> nodeList = this.buildTargetList(billDy, col);
        A[] obj = col.stream().map(dy -> dy.getLong("fbasedataid.id")).toArray(Object[]::new);
        this.getModel().setValue("split_target_org", obj);
        this.setDataForCustomControl(this.buildData(toSplit, nodeList), "init", "split");
    }

    private OrgCubeTreeNode buildOrgCube(DynamicObject billDy, long orgId, String orgName) {
        List<String> list = Collections.singletonList("entryentity_disable");
        return AdminOrgBatchChartBaseHelper.buildOrgCube((DynamicObject)billDy, (long)orgId, (String)orgName, list, (boolean)false);
    }

    private List<OrgCubeTreeNode> buildTargetList(DynamicObject billDy, DynamicObjectCollection targetCol) {
        ArrayList<OrgCubeTreeNode> nodeList = new ArrayList<OrgCubeTreeNode>(targetCol.size());
        List<String> list = Arrays.asList("entryentity_add", "entryentity_info", "entryentity_parent");
        for (DynamicObject targetDy : targetCol) {
            DynamicObject toTargetDy = targetDy.getDynamicObject("fbasedataid");
            nodeList.add(AdminOrgBatchChartBaseHelper.buildOrgCube((DynamicObject)billDy, (long)toTargetDy.getLong("id"), (String)toTargetDy.getString("name"), list, (boolean)false));
        }
        return nodeList;
    }

    private void fillUnSaveChangeType(Map<Long, OrgCubeTreeNode> orgMap, Long billId, boolean nameFlag) {
        DynamicObject[] dyArray;
        for (DynamicObject unSaveDy : dyArray = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData((Long)billId, orgMap.keySet(), (String)"adminorg.id,name,changetype,mergesplitstatus")) {
            OrgCubeTreeNode node = orgMap.get(unSaveDy.getLong("adminorg.id"));
            if ("1".equals(unSaveDy.getString("mergesplitstatus"))) {
                node.setChangeType("");
                node.setChangeTypeId("");
                continue;
            }
            DynamicObject changeTypeDy = unSaveDy.getDynamicObject("changetype");
            node.setChangeType(nameFlag ? changeTypeDy.getString("name") : ChangeTypeEnum.getNumberById((Long)changeTypeDy.getLong("id")));
            node.setChangeTypeId(changeTypeDy.getString("id"));
            node.setText(unSaveDy.getString("name"));
        }
    }

    private void buildUndoAdjustmentData(DynamicObject billDy, List<Long> orgList) {
        DynamicObject dy = this.getModel().getDataEntity(true);
        DynamicObjectCollection col = dy.getDynamicObjectCollection("split_target_org");
        Iterator it = col.iterator();
        HashSet<Long> addOrgSet = new HashSet<Long>(col.size());
        while (it.hasNext()) {
            DynamicObject baseDy = (DynamicObject)it.next();
            Long targetOrgId = baseDy.getDynamicObject("fbasedataid").getLong("id");
            if (!orgList.contains(targetOrgId) || !EnumHisDataVersionStatus.TEMP.getStatus().equals(baseDy.getDynamicObject("fbasedataid").getString("datastatus"))) continue;
            it.remove();
            addOrgSet.add(targetOrgId);
        }
        List<OrgCubeTreeNode> nodeList = this.buildTargetList(billDy, col);
        AdminOrgBatchChartBaseHelper.delAddMaster((long)billDy.getLong("id"), addOrgSet, (boolean)false);
        Map<Long, OrgCubeTreeNode> orgMap = nodeList.stream().collect(Collectors.toMap(key -> Long.valueOf(key.getId()), org -> org));
        DynamicObject toSplitDy = dy.getDynamicObject("to_split_org");
        OrgCubeTreeNode toSplit = null;
        if (toSplitDy != null) {
            toSplit = this.buildOrgCube(billDy, toSplitDy.getLong("id"), toSplitDy.getString("name"));
        }
        this.fillUnSaveChangeType(orgMap, billDy.getLong("id"), false);
        this.setDataForCustomControl(this.buildData(toSplit, nodeList), "init", "undoMergeSplit");
    }

    private void addTargetOrg(DynamicObjectCollection col, Long orgId) {
        Set<Object> orgIdSet = col.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        orgIdSet.add(orgId);
        this.getModel().setValue("split_target_org", (Object)orgIdSet.toArray(new Object[0]));
    }

    public void customEvent(CustomEventArgs evt) {
        if (!"customcontrolap".equals(evt.getKey())) {
            return;
        }
        String eventName = evt.getEventName();
        Long orgId = this.getModel().getDataEntity().getDynamicObject("org").getLong("id");
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity(true);
        switch (eventName) {
            case "selectToSplit": {
                Set<Long> excludeOrgSet = this.getSplitAndMergeOrgList(billDy, true);
                ListShowParameter toShowParameter = AdminOrgBatchChartBaseHelper.getListShowParameter(null, excludeOrgSet, (Long)orgId, (boolean)true);
                toShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectToSplit"));
                toShowParameter.setMultiSelect(false);
                this.getView().showForm((FormShowParameter)toShowParameter);
                break;
            }
            case "selectTargetSplit": {
                Set<Long> orgSet = this.getSplitAndMergeOrgList(billDy, false);
                Set newOrgSet = billDy.getDynamicObjectCollection("entryentity_add").stream().map(dy -> dy.getLong("add_adminorg")).collect(Collectors.toSet());
                Set deleteOrgSet = AdminOrgBatchChartBaseHelper.getEntryCol((Long)billDy.getLong("id"), newOrgSet, (String)"adminorg.id", Collections.singletonList("1")).stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
                newOrgSet.removeAll(deleteOrgSet);
                ListShowParameter listShowParameter = AdminOrgBatchChartBaseHelper.getListShowParameter(newOrgSet, orgSet, (Long)orgId, (boolean)false);
                listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectTargetSplit"));
                listShowParameter.setMultiSelect(false);
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
            default: {
                this.operateCustomEvent(evt, billDy);
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        int result = event.getResult().getValue();
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity(true);
        switch (event.getCallBackId()) {
            case "undoMergeSplit": {
                if (result != MessageBoxResult.Yes.getValue()) break;
                List orgList = JSONObject.parseArray((String)event.getCustomVaule(), Long.class);
                super.undoAdjustmentCallBack(orgList);
                this.buildUndoAdjustmentData(billDy, orgList);
                break;
            }
            case "disableOrg": {
                if (result != MessageBoxResult.Yes.getValue()) break;
                List orgList = JSONObject.parseArray((String)event.getCustomVaule(), ChgOrgInfoDto.class);
                this.showDisableLit(orgList, billDy);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "select_type": {
                BillShowParameter billShowParameter = AdminOrgBatchChartBaseHelper.openAddOrgPage((IFormView)this.getView().getParentView(), (String)this.getPluginName(), (ClosedCallBackEvent)closedCallBackEvent, (String)"1");
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
            case "selectToSplit": {
                this.selectOrg(closedCallBackEvent, "selectToSplit");
                break;
            }
            case "selectTargetSplit": {
                this.selectOrg(closedCallBackEvent, "selectTargetSplit");
                break;
            }
            case "add_orgDisable": {
                this.disableOrg((DynamicObjectCollection)closedCallBackEvent.getReturnData());
                break;
            }
            case "add_org": {
                Object data = closedCallBackEvent.getReturnData();
                if (!(data instanceof Map)) break;
                Map map = (Map)data;
                OrgCubeTreeNode node = new OrgCubeTreeNode((String)map.get("orgId"), (String)map.get("name"));
                node.setChangeType(ChangeTypeEnum.ADD.getNumber());
                this.addTargetOrg(this.getModel().getDataEntity().getDynamicObjectCollection("split_target_org"), Long.valueOf((String)map.get("orgId")));
                this.setDataCustomControl(node, "add_org");
                break;
            }
            case "entryentity_parent": {
                this.parentAndInfoClosedBack(closedCallBackEvent, "parent", "merge_parent_chg");
                break;
            }
            case "add_orgInfo": {
                this.parentAndInfoClosedBack(closedCallBackEvent, "info", "info_chg");
                break;
            }
        }
    }

    private void selectOrg(ClosedCallBackEvent closedCallBackEvent, String eventName) {
        List<String> list;
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (CollectionUtils.isEmpty((Collection)selectRowColl) || selectRowColl.size() != 1) {
            return;
        }
        ListSelectedRow listSelectedRow = selectRowColl.get(0);
        Long orgId = Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString());
        String orgName = listSelectedRow.getName();
        if ("selectToSplit".equals(eventName)) {
            list = Collections.singletonList("entryentity_disable");
            this.getModel().setValue("to_split_org", (Object)orgId);
        } else {
            list = Arrays.asList("entryentity_add", "entryentity_info", "entryentity_parent");
            this.addTargetOrg(this.getModel().getDataEntity().getDynamicObjectCollection("split_target_org"), orgId);
        }
        OrgCubeTreeNode node = AdminOrgBatchChartBaseHelper.buildOrgCube((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true), (long)orgId, (String)orgName, list, (boolean)false);
        this.setDataForCustomControl(node, "update", eventName);
    }

    private void parentAndInfoClosedBack(ClosedCallBackEvent closedCallBackEvent, String prefix, String eventName) {
        Object data = closedCallBackEvent.getReturnData();
        if (data instanceof Map) {
            OrgCubeTreeNode node = this.buildClosedBackNode((Map)data, prefix);
            this.setDataForCustomControl(node, "update", eventName);
        }
    }

    private List<String> validate() {
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObject dy = this.getModel().getDataEntity();
        List<OrgCubeTreeNode> list = this.buildTargetList(billDy, dy.getDynamicObjectCollection("split_target_org"));
        Map<Long, OrgCubeTreeNode> orgMap = list.stream().collect(Collectors.toMap(key -> Long.valueOf(key.getId()), org -> org));
        DynamicObject toSplitDy = dy.getDynamicObject("to_split_org");
        if (list.size() == 1 && Long.parseLong(list.get(0).getId()) == toSplitDy.getLong("id")) {
            return Collections.singletonList(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5c06\u7ec4\u7ec7\u201c%s\u201d\u62c6\u5206\u4e3a\u7ec4\u7ec7\u672c\u8eab\uff0c\u8bf7\u9009\u62e9\u66f4\u591a\u62c6\u5206\u540e\u7ec4\u7ec7\u3002", (String)"AdminOrgBatchChartSplitPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[]{toSplitDy.getString("name")}));
        }
        Long totoSplitId = toSplitDy.getLong("id");
        if (orgMap.get(totoSplitId) == null) {
            orgMap.put(totoSplitId, this.buildOrgCube(billDy, totoSplitId, toSplitDy.getString("name")));
        }
        this.fillUnSaveChangeType(orgMap, billDy.getLong("id"), false);
        Long splitOriginId = this.getLongValue("split_origin_id");
        return AdminOrgBatchChartHelper.checkSplitOrg((DynamicObject)billDy, this.buildCheckVO(orgMap), (Long)splitOriginId);
    }

    private List<OrgChartCheckVO> buildCheckVO(Map<Long, OrgCubeTreeNode> orgMap) {
        QFilter qFilter = new QFilter("id", "in", orgMap.keySet());
        Map<Long, DynamicObject> dyMap = AdminOrgBatchChartBaseHelper.queryOrgDetail((String)"id,enable", (QFilter[])qFilter.toArray()).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        ArrayList<OrgChartCheckVO> list = new ArrayList<OrgChartCheckVO>(orgMap.size());
        orgMap.forEach((k, v) -> list.add(new OrgChartCheckVO(k, v.getText(), ((DynamicObject)dyMap.get(k)).getString("enable"))));
        return list;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"confirm")) {
            return;
        }
        List<String> errorList = this.validate();
        if (!CollectionUtils.isEmpty(errorList)) {
            errorList.forEach(item -> this.getView().showTipNotification(item));
            return;
        }
        try (TXHandle required = TX.required();){
            try {
                this.saveData();
            }
            catch (Exception ex) {
                required.markRollback();
                throw ex;
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private void saveData() {
        long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
        HashSet<Long> toSaveOrgIdSet = new HashSet<Long>();
        HashSet<Long> deleteOrgIdSet = new HashSet<Long>();
        AdminOrgBatchChartBaseHelper.dealUnSaveAndDeleteData((long)billId, toSaveOrgIdSet, deleteOrgIdSet);
        Long oldToSplitOrg = this.getLongValue("split_origin_id");
        if (oldToSplitOrg != null) {
            QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("beforesplitorgid", "=", (Object)oldToSplitOrg));
            AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.deleteByFilter(filter.toArray());
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("split_target_org");
        DynamicObject toSplitOrg = dataEntity.getDynamicObject("to_split_org");
        long toSplitOrgId = toSplitOrg.getLong("id");
        ArrayList<DynamicObject> splitEntityList = new ArrayList<DynamicObject>(col.size());
        ArrayList<Long> splitTargetIdList = new ArrayList<Long>(col.size());
        for (DynamicObject dy : col) {
            DynamicObject splitTargetOrg = dy.getDynamicObject("fbasedataid");
            splitTargetIdList.add(splitTargetOrg.getLong("id"));
            splitEntityList.add(this.createSplitEntity(billId, dataEntity, toSplitOrgId, splitTargetOrg));
        }
        DynamicObject dy = this.createSplitEntity(billId, dataEntity, toSplitOrgId, toSplitOrg);
        dy.set("aftersplitorgid", (Object)0L);
        splitEntityList.add(dy);
        AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.save(splitEntityList.toArray(new DynamicObject[0]));
        this.setReturnData(dataEntity, splitTargetIdList, toSaveOrgIdSet, deleteOrgIdSet);
    }

    private void setReturnData(DynamicObject dataEntity, List<Long> splitTargetIdList, Set<Long> toSaveOrgIdSet, Set<Long> deleteOrgIdSet) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(8);
        DynamicObject toSplitOrgDy = dataEntity.getDynamicObject("to_split_org");
        Long toSplitOrg = this.getLongValue("split_origin_id");
        toSplitOrg = toSplitOrg == null ? Long.valueOf(toSplitOrgDy.getLong("id")) : toSplitOrg;
        returnMap.put("split_target_org", splitTargetIdList);
        returnMap.put("to_split_org", toSplitOrgDy);
        returnMap.put("changescene", dataEntity.getDynamicObject("changescene"));
        returnMap.put("changereason", dataEntity.getDynamicObject("changereason"));
        returnMap.put("changedescription", dataEntity.getString("changedescription"));
        returnMap.put("split_origin_id", toSplitOrg);
        returnMap.put("toSaveOrgIdSet", toSaveOrgIdSet);
        returnMap.put("deleteOrgIdSet", deleteOrgIdSet);
        this.getView().returnDataToParent(returnMap);
    }

    private DynamicObject createSplitEntity(long billId, DynamicObject dataEntity, long toSplitOrgId, DynamicObject splitTargetOrg) {
        DynamicObject entityDy = AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
        entityDy.set("billid", (Object)billId);
        entityDy.set("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_SPLIT);
        entityDy.set("changescene", dataEntity.get("changescene"));
        entityDy.set("changereason", dataEntity.get("changereason"));
        entityDy.set("changedescription", dataEntity.get("changedescription"));
        entityDy.set("mergesplitstatus", (Object)"2");
        entityDy.set("index", (Object)0);
        entityDy.set("beforesplitorgid", (Object)toSplitOrgId);
        entityDy.set("aftersplitorgid", (Object)splitTargetOrg.getLong("id"));
        entityDy.set("adminorg", (Object)splitTargetOrg.getLong("id"));
        return entityDy;
    }

    private void disableOrg(DynamicObjectCollection dyCol) {
        if (CollectionUtils.isEmpty((Collection)dyCol) || dyCol.size() != 1) {
            return;
        }
        DynamicObject billDy = this.getView().getParentView().getModel().getDataEntity();
        Set disableSet = dyCol.stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
        AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billDy.getLong("id"), disableSet);
        AdminOrgBatchChartBaseHelper.buildDisableEntityDy((DynamicObject)((DynamicObject)dyCol.get(0)), (Long)billDy.getLong("id"));
        DynamicObject adminOrgDy = ((DynamicObject)dyCol.get(0)).getDynamicObject("adminorg");
        String changeTypeNumber = ChangeTypeEnum.getNumberById((Long)((DynamicObject)dyCol.get(0)).getDynamicObject("changetype").getLong("id"));
        this.getModel().getDataEntity(true).getDynamicObjectCollection("split_target_org").removeIf(org -> org.getLong("fbasedataid.id") == adminOrgDy.getLong("id"));
        OrgCubeTreeNode node = new OrgCubeTreeNode(adminOrgDy.getString("id"), adminOrgDy.getString("name"), null, changeTypeNumber, "1");
        this.setDataForCustomControl(node, "update", "disableOrg");
    }

    private void operateCustomEvent(CustomEventArgs evt, DynamicObject billDy) {
        OrgChartChgRequest request = (OrgChartChgRequest)JSONObject.parseObject((String)evt.getEventArgs(), OrgChartChgRequest.class);
        String eventName = evt.getEventName();
        List orgList = request == null ? Collections.emptyList() : request.getOrgList();
        Set<Long> orgIdSet = orgList.stream().map(ChgOrgInfoDto::getOrgId).collect(Collectors.toSet());
        Long billId = billDy.getLong("id");
        switch (eventName) {
            case "stopSplit": {
                this.removeOrgSet(orgIdSet);
                AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgIdSet);
                this.setDataCustomControl(new OrgCubeTreeNode(), "stopSplit");
                break;
            }
            case "stopTargetSplit": {
                this.removeTargetOrgSet(orgIdSet);
                AdminOrgBatchChartBaseHelper.delAddMaster((long)billId, orgIdSet, (boolean)false);
                AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgIdSet);
                this.setDataCustomControl(new OrgCubeTreeNode(), "stopTargetSplit");
                break;
            }
            case "undoMergeSplit": {
                super.undoAdjustment(orgIdSet);
                break;
            }
            case "disableOrg": {
                String changeTypeName = this.getChangeTypeName(billDy, ((ChgOrgInfoDto)orgList.get(0)).getOrgId());
                if (HRStringUtils.isNotEmpty((String)changeTypeName)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u9700\u64a4\u9500\u8be5\u7ec4\u7ec7\u7684\u201c%s\u201d\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdminOrgBatchChartSplitPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[]{changeTypeName}), null, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("disableOrg", (IFormPlugin)this), null, JSONObject.toJSONString((Object)orgList));
                    break;
                }
                this.showDisableLit(orgList, billDy);
                break;
            }
            case "cancelDisable": {
                this.cancelDisable(((ChgOrgInfoDto)orgList.get(0)).getOrgId());
                break;
            }
            default: {
                this.commonCustomEvent(eventName, orgList, (AbstractFormPlugin)this);
            }
        }
    }

    private void cancelDisable(Long orgId) {
        Long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
        AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, Collections.singletonList(orgId));
        AdminOrgBatchChartBaseHelper.addToDeleteData((Long)billId, (long)orgId);
        DynamicObjectCollection col = AdminOrgBatchChartBaseHelper.queryOrgDetail((String)"id,name", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
        if (!CollectionUtils.isEmpty((Collection)col)) {
            DynamicObject orgDy = (DynamicObject)col.get(0);
            OrgCubeTreeNode orgNode = new OrgCubeTreeNode(String.valueOf(orgId), orgDy.getString("name"), null, "", "1");
            this.setDataForCustomControl(orgNode, "update", "cancelDisable");
        }
    }

    private void showDisableLit(List<ChgOrgInfoDto> orgList, DynamicObject dataEntity) {
        AdminOrgBatchChartBaseHelper.openChartList((String)"homs_chartdisablelist", (String)"add_orgDisable", orgList, (DynamicObject)dataEntity, (String)this.getPluginName(), (IFormView)this.getView(), (String)"1");
    }

    private void removeTargetOrgSet(Collection<Long> orgIdSet) {
        DynamicObject dy = this.getModel().getDataEntity(true);
        DynamicObjectCollection mergeOrgCol = dy.getDynamicObjectCollection("split_target_org");
        mergeOrgCol.removeIf(org -> orgIdSet.contains(org.getLong("fbasedataid.id")));
    }

    private void removeOrgSet(Collection<Long> orgIdSet) {
        DynamicObject dy = this.getModel().getDataEntity(true);
        if (orgIdSet.contains(dy.getLong("to_split_org.id"))) {
            this.getModel().setValue("to_split_org", null);
        }
    }

    private Set<Long> getSplitAndMergeOrgList(DynamicObject billDy, boolean flag) {
        DynamicObjectCollection splitCol = billDy.getDynamicObjectCollection("entryentity_split");
        Long splitOriginId = this.getLongValue("split_origin_id");
        HashSet<Long> orgSet = new HashSet<Long>(16);
        for (DynamicObject dy2 : splitCol) {
            if (splitOriginId != null && splitOriginId.longValue() == dy2.getLong("split_origin_id")) continue;
            orgSet.add(dy2.getLong("to_split_org.id"));
            dy2.getDynamicObjectCollection("split_target_org").forEach(targetDy -> orgSet.add(targetDy.getLong("fbasedataid.id")));
        }
        billDy.getDynamicObjectCollection("entryentity_merge").forEach(mergeDy -> {
            orgSet.add(mergeDy.getLong("merge_target_org.id"));
            mergeDy.getDynamicObjectCollection("to_merge_org").forEach(targetDy -> orgSet.add(targetDy.getLong("fbasedataid.id")));
        });
        DynamicObject splitDy = this.getModel().getDataEntity();
        Long currentSplitId = splitDy.getLong("to_split_org.id");
        if (flag) {
            orgSet.add(currentSplitId);
        } else {
            DynamicObjectCollection mergeOrgCol = splitDy.getDynamicObjectCollection("split_target_org");
            mergeOrgCol.forEach(org -> orgSet.add(org.getLong("fbasedataid.id")));
            orgSet.addAll(billDy.getDynamicObjectCollection("entryentity_disable").stream().map(dy -> dy.getLong("disable_adminorg.id")).collect(Collectors.toSet()));
            Long changeTypeId = this.getChangeTypeId(billDy, currentSplitId, Collections.singletonList("entryentity_disable"));
            if (changeTypeId == null || !changeTypeId.equals(ChangeTypeEnum.DISABLE.getId())) {
                orgSet.remove(currentSplitId);
            } else {
                orgSet.add(currentSplitId);
            }
        }
        return orgSet;
    }

    private Long getChangeTypeId(DynamicObject billDy, Long orgId, List<String> list) {
        if (orgId == 0L) {
            return null;
        }
        OrgCubeTreeNode node = AdminOrgBatchChartBaseHelper.buildOrgCube((DynamicObject)billDy, (long)orgId, null, list, (boolean)true);
        HashMap<Long, OrgCubeTreeNode> map = new HashMap<Long, OrgCubeTreeNode>(1);
        map.put(orgId, node);
        this.fillUnSaveChangeType(map, billDy.getLong("id"), true);
        return HRStringUtils.isEmpty((String)node.getChangeTypeId()) ? null : Long.valueOf(node.getChangeTypeId());
    }

    private String getChangeTypeName(DynamicObject billDy, long orgId) {
        List<String> list = Arrays.asList("entryentity_info", "entryentity_parent");
        OrgCubeTreeNode node = AdminOrgBatchChartBaseHelper.buildOrgCube((DynamicObject)billDy, (long)orgId, null, list, (boolean)true);
        HashMap<Long, OrgCubeTreeNode> map = new HashMap<Long, OrgCubeTreeNode>(1);
        map.put(orgId, node);
        this.fillUnSaveChangeType(map, billDy.getLong("id"), true);
        return node.getChangeType();
    }

    private Map<String, Object> buildData(OrgCubeTreeNode toSplit, List<OrgCubeTreeNode> splitTargetOrgList) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("toSplitOrg", toSplit);
        map.put("splitTargetOrgList", splitTargetOrgList);
        ArrayList<OrgCubeTreeNode> list = new ArrayList<OrgCubeTreeNode>(splitTargetOrgList.size() + 1);
        list.addAll(splitTargetOrgList);
        if (toSplit != null) {
            list.add(toSplit);
        }
        if (!CollectionUtils.isEmpty(list)) {
            AdminOrgMagicHelper.setOrgInfo(list, (Date)this.getModifyTime());
        }
        map.put("changeTypeVo", AdminOrgMagicHelper.getOrgChangeTypeVo());
        return map;
    }

    private Date getModifyTime() {
        return this.getView().getParentView().getModel().getDataEntity().getDate("modifytime");
    }

    private void setDataCustomControl(OrgCubeTreeNode splitNode, String eventName) {
        splitNode.setManagerName("");
        splitNode.setManagerImg("");
        this.setCustomControl(splitNode, "update", eventName);
    }

    private void setDataForCustomControl(Object obj, String eventStatus, String eventName) {
        if (obj instanceof OrgCubeTreeNode) {
            ArrayList<OrgCubeTreeNode> list = new ArrayList<OrgCubeTreeNode>(1);
            list.add((OrgCubeTreeNode)obj);
            AdminOrgMagicHelper.setOrgInfo(list, (Date)this.getModifyTime());
        }
        this.setCustomControl(obj, eventStatus, eventName);
    }

    private void setCustomControl(Object obj, String eventStatus, String eventName) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("data", obj);
        data.put("code", "200");
        data.put("errorMessage", "");
        data.put("time", System.currentTimeMillis());
        data.put("eventName", eventName);
        data.put("eventStatus", eventStatus);
        data.put("viewStatus", AdminOrgBatchChartBaseHelper.getViewStatus((IFormView)this.getView()));
        customcontrol.setData(data);
    }
}

