/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.common.constants.batchchg.AdminOrgBatchBillConstants;
import kd.hr.homs.common.constants.batchchg.ChangeTypeEnum;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;
import kd.hr.homs.common.model.OrgChartChgRequest;
import kd.hr.homs.common.model.OrgCubeTreeNode;
import kd.hr.homs.formplugin.web.orgbatch.AdminOrgBatchChartBasePlugin;

public class AdminOrgBatchMergePlugin
extends AdminOrgBatchChartBasePlugin
implements AdminOrgBatchBillConstants,
BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        List toBeMergeOrgId;
        super.beforeBindData(e);
        this.initData(OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String newMerge = (String)formShowParameter.getCustomParam("newMerge");
        if (HRStringUtils.isEmpty((String)newMerge) || HRStringUtils.equals((String)"true", (String)newMerge)) {
            List toBeMergeOrgId2 = (List)formShowParameter.getCustomParam("tobemergeorg");
            if (!CollectionUtils.isEmpty((Collection)toBeMergeOrgId2)) {
                this.getModel().setValue("tobemergeorg", (Object)toBeMergeOrgId2.toArray(new Object[0]));
                DynamicObject[] query = AdminOrgBatchChartBaseHelper.HAOS_ADMINORGDETAIL_HELPER.query("id,name", new QFilter[]{new QFilter("id", "in", (Object)toBeMergeOrgId2)});
                AdminOrgBatchChartBaseHelper.initOrgMerge(Arrays.stream(query).collect(Collectors.toList()), null, (IFormView)this.getView(), (String)"merge");
            } else {
                AdminOrgBatchChartBaseHelper.initOrgMerge(new ArrayList(), null, (IFormView)this.getView(), (String)"merge");
            }
            this.getModel().setDataChanged(false);
            return;
        }
        this.getView().getPageCache().put("initMergeOrgFlag", "true");
        Object mergeTargetOrgId = formShowParameter.getCustomParam("targetorg");
        if (mergeTargetOrgId != null) {
            this.getModel().setValue("targetorg", (Object)Long.valueOf(mergeTargetOrgId.toString()));
        }
        if (!CollectionUtils.isEmpty((Collection)(toBeMergeOrgId = (List)formShowParameter.getCustomParam("tobemergeorg")))) {
            this.getModel().setValue("tobemergeorg", (Object)toBeMergeOrgId.toArray(new Object[0]));
        }
        this.initOrgMerge(this.getModel().getDataEntity().getDynamicObjectCollection("tobemergeorg"), "merge");
        Object originTargetOrg = formShowParameter.getCustomParam("originTargetOrg");
        this.getView().getPageCache().put("originTargetOrg", originTargetOrg.toString());
        this.getModel().setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String initMergeOrgFlag;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"tobemergeorg") && HRStringUtils.equals((String)"true", (String)(initMergeOrgFlag = this.getView().getPageCache().get("initMergeOrgFlag")))) {
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            Set newValueIdSet = Optional.ofNullable(newValue).orElseGet(MulBasedataDynamicObjectCollection::new).stream().map(value -> value.getLong("fbasedataid.id")).collect(Collectors.toSet());
            MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            if (!CollectionUtils.isEmpty((Collection)oldValue)) {
                Set oldValueIdSet = oldValue.stream().map(value -> value.getLong("fbasedataid.id")).filter(id -> !newValueIdSet.contains(id)).collect(Collectors.toSet());
                Long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
                AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, oldValueIdSet);
            }
            this.initOrgMerge((DynamicObjectCollection)newValue, "merge");
        }
    }

    private void initOrgMerge(DynamicObjectCollection newValue, String eventName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        List list = Optional.ofNullable(newValue).orElseGet(MulBasedataDynamicObjectCollection::new).stream().map(value -> {
            DynamicObject org = helper.generateEmptyDynamicObject();
            org.set("id", (Object)value.getLong("fbasedataid.id"));
            org.set("name", (Object)value.getString("fbasedataid.name"));
            return org;
        }).collect(Collectors.toList());
        DynamicObject targetOrg = this.getModel().getDataEntity().getDynamicObject("targetorg");
        AdminOrgBatchChartBaseHelper.initOrgMerge(list, (DynamicObject)targetOrg, (IFormView)this.getView(), (String)eventName);
    }

    public void customEvent(CustomEventArgs evt) {
        String key = evt.getKey();
        if ("customcontrolap".equals(key)) {
            String eventName = evt.getEventName();
            OrgChartChgRequest request = (OrgChartChgRequest)JSONObject.parseObject((String)evt.getEventArgs(), OrgChartChgRequest.class);
            List orgList = Optional.ofNullable(request).map(OrgChartChgRequest::getOrgList).orElseGet(ArrayList::new);
            Set<Long> orgIdSet = orgList.stream().map(ChgOrgInfoDto::getOrgId).collect(Collectors.toSet());
            DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            switch (eventName) {
                case "disable_after_merge": 
                case "reserved_after_merge": {
                    DynamicObject orgChangeType = AdminOrgBatchChartBaseHelper.getOrgChangeType((DynamicObject)parentDataEntity, (Long)((ChgOrgInfoDto)orgList.get(0)).getOrgId());
                    if (orgChangeType == null) {
                        AdminOrgBatchChartBaseHelper.openChartList((String)"homs_chartdisablelist", (String)"disable_after_merge", (List)orgList, (DynamicObject)parentDataEntity, (String)this.getPluginName(), (IFormView)this.getView(), (String)"1");
                        return;
                    }
                    String param = JSONObject.toJSONString((Object)orgList);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(eventName, (IFormPlugin)this);
                    String description = ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u9700\u64a4\u9500\u8be5\u7ec4\u7ec7\u7684\u201c%s\u201d\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdminOrgBatchMergePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[]{orgChangeType.getString("name")});
                    this.getView().showConfirm(description, null, MessageBoxOptions.OKCancel, null, confirmCallBackListener, null, param);
                    break;
                }
                case "stop_merge": {
                    this.stopMerge(request);
                    break;
                }
                case "merge_undo_adjustment": {
                    super.undoAdjustment(orgIdSet);
                    break;
                }
                case "exist_org_f7": {
                    this.existOrgF7(parentDataEntity);
                    break;
                }
                default: {
                    this.commonCustomEvent(eventName, orgList, (AbstractFormPlugin)this);
                }
            }
        }
    }

    private void existOrgF7(DynamicObject parentDataEntity) {
        DynamicObject[] unSaveAndDeleteData;
        Long dutyOrgId = parentDataEntity.getDynamicObject("org").getLong("id");
        DynamicObjectCollection add = parentDataEntity.getDynamicObjectCollection("entryentity_add");
        DynamicObjectCollection disable = parentDataEntity.getDynamicObjectCollection("entryentity_disable");
        Set newOrgSet = add.stream().map(entry -> entry.getLong("add_adminorg")).collect(Collectors.toSet());
        Set excludeOrgSet = disable.stream().map(entry -> entry.getLong("disable_adminorg.id")).collect(Collectors.toSet());
        for (DynamicObject data : unSaveAndDeleteData = AdminOrgBatchChartBaseHelper.getUnSaveAndDeleteData((Long)parentDataEntity.getLong("id"), (String)"adminorg.id,name,changetype.id,mergesplitstatus")) {
            if (data.getLong("changetype.id") == ChangeTypeEnum.DISABLE.getId().longValue()) {
                excludeOrgSet.add(data.getLong("adminorg.id"));
            } else {
                excludeOrgSet.removeIf(id -> id.longValue() == data.getLong("adminorg.id"));
            }
            if (!HRStringUtils.equals((String)"1", (String)data.getString("mergesplitstatus"))) continue;
            newOrgSet.removeIf(id -> id.longValue() == data.getLong("adminorg.id"));
        }
        excludeOrgSet.addAll(this.excludeOrgSet(parentDataEntity));
        ListShowParameter toShowParameter = AdminOrgBatchChartBaseHelper.getListShowParameter(newOrgSet, excludeOrgSet, (Long)dutyOrgId, (boolean)false);
        toShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "exist_org_f7"));
        toShowParameter.setMultiSelect(false);
        this.getView().showForm((FormShowParameter)toShowParameter);
    }

    private Set<Long> excludeOrgSet(DynamicObject billDy) {
        DynamicObjectCollection mergeCol = billDy.getDynamicObjectCollection("entryentity_merge");
        String oldTargetOrgId = this.getView().getPageCache().get("originTargetOrg");
        Long oldMergeTargetOrgId = HRStringUtils.isEmpty((String)oldTargetOrgId) ? null : Long.valueOf(Long.parseLong(oldTargetOrgId));
        HashSet<Long> orgSet = new HashSet<Long>(16);
        for (DynamicObject dy : mergeCol) {
            if (oldMergeTargetOrgId != null && oldMergeTargetOrgId.longValue() == dy.getLong("merge_origin_id")) continue;
            orgSet.add(dy.getLong("merge_target_org.id"));
            dy.getDynamicObjectCollection("to_merge_org").forEach(targetDy -> orgSet.add(targetDy.getLong("fbasedataid.id")));
        }
        billDy.getDynamicObjectCollection("entryentity_split").forEach(splitDy -> {
            orgSet.add(splitDy.getLong("to_split_org.id"));
            splitDy.getDynamicObjectCollection("split_target_org").forEach(targetDy -> orgSet.add(targetDy.getLong("fbasedataid.id")));
        });
        return orgSet;
    }

    private void stopMerge(OrgChartChgRequest request) {
        if (request == null) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
        List orgList = Optional.of(request).map(OrgChartChgRequest::getOrgList).orElseGet(ArrayList::new);
        Set orgIdSet = orgList.stream().map(ChgOrgInfoDto::getOrgId).collect(Collectors.toSet());
        if (request.isTargetOrg()) {
            AdminOrgBatchChartBaseHelper.delAddMaster((long)billId, orgIdSet, (boolean)false);
            this.getView().getModel().setValue("targetorg", null);
        } else {
            DynamicObjectCollection toBeMergeOrg = dataEntity.getDynamicObjectCollection("tobemergeorg");
            boolean removeIf = toBeMergeOrg.removeIf(org -> orgIdSet.contains(org.getDynamicObject("fbasedataid").getLong("id")));
            if (removeIf) {
                this.getView().getPageCache().put("initMergeOrgFlag", "false");
                this.getModel().setValue("tobemergeorg", (Object)toBeMergeOrg);
                this.getView().updateView("tobemergeorg");
            }
        }
        AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgIdSet);
        OrgCubeTreeNode orgCubeTreeNode = orgIdSet.stream().map(orgId -> new OrgCubeTreeNode(orgId.toString(), null)).findFirst().orElseGet(() -> new OrgCubeTreeNode("0", null));
        this.setCustomData("stop_merge", orgCubeTreeNode);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "select_type": {
                BillShowParameter billShowParameter = AdminOrgBatchChartBaseHelper.openAddOrgPage((IFormView)this.getView().getParentView(), (String)this.getPluginName(), (ClosedCallBackEvent)closedCallBackEvent, (String)"1");
                this.getView().showForm((FormShowParameter)billShowParameter);
                break;
            }
            case "add_org": {
                Object data = closedCallBackEvent.getReturnData();
                if (!(data instanceof Map)) break;
                Map map = (Map)data;
                OrgCubeTreeNode node = new OrgCubeTreeNode((String)map.get("orgId"), (String)map.get("name"));
                node.setChangeType(ChangeTypeEnum.ADD.getNumber());
                this.getModel().setValue("targetorg", map.get("orgId"));
                this.setCustomData("add_org", node);
                break;
            }
            case "entryentity_parent": {
                this.parentAndInfoClosedBack(closedCallBackEvent, "parent", "merge_parent_chg");
                break;
            }
            case "add_orgInfo": {
                this.parentAndInfoClosedBack(closedCallBackEvent, "info", "info_chg");
                break;
            }
            case "disable_after_merge": {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                if (CollectionUtils.isEmpty((Collection)dynamicObjects)) break;
                Set orgIdSet = dynamicObjects.stream().map(entry -> entry.getLong("adminorg.id")).collect(Collectors.toSet());
                Long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
                AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgIdSet);
                AdminOrgBatchChartBaseHelper.buildDisableEntityDy((DynamicObject)((DynamicObject)dynamicObjects.get(0)), (Long)billId);
                DynamicObject org = dynamicObjects.stream().map(value -> value.getDynamicObject("adminorg")).findFirst().orElse(null);
                this.setSingleTreeNode(org, "disable_after_merge");
                break;
            }
            case "exist_org_f7": {
                this.setTargetOrgWithExistOrg(closedCallBackEvent);
                break;
            }
        }
    }

    private void setTargetOrgWithExistOrg(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (selectRowColl != null && !selectRowColl.isEmpty()) {
            ListSelectedRow listSelectedRow = selectRowColl.get(0);
            long orgId = Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString());
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObject targetOrg = helper.generateEmptyDynamicObject();
            targetOrg.set("id", (Object)orgId);
            targetOrg.set("name", (Object)listSelectedRow.getName());
            this.getModel().setValue("targetorg", (Object)targetOrg);
            this.setSingleTreeNode(targetOrg, "exist_org_f7");
        }
    }

    private void setSingleTreeNode(DynamicObject org, String eventName) {
        if (org == null) {
            return;
        }
        List orgNodes = AdminOrgBatchChartBaseHelper.getOrgNodes(Collections.singletonList(org), (IFormView)this.getView().getParentView());
        this.setCustomData(eventName, (OrgCubeTreeNode)orgNodes.get(0));
    }

    private void parentAndInfoClosedBack(ClosedCallBackEvent closedCallBackEvent, String prefix, String eventName) {
        Object data = closedCallBackEvent.getReturnData();
        if (data instanceof Map) {
            OrgCubeTreeNode node = this.buildClosedBackNode((Map)data, prefix);
            this.setCustomData(eventName, node);
        }
    }

    private void setCustomData(String eventName, OrgCubeTreeNode node) {
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("data", node);
        customData.put("eventName", eventName);
        customData.put("eventStatus", "update");
        customData.put("code", "200");
        customData.put("errorMessage", "");
        customData.put("dataTime", new Date());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(customData);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("tobemergeorg");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        MulBasedataEdit mulBasedataEdit;
        String name;
        super.beforeF7Select(beforeF7SelectEvent);
        Object source = beforeF7SelectEvent.getSource();
        if (source instanceof MulBasedataEdit && HRStringUtils.equals((String)(name = (mulBasedataEdit = (MulBasedataEdit)source).getKey()), (String)"tobemergeorg")) {
            this.getView().getPageCache().put("initMergeOrgFlag", "true");
            DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            long orgId = dataEntity.getLong("org.id");
            Set<Long> excludeOrgIdSet = this.getExcludeOrgIdSet(dataEntity);
            AdminOrgBatchChartBaseHelper.setF7OrgFilter((BeforeF7SelectEvent)beforeF7SelectEvent, new HashSet(), excludeOrgIdSet, (Long)orgId);
        }
    }

    private Set<Long> getExcludeOrgIdSet(DynamicObject dataEntity) {
        DynamicObjectCollection merge = dataEntity.getDynamicObjectCollection("entryentity_merge");
        HashSet<Long> excludeOrgIdSet = new HashSet<Long>();
        Object originTargetOrg = this.getView().getFormShowParameter().getCustomParam("originTargetOrg");
        merge.forEach(entry -> {
            if (originTargetOrg == null || entry.getLong("merge_origin_id") != Long.parseLong(originTargetOrg.toString())) {
                DynamicObjectCollection toMergeOrg = entry.getDynamicObjectCollection("to_merge_org");
                DynamicObject targetOrg = entry.getDynamicObject("merge_target_org");
                if (targetOrg != null) {
                    excludeOrgIdSet.add(targetOrg.getLong("id"));
                }
                if (!CollectionUtils.isEmpty((Collection)toMergeOrg)) {
                    excludeOrgIdSet.addAll(toMergeOrg.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
                }
            }
        });
        DynamicObjectCollection split = dataEntity.getDynamicObjectCollection("entryentity_split");
        split.forEach(entry -> {
            DynamicObjectCollection splitTargetOrg = entry.getDynamicObjectCollection("split_target_org");
            DynamicObject toSplitOrg = entry.getDynamicObject("to_split_org");
            if (toSplitOrg != null) {
                excludeOrgIdSet.add(toSplitOrg.getLong("id"));
            }
            if (!CollectionUtils.isEmpty((Collection)splitTargetOrg)) {
                excludeOrgIdSet.addAll(splitTargetOrg.stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
            }
        });
        return excludeOrgIdSet;
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        int result = messageBoxClosedEvent.getResult().getValue();
        if (result != MessageBoxResult.Yes.getValue()) {
            return;
        }
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "disable_after_merge": {
                List orgList = JSONObject.parseArray((String)messageBoxClosedEvent.getCustomVaule(), ChgOrgInfoDto.class);
                AdminOrgBatchChartBaseHelper.openChartList((String)"homs_chartdisablelist", (String)"disable_after_merge", (List)orgList, (DynamicObject)this.getView().getParentView().getModel().getDataEntity(), (String)this.getPluginName(), (IFormView)this.getView(), (String)"1");
                break;
            }
            case "reserved_after_merge": {
                this.reservedAfterMerge(messageBoxClosedEvent);
                break;
            }
            case "undoMergeSplit": {
                this.undoMergeSplit(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void undoMergeSplit(MessageBoxClosedEvent messageBoxClosedEvent) {
        long targetOrgId;
        List orgList = JSONObject.parseArray((String)messageBoxClosedEvent.getCustomVaule(), Long.class);
        super.undoAdjustmentCallBack(orgList);
        HashSet orgIdSet = new HashSet(orgList);
        DynamicObject targetOrg = this.getModel().getDataEntity().getDynamicObject("targetorg");
        if (targetOrg != null && orgIdSet.contains(targetOrgId = targetOrg.getLong("id"))) {
            DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
            long billId = dataEntity.getLong("id");
            QFilter filter = new QFilter("adminorg.id", "=", (Object)targetOrgId).and(new QFilter("changetype.id", "=", (Object)ChangeTypeEnum.ADD.getId()).and(new QFilter("billid", "=", (Object)billId)));
            boolean isAddOrg = AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.isExists(filter);
            if (isAddOrg) {
                this.getModel().setValue("targetorg", null);
            }
            AdminOrgBatchChartBaseHelper.delAddMaster((long)billId, orgIdSet, (boolean)false);
        }
        DynamicObjectCollection toBeMergeOrgs = this.getModel().getDataEntity(true).getDynamicObjectCollection("tobemergeorg");
        this.initOrgMerge(toBeMergeOrgs, "merge_undo_adjustment");
    }

    private void reservedAfterMerge(MessageBoxClosedEvent messageBoxClosedEvent) {
        List orgList = JSONObject.parseArray((String)messageBoxClosedEvent.getCustomVaule(), ChgOrgInfoDto.class);
        Set orgIdSet = orgList.stream().map(ChgOrgInfoDto::getOrgId).collect(Collectors.toSet());
        Long orgId = ((ChgOrgInfoDto)orgList.get(0)).getOrgId();
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        long billId = dataEntity.getLong("id");
        AdminOrgBatchChartBaseHelper.deleteUnSaveEntity((Long)billId, orgIdSet);
        AdminOrgBatchChartBaseHelper.addToDeleteData((Long)billId, (long)orgId);
        DynamicObjectCollection toBeMergeOrgs = this.getModel().getDataEntity(true).getDynamicObjectCollection("tobemergeorg");
        Optional<DynamicObject> disableOrgOptional = toBeMergeOrgs.stream().filter(org -> org.getDynamicObject("fbasedataid").getLong("id") == orgId.longValue()).map(org -> org.getDynamicObject("fbasedataid")).findFirst();
        if (disableOrgOptional.isPresent()) {
            DynamicObject disableOrg = disableOrgOptional.get();
            this.setSingleTreeNode(disableOrg, "reserved_after_merge");
        }
    }

    private boolean validate() {
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObject mergeEntity = this.getModel().getDataEntity(true);
        Set orgIdSet = mergeEntity.getDynamicObjectCollection("tobemergeorg").stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        long targetOrgId = mergeEntity.getLong("targetorg.id");
        String oldTargetOrgId = this.getView().getPageCache().get("originTargetOrg");
        Long oldMergeTargetOrgId = HRStringUtils.isEmpty((String)oldTargetOrgId) ? 0L : Long.parseLong(oldTargetOrgId);
        List result = AdminOrgBatchChartBaseHelper.checkMergeOrg((DynamicObject)dataEntity, orgIdSet, (Long)targetOrgId, (Long)oldMergeTargetOrgId);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result.forEach(item -> this.getView().showTipNotification(item));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        long billId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
        if (HRStringUtils.equals((String)operateKey, (String)"confirm")) {
            if (!this.validate()) {
                return;
            }
            try (TXHandle txHandle = TX.required();){
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection toBeMergeOrgs = dataEntity.getDynamicObjectCollection("tobemergeorg");
                DynamicObject targetOrg = dataEntity.getDynamicObject("targetorg");
                HashSet<Long> toSaveOrgIdSet = new HashSet<Long>();
                HashSet<Long> deleteOrgIdSet = new HashSet<Long>();
                AdminOrgBatchChartBaseHelper.dealUnSaveAndDeleteData((long)billId, toSaveOrgIdSet, deleteOrgIdSet);
                String oldTargetOrgId = this.getView().getPageCache().get("originTargetOrg");
                if (HRStringUtils.isNotEmpty((String)oldTargetOrgId)) {
                    QFilter filter = new QFilter("billid", "=", (Object)billId).and(new QFilter("aftermergeorgid", "=", (Object)Long.valueOf(oldTargetOrgId)));
                    AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.deleteByFilter(filter.toArray());
                }
                List<DynamicObject> mergeOrgEntryList = toBeMergeOrgs.stream().map(toBeMergeOrg -> {
                    DynamicObject entityDy = this.getMergeOrgEntity(dataEntity, billId);
                    DynamicObject org = toBeMergeOrg.getDynamicObject("fbasedataid");
                    long orgId = org.getLong("id");
                    entityDy.set("adminorg", (Object)orgId);
                    entityDy.set("beforemergeorgid", (Object)orgId);
                    entityDy.set("aftermergeorgid", (Object)targetOrg.getLong("id"));
                    return entityDy;
                }).collect(Collectors.toList());
                DynamicObject targetOrgEntity = this.getMergeOrgEntity(dataEntity, billId);
                targetOrgEntity.set("beforemergeorgid", (Object)0L);
                targetOrgEntity.set("aftermergeorgid", (Object)targetOrg.getLong("id"));
                targetOrgEntity.set("adminorg", (Object)targetOrg.getLong("id"));
                mergeOrgEntryList.add(targetOrgEntity);
                AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.save(mergeOrgEntryList.toArray(new DynamicObject[0]));
                this.setReturnData(dataEntity, toSaveOrgIdSet, deleteOrgIdSet);
            }
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private DynamicObject getMergeOrgEntity(DynamicObject dataEntity, long billId) {
        DynamicObject entityDy = AdminOrgBatchChartBaseHelper.HOMS_BATCHORGENTITY_HELPER.generateEmptyDynamicObject();
        entityDy.set("billid", (Object)billId);
        entityDy.set("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_MERGE);
        entityDy.set("changescene", dataEntity.get("changescene"));
        entityDy.set("changereason", dataEntity.get("changereason"));
        entityDy.set("changedescription", dataEntity.get("changedescription"));
        entityDy.set("mergesplitstatus", (Object)"2");
        entityDy.set("index", (Object)0);
        entityDy.set("org", (Object)dataEntity.getLong("org.id"));
        return entityDy;
    }

    private void setReturnData(DynamicObject dataEntity, Set<Long> toSaveOrgIdSet, Set<Long> deleteOrgIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List toBeMergeOrgArr = dataEntity.getDynamicObjectCollection("tobemergeorg").stream().map(org -> org.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        map.put("tobemergeorg", toBeMergeOrgArr);
        map.put("targetorg", dataEntity.getDynamicObject("targetorg"));
        map.put("changescene", dataEntity.getDynamicObject("changescene"));
        map.put("changereason", dataEntity.getDynamicObject("changereason"));
        map.put("changedescription", dataEntity.getString("changedescription"));
        String originTargetOrg = this.getView().getPageCache().get("originTargetOrg");
        map.put("originTargetOrg", originTargetOrg == null ? 0L : Long.parseLong(originTargetOrg));
        map.put("toSaveOrgIdSet", toSaveOrgIdSet);
        map.put("deleteOrgIdSet", deleteOrgIdSet);
        this.getView().returnDataToParent(map);
    }
}

