/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillAfterBindDataService;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillClosedCallBackService;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillConfirmCallBackService;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillCustomEventService;
import kd.hr.homs.business.service.batchservice.AdminOrgBatchBillPropertyChangedService;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChartBaseHelper;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.helper.OrgBatchBillCheckHelper;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.validcommon.BillEntryHelperEnum;
import kd.hr.homs.common.constants.batchchg.AdminOrgBatchBillConstants;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.formplugin.web.orgbatch.AdminOrgBatchParentBillPlugin;
import org.apache.commons.lang3.time.DateUtils;

public class AdminorgBatchBillPlugin
extends HRCoreBaseBillEdit
implements ClickListener,
BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener,
AdminOrgBatchBillConstants {
    private static final Log LOG = LogFactory.getLog(AdminorgBatchBillPlugin.class);
    private static final String ADD = "add";
    private static final String PARENT = "parent";
    private static final String DISABLE = "disable";
    private static final String INFO_CHG = "infochg";
    private static final String ADD_ORG = "add_org";
    private static final String IS_CANCEL_OVER = "isCancelOver";
    private static final String TAB_AP_ENTRY = "tabapentry";
    private static final String OPERATION_DONOTHING_SUBMIT = "donothing_submit";
    private static final String OPERATION_DONOTHING_SUBMITEFFECT = "donothing_submiteffect";

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg((boolean)true);
            List hasPermOrgs = hrPermOrg.getHasPermOrgs();
            if (!Objects.isNull(hasPermOrgs) && hasPermOrgs.size() != 0) {
                if (hasPermOrgs.contains(RequestContext.get().getOrgId())) {
                    this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                } else {
                    this.getModel().setValue("org", hasPermOrgs.get(0));
                }
            } else {
                LOG.error("AdminorgBatchBillPlugin can not get any org");
            }
        }
        if ((org = this.getModel().getDataEntity().getDynamicObject("org")) == null) {
            this.setBillNo(e);
        } else {
            long orgid = org.getLong("id");
            boolean cudeRule = CodeRuleServiceHelper.isExist((String)"homs_orgbatchchgbill", (DynamicObject)this.getModel().getDataEntity(), (String)String.valueOf(orgid));
            if (!cudeRule) {
                this.setBillNo(e);
            }
        }
    }

    private void setBillNo(EventObject e) {
        HashMap map = new HashMap();
        HashMap item = new HashMap();
        HashMap<Locale, String> emptyTip = new HashMap<Locale, String>();
        map.put("item", item);
        item.put("emptytip", emptyTip);
        Lang lang = Lang.get();
        emptyTip.put(lang.getLocale(), "");
        this.getView().updateControlMetadata("billno", map);
        this.getModel().setValue("billno", (Object)"");
        this.getView().setEnable(Boolean.TRUE, new String[]{"billno"});
        super.afterCreateNewData(e);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        LocaleString caption = billShowParameter.getFormConfig().getCaption();
        if (billShowParameter.getPkId() == null) {
            caption.setLocaleValue(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u7533\u8bf7", (String)"AdminorgBatchBillPlugin_38", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        } else {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
            DynamicObject billObject = hrBaseServiceHelper.queryOne("id,billno", billShowParameter.getPkId());
            if (billObject != null) {
                caption.setLocaleValue(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u8c03\u6574\u7533\u8bf7-%s", (String)"AdminorgBatchBillPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[0]), billObject.getString("billno")));
            }
        }
    }

    private void deleteUnSaveData() {
        long billId = this.getModel().getDataEntity().getLong("id");
        if (billId != 0L) {
            AdminOrgBatchChartBaseHelper.deleteAllUnSaveEntity((Long)billId);
        }
    }

    public void beforeBindData(EventObject e) {
        String billstatus;
        Container baseInfo;
        this.deleteUnSaveData();
        this.changePageCacheFromWhatVie();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"chg_info"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"org_magic"});
        this.getView().getPageCache().put("isList", "1");
        if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getAppId(), (String)"wftask")) {
            baseInfo = (Container)this.getView().getControl("fs_baseinfo");
            baseInfo.setCollapse(true);
        } else {
            baseInfo = (Container)this.getView().getControl("fs_baseinfo");
            baseInfo.setCollapse(false);
        }
        this.setTips();
        if (this.getModel().getDataEntity(true).getDynamicObject("org") == null) {
            this.getView().getModel().setValue("org", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
        }
        if (("B".equals(billstatus = this.getModel().getDataEntity().getString("billstatus")) || "C".equals(billstatus) || "D".equals(billstatus) || "E".equals(billstatus)) && this.getModel().getDataEntity().getBoolean("isexistsworkflow")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"baritemap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"baritemap"});
        }
    }

    private void changePageCacheFromWhatVie() {
        if ("true".equals(this.getView().getFormShowParameter().getCustomParam("fromList"))) {
            HasPermOrgResult hrPermOrg;
            List hasPermOrgs;
            Object businessUnit = this.getView().getFormShowParameter().getCustomParam("businessUnit");
            if (businessUnit != null) {
                this.getModel().setValue("org", businessUnit);
            } else if (!"true".equals(this.getView().getFormShowParameter().getCustomParam("isFromBillClick")) && !Objects.isNull(hasPermOrgs = (hrPermOrg = OrgPermHelper.getHRPermOrg((boolean)false)).getHasPermOrgs()) && hasPermOrgs.size() != 0) {
                if (hasPermOrgs.contains(RequestContext.get().getOrgId())) {
                    this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                } else {
                    this.getModel().setValue("org", hasPermOrgs.get(0));
                }
            }
            this.getView().getFormShowParameter().setCustomParam("fromList", (Object)"false");
            this.getView().cacheFormShowParameter();
        } else if ("true".equals(this.getView().getPageCache().get("isFromImport")) || this.getView().getParentView() != null && ("homs_apphome".equals(this.getView().getParentView().getEntityId()) || this.getView().getParentView().getEntityId().startsWith("wf_"))) {
            HasPermOrgResult hrPermOrg;
            List hasPermOrgs;
            if (this.getView().getParentView() != null && "homs_apphome".equals(this.getView().getParentView().getEntityId()) && this.getView().getPageCache().get("isFromHomePage") == null && !Objects.isNull(hasPermOrgs = (hrPermOrg = OrgPermHelper.getHRPermOrg((boolean)false)).getHasPermOrgs()) && hasPermOrgs.size() != 0) {
                if (hasPermOrgs.contains(RequestContext.get().getOrgId())) {
                    this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                } else {
                    this.getModel().setValue("org", hasPermOrgs.get(0));
                }
                this.getView().getPageCache().put("isFromHomePage", "true");
            }
            this.getView().getPageCache().put("isFromImport", "false");
        } else {
            String parentView = this.getView().getParentView() != null ? this.getView().getParentView().getEntityId() : "null";
            LOG.info("method changePageCacheFromWhatVie parentView is [{}]", (Object)parentView);
        }
    }

    public void afterBindData(EventObject e) {
        long startTime = System.currentTimeMillis();
        AdminOrgBatchBillAfterBindDataService afterBindDataService = new AdminOrgBatchBillAfterBindDataService(this.getView());
        afterBindDataService.afterBindData(e);
        LOG.info(String.format(Locale.ROOT, "AdminorgBatchBillPlugin afterBindData() time cost is: %s", System.currentTimeMillis() - startTime));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String isCancelOverFlag = this.getView().getPageCache().get(IS_CANCEL_OVER);
        if (HRStringUtils.isNotEmpty((String)isCancelOverFlag) && "true".equals(isCancelOverFlag)) {
            this.getModel().setDataChanged(false);
            this.getView().getPageCache().put(IS_CANCEL_OVER, "false");
            return;
        }
        boolean hasEntryData = false;
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        for (BillEntryHelperEnum billEntryEnum : BillEntryHelperEnum.values()) {
            DynamicObjectCollection entryDynColl = dataEntity.getDynamicObjectCollection(billEntryEnum.getEntryName());
            boolean bl = hasEntryData = entryDynColl != null && entryDynColl.size() > 0;
            if (hasEntryData) break;
        }
        HRBaseServiceHelper orgBatchChgBillHelper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        long billId = this.getModel().getDataEntity().getLong("id");
        QFilter idFilter = new QFilter("id", "=", (Object)billId);
        boolean isExistFromDb = orgBatchChgBillHelper.isExists(idFilter);
        if (hasEntryData && !isExistFromDb) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close_bill", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AdminorgBatchBillPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AdminorgBatchBillPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AdminorgBatchBillPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private boolean executeSaveOperation(String operateKey) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignoreValidation", "true");
        operateOption.setVariableValue("operateKey", operateKey);
        operateOption.setVariableValue("isshowmessage", "false");
        OperationResult saveOperationResult = this.getView().invokeOperation("save_new", operateOption);
        if (!saveOperationResult.isSuccess()) {
            this.getView().showOperationResult(saveOperationResult);
            return false;
        }
        AdminOrgBatchChgHelper.saveAttachment((IFormView)this.getView());
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (this.getAllEntrySize() == 0) {
            OperateOption option = operate.getOption();
            option.setVariableValue("ishasright", "false");
        }
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.disableValidate(args, "allowDisableSaveWithPerson", true);
        } else if (HRStringUtils.equals((String)operateKey, (String)OPERATION_DONOTHING_SUBMIT)) {
            this.disableValidate(args, "allowDisableSubmitWithPerson", SystemParamHelper.getAllowPersonOnPosDisableParameter((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id")));
        } else if (HRStringUtils.equals((String)operateKey, (String)OPERATION_DONOTHING_SUBMITEFFECT)) {
            this.disableValidate(args, "allowDisableSubmitEffectWithPerson", SystemParamHelper.getAllowPersonOnPosDisableParameter((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id")));
        }
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)OPERATION_DONOTHING_SUBMIT) || HRStringUtils.equals((String)operateKey, (String)OPERATION_DONOTHING_SUBMITEFFECT)) {
            AdminOrgBatchChgHelper.setAdminorgBoIdToEntryEntity((IFormView)this.getView());
        }
    }

    private void disableValidate(BeforeDoOperationEventArgs args, String callbackId, boolean allowDisable) {
        Map<Long, DynamicObject> disableOrgMap;
        Map orgIdPersonMap;
        String allowDisableConfirm = this.getPageCache().get(callbackId);
        if (HRStringUtils.isNotEmpty((String)allowDisableConfirm) && Boolean.parseBoolean(allowDisableConfirm)) {
            this.getPageCache().remove(callbackId);
            return;
        }
        DynamicObjectCollection disableOrgEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_disable");
        if (!CollectionUtils.isEmpty((Collection)disableOrgEntry) && !(orgIdPersonMap = OrgBatchBillCheckHelper.invokePersonService((disableOrgMap = disableOrgEntry.stream().collect(Collectors.toMap(org -> org.getLong("disable_adminorg.boid"), org -> org))).keySet(), (boolean)false)).isEmpty()) {
            ArrayList list = new ArrayList();
            orgIdPersonMap.forEach((k, v) -> list.add(((DynamicObject)disableOrgMap.get(k)).getString("disable_adminorg.name")));
            String hasPersonOrg = String.join((CharSequence)",", list);
            if (allowDisable) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callbackId, (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u505c\u7528\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgBatchBillPlugin_48", (String)"odc-homs-formplugin", (Object[])new Object[0]), hasPersonOrg), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u505c\u7528\u7ec4\u7ec7\u201c%s\u201d\u5931\u8d25\uff1a\u5b58\u5728\u5728\u804c\u4eba\u5458\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminOrgDisableValidator_11", (String)"odc-homs-opplugin", (Object[])new Object[]{hasPersonOrg}));
            }
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        if ("viewflowchart".equals(opKey)) {
            return;
        }
        OperationResult afterOperationResult = eventArgs.getOperationResult();
        if (afterOperationResult != null && !afterOperationResult.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "deleteentry_add": 
            case "deleteentry_parent": 
            case "deleteentry_info": 
            case "deleteentry_disable": 
            case "deleteentry_merge": 
            case "deleteentry_split": {
                String opKeyPrefix = opKey.substring(12);
                if (this.validateHasChildOrg(opKeyPrefix)) break;
                this.openDelConfirm(opKeyPrefix);
                break;
            }
            case "edit_add": {
                this.openEditAddPage(OperationStatus.EDIT, this.getModel(), this.getView());
                break;
            }
            case "more_add": {
                this.openEditAddPage(OperationStatus.VIEW, this.getModel(), this.getView());
                break;
            }
            case "add": {
                AdminOrgBatchChgHelper.openViewForm((IFormView)this.getView(), (String)ADD, (String)this.getPluginName(), null);
                break;
            }
            case "parent": {
                QFilter rootFilter = new QFilter("boid", "!=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
                AdminOrgBatchChgHelper.openViewForm((IFormView)this.getView(), (String)PARENT, (String)this.getPluginName(), (QFilter)rootFilter);
                break;
            }
            case "parent_more": {
                AdminOrgBatchParentBillPlugin.entryEntityMore(this.getModel(), this.getView(), PARENT, OperationStatus.VIEW);
                break;
            }
            case "parent_edit": {
                AdminOrgBatchParentBillPlugin.entryEntityMore(this.getModel(), this.getView(), PARENT, OperationStatus.EDIT);
                break;
            }
            case "infochg": {
                AdminOrgBatchChgHelper.openViewForm((IFormView)this.getView(), (String)INFO_CHG, (String)this.getPluginName(), null);
                break;
            }
            case "more_info": {
                AdminOrgBatchParentBillPlugin.entryEntityMore(this.getModel(), this.getView(), "info", OperationStatus.VIEW);
                break;
            }
            case "edit_info": {
                AdminOrgBatchParentBillPlugin.entryEntityMore(this.getModel(), this.getView(), "info", OperationStatus.EDIT);
                break;
            }
            case "disable": {
                AdminOrgBatchChgHelper.openViewForm((IFormView)this.getView(), (String)DISABLE, (String)this.getPluginName(), null);
                break;
            }
            case "delete_rows": {
                this.deleteRowsConfirm();
                break;
            }
            case "save": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                this.getModel().setDataChanged(false);
                break;
            }
            case "unsubmit": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                break;
            }
            case "donothing_submiteffect": {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("effect_confirm", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u201c\u63d0\u4ea4\u5e76\u751f\u6548\u201d\u7684\u64cd\u4f5c\u540e\u8c03\u6574\u7684\u884c\u653f\u7ec4\u7ec7\u5c06\u76f4\u63a5\u751f\u6548\uff0c\u786e\u5b9a\u64cd\u4f5c\uff1f", (String)"AdminorgBatchBillPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case "donothing_submit": {
                if (!this.executeSaveOperation(opKey)) break;
                this.afterDoNothingSubmit();
                break;
            }
            case "submit": {
                this.afterSubmit();
                break;
            }
            case "org_merge": {
                this.mergeOperation();
                break;
            }
            case "edit_merge_detail": {
                this.moreMergeOrg();
                break;
            }
            case "more_merge": {
                this.moreMergeOrg();
                break;
            }
            case "more_split": {
                this.moreSplitOrg();
                break;
            }
            case "org_split": {
                this.splitOperation();
                break;
            }
            case "edit_split_detail": {
                this.moreSplitOrg();
                break;
            }
        }
    }

    private void mergeOperation() {
        AdminOrgBatchChartBaseHelper.openNewMergePage(new HashSet(), (IFormView)this.getView(), (IFormPlugin)this);
    }

    private void moreMergeOrg() {
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity_merge");
        int row = entryEntity.getEntryState().getFocusRow();
        DynamicObject mergeOrgEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_merge").get(row);
        AdminOrgBatchChartBaseHelper.openEditMergePage((DynamicObject)mergeOrgEntry, (IFormView)this.getView(), (IFormPlugin)this);
    }

    private void splitOperation() {
        AdminOrgBatchChartBaseHelper.openSplit(null, null, (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "org_split"));
    }

    private void moreSplitOrg() {
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl("entryentity_split");
        int row = entryEntity.getEntryState().getFocusRow();
        DynamicObject splitOrgEntry = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_split").get(row);
        AdminOrgBatchChartBaseHelper.openSplit((Long)splitOrgEntry.getLong("split_origin_id"), null, (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "edit_split_detail"));
    }

    private void afterDoNothingSubmit() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignoreValidation", "true");
        OperationResult operationResult = this.getView().invokeOperation("submit", operateOption);
        if (!operationResult.isSuccess()) {
            boolean needWfAssignPersons = operationResult.isNeedWfAssignPersons();
            List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
            String errorMsg = allErrorOrValidateInfo.isEmpty() ? operationResult.getMessage() : ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            if ((errorMsg == null || errorMsg.isEmpty()) && needWfAssignPersons) {
                return;
            }
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private void afterSubmit() {
        LOG.info("afterDoSubmit:" + this.getModel().getDataEntity().get("billno"));
        LOG.info("afterDoSubmit getEntityId refresh:" + this.getView().getFormShowParameter().getAppId());
        if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getAppId(), (String)"wftask")) {
            LOG.info("afterDoSubmit refresh:" + this.getModel().getDataEntity().get("billno"));
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().invokeOperation("close");
        } else {
            this.getView().updateView();
        }
    }

    private void deleteRowsConfirm() {
        long id = this.getModel().getDataEntity().getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_orgbatchchgbill");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyn = helper.queryOne("id, billstatus", new QFilter[]{idFilter});
        String billstatus = Objects.isNull(dyn) ? "A" : dyn.getString("billstatus");
        Boolean enableDeleteForUserPage = billstatus.equals("A") || billstatus.equals("G");
        Boolean enableDeleteForAuditPage = HRStringUtils.equals((String)this.getView().getFormShowParameter().getAppId(), (String)"wftask") && billstatus.equals("B");
        if (!enableDeleteForUserPage.booleanValue() && !enableDeleteForAuditPage.booleanValue()) {
            String auditStatusName = AdminOrgBatchChgHelper.getAuditstatusName((String)billstatus);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u7684\u5355\u636e\u4e0d\u80fd\u5220\u9664\u8c03\u6574\u660e\u7ec6\u3002", (String)"AdminorgBatchBillPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[]{auditStatusName}));
            return;
        }
        String currentTab = ((Tab)this.getView().getControl(TAB_AP_ENTRY)).getCurrentTab();
        int index = currentTab.indexOf(95);
        String prefix = currentTab.substring(index + 1);
        String entryName = BillEntryHelperEnum.getEntryNameByPrefix((String)prefix);
        EntryGrid coopRelEntryGrid = (EntryGrid)this.getView().getControl(entryName);
        if (null == coopRelEntryGrid) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u9700\u8981\u5220\u9664\u7684\u884c\u3002", (String)"AdminorgBatchBillPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] selectRows = coopRelEntryGrid.getSelectRows();
        int length = selectRows.length;
        if (selectRows.length > 0) {
            ConfirmCallBackListener deleteEntryCallBackListener = new ConfirmCallBackListener("del_rows", (IFormPlugin)this);
            if (("merge".equals(prefix) || "split".equals(prefix)) && this.showMessageForMergeAndSplit(prefix, selectRows, deleteEntryCallBackListener)) {
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff08\u9009\u4e2d\u6761\u6570\uff1a%s\uff09\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"AdminorgBatchBillPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[]{length}), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, deleteEntryCallBackListener);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u9700\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"AdminorgBatchBillPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean showMessageForMergeAndSplit(String prefix, int[] selectRows, ConfirmCallBackListener deleteEntryCallBackListener) {
        ArrayList selectDyn = Lists.newArrayListWithCapacity((int)16);
        for (int row : selectRows) {
            selectDyn.add(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_" + prefix).get(row));
        }
        HashMap orgId2Name = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject entryEntityDyn : selectDyn) {
            DynamicObjectCollection toMergeOrg = entryEntityDyn.getDynamicObjectCollection("merge".equals(prefix) ? "to_merge_org" : "split_target_org");
            DynamicObject mergeTargetOrg = entryEntityDyn.getDynamicObject("merge".equals(prefix) ? "merge_target_org" : "to_split_org");
            for (DynamicObject dy : toMergeOrg) {
                orgId2Name.put(dy.getLong("fbasedataid.id"), dy.getString("fbasedataid.name"));
            }
            if (mergeTargetOrg == null) continue;
            orgId2Name.put(mergeTargetOrg.getLong("id"), mergeTargetOrg.getString("name"));
        }
        HashMap orgIdToChangeType = Maps.newHashMapWithExpectedSize((int)16);
        List entryKeys = EntryEntityEnum.getEntryKeys();
        for (String entryKey : entryKeys) {
            if ("entryentity_merge".equals(entryKey) || "entryentity_split".equals(entryKey)) continue;
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
            for (DynamicObject dy : dynamicObjectCollection) {
                if (entryKey.equals(EntryEntityEnum.addEntry.getEntryKey())) {
                    orgIdToChangeType.put(dy.getLong("add_adminorg"), OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
                    continue;
                }
                orgIdToChangeType.put(dy.getLong(entryKey.substring(entryKey.indexOf("_") + 1) + "_adminorg.id"), BillEntryHelperEnum.getChangeTypeIdByPrefix((String)entryKey.substring(entryKey.indexOf("_") + 1)));
            }
        }
        StringBuilder showMsg = new StringBuilder();
        for (Map.Entry entry : orgId2Name.entrySet()) {
            if (!orgIdToChangeType.containsKey(entry.getKey())) continue;
            showMsg.append(String.format(ResManager.loadKDString((String)"[%1$s]\u5728\u672c\u5355\u4e2d\u8fd8\u505a\u4e86[%2$s]\uff0c", (String)"AdminorgBatchBillPlugin_42", (String)"odc-homs-formplugin", (Object[])new Object[0]), entry.getValue(), BillEntryHelperEnum.getEntryDescriptionByChangeType((Long)((Long)orgIdToChangeType.get(entry.getKey()))))).append("\n");
        }
        if (showMsg.length() != 0) {
            if ("merge".equals(prefix)) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s \u5220\u9664\u5408\u5e76\u6570\u636e\u540e\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u81ea\u52a8\u5220\u9664\u8be5\u6761\u53d8\u52a8\u6570\u636e\uff0c\u9700\u7528\u6237\u624b\u52a8\u5220\u9664\uff0c\u786e\u5b9a\u5220\u9664\u5408\u5e76\u6570\u636e\uff1f", (String)"AdminorgBatchBillPlugin_41", (String)"odc-homs-formplugin", (Object[])new Object[0]), showMsg.toString()), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, deleteEntryCallBackListener);
                return true;
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s \u5220\u9664\u62c6\u5206\u6570\u636e\u540e\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u81ea\u52a8\u5220\u9664\u8be5\u6761\u53d8\u52a8\u6570\u636e\uff0c\u9700\u7528\u6237\u624b\u52a8\u5220\u9664\uff0c\u786e\u5b9a\u5220\u9664\u62c6\u5206\u6570\u636e\uff1f", (String)"AdminorgBatchBillPlugin_39", (String)"odc-homs-formplugin", (Object[])new Object[0]), showMsg.toString()), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, deleteEntryCallBackListener);
            return true;
        }
        return false;
    }

    private boolean validateHasChildOrg(String opKeyPrefix) {
        if (opKeyPrefix.equals(ADD)) {
            EntryGrid strategyEntryGrid = (EntryGrid)this.getView().getControl("entryentity_add");
            int row = strategyEntryGrid.getEntryState().getFocusRow();
            DynamicObjectCollection addEntryDynCol = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity_add");
            DynamicObject focusEntityAddDyn = (DynamicObject)this.getModel().getDataEntity().getDynamicObjectCollection("entryentity_add").get(row);
            Long addAdminOrgId = focusEntityAddDyn.getLong("add_adminorg");
            ArrayList parentOrgIdList = Lists.newArrayListWithExpectedSize((int)addEntryDynCol.size());
            for (int i = 0; i < addEntryDynCol.size(); ++i) {
                if (row == i) continue;
                parentOrgIdList.add(((DynamicObject)addEntryDynCol.get(i)).getLong("add_parentorg.id"));
            }
            DynamicObjectCollection parentEntryDynCol = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity_parent");
            parentEntryDynCol.stream().filter(dyn -> Objects.nonNull(dyn.getDynamicObject("parent_parentorg"))).forEach(dyn -> parentOrgIdList.add(dyn.getLong("parent_parentorg.id")));
            if (parentOrgIdList.contains(addAdminOrgId)) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadResFormat((String)"%s\u5728\u672c\u5355\u6709\u4e0b\u5c42\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AdminorgBatchBillPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), focusEntityAddDyn.getString("add_name")));
                return true;
            }
        }
        return false;
    }

    private void openDelConfirm(String opKeyPrefix) {
        EntryGrid strategyEntryGrid;
        int[] selectRows;
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("del_row_" + opKeyPrefix, (IFormPlugin)this);
        if (("merge".equals(opKeyPrefix) || "split".equals(opKeyPrefix)) && this.showMessageForMergeAndSplit(opKeyPrefix, selectRows = new int[]{(strategyEntryGrid = (EntryGrid)this.getView().getControl("entryentity_" + opKeyPrefix)).getEntryState().getFocusRow()}, confirmCallBackListener)) {
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff08\u9009\u4e2d\u6761\u6570\uff1a%s\uff09\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"AdminorgBatchBillPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{"1"}), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
    }

    private void openEditAddPage(OperationStatus status, IDataModel iDataModel, IFormView iFormView) {
        EntryGrid strategyEntryGrid = (EntryGrid)this.getView().getControl("entryentity_add");
        int row = strategyEntryGrid.getEntryState().getFocusRow();
        DynamicObject addDy = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_add").get(row);
        Long addDyId = addDy.getLong("id");
        DynamicObject dynamicObject = (DynamicObject)iDataModel.getDataEntity(true).getDynamicObjectCollection("entryentity_add").get(row);
        Map map = HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject);
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_batchorgentityadd");
        formShowParameter.setPkId((Object)addDyId);
        formShowParameter.setStatus(status);
        if (!status.equals((Object)OperationStatus.VIEW)) {
            formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), ADD_ORG));
        }
        formShowParameter.setCustomParam("selectObject", (Object)SerializationUtils.toJsonString((Object)map));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        AdminOrgBatchBillConfirmCallBackService confirmCallBackService = new AdminOrgBatchBillConfirmCallBackService(this.getView());
        confirmCallBackService.confirmCallBack(event);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        AdminOrgBatchBillClosedCallBackService closedCallBackService = new AdminOrgBatchBillClosedCallBackService(this.getView());
        closedCallBackService.setPluginName(this.getPluginName());
        closedCallBackService.closedCallBack(closedCallBackEvent);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity_parent");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        List<String> beforeF7ListenerControlList = this.getRegisterBeforeF7ListenerControlList();
        for (String registerBeforeF7Listener : beforeF7ListenerControlList) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(registerBeforeF7Listener);
            if (basedataEdit == null) continue;
            basedataEdit.setF7BatchFill(false);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private List<String> getRegisterBeforeF7ListenerControlList() {
        return Arrays.asList("to_merge_org", "merge_target_org", "to_split_org", "split_target_org", "parent_adminorg", "parent_parentorg", "parent_adminorgtype", "parent_changescene", "parent_changereason", "parent_city", "info_adminorg", "info_adminorgtype", "info_changescene", "info_changereason", "info_city", "disable_adminorg", "disable_changescene", "disable_changereason", "parent_corporateorg", "info_corporateorg", "disorg", "parent_adminorglayer", "parent_adminorgfunction", "info_adminorglayer", "info_adminorgfunction", "merge_changescene", "merge_changereason", "split_changescene", "split_changereason");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        this.setFuzzySearchAuthFilter(beforeF7SelectEvent);
        this.replaceFormIdByFieldKey(beforeF7SelectEvent);
        if ("disorg".equals(fieldKey)) {
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u7b7e\u53d1\u7ec4\u7ec7", (String)"AdminorgBatchBillPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(((DynamicObject)this.getView().getModel().getValue("org")).getLong("id"))));
            return;
        }
        int rowIndex = beforeF7SelectEvent.getRow();
        String prefix = this.getPrefixByFieldKey(fieldKey);
        String entryName = BillEntryHelperEnum.getEntryNameByPrefix((String)prefix);
        DynamicObjectCollection entryDynColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        Date date = DateUtils.truncate((Date)new Date(), (int)5);
        switch (fieldKey) {
            case "parent_adminorg": {
                QFilter rootFilter = new QFilter("boid", "!=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
                showParameter.setFormId("haos_orgbatchtreelistf7");
                showParameter.getCustomParams().put("searchdate", date);
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent, (QFilter)rootFilter);
                this.setFilterByOrg(beforeF7SelectEvent);
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("isvirtualorg", "!=", (Object)Character.valueOf('1')));
                break;
            }
            case "info_adminorg": 
            case "disable_adminorg": {
                this.setFilterByOrg(beforeF7SelectEvent);
                showParameter.setFormId("haos_orgbatchtreelistf7");
                showParameter.getCustomParams().put("searchdate", date);
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent, null);
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("isvirtualorg", "!=", (Object)Character.valueOf('1')));
                this.excludeOrgIfNeed(beforeF7SelectEvent);
                if (!HRStringUtils.equals((String)fieldKey, (String)"disable_adminorg")) break;
                AdminOrgBatchChgHelper.excludeMergeSplitTargetOrg((IFormView)this.getView(), (List)beforeF7SelectEvent.getCustomQFilters());
                break;
            }
            case "parent_parentorg": {
                DynamicObject adminOrg = focusEntryDyn.getDynamicObject(prefix + "_" + "adminorg");
                AdminOrgBatchChgHelper.setParentFilter((IFormView)this.getView(), (DynamicObject)adminOrg, (BeforeF7SelectEvent)beforeF7SelectEvent);
                DynamicObject adminOrgType = focusEntryDyn.getDynamicObject(prefix + "_adminorgType");
                AdminOrgBatchChgHelper.setOrgTypeFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (DynamicObject)adminOrgType);
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgBatchBillPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "to_merge_org": 
            case "merge_target_org": 
            case "split_target_org": 
            case "to_split_org": {
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                DynamicObject dataEntityParent = this.getView().getModel().getDataEntity(true);
                DynamicObjectCollection addCollection = dataEntityParent.getDynamicObjectCollection("entryentity_add");
                Set adminOrgSet = addCollection.stream().map(s -> s.getString("add_adminorg")).collect(Collectors.toSet());
                Set addOrgIdSet = adminOrgSet.stream().map(Long::valueOf).collect(Collectors.toSet());
                QFilter currentOrderFilter = new QFilter("id", "in", addOrgIdSet);
                AdminOrgBatchChgHelper.setMergeAndSplitOrgFilter((IFormView)this.getView(), (BeforeF7SelectEvent)beforeF7SelectEvent, (QFilter)currentOrderFilter);
                this.setFilterByOrg(beforeF7SelectEvent);
                if ("merge_target_org".equals(beforeF7SelectEvent.getProperty().getName()) || "split_target_org".equals(beforeF7SelectEvent.getProperty().getName())) {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("iscurrentversion", "=", (Object)"0").or(currentOrderFilter));
                } else {
                    beforeF7SelectEvent.getFormShowParameter().getCustomParams().put("searchdate", date);
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("iscurrentversion", "=", (Object)"0").or(currentOrderFilter));
                }
                this.excludeOrgIfNeed(beforeF7SelectEvent);
                break;
            }
            case "parent_changescene": 
            case "info_changescene": 
            case "disable_changescene": 
            case "merge_changescene": 
            case "split_changescene": {
                QFilter changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)focusEntryDyn.getLong(prefix + "_changetype.id")).and("id", "!=", (Object)OrgBatchChgBillConstants.CHANGE_SCENE_ENABLE);
                beforeF7SelectEvent.getCustomQFilters().add(changeTyeFilter);
                break;
            }
            case "info_adminorgtype": {
                long orgid;
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                long l = orgid = focusEntryDyn.getDynamicObject("info_adminorg") != null ? focusEntryDyn.getLong("info_adminorg.boid") : 0L;
                if (rootOrgId != orgid) break;
                QFilter qFilter = new QFilter("adminorgtypestd", "in", (Object)new Long[]{1010L, 1020L});
                beforeF7SelectEvent.getCustomQFilters().add(qFilter);
                break;
            }
            case "parent_changereason": 
            case "info_changereason": 
            case "disable_changereason": 
            case "merge_changereason": 
            case "split_changereason": {
                AdminOrgBatchChgHelper.setChangeReasonF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel(), (String)prefix, (Boolean)Boolean.TRUE);
                break;
            }
            case "parent_city": 
            case "info_city": {
                DynamicObject companyArea = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName).get(rowIndex)).getDynamicObject(prefix + "_companyarea");
                if (companyArea != null && companyArea.getLong("id") != 0L) {
                    QFilter qFilter = new QFilter("country", "=", (Object)companyArea.getLong("id"));
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(qFilter);
                    beforeF7SelectEvent.setCustomQFilters(qFilters);
                }
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02", (String)"AdminorgBatchBillPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "info_corporateorg": 
            case "parent_corporateorg": {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("oprsts", "=", (Object)"1"));
                break;
            }
        }
    }

    public static boolean shouldExclude(BeforeF7SelectEvent event) {
        return AdminOrgBatchChgHelper.mergeAndSplitFields.contains(event.getProperty().getName());
    }

    private final void excludeOrgIfNeed(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (!AdminorgBatchBillPlugin.shouldExclude(beforeF7SelectEvent)) {
            return;
        }
        String name = beforeF7SelectEvent.getProperty().getName();
        ArrayList ids = Lists.newArrayListWithCapacity((int)16);
        for (String entryName : AdminOrgBatchChgHelper.entryEntityName) {
            if (!entryName.equals(AdminOrgBatchChgHelper.mergeAndSplitFieldsExcludeMap.get(name))) continue;
            DynamicObjectCollection entryEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
            for (DynamicObject dyn : entryEntities) {
                ids.add(dyn.getLong("entryentity_merge".equals(entryName) ? "merge_target_org.id" : "to_split_org.id"));
                ids.addAll(dyn.getDynamicObjectCollection("entryentity_merge".equals(entryName) ? "to_merge_org" : "split_target_org").stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList()));
            }
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter orgIdFilter = new QFilter("id", "not in", (Object)ids);
        beforeF7SelectEvent.getCustomQFilters().add(orgIdFilter);
    }

    private void setFilterByOrg(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter baseDataFilter = BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(((DynamicObject)this.getModel().getValue("org")).getLong("id")));
        beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
    }

    private void setFuzzySearchAuthFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("getLookUpList".equals(beforeF7SelectEvent.getSourceMethod()) || "setItemByNumber".equals(beforeF7SelectEvent.getSourceMethod())) {
            AuthorizedOrgResult authorizedOrgResult = AdminOrgBatchChgHelper.getOrgAuth((IFormView)this.getView());
            if (authorizedOrgResult.isHasAllOrgPerm()) {
                return;
            }
            String fieldName = beforeF7SelectEvent.getProperty().getName();
            if ("parent_adminorg".equals(fieldName) || "info_adminorg".equals(fieldName) || "disable_adminorg".equals(fieldName) || "disorg".equals(fieldName)) {
                List hasPermOrgList = authorizedOrgResult.getHasPermOrgs();
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("boid", "in", (Object)hasPermOrgList));
            }
        }
    }

    private void replaceFormIdByFieldKey(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("parent_adminorg".equals(fieldKey) || "info_adminorg".equals(fieldKey) || "disable_adminorg".equals(fieldKey) || "disorg".equals(fieldKey) || "to_split_org".equals(fieldKey) || "to_merge_org".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setFormId("haos_orgbatchtreelistf7");
        }
    }

    private String getPrefixByFieldKey(String fieldKey) {
        if ("to_merge_org".equals(fieldKey)) {
            return "merge";
        }
        if ("to_split_org".equals(fieldKey)) {
            return "split";
        }
        int charIndex = fieldKey.indexOf("_");
        String prefix = "";
        if (charIndex != -1) {
            prefix = fieldKey.substring(0, charIndex);
        }
        return prefix;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        AdminOrgBatchBillPropertyChangedService propertyChangedService = new AdminOrgBatchBillPropertyChangedService(this.getView());
        propertyChangedService.setCloseCallBackPlugin((IFormPlugin)this);
        propertyChangedService.propertyChanged(e);
    }

    public void customEvent(CustomEventArgs evt) {
        AdminOrgBatchBillCustomEventService customEventService = new AdminOrgBatchBillCustomEventService(this.getView());
        customEventService.setCloseCallBackPlugin((IFormPlugin)this);
        customEventService.setPluginName(this.getPluginName());
        customEventService.customEvent(evt);
    }

    private void setTips() {
        Tips tips = new Tips();
        List tipsStr = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "effdt", this.getModel().getDataEntity()});
        if (!CollectionUtils.isEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl("effdt");
            control.addTips(tips);
        }
        Tips operationTips = new Tips();
        List operationTipsStr = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "labelap3", this.getModel().getDataEntity()});
        if (!CollectionUtils.isEmpty((Collection)operationTipsStr)) {
            operationTips.setContent(new LocaleString((String)operationTipsStr.get(0)));
            operationTips.setType("text");
            operationTips.setTriggerType("hover");
            operationTips.setIsConfirm(false);
            operationTips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl("chg_info");
            control.addTips(operationTips);
        }
        Tips belongcompanyTips = new Tips();
        List belongcompanyTipsStr = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "belongcompany", this.getModel().getDataEntity()});
        if (!CollectionUtils.isEmpty((Collection)belongcompanyTipsStr)) {
            belongcompanyTips.setContent(new LocaleString((String)belongcompanyTipsStr.get(0)));
            belongcompanyTips.setType("text");
            belongcompanyTips.setTriggerType("hover");
            belongcompanyTips.setIsConfirm(false);
            belongcompanyTips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl("belongcompany_name");
            control.addTips(operationTips);
        }
    }

    private int getAllEntrySize() {
        DynamicObjectCollection addDyS = this.getModel().getEntryEntity("entryentity_add");
        DynamicObjectCollection parentDyS = this.getModel().getEntryEntity("entryentity_parent");
        DynamicObjectCollection infoDyS = this.getModel().getEntryEntity("entryentity_info");
        DynamicObjectCollection disDyS = this.getModel().getEntryEntity("entryentity_disable");
        return addDyS.size() + parentDyS.size() + infoDyS.size() + disDyS.size();
    }
}

