/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchBillChartListHelper;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;

public class AdminorgBatchChartDisableListPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        JSONArray orgJson = (JSONArray)this.getView().getFormShowParameter().getCustomParam("selectOrg");
        if (orgJson != null) {
            List orgList = JSON.parseArray((String)orgJson.toJSONString(), ChgOrgInfoDto.class);
            this.setOrgEntryEntity(orgList);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit changeSceneForParent = (BasedataEdit)this.getView().getControl("changescene");
        changeSceneForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrgForParent = (BasedataEdit)this.getView().getControl("adminorg");
        adminOrgForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changeReasonForParent = (BasedataEdit)this.getView().getControl("changereason");
        changeReasonForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        int rowIndex = beforeF7SelectEvent.getRow();
        DynamicObjectCollection entryDynColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
        switch (fieldKey) {
            case "changescene": {
                QFilter changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)focusEntryDyn.getLong("changetype.id"));
                beforeF7SelectEvent.getCustomQFilters().add(changeTyeFilter);
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getBaseDataFilter((String)"haos_changescene", Collections.singletonList(focusEntryDyn.getLong("org.id"))));
                break;
            }
            case "adminorg": {
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getParentView(), (BeforeF7SelectEvent)beforeF7SelectEvent, null);
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                break;
            }
            case "changereason": {
                OrgBatchBillChartListHelper.setChangeReasonF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (int)rowIndex, (IFormView)this.getView());
            }
        }
    }

    private IFormView getParentView() {
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("openType");
        if (HRStringUtils.equals((String)"1", (String)openType)) {
            return this.getView().getParentView().getParentView();
        }
        return this.getView().getParentView();
    }

    private void setOrgEntryEntity(List<ChgOrgInfoDto> orgList) {
        ArrayList orgIds = new ArrayList();
        orgList.forEach(orgInfo -> orgIds.add(orgInfo.getOrgId()));
        DynamicObject[] dynamicObjects = AdminOrgBatchChgHelper.getOrgDyCollectionByIds(orgIds);
        Long billid = (Long)this.getView().getFormShowParameter().getCustomParam("billid");
        DynamicObject[] disableChangesceneDys = this.getChangesceneByChgType(OrgBatchChgBillConstants.CHANGE_SCENE_DISABLE);
        if (dynamicObjects.length > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("adminorg", new Object[0]);
            vs.addField("parentorg", new Object[0]);
            vs.addField("adminorgtype", new Object[0]);
            vs.addField("tobedisableflag", new Object[0]);
            vs.addField("changescene", new Object[0]);
            vs.addField("changereason", new Object[0]);
            vs.addField("changedescription", new Object[0]);
            vs.addField("index", new Object[0]);
            vs.addField("billid", new Object[0]);
            vs.addField("org", new Object[0]);
            Map entrtyMap = AdminOrgBatchChgHelper.getEntryInfoMap((IFormView)this.getView());
            int length = dynamicObjects.length;
            if (!CollectionUtils.isEmpty((Map)entrtyMap)) {
                Set boIdSet = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
                boIdSet.removeAll(entrtyMap.keySet());
                length = boIdSet.size();
            }
            length = dynamicObjects.length;
            long[] ids = new long[length];
            if (length > 0) {
                ids = ORM.create().genLongIds("homs_batchorgentity", length);
            }
            for (DynamicObject dy2 : dynamicObjects) {
                boolean isInEntry = entrtyMap.containsKey(dy2.getLong("boid"));
                DynamicObject disableEntity = (DynamicObject)entrtyMap.get(dy2.getLong("boid"));
                boolean isInDisable = true;
                if (disableEntity != null && !"entryentity_disable".equals(disableEntity.getDataEntityType().getName())) {
                    isInDisable = false;
                }
                vs.addRow(new Object[]{isInEntry && isInDisable && disableEntity != null ? disableEntity.getLong("id") : ids[--length], dy2.getLong("id"), dy2.getDynamicObject("parentorg") != null ? Long.valueOf(dy2.getLong("parentorg.id")) : null, dy2.getDynamicObject("adminorgtype") != null ? Long.valueOf(dy2.getLong("adminorgtype.id")) : null, dy2.getString("tobedisableflag"), isInEntry && isInDisable && disableEntity != null ? HRDyObjectPropUtil.getIdLongObject((DynamicObject)disableEntity.getDynamicObject("disable_changescene")) : (disableChangesceneDys.length == 1 ? Long.valueOf(disableChangesceneDys[0].getLong("id")) : null), isInEntry && isInDisable && disableEntity != null ? HRDyObjectPropUtil.getIdLongObject((DynamicObject)disableEntity.getDynamicObject("disable_changereason")) : null, isInEntry && isInDisable && disableEntity != null ? disableEntity.getString("disable_changedescription") : null, dy2.getInt("index"), billid, isInEntry && isInDisable && disableEntity != null ? HRDyObjectPropUtil.getIdLongObject((DynamicObject)disableEntity.getDynamicObject("disable_org")) : HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy2.getDynamicObject("org"))});
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            OrgBatchBillChartListHelper.setFieldEnable((IFormView)this.getView());
        }
    }

    public DynamicObject[] getChangesceneByChgType(Long chgTypeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_changescene");
        QFilter qFilter = new QFilter("orgchangetype", "=", (Object)chgTypeId);
        return hrBaseServiceHelper.query(qFilter.toArray());
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        int rowIndex = changedArgs.getChangeSet()[0].getRowIndex();
        Object objectNew = changedArgs.getChangeSet()[0].getNewValue();
        switch (fieldKey) {
            case "adminorg": {
                DynamicObject dynamicObject;
                Long orgId;
                String orgIdStr;
                String oldOrgId = this.getPageCache().get("orgId");
                if (changedArgs.getChangeSet()[0].getNewValue() == null || HRStringUtils.equals((String)(orgIdStr = String.valueOf(orgId = Long.valueOf((dynamicObject = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue()).getLong("id")))), (String)oldOrgId)) break;
                DynamicObject orgDy = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
                Long orgOld = orgDy == null ? 0L : orgDy.getLong("id");
                this.getPageCache().put("orgId", String.valueOf(orgOld));
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_org", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u5f53\u524d\u5df2\u4fee\u6539\u7684\u5185\u5bb9\u5c06\u4f1a\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_39", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
            case "changescene": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"changereason"});
                this.getModel().setValue("changereason", null, rowIndex);
                if (!Objects.isNull(objectNew)) break;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"changereason"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        switch (key = eventArgs.getOperateKey()) {
            case "delete_one": {
                this.openDelConfirm(key, 1);
                break;
            }
            case "delete_all": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                this.openDelConfirm(key, entryGrid.getSelectRows().length);
                break;
            }
            case "save": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"delete_one")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int row = entryGrid.getEntryState().getFocusRow();
                this.getModel().deleteEntryRow("entryentity", row);
            }
        } else if (HRStringUtils.equals((String)callBackId, (String)"delete_all")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int[] rows = entryGrid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRows("entryentity", rows);
            }
        } else if (HRStringUtils.equals((String)callBackId, (String)"select_org")) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.updateEntryEntity();
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int row = entryGrid.getEntryState().getFocusRow();
                String orgId = this.getPageCache().get("orgId");
                this.getModel().setValue("adminorg", (Object)Long.valueOf(orgId), row);
            }
        }
    }

    private void updateEntryEntity() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int row = entryGrid.getEntryState().getFocusRow();
        DynamicObject adminorgDy = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row)).getDynamicObject("adminorg");
        Long orgId = adminorgDy.getLong("id");
        DynamicObject dy = AdminOrgBatchChgHelper.getOrgDyById((Long)orgId);
        this.getModel().setValue("parentorg", dy.getDynamicObject("parentorg") != null ? Long.valueOf(dy.getLong("parentorg.id")) : null, row);
        this.getModel().setValue("adminorgtype", dy.getDynamicObject("adminorgtype") != null ? Long.valueOf(dy.getLong("adminorgtype.id")) : null, row);
        this.getModel().setValue("tobedisableflag", (Object)dy.getString("tobedisableflag"), row);
        this.getModel().setValue("billid", this.getView().getFormShowParameter().getCustomParam("billid"));
    }

    private void openDelConfirm(String deleteKey, int number) {
        if (number > 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(deleteKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff08\u9009\u4e2d\u6761\u6570\uff1a%s\uff09\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"AdminorgBatchChgPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{number}), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdminorgBatchChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        Object cacheModel = this.getView().getFormShowParameter().getCustomParams().get("cacheModel");
        String openType = (String)this.getView().getFormShowParameter().getCustomParam("openType");
        formOperate.getOption().setVariableValue("openType", openType);
        formOperate.getOption().setVariableValue("cacheModel", SerializationUtils.toJsonString(cacheModel));
        formOperate.getOption().setVariableValue("entryKey", EntryEntityEnum.disableEntry.getEntryKey());
    }
}

