/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgBatchChgHelper;
import kd.hr.homs.business.service.orgbatch.OrgBatchBillChartListHelper;
import kd.hr.homs.business.service.utils.OrgChgUtil;
import kd.hr.homs.business.service.utils.PatternUtil;
import kd.hr.homs.common.constants.batchchg.OrgBatchChgBillConstants;
import kd.hr.homs.common.model.ChgOrgInfoDto;

public class AdminorgBatchChartParentListPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(AdminorgBatchChartParentListPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        JSONArray orgJson = (JSONArray)this.getView().getFormShowParameter().getCustomParam("selectOrg");
        if (orgJson != null) {
            List orgList = JSON.parseArray((String)orgJson.toJSONString(), ChgOrgInfoDto.class);
            this.setOrgEntryEntity(orgList);
        }
        this.getModel().setValue("bsed", this.getView().getParentView().getModel().getDataEntity().get("effdt"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setDataChanged(false);
    }

    private void setOrgEntryEntity(List<ChgOrgInfoDto> orgList) {
        ArrayList orgIds = new ArrayList();
        HashSet parentIds = new HashSet(orgList.size());
        orgList.forEach(orgInfo -> {
            orgIds.add(orgInfo.getOrgId());
            parentIds.add(orgInfo.getParentId());
        });
        Date modifyTime = OrgChgUtil.getView((IFormView)this.getView()).getModel().getDataEntity().getDate("modifytime");
        Map orgLongNameMap = OrgBatchBillHelper.getOrgLongNameByFid(parentIds, (Date)modifyTime, null);
        Map<Long, Long> orgMap = orgList.stream().collect(Collectors.toMap(ChgOrgInfoDto2 -> ChgOrgInfoDto2.getOrgId(), ChgOrgInfoDto2 -> ChgOrgInfoDto2.getParentId() == null ? Long.valueOf(0L) : ChgOrgInfoDto2.getParentId()));
        DynamicObject[] dynamicObjects = AdminOrgBatchChgHelper.getOrgDyCollectionByIds(orgIds);
        if (dynamicObjects.length > 0) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("id", new Object[0]);
            vs.addField("adminorg", new Object[0]);
            vs.addField("number", new Object[0]);
            vs.addField("name", new Object[0]);
            vs.addField("old_parentorg", new Object[0]);
            vs.addField("oriparentorg_name", new Object[0]);
            vs.addField("parentorg", new Object[0]);
            vs.addField("parentorg_name", new Object[0]);
            vs.addField("simplename", new Object[0]);
            vs.addField("adminorgtype", new Object[0]);
            vs.addField("establishmentdate", new Object[0]);
            vs.addField("corporateorg", new Object[0]);
            vs.addField("changescene", new Object[0]);
            vs.addField("tobedisableflag", new Object[0]);
            vs.addField("adminorglayer", new Object[0]);
            vs.addField("adminorgfunction", new Object[0]);
            vs.addField("companyarea", new Object[0]);
            vs.addField("city", new Object[0]);
            vs.addField("workplace", new Object[0]);
            vs.addField("changetype", new Object[0]);
            vs.addField("index", new Object[0]);
            vs.addField("billid", new Object[0]);
            vs.addField("org", new Object[0]);
            vs.addField("safelevel", new Object[0]);
            vs.addField("safetype", new Object[0]);
            DataEntityPropertyCollection properties = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (!PatternUtil.isExProperty((String)property.getName())) continue;
                vs.addField(property.getName(), new Object[0]);
            }
            DynamicObject[] addChangesceneDys = this.getChangesceneByChgType(OrgBatchChgBillConstants.CHANGE_TYPE_ADD);
            DynamicObject[] parentChangesceneDys = this.getChangesceneByChgType(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT);
            Long billid = (Long)this.getView().getFormShowParameter().getCustomParam("billid");
            Map<Long, DynamicObject> addMap = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_add").stream().collect(Collectors.toMap(dyn -> dyn.getLong("add_adminorg"), dyn -> dyn));
            Map<Long, DynamicObject> parentMap = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_parent").stream().collect(Collectors.toMap(dyn -> dyn.getLong("parent_adminorg.id"), dyn -> dyn));
            Map<Long, DynamicObject> infoMap = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_info").stream().collect(Collectors.toMap(dyn -> dyn.getLong("info_adminorg.id"), dyn -> dyn));
            for (DynamicObject dy : dynamicObjects) {
                Long orgId = dy.getLong("id");
                if (addMap.containsKey(orgId)) {
                    this.setAddEntryToEntry(vs, dy, billid, orgMap, addChangesceneDys, addMap, orgLongNameMap);
                    continue;
                }
                if (parentMap.containsKey(orgId)) {
                    this.setParentEntryToEntry(vs, dy, billid, orgMap, parentChangesceneDys, parentMap, orgLongNameMap);
                    continue;
                }
                if (infoMap.containsKey(orgId)) {
                    this.setInfoEntryToEntry(vs, dy, billid, orgMap, parentChangesceneDys, infoMap, orgLongNameMap);
                    continue;
                }
                this.setMasterEntryToEntry(vs, dy, billid, orgMap, parentChangesceneDys, orgLongNameMap);
            }
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
            OrgBatchBillChartListHelper.setFieldEnable((IFormView)this.getView());
        }
    }

    private void setAddEntryToEntry(TableValueSetter vs, DynamicObject dy, Long billid, Map<Long, Long> orgMap, DynamicObject[] changesceneDys, Map<Long, DynamicObject> entrtyMap, Map<Long, String> orgLongNameMap) {
        DynamicObject addDy = entrtyMap.get(dy.getLong("id"));
        Long oldParentSourcevId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.sourcevid") : 0L;
        Long oldParentId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.id") : 0L;
        Long orgId = dy.getLong("id");
        vs.addRow(new Object[]{addDy.getLong("id"), addDy.getLong("add_adminorg"), addDy.getString("add_number"), addDy.getString("add_name"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_parentorg")), HRDyObjectPropUtil.getName((DynamicObject)addDy.getDynamicObject("add_parentorg")), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? null : orgMap.get(orgId), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? "" : orgLongNameMap.get(orgMap.get(orgId)), addDy.getString("add_simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_adminorgtype")), addDy.getDate("add_establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_corporateorg")), changesceneDys.length == 1 ? Long.valueOf(changesceneDys[0].getLong("id")) : null, dy.getString("tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_workplace")), OrgBatchChgBillConstants.CHANGE_TYPE_ADD, dy.getInt("index"), billid, HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)addDy.getDynamicObject("add_safetype"))});
    }

    private void setParentEntryToEntry(TableValueSetter vs, DynamicObject dy, Long billid, Map<Long, Long> orgMap, DynamicObject[] parentChangesceneDys, Map<Long, DynamicObject> entrtyMap, Map<Long, String> orgLongNameMap) {
        DynamicObject parentDy = entrtyMap.get(dy.getLong("id"));
        Long oldParentSourcevId = parentDy.getDynamicObject("parent_parentorg") != null ? parentDy.getLong("parent_parentorg.sourcevid") : 0L;
        Long oldParentId = parentDy.getDynamicObject("parent_parentorg") != null ? parentDy.getLong("parent_parentorg.id") : 0L;
        Long orgId = dy.getLong("id");
        List fields = vs.getFields();
        ArrayList<Serializable> values = new ArrayList<Serializable>(Arrays.asList(parentDy.getLong("id"), parentDy.getLong("parent_adminorg.id"), parentDy.getString("parent_number"), parentDy.getString("parent_name"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_parentorg")), parentDy.getString("parent_oriparentorg_name"), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? null : (Serializable)orgMap.get(orgId), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? "" : (Serializable)((Object)orgLongNameMap.get(orgMap.get(orgId))), parentDy.getString("parent_simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_adminorgtype")), parentDy.getDate("parent_establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_corporateorg")), parentChangesceneDys.length == 1 ? Long.valueOf(parentChangesceneDys[0].getLong("id")) : null, parentDy.getString("parent_tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_workplace")), OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, dy.getInt("index"), billid, HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_safetype"))));
        for (String property : fields) {
            if (!PatternUtil.isExProperty((String)property)) continue;
            Object obj = parentDy.get("parent_" + property);
            if (obj instanceof DynamicObject) {
                values.add(HRDyObjectPropUtil.getIdLongObject((DynamicObject)parentDy.getDynamicObject("parent_" + property)));
                continue;
            }
            values.add((Serializable)obj);
        }
        vs.addRow(values.toArray());
    }

    private void setInfoEntryToEntry(TableValueSetter vs, DynamicObject dy, Long billid, Map<Long, Long> orgMap, DynamicObject[] parentChangesceneDys, Map<Long, DynamicObject> entrtyMap, Map<Long, String> orgLongNameMap) {
        DynamicObject infoDy = entrtyMap.get(dy.getLong("id"));
        Long oldParentSourcevId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.sourcevid") : 0L;
        Long oldParentId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.id") : 0L;
        Long orgId = dy.getLong("id");
        vs.addRow(new Object[]{infoDy.getLong("id"), infoDy.getLong("info_adminorg.id"), infoDy.getString("info_number"), infoDy.getString("info_name"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_parentorg")), infoDy.getString("info_oriparentorg_name"), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? null : orgMap.get(orgId), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? "" : orgLongNameMap.get(orgMap.get(orgId)), infoDy.getString("info_simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_adminorgtype")), infoDy.getDate("info_establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_corporateorg")), parentChangesceneDys.length == 1 ? Long.valueOf(parentChangesceneDys[0].getLong("id")) : null, infoDy.getString("info_tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_workplace")), OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, dy.getInt("index"), billid, HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)infoDy.getDynamicObject("info_safetype"))});
    }

    private void setMasterEntryToEntry(TableValueSetter vs, DynamicObject dy, Long billid, Map<Long, Long> orgMap, DynamicObject[] parentChangesceneDys, Map<Long, String> orgLongNameMap) {
        Long oldParentSourcevId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.sourcevid") : 0L;
        Long oldParentId = dy.getDynamicObject("parentorg") != null ? dy.getLong("parentorg.id") : 0L;
        Long orgId = dy.getLong("id");
        vs.addRow(new Object[]{ORM.create().genLongId("homs_batchorgentity"), dy.getLong("id"), dy.getString("number"), dy.getString("name"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("parentorg")), HRDyObjectPropUtil.getName((DynamicObject)dy.getDynamicObject("parentorg")), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? null : orgMap.get(orgId), oldParentId.equals(orgMap.get(orgId)) || oldParentSourcevId.equals(orgMap.get(orgId)) ? "" : orgLongNameMap.get(orgMap.get(orgId)), dy.getString("simplename"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("adminorgtype")), dy.getDate("establishmentdate"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("corporateorg")), parentChangesceneDys.length == 1 ? Long.valueOf(parentChangesceneDys[0].getLong("id")) : null, dy.getString("tobedisableflag"), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("adminorglayer")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("adminorgfunction")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("companyarea")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("city")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("workplace")), OrgBatchChgBillConstants.CHANGE_TYPE_PARENT, dy.getInt("index"), billid, HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("org")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("safelevel")), HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("safetype"))});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit adminOrgForParent = (BasedataEdit)this.getView().getControl("adminorg");
        adminOrgForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changeSceneForParent = (BasedataEdit)this.getView().getControl("changescene");
        changeSceneForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentBased = (BasedataEdit)this.getView().getControl("parentorg");
        parentBased.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminOrgTypeForParent = (BasedataEdit)this.getView().getControl("adminorgtype");
        adminOrgTypeForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changeReasonForParent = (BasedataEdit)this.getView().getControl("changereason");
        changeReasonForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cityForParent = (BasedataEdit)this.getView().getControl("city");
        cityForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentCorporateOrg = (BasedataEdit)this.getView().getControl("corporateorg");
        parentCorporateOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminorglayerForParent = (BasedataEdit)this.getView().getControl("adminorglayer");
        adminorglayerForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit adminorgfunctionForParent = (BasedataEdit)this.getView().getControl("adminorgfunction");
        adminorgfunctionForParent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey = changedArgs.getProperty().getName();
        int rowIndex = changedArgs.getChangeSet()[0].getRowIndex();
        Object objectNew = changedArgs.getChangeSet()[0].getNewValue();
        switch (fieldKey) {
            case "adminorg": {
                this.adminorgChange(changedArgs);
                break;
            }
            case "parentorg": {
                this.parentChange(changedArgs);
                break;
            }
            case "changescene": {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"changereason"});
                this.getModel().setValue("changereason", null, rowIndex);
                if (!Objects.isNull(objectNew)) break;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"changereason"});
                break;
            }
            case "companyarea": {
                DynamicObject workplace = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("workplace");
                AdminOrgBatchChgHelper.propChgForCountryArea((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel(), (DynamicObject)workplace, (String)"entryentity");
                break;
            }
            case "city": {
                DynamicObject workplace = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("workplace");
                AdminOrgBatchChgHelper.propChgForCity((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel(), (DynamicObject)workplace, (String)"entryentity");
            }
        }
    }

    private void parentChange(PropertyChangedArgs changedArgs) {
        DynamicObject newValue = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            return;
        }
        int row = this.getFocusRow();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row);
        DynamicObject adminorgDy = dynamicObject.getDynamicObject("adminorg");
        long oldParentId = adminorgDy.getDynamicObject("parentorg") != null ? adminorgDy.getLong("parentorg.id") : 0L;
        long newParentId = newValue.getLong("boid");
        Long changeType = dynamicObject.getLong("changetype.id");
        if (oldParentId != newParentId) {
            Long id = HRDyObjectPropUtil.getIdLongObject((DynamicObject)dynamicObject.getDynamicObject("adminorg"));
            AdminOrgBatchChgHelper.propChgForParentOrg((IFormView)this.getView(), (DynamicObject)newValue, (String)"entryentity", (int)row);
            this.setIndex(newValue, id, row);
            if (changeType.equals(OrgBatchChgBillConstants.CHANGE_TYPE_INFO)) {
                this.getModel().setValue("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_INFO, row);
                DynamicObject[] parentChangesceneDys = this.getChangesceneByChgType(OrgBatchChgBillConstants.CHANGE_TYPE_PARENT);
                this.getModel().setValue("changescene", parentChangesceneDys.length == 1 ? Long.valueOf(parentChangesceneDys[0].getLong("id")) : null);
            }
        } else {
            if (adminorgDy == null || OrgBatchChgBillConstants.CHANGE_TYPE_ADD.equals(changeType)) {
                return;
            }
            DynamicObject orgDy = AdminOrgBatchChgHelper.getOrgDyById((Long)adminorgDy.getLong("id"));
            this.getModel().setValue("changetype", (Object)OrgBatchChgBillConstants.CHANGE_TYPE_INFO, row);
            DynamicObject[] infoChangesceneDys = this.getChangesceneByChgType(OrgBatchChgBillConstants.CHANGE_TYPE_INFO);
            this.getModel().setValue("changescene", infoChangesceneDys.length == 1 ? Long.valueOf(infoChangesceneDys[0].getLong("id")) : null);
            this.getModel().setValue("index", (Object)orgDy.getInt("index"), row);
        }
    }

    private void setIndex(DynamicObject parentDy, Long orgId, int row) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        if (parentDy != null && parentDy.getLong("id") != 0L) {
            QFilter qFilter = new QFilter("parentorg", "=", (Object)parentDy.getLong("boid")).and("id", "!=", (Object)orgId).and("iscurrentversion", "=", (Object)"1");
            DynamicObjectCollection dynamicObjects = serviceHelper.queryOriginalCollection("id,parentorg.id,index", qFilter.toArray());
            int max = 1;
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                for (DynamicObject dy : dynamicObjects) {
                    if (dy.getInt("index") < max || max >= 100000) continue;
                    max = dy.getInt("index") + 1;
                }
            }
            this.getModel().setValue("index", (Object)max, row);
        }
    }

    private void adminorgChange(PropertyChangedArgs changedArgs) {
        String oldOrgId = this.getPageCache().get("orgId");
        if (changedArgs.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)changedArgs.getChangeSet()[0].getNewValue();
        Long orgId = dynamicObject.getLong("id");
        String orgIdStr = String.valueOf(orgId);
        if (HRStringUtils.equals((String)orgIdStr, (String)oldOrgId)) {
            return;
        }
        DynamicObject orgDy = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
        Long orgOld = orgDy == null ? 0L : orgDy.getLong("id");
        this.getPageCache().put("orgId", String.valueOf(orgOld));
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("select_org", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u540e\uff0c\u5f53\u524d\u5df2\u4fee\u6539\u7684\u5185\u5bb9\u5c06\u4f1a\u4e22\u5931\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminorgFastChgPlugin_38", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String key;
        super.afterDoOperation(eventArgs);
        switch (key = eventArgs.getOperateKey()) {
            case "delete_one": {
                this.openDelConfirm(key, 1);
                break;
            }
            case "delete_all": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                this.openDelConfirm(key, entryGrid.getSelectRows().length);
                break;
            }
            case "save": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                this.getView().returnDataToParent((Object)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
            case "more_info": {
                this.editParent(this.getModel(), this.getView());
            }
        }
    }

    private void editParent(IDataModel iDataModel, IFormView iFormView) {
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        int row = entryEntity.getEntryState().getFocusRow();
        DynamicObject dynamicObject = (DynamicObject)iDataModel.getDataEntity(true).getDynamicObjectCollection("entryentity").get(row);
        long id = dynamicObject.getLong("id");
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("homs_batchorgentityparent");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("homs_batchorgentity");
        QFilter qFilter = new QFilter("id", "=", (Object)id).and(new QFilter("adminorg", "=", (Object)dynamicObject.getLong("adminorg.id")));
        boolean exists = hrBaseServiceHelper.isExists(qFilter);
        if (exists) {
            formShowParameter.setPkId((Object)id);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("selectObject", (Object)SerializationUtils.toJsonString((Object)dynamicObject));
        formShowParameter.setCustomParam("row", (Object)row);
        formShowParameter.setCustomParam("billid", this.getView().getFormShowParameter().getCustomParam("billid"));
        formShowParameter.setCustomParam("id", (Object)id);
        formShowParameter.setCustomParam("orgid", (Object)String.valueOf(dynamicObject.getDynamicObject("adminorg").getLong("id")));
        formShowParameter.setCustomParam("org", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)dynamicObject.getDynamicObject("org")));
        formShowParameter.setCustomParam("iscard", (Object)"true");
        formShowParameter.setCloseCallBack(new CloseCallBack(this.getPluginName(), "entryentity_parent"));
        iFormView.showForm((FormShowParameter)formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"delete_one")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int row = entryGrid.getEntryState().getFocusRow();
                this.getModel().deleteEntryRow("entryentity", row);
            }
        } else if (HRStringUtils.equals((String)callBackId, (String)"delete_all")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int[] rows = entryGrid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRows("entryentity", rows);
            }
        } else if (HRStringUtils.equals((String)callBackId, (String)"select_org")) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.updateEntryEntity();
            } else {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
                int row = entryGrid.getEntryState().getFocusRow();
                String orgId = this.getPageCache().get("orgId");
                this.getModel().setValue("adminorg", (Object)Long.valueOf(orgId), row);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object data = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "entryentity_parent": {
                if (!(data instanceof Map)) break;
                Map map = (Map)data;
                DynamicObjectCollection info = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                Optional<DynamicObject> changeEntry = info.stream().filter(entry -> entry.getLong("id") == ((Long)map.get("id")).longValue()).findFirst();
                if (!changeEntry.isPresent()) break;
                DynamicObject dynamicObject = changeEntry.get();
                map.keySet().forEach(item -> dynamicObject.set(!Objects.equals(item, "id") ? item.substring(7) : item, map.get(item)));
                this.getView().updateView("entryentity");
            }
        }
    }

    private void updateEntryEntity() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int row = entryGrid.getEntryState().getFocusRow();
        DynamicObject adminorgDy = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row)).getDynamicObject("adminorg");
        Long orgId = adminorgDy.getLong("id");
        DynamicObject dy = AdminOrgBatchChgHelper.getOrgDyById((Long)orgId);
        this.getModel().setValue("id", (Object)ORM.create().genLongId("homs_batchorgentity"), row);
        this.getModel().setValue("number", (Object)dy.getString("number"), row);
        this.getModel().setValue("name", (Object)dy.getString("name"), row);
        this.getModel().setValue("old_parentorg", dy.getDynamicObject("parentorg") != null ? Long.valueOf(dy.getLong("parentorg.id")) : null, row);
        this.getModel().setValue("oriparentorg_name", (Object)"");
        this.getModel().setValue("parentorg", dy.getDynamicObject("parentorg") != null ? Long.valueOf(dy.getLong("parentorg.id")) : null, row);
        this.getModel().setValue("parentorg_name", (Object)"");
        this.getModel().setValue("simplename", (Object)dy.getString("simplename"), row);
        this.getModel().setValue("adminorgtype", dy.getDynamicObject("adminorgtype") != null ? Long.valueOf(dy.getLong("adminorgtype.id")) : null, row);
        this.getModel().setValue("establishmentdate", (Object)dy.getDate("establishmentdate"), row);
        this.getModel().setValue("corporateorg", dy.getDynamicObject("corporateorg") != null ? Long.valueOf(dy.getLong("corporateorg.id")) : null, row);
        this.getModel().setValue("tobedisableflag", (Object)dy.getString("tobedisableflag"), row);
        this.getModel().setValue("adminorglayer", dy.getDynamicObject("adminorglayer") != null ? Long.valueOf(dy.getLong("adminorglayer.id")) : null, row);
        this.getModel().setValue("adminorgfunction", (Object)HRDyObjectPropUtil.getIdLongObject((DynamicObject)dy.getDynamicObject("adminorgfunction")), row);
        this.getModel().setValue("companyarea", dy.getDynamicObject("companyarea") != null ? Long.valueOf(dy.getLong("companyarea.id")) : null, row);
        this.getModel().setValue("city", dy.getDynamicObject("city") != null ? Long.valueOf(dy.getLong("city.id")) : null, row);
        this.getModel().setValue("workplace", dy.getDynamicObject("workplace") != null ? Long.valueOf(dy.getLong("workplace.id")) : null, row);
        Set<Long> addSet = this.getOrgChgAddSet();
        this.getModel().setValue("changetype", (Object)(addSet.contains(dy.getLong("id")) ? 1010L : 1020L), row);
        DynamicObject[] changesceneDys = this.getChangesceneByChgType(addSet.contains(dy.getLong("id")) ? 1010L : 1020L);
        if (changesceneDys.length == 1) {
            this.getModel().setValue("changescene", (Object)changesceneDys[0].getLong("id"), row);
        }
        this.getModel().setValue("index", dy.get("index"));
        this.getModel().setValue("billid", this.getView().getFormShowParameter().getCustomParam("billid"));
    }

    private void openDelConfirm(String deleteKey, int number) {
        if (number > 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(deleteKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6570\u636e\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff08\u9009\u4e2d\u6761\u6570\uff1a%s\uff09\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"AdminorgBatchChgPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{number}), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AdminorgBatchChgPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
    }

    public Set<Long> getOrgChgAddSet() {
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection addEntity = parentView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_add");
        HashSet<Long> addSet = new HashSet<Long>();
        if (addEntity != null) {
            addEntity.stream().forEach(dynamicObject -> {
                if (dynamicObject.getLong("add_adminorg") != 0L) {
                    addSet.add(dynamicObject.getLong("add_adminorg"));
                }
            });
        }
        return addSet;
    }

    public DynamicObject[] getChangesceneByChgType(Long chgTypeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_changescene");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter qFilter = new QFilter("orgchangetype", "=", (Object)chgTypeId);
        return hrBaseServiceHelper.query(new QFilter[]{qFilter, statusFilter, enableFilter});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        int rowIndex = beforeF7SelectEvent.getRow();
        DynamicObjectCollection entryDynColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject focusEntryDyn = (DynamicObject)entryDynColl.get(rowIndex);
        switch (fieldKey) {
            case "changescene": {
                QFilter changeTyeFilter = new QFilter("orgchangetype.id", "=", (Object)focusEntryDyn.getLong("changetype.id"));
                beforeF7SelectEvent.getCustomQFilters().add(changeTyeFilter);
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getBaseDataFilter((String)"haos_changescene", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                break;
            }
            case "parentorg": {
                DynamicObject adminOrg = focusEntryDyn.getDynamicObject("adminorg");
                AdminOrgBatchChgHelper.setParentFilter((IFormView)this.getView().getParentView(), (DynamicObject)adminOrg, (BeforeF7SelectEvent)beforeF7SelectEvent);
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7", (String)"AdminorgFastChgPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "adminorg": {
                AdminOrgBatchChgHelper.filterF7Org((IFormView)this.getView().getParentView(), (BeforeF7SelectEvent)beforeF7SelectEvent, null);
                AuthorizedOrgResult authorizedOrgResult = AdminOrgBatchChgHelper.getOrgAuth((IFormView)this.getView());
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgdetail", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                if (authorizedOrgResult.isHasAllOrgPerm()) break;
                List hasPermOrgList = authorizedOrgResult.getHasPermOrgs();
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("boid", "in", (Object)hasPermOrgList));
                break;
            }
            case "changereason": {
                OrgBatchBillChartListHelper.setChangeReasonF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (int)rowIndex, (IFormView)this.getView());
                break;
            }
            case "city": {
                this.setCityF7Filter(beforeF7SelectEvent, rowIndex);
                break;
            }
            case "corporateorg": {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("oprsts", "=", (Object)"1"));
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getBaseDataFilter((String)"hbss_lawentity", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                break;
            }
            case "adminorglayer": {
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getBaseDataFilter((String)"haos_adminorglayer", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                break;
            }
            case "adminorgfunction": {
                beforeF7SelectEvent.getCustomQFilters().add(BaseDataHelper.getBaseDataFilter((String)"haos_adminorgfunction", Collections.singletonList(focusEntryDyn.getDynamicObject("org").getLong("id"))));
                break;
            }
        }
    }

    private void setCityF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, int rowIndex) {
        DynamicObject companyArea = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(rowIndex)).getDynamicObject("companyarea");
        if (companyArea != null && companyArea.getLong("id") != 0L) {
            QFilter qFilter = new QFilter("country", "=", (Object)companyArea.getLong("id"));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(qFilter);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
        }
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5728\u57ce\u5e02", (String)"AdminorgFastChgPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
    }

    private int getFocusRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int row = entryGrid.getEntryState().getFocusRow();
        return row;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        Object cacheModel = this.getView().getFormShowParameter().getCustomParams().get("cacheModel");
        formOperate.getOption().setVariableValue("cacheModel", SerializationUtils.toJsonString(cacheModel));
        formOperate.getOption().setVariableValue("entryKey", EntryEntityEnum.parentEntry.getEntryKey());
    }
}

