/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgbatch;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.enums.EntryEntityEnum;
import kd.hr.homs.business.service.helper.AdminOrgMagicHelper;

public class AdminorgCubeViewPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String VECTORAP = "vectorap";
    private static final String EXCHANGE_ROOT = "exchange_root";
    private static final String DISPLAY_CHGORG = "display_chgorg";
    private static final String TO_MAGIC = "to_magic";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTORAP});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (VECTORAP.equals(control.getKey().toLowerCase(Locale.ROOT))) {
            String formId = "homs_cubeinstruction";
            FormShowParameter formShowParameter = new FormShowParameter();
            OpenStyle openStyle = formShowParameter.getOpenStyle();
            openStyle.setShowType(ShowType.Floating);
            openStyle.setFloatingDirection(FloatingDirection.BottomRight);
            openStyle.setTargetKey(VECTORAP);
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("365px");
            cssValue.setHeight("150px");
            String langName = RequestContext.get().getLang().name();
            if (HRStringUtils.equals((String)langName, (String)"en_US")) {
                cssValue.setHeight("240px");
            }
            openStyle.setInlineStyleCss(cssValue);
            formShowParameter.setFormId(formId);
            this.getView().showForm(formShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String opKey;
        super.afterDoOperation(eventArgs);
        switch (opKey = eventArgs.getOperateKey()) {
            case "to_magic": {
                this.setMustInput(true);
                if (!this.parentOrgChange() || !eventArgs.getOperationResult().isSuccess()) break;
                this.createOrgChart();
                break;
            }
            case "to_list": {
                AdminOrgMagicHelper.returnToList((IFormView)this.getView());
                break;
            }
        }
    }

    private void setMustInput(boolean value) {
        FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("billno");
        fieldEdit.setMustInput(value);
        FieldProp property = (FieldProp)fieldEdit.getProperty();
        property.setMustInput(value);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)TO_MAGIC)) {
            this.setMustInput(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)DISPLAY_CHGORG)) {
            AdminOrgMagicHelper.refreshOrgCubeView((IFormView)this.getView(), (String)name, (String)"update");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRowColl;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)EXCHANGE_ROOT) && (selectRowColl = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && selectRowColl.size() > 0) {
            long rootOrgId = Long.parseLong(selectRowColl.get(0).getPrimaryKeyValue().toString());
            AdminOrgMagicHelper.showOrgCubeView((IFormView)this.getView(), (long)rootOrgId, (String)actionId, (String)"update");
            this.getPageCache().put(EXCHANGE_ROOT, Long.toString(rootOrgId));
        }
    }

    private void createOrgChart() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List entryKeys = EntryEntityEnum.getEntryKeysWithExt();
        boolean isEmpty = entryKeys.stream().allMatch(entryName -> {
            DynamicObjectCollection entities = dataEntity.getDynamicObjectCollection(entryName);
            return CollectionUtils.isEmpty((Collection)entities);
        });
        if (isEmpty) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u5f62\u5316\u68c0\u67e5\u9700\u8981\u81f3\u5c11\u6dfb\u52a0\u4e00\u6761\u7ec4\u7ec7\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AdminorgCubeViewPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().getPageCache().put("isList", "0");
        Container baseInfo = (Container)this.getView().getControl("fs_baseinfo");
        baseInfo.setCollapse(true);
        this.getPageCache().remove(EXCHANGE_ROOT);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"chg_info"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"org_magic"});
        this.updateControl(this.getView());
        AdminOrgMagicHelper.showOrgCubeView((IFormView)this.getView(), (long)0L, (String)"init", (String)"init");
    }

    private void updateControl(IFormView view) {
        String langName = RequestContext.get().getLang().name();
        if (HRStringUtils.equals((String)langName, (String)"en_US")) {
            FieldEdit fieldEdit = (FieldEdit)view.getControl(DISPLAY_CHGORG);
            LocaleString displayName = fieldEdit.getProperty().getDisplayName();
            FieldAp fieldAp = new FieldAp();
            fieldAp.setKey(DISPLAY_CHGORG);
            fieldAp.setName(displayName);
            fieldAp.setWidth(new LocaleString("260px"));
            fieldAp.setLabelWidth(new LocaleString("201px"));
            view.updateControlMetadata(DISPLAY_CHGORG, fieldAp.createControl());
        }
    }

    private boolean parentOrgChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection parentEntryColl = dataEntity.getDynamicObjectCollection("entryentity_parent");
        String adminOrgName = parentEntryColl.stream().filter(entry -> entry.getLong("parent_adminorg.parentorg.id") == entry.getLong("parent_parentorg.boid")).map(entry -> entry.getString("parent_name")).collect(Collectors.joining(","));
        if (HRStringUtils.isNotEmpty((String)adminOrgName)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u4e0a\u7ea7\u4e2d\u201c%1$s\u201d\u7684\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u672a\u53d1\u751f\u53d8\u5316\u3002", (String)"AdminorgCubeViewPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), adminOrgName));
            return false;
        }
        return true;
    }
}

