/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.constants.orgchart.ProjectChartConstants;
import kd.hr.homs.formplugin.web.orgchart.OrgChartBase;
import kd.hr.homs.formplugin.web.projectchart.ProjectChartBase;

public class ChartHelper {
    private static final Log LOG = LogFactory.getLog(ChartHelper.class);
    private static final String HRCS = "hrcs";
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";

    public static boolean checkOrgTeamPerm(DynamicObject dataEntity, FormShowParameter formShowParameter, String key, String orgTeamKey) {
        long cardDimensionId = dataEntity.getDynamicObject(key).getLong("id");
        String formId = "";
        Long otcClassifyId = 0L;
        if (cardDimensionId == OrgChartConstants.ORG_CARDDISSION || cardDimensionId == OrgChartConstants.POSITION_CARDDISSION) {
            formId = "haos_adminorgdetail";
            otcClassifyId = OrgChartConstants.DEFAULT_OTCCLASSIFY_ID;
        } else if (cardDimensionId == OrgChartConstants.PROJECT_CARDDISSION) {
            formId = "haos_projteambaseinfo";
            otcClassifyId = ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID;
        }
        String permItemId = "47150e89000000ac";
        Long userId = RequestContext.get().getCurrUserId();
        String permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)formId);
        String appIdFromShowParam = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)appIdFromShowParam, (String)permEntityId);
        AuthorizedOrgTeamResult permResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedOrgTeams", (Object[])new Object[]{userId, appId, permEntityId, permItemId, "boid"});
        if (permResult.isHasAllOrgPerm()) {
            LOG.info("user has all org perm");
            return true;
        }
        List permIds = permResult.getHasPermOrgTeamMap().getOrDefault(otcClassifyId, new ArrayList());
        long orgTeam = dataEntity.getLong(orgTeamKey + ".boid");
        return new HashSet(permIds).contains(orgTeam);
    }

    public static Set<Long> getPermCardStyleIds(FormShowParameter formShowParameter) {
        ProjectChartBase projectChartBase = new ProjectChartBase();
        HashSet<Long> cardStyles = new HashSet<Long>();
        AuthorizedOrgTeamResult permProjectResult = projectChartBase.invokeProjectPerm(formShowParameter);
        if (!permProjectResult.isHasAllOrgPerm()) {
            Map hasPermOrgTeamMap = permProjectResult.getHasPermOrgTeamMap();
            List projectIds = hasPermOrgTeamMap.getOrDefault(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID, new ArrayList());
            if (projectIds.isEmpty()) {
                return cardStyles;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgstructure");
            QFilter idFilter = new QFilter("orgteam", "in", (Object)projectIds);
            idFilter.and(new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')));
            idFilter.and(new QFilter("datastatus", "=", (Object)Character.valueOf('1')));
            idFilter.and(new QFilter("enable", "=", (Object)"1"));
            idFilter.and((QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get());
            DynamicObject[] querys = helper.query("structlongnumber, id", idFilter.toArray());
            List structLongNumbers = Arrays.stream(querys).map(dy -> dy.getString("structlongnumber")).collect(Collectors.toList());
            Map<Long, String> permStructLongNumberMap = Arrays.stream(querys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("structlongnumber")));
            String select = "select c.fid, c.fadminorgid, c.fiscontainslower, s.fstructlongnumber from t_homs_cardstyleorgentry c left join T_HAOS_ORGTEAMSTRUCT s on c.fadminorgid = s.forgteamid left join t_homs_cardstyle m on m.fid = c.fid where s.fiscurrentversion ='1' and m.fcarddimensionid = 1020 ";
            try (DataSet rs = HRDBUtil.queryDataSet((String)"t_homs_cardstyleorgentry", (DBRoute)new DBRoute("haos"), (String)select, null);){
                block9: for (Row data : rs) {
                    Long adminorgId = data.getLong("fadminorgid");
                    String isContainsLower = data.getString("fiscontainslower");
                    String structLongNumber = data.getString("fstructlongnumber");
                    if ("1".equals(isContainsLower)) {
                        for (String longNumber : structLongNumbers) {
                            if (!longNumber.startsWith(structLongNumber)) continue;
                            cardStyles.add(data.getLong("fid"));
                            continue block9;
                        }
                        continue;
                    }
                    if (!permStructLongNumberMap.containsKey(adminorgId)) continue;
                    cardStyles.add(data.getLong("fid"));
                }
            }
            return cardStyles;
        }
        return OrgChartServiceHelper.getAllCardStyleIds(null);
    }

    public QFilter getPermFilter(long carddimensionId, FormShowParameter formShowParameter) {
        HasPermOrgResult permOrg;
        List ids = new ArrayList();
        QFilter permFilter = new QFilter("1", "=", (Object)1);
        if (carddimensionId == OrgChartConstants.ORG_CARDDISSION || carddimensionId == OrgChartConstants.POSITION_CARDDISSION) {
            OrgChartBase helper = new OrgChartBase();
            AuthorizedOrgResult permOrgResults = helper.getPermOrgResults(formShowParameter);
            permFilter.and(new QFilter("otclassify", "=", (Object)OrgChartConstants.DEFAULT_OTCCLASSIFY_ID));
            if (!permOrgResults.isHasAllOrgPerm()) {
                ids = permOrgResults.getHasPermOrgs();
            }
        } else if (carddimensionId == OrgChartConstants.PROJECT_CARDDISSION) {
            ProjectChartBase projectChartBase = new ProjectChartBase();
            AuthorizedOrgTeamResult permProjectResult = projectChartBase.invokeProjectPerm(formShowParameter);
            permFilter.and(new QFilter("otclassify", "=", (Object)ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID));
            if (!permProjectResult.isHasAllOrgPerm()) {
                Map hasPermOrgTeamMap = permProjectResult.getHasPermOrgTeamMap();
                ids = hasPermOrgTeamMap.getOrDefault(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID, new ArrayList());
            }
        }
        if (!ids.isEmpty()) {
            permFilter.and(new QFilter("id", "in", ids));
        }
        if (!(permOrg = OrgPermHelper.getHRPermOrg((String)formShowParameter.getFormId())).hasAllOrgPerm()) {
            QFilter orgFilter = new QFilter("org", "in", (Object)permOrg.getHasPermOrgs());
            permFilter.and(orgFilter);
        }
        LOG.info("permFilter {}", (Object)permFilter.toCurrentString());
        return permFilter.and(this.getCommonFilter());
    }

    public QFilter getCommonFilter() {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        currentVersionFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        currentVersionFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        currentVersionFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        return currentVersionFilter;
    }

    public static QFilter buildPermissionFilter(FormShowParameter formShowParameter, String key, String orgteam) {
        QFilter permFilter = ChartHelper.getAuthorizedOrgResult(formShowParameter, key, orgteam);
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)((ListShowParameter)formShowParameter).getBillFormId());
        if (!permOrg.hasAllOrgPerm()) {
            if ("id".equals(orgteam)) {
                permFilter.and(new QFilter("org.id", "in", (Object)permOrg.getHasPermOrgs()));
            } else {
                permFilter.and(new QFilter(orgteam + ".org.id", "in", (Object)permOrg.getHasPermOrgs()));
            }
        }
        return permFilter;
    }

    private static QFilter getAuthorizedOrgResult(FormShowParameter formShowParameter, String key, String orgteam) {
        ProjectChartBase projectChartBase;
        AuthorizedOrgTeamResult permProjectResult;
        QFilter permFilter = new QFilter("1", "=", (Object)1);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appIdFromShowParam = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)appIdFromShowParam, (String)permEntityId);
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, permEntityId, permItemId, "boid"});
        LOG.info("getAuthorizedAdminOrgSet:{}", (Object)permResult);
        ArrayList ids = new ArrayList();
        if (!permResult.isHasAllOrgPerm()) {
            if (permResult.getHasPermOrgs().isEmpty()) {
                permFilter.and(new QFilter(key, "!=", (Object)Long.parseLong("1010")));
            } else {
                ids.addAll(permResult.getHasPermOrgs());
            }
        }
        if (!(permProjectResult = (projectChartBase = new ProjectChartBase()).invokeProjectPerm(formShowParameter)).isHasAllOrgPerm()) {
            Map hasPermOrgTeamMap = permProjectResult.getHasPermOrgTeamMap();
            List projectIds = (List)hasPermOrgTeamMap.get(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID);
            if (hasPermOrgTeamMap.containsKey(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID) && !projectIds.isEmpty()) {
                ids.addAll(projectIds);
            } else {
                permFilter.and(new QFilter(key, "!=", (Object)Long.parseLong("1020")));
            }
        }
        if (!ids.isEmpty()) {
            if ("id".equals(orgteam)) {
                permFilter.and(new QFilter("id", "in", ids));
            } else {
                permFilter.and(new QFilter(orgteam + ".id", "in", ids));
            }
        }
        return permFilter;
    }
}

