/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;

public class OrgChartBase
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final Log LOG = LogFactory.getLog(OrgChartBase.class);
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String HRCS = "hrcs";
    private static final String PERMORGIDS = "permorgids";
    private static final String CACHE_PERM_ORG_RESULT = "perm_org_result";
    private static final String CACHE_PERM_ORG_RESULT_WITHSUB = "perm_org_result_withsub";
    private static final String CACHE_SHOW_COOP_ORG = "show_coop_org";
    private static final String CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER_DATE = "root_structlongnumber_date";
    private static final String PROP_KEY_BO_ID = "boid";

    protected void removePermPageCache(AbstractFormPlugin plugin) {
        plugin.getPageCache().remove(PERMORGIDS);
        plugin.getPageCache().remove(CACHE_PERM_ORG_RESULT);
        plugin.getPageCache().remove(CACHE_PERM_ORG_RESULT_WITHSUB);
        plugin.getPageCache().remove(CACHE_SHOW_COOP_ORG);
    }

    protected Set<String> buildChildStructLongNumbers(DynamicObjectCollection belongAdminOrgStructCollection, String parentStructLongNumber) {
        HashSet<String> childLongNumbers = new HashSet<String>();
        belongAdminOrgStructCollection.forEach(belongAdminOrgStruct -> {
            int tempIndex;
            String structLongNumber = belongAdminOrgStruct.getString("structlongnumber");
            if (structLongNumber.length() > parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                childLongNumbers.add(structLongNumber);
            }
            while (-1 != (tempIndex = structLongNumber.lastIndexOf(33)) && !structLongNumber.equals(parentStructLongNumber) && structLongNumber.length() >= parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                structLongNumber = structLongNumber.substring(0, tempIndex);
                childLongNumbers.add(structLongNumber);
            }
        });
        return childLongNumbers;
    }

    protected String getRealRootOrgStructLongNumber(AbstractFormPlugin plugin, Date queryDate) {
        String realRootOrgStructLongNumber = plugin.getPageCache().get("real_rootorg_structlongnumber");
        String queryDateStr = plugin.getPageCache().get(CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER_DATE);
        if (!StringUtils.isEmpty((CharSequence)queryDateStr)) {
            try {
                Date datefield = HRDateTimeUtils.parseDate((String)queryDateStr, (String)"yyyy-MM-dd");
                if (datefield.equals(queryDate) && !HRStringUtils.isEmpty((String)realRootOrgStructLongNumber)) {
                    return realRootOrgStructLongNumber;
                }
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("root_structlongnumber_date.date:{0}", queryDateStr));
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter rootFilter = new QFilter("isroot", "=", (Object)"1");
        QFilter baseCommonFilterWithDate = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate);
        QFilter structFilter = new QFilter("structproject", "=", (Object)Long.parseLong(this.getStructProjectId()));
        Object[] rootOrgTeam = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{rootFilter, baseCommonFilterWithDate, structFilter});
        LOG.info("rootOrgTeam:{}", rootOrgTeam);
        if (rootOrgTeam != null && rootOrgTeam.length > 0) {
            realRootOrgStructLongNumber = rootOrgTeam[0].getString("structlongnumber");
            plugin.getPageCache().put("real_rootorg_structlongnumber", realRootOrgStructLongNumber);
            plugin.getPageCache().put(CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER_DATE, HRDateTimeUtils.format((Date)queryDate, (String)"yyyy-MM-dd"));
        }
        return realRootOrgStructLongNumber;
    }

    protected List<Long> getPermOrgs(AbstractFormPlugin plugin) {
        String orgIdsString = plugin.getPageCache().get(PERMORGIDS);
        if (!HRStringUtils.isEmpty((String)orgIdsString)) {
            List orgIds = SerializationUtils.fromJsonStringToList((String)orgIdsString, Long.class);
            return orgIds;
        }
        AuthorizedOrgResult orgResult = this.getPermOrgResult(plugin);
        List orgIds = !orgResult.isHasAllOrgPerm() ? orgResult.getHasPermOrgs() : (List)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAllAdminOrgs", (Object[])new Object[]{this.isAdminOrgFilterEnable()});
        plugin.getPageCache().put(PERMORGIDS, SerializationUtils.toJsonString((Object)orgIds));
        LOG.info("getPermOrgs orgIds={}", (Object)JSONObject.toJSONString((Object)orgIds));
        return orgIds;
    }

    protected boolean isAdminOrgFilterEnable() {
        return false;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub(AbstractFormPlugin plugin, IFormView view) {
        String orgResultString = plugin.getPageCache().get(CACHE_PERM_ORG_RESULT_WITHSUB);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp(formShowParameter, permEntityId);
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, PROP_KEY_BO_ID, HAOSPermUtils.getStructProjectCustomInParam((String)PROP_KEY_BO_ID, (long)Long.parseLong(this.getStructProjectId()))});
        plugin.getPageCache().put(CACHE_PERM_ORG_RESULT_WITHSUB, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    public DynamicObject getRootDynByRootId(QFilter qFilter, Long rootId) {
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter[] filters = new QFilter[]{new QFilter("orgteam.boid", "=", (Object)rootId), qFilter};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    public DynamicObject getRootNodeDynamicObj(QFilter qFilter, List<String> orgIds, Date queryDate) {
        DynamicObjectCollection structOrgCollection;
        QFilter realRootOrgStructLongNumberFilter;
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(qFilter);
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            filters.add(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)this.getStructProjectId()));
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            filters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
        }
        if ((realRootOrgStructLongNumberFilter = OrgChartServiceHelper.getRealRootOrgStructLongNumberQFilter((String)this.getRealRootOrgStructLongNumber((AbstractFormPlugin)this, queryDate))) != null) {
            filters.add(realRootOrgStructLongNumberFilter);
        }
        if (null == (structOrgCollection = serviceHelper.queryOriginalCollection(selectFields, filters.toArray(new QFilter[0]))) || structOrgCollection.size() == 0) {
            return null;
        }
        ArrayList structLongNumberList = new ArrayList(16);
        structOrgCollection.forEach(dyn -> {
            String structLongNumber = dyn.getString("structlongnumber");
            structLongNumberList.add(structLongNumber);
        });
        String commonPrefixStructLongNumber = OrgTreeUtils.getCommonPrefixStructLongNumber(structLongNumberList);
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "=", (Object)commonPrefixStructLongNumber);
        LOG.info("getRootNodeDynamicObj.commonPrefixStructLongNumber is:{}", (Object)commonPrefixStructLongNumber);
        if (HRStringUtils.isEmpty((String)commonPrefixStructLongNumber)) {
            return null;
        }
        return serviceHelper.queryOriginalOne(selectFields, new QFilter[]{structLongNumberFilter, qFilter});
    }

    protected AuthorizedOrgResult getPermOrgResult(AbstractFormPlugin plugin) {
        String orgResultString = plugin.getPageCache().get(CACHE_PERM_ORG_RESULT);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResult.class);
        }
        FormShowParameter formShowParameter = plugin.getView().getFormShowParameter();
        String formId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        String permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)formId);
        String appId = this.getAppIdWithDealThirdApp(formShowParameter, formId);
        Long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgs", (Object[])new Object[]{userId, appId, permEntityId, permItemId, PROP_KEY_BO_ID, HAOSPermUtils.getStructProjectCustomInParam((String)PROP_KEY_BO_ID, (long)Long.parseLong(this.getStructProjectId()))});
        plugin.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    protected List<Long> getStylePermOrgIds(AbstractFormPlugin plugin) {
        AuthorizedOrgResult orgResult = this.getPermOrgResults(plugin.getView().getFormShowParameter());
        List orgIds = !orgResult.isHasAllOrgPerm() ? orgResult.getHasPermOrgs() : (List)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAllAdminOrgs", (Object[])new Object[]{Boolean.FALSE});
        return orgIds;
    }

    public AuthorizedOrgResult getPermOrgResults(FormShowParameter formShowParameter) {
        Long userId = RequestContext.get().getCurrUserId();
        String permEntityId = "homs_orgchart_new";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appIdFromShowParam = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)appIdFromShowParam, (String)permEntityId);
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, permEntityId, permItemId, PROP_KEY_BO_ID});
    }

    protected DynamicObject getDefaultPersonalStyle(String chartStyleId, List<String> orgIds) {
        Object[] personalStyles;
        if (StringUtils.isEmpty((CharSequence)chartStyleId)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_personalstyle");
        QFilter idFilter = new QFilter("chartstyle", "=", (Object)Long.parseLong(chartStyleId));
        if (!CollectionUtils.isEmpty(orgIds)) {
            ArrayList orgs = Lists.newArrayListWithCapacity((int)orgIds.size());
            orgIds.forEach(orgId -> orgs.add(Long.parseLong(orgId)));
            QFilter orgFilter = new QFilter("rootorg.org", "in", (Object)orgs);
            idFilter.and(orgFilter);
        }
        if (!ArrayUtils.isEmpty((Object[])(personalStyles = serviceHelper.query("id,name,rootorg.boid,rootorg.org,chartstyle,content,content_tag", new QFilter[]{idFilter}, "createtime asc")))) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            if (permOrgResultWithSub.isHasAllOrgPerm()) {
                return personalStyles[0];
            }
            List<Long> permOrgs = this.getPermOrgs((AbstractFormPlugin)this);
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
            List hasPermOrgs = hrPermOrg.getHasPermOrgs();
            for (Object personalStyle : personalStyles) {
                if (!permOrgs.contains(personalStyle.getLong("rootorg.boid")) || !hasPermOrgs.contains(personalStyle.getLong("rootorg.org.id"))) continue;
                return personalStyle;
            }
        }
        return null;
    }

    protected Date getDate() {
        String queryDateStr = this.getPageCache().get("datefield");
        Date datefield = new Date();
        if (!StringUtils.isEmpty((CharSequence)queryDateStr)) {
            try {
                datefield = HRDateTimeUtils.parseDate((String)queryDateStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("getDate.date:{0}", queryDateStr));
            }
        }
        return datefield;
    }

    protected Map<Long, Boolean> getShowAllCoopOrgFlag(AbstractFormPlugin plugin, Set<Long> orgIds) {
        String orgIdShowAllCoopOrgMapString = plugin.getPageCache().get(CACHE_SHOW_COOP_ORG);
        if (!HRStringUtils.isEmpty((String)orgIdShowAllCoopOrgMapString)) {
            Map orgIdShowAllCoopOrgMap = (Map)SerializationUtils.fromJsonString((String)orgIdShowAllCoopOrgMapString, Map.class);
            return orgIdShowAllCoopOrgMap;
        }
        Map orgIdShowAllCoopOrgMap = SystemParamHelper.getBatchOrgParameter(orgIds, (String)"chartshowallcooporg");
        plugin.getPageCache().put(CACHE_SHOW_COOP_ORG, SerializationUtils.toJsonString((Object)orgIdShowAllCoopOrgMap));
        LOG.info("getShowAllCoopOrgFlag={}", (Object)JSONObject.toJSONString((Object)orgIdShowAllCoopOrgMap));
        return orgIdShowAllCoopOrgMap;
    }

    String getStructProjectId() {
        if (this.getView() == null) {
            return "1010";
        }
        String result = this.getView().getPageCache().get("STRUCT_PROJECT_KEY");
        if (HRStringUtils.isNotEmpty((String)result)) {
            return result;
        }
        String structProjectId = Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("showStructProjectType")).map(Object::toString).orElse("1010");
        this.getView().getPageCache().put("STRUCT_PROJECT_KEY", structProjectId);
        return structProjectId;
    }
}

