/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.enums.OrgChartOperateTypes;
import kd.hr.homs.common.model.PersonalStyleData;

public class OrgChartPersonStylePlugin
extends AbstractTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(OrgChartPersonStylePlugin.class);

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "savePersonalStyle": {
                this.savePersonalStyleData(eventArgs);
                break;
            }
            case "updatePersonalStyle": {
                this.updatePersonalStyleData(eventArgs);
                break;
            }
            case "showTreeView": {
                JSONObject params = JSONObject.parseObject((String)eventArgs);
                String showType = params.getString("showType");
                this.openOrHideTreeView(showType);
                break;
            }
        }
    }

    private void savePersonalStyleData(String eventArgs) {
        PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)eventArgs, PersonalStyleData.class);
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        HRBaseServiceHelper personalStyleHelper = new HRBaseServiceHelper("homs_personalstyle");
        DynamicObject personalStyleDy = personalStyleHelper.generateEmptyDynamicObject();
        String personalStyleDataName = personalStyleData.getName().trim();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String errorInfo = "";
        int operateType = OrgChartOperateTypes.FAIL.getValue();
        if (!StringUtils.isEmpty((CharSequence)personalStyleDataName)) {
            DynamicObject dynamicObject;
            QFilter nameFilter = new QFilter("name", "=", (Object)personalStyleDataName);
            if (!StringUtils.isEmpty((CharSequence)personalStyleData.getSearchChartData().getChartStyleId())) {
                long chartStyleId = Long.parseLong(personalStyleData.getSearchChartData().getChartStyleId());
                QFilter chartStyleFilter = new QFilter("chartstyle", "=", (Object)chartStyleId);
                nameFilter.and(chartStyleFilter);
            }
            if ((dynamicObject = personalStyleHelper.queryOne(new QFilter[]{nameFilter})) != null) {
                errorInfo = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"OrgChartPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"OrgChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            } else if (this.validateNameLength(personalStyleDataName)) {
                long personalStyleId = ORM.create().genLongId("homs_personalstyle");
                personalStyleDy.set("id", (Object)personalStyleId);
                this.savePersonalStyle(eventArgs, personalStyleData, personalStyleHelper, personalStyleDy, personalStyleDataName);
                this.getPageCache().put("0", "1");
                if ("0".equals(jsonObject.getString("isHideTree"))) {
                    this.openOrHideTreeView("0");
                } else {
                    this.openOrHideTreeView("1");
                }
                operateType = OrgChartOperateTypes.SAVE_PERSONAL_STYLE.getValue();
                data.put("data", personalStyleId + "");
                this.showPersonStyleSaveSuccessInfo(personalStyleDataName);
            }
        } else {
            errorInfo = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgChartPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"OrgChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        data.put("errorInfo", errorInfo);
        data.put("operateType", operateType);
        data.put("isHideTree", jsonObject.getString("isHideTree"));
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"savePersonalStyle", data, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"savePersonalStyle", data, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
    }

    private void updatePersonalStyleData(String eventArgs) {
        PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)eventArgs, PersonalStyleData.class);
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        HRBaseServiceHelper personalStyleHelper = new HRBaseServiceHelper("homs_personalstyle");
        String personalStyleDataName = personalStyleData.getName().trim();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String errorInfo = "";
        int operateType = OrgChartOperateTypes.FAIL.getValue();
        if (!StringUtils.isEmpty((CharSequence)personalStyleDataName)) {
            DynamicObject dynamicObject;
            QFilter nameFilter = new QFilter("name", "=", (Object)personalStyleDataName);
            if (!StringUtils.isEmpty((CharSequence)personalStyleData.getSearchChartData().getChartStyleId())) {
                long chartStyleId = Long.parseLong(personalStyleData.getSearchChartData().getChartStyleId());
                QFilter chartStyleFilter = new QFilter("chartstyle", "=", (Object)chartStyleId);
                nameFilter.and(chartStyleFilter);
            }
            if ((dynamicObject = personalStyleHelper.queryOne(new QFilter[]{nameFilter})) != null && !personalStyleData.getId().equals(dynamicObject.getString("id"))) {
                errorInfo = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728", (String)"OrgChartPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"OrgChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            } else if (this.validateNameLength(personalStyleDataName)) {
                this.personalStyleUpdate(eventArgs, personalStyleData, personalStyleHelper, personalStyleDataName);
                this.getPageCache().put("0", "1");
                if ("0".equals(jsonObject.getString("isHideTree"))) {
                    this.openOrHideTreeView("0");
                } else {
                    this.openOrHideTreeView("1");
                }
                operateType = OrgChartOperateTypes.UPDATE_PERSONAL_STYLE.getValue();
                data.put("data", personalStyleData.getId());
                this.showPersonStyleSaveSuccessInfo(personalStyleDataName);
            }
        } else {
            errorInfo = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrgChartPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"OrgChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        data.put("errorInfo", errorInfo);
        data.put("operateType", operateType);
        data.put("isHideTree", jsonObject.getString("isHideTree"));
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"updatePersonalStyle", data, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void personalStyleUpdate(String eventArgs, PersonalStyleData personalStyleData, HRBaseServiceHelper personalStyleHelper, String personalStyleDataName) {
        DynamicObject personalStyleDy = personalStyleHelper.queryOne((Object)personalStyleData.getId());
        if (personalStyleDy != null) {
            String chartStyleId = personalStyleData.getSearchChartData().getChartStyleId();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_chartstyle");
            DynamicObject chartStyle = serviceHelper.loadSingle((Object)chartStyleId);
            personalStyleDy.set("chartstyle", (Object)chartStyle);
            serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
            DynamicObject rootOrgTeam = serviceHelper.loadSingle((Object)personalStyleData.getSearchChartData().getCurrentOrgChartRootNodeId());
            personalStyleDy.set("rootorg", (Object)rootOrgTeam);
            personalStyleDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            personalStyleDy.set("content_tag", (Object)eventArgs);
            LocaleString personalStyleName = new LocaleString();
            personalStyleName.setLocaleValue(personalStyleDataName);
            personalStyleDy.set("name", (Object)personalStyleName);
            TXHandle txHandle = TX.requiresNew();
            OperationResult localOperationResult = new OperationResult();
            try {
                personalStyleHelper.updateOne(personalStyleDy);
                OrgChartServiceHelper.addOperateLog((DynamicObject)personalStyleDy, (int)2);
            }
            catch (Exception e) {
                LOG.error("kd.hr.homs.formplugin.web.orgchart.OrgChartPlugin.savePersonalStyleData Exception ", (Throwable)e);
                localOperationResult.setSuccess(false);
            }
            finally {
                if (!localOperationResult.isSuccess()) {
                    txHandle.markRollback();
                }
                txHandle.close();
            }
        }
    }

    private void showPersonStyleSaveSuccessInfo(String name) {
        this.getView().showSuccessNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6837\u5f0f\u201c%s\u201d\u4fdd\u5b58\u6210\u529f\u3002", (String)"OrgChartPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersonalStyle(String eventArgs, PersonalStyleData personalStyleData, HRBaseServiceHelper personalStyleHelper, DynamicObject personalStyleDy, String personalStyleDataName) {
        String chartStyleId = personalStyleData.getSearchChartData().getChartStyleId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_chartstyle");
        DynamicObject chartStyle = serviceHelper.loadSingle((Object)chartStyleId);
        personalStyleDy.set("chartstyle", (Object)chartStyle);
        serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        DynamicObject rootOrgTeam = serviceHelper.loadSingle((Object)personalStyleData.getSearchChartData().getCurrentOrgChartRootNodeId());
        personalStyleDy.set("rootorg", (Object)rootOrgTeam);
        personalStyleDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        personalStyleDy.set("content_tag", (Object)eventArgs);
        LocaleString personalStyleName = new LocaleString();
        personalStyleName.setLocaleValue(personalStyleDataName);
        personalStyleDy.set("name", (Object)personalStyleName);
        TXHandle txHandle = TX.requiresNew();
        OperationResult localOperationResult = new OperationResult();
        try {
            personalStyleHelper.saveOne(personalStyleDy);
            OrgChartServiceHelper.addOperateLog((DynamicObject)personalStyleDy, (int)1);
        }
        catch (Exception e) {
            LOG.error("kd.hr.homs.formplugin.web.orgchart.OrgChartPlugin.savePersonalStyleData Exception ", (Throwable)e);
            localOperationResult.setSuccess(false);
        }
        finally {
            if (!localOperationResult.isSuccess()) {
                txHandle.markRollback();
            }
            txHandle.close();
        }
    }

    private void openOrHideTreeView(String showType) {
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        if ("1".equals(showType)) {
            splitContainer.hidePanel(SplitDirection.left, true);
            data.put("operateType", OrgChartOperateTypes.HIDE_LEFT_TREE.getValue());
        } else {
            splitContainer.hidePanel(SplitDirection.left, false);
            data.put("operateType", OrgChartOperateTypes.SHOW_LEFT_TREE.getValue());
        }
        data.put("data", "1");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"showTreeView", data, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
    }

    private boolean validateNameLength(String personalStyleDataName) {
        if (personalStyleDataName.length() > 100) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]\u3002", (String)"OrgChartPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

