/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.business.service.proxy.ProxyUtils;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.enums.OrgChartOperateTypes;
import kd.hr.homs.common.model.ChartOrgInfo;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartQueryParam;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.PersonalStyleData;
import kd.hr.homs.common.model.SearchChartData;
import kd.hr.homs.formplugin.web.orgchart.OrgChartBase;
import kd.hr.homs.formplugin.web.orgchart.OrgChartViewDetailsPlugin;
import kd.sdk.odc.homs.service.IOrgChartCustomEventService;

public class OrgChartPlugin
extends OrgChartBase
implements TreeNodeQueryListener {
    private static final Log LOG = LogFactory.getLog(OrgChartPlugin.class);
    private HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_orgchart");

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", "treeview");
        hashMap.put("labelShowType", 1);
        service.addAction("u", hashMap);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.getTreeListView().getTreeView().addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        this.initDataQuery("initData");
    }

    private void refreshTreeByDefaultSearchChartData(QFilter defaultFilter, String dataFlag) {
        SearchChartData searchChartData = OrgChartServiceHelper.getDefaultSearchChartData((Date)new Date());
        this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)searchChartData.getOrgs()));
        this.refreshTreeData(defaultFilter, dataFlag, searchChartData);
    }

    private void refreshTreeData(QFilter qFilter, String dataFlag, SearchChartData searchChartData) {
        OrgChartTreeNode orgChartRootNode;
        this.removePermPageCache((AbstractFormPlugin)this);
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)searchChartData));
        OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(qFilter, searchChartData.getOrgs(), searchChartData.getDateField());
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        OrgChartTreeNode firstPermOrgNode = OrgChartServiceHelper.findFirstPermOrgNode((OrgChartTreeNode)rootNode, permOrgResultWithSub.isHasAllOrgPerm() ? null : this.getPermOrgs((AbstractFormPlugin)this), (List)searchChartData.getOrgs(), (boolean)permOrgResultWithSub.isHasAllOrgPerm());
        OrgChartTreeNode virtualNode = this.getAllOrgNoParentVirtualNodes(qFilter, searchChartData.getOrgs(), searchChartData.getDateField());
        if (rootNode == null && virtualNode != null && virtualNode.getChildren().size() > 0) {
            rootNode = virtualNode;
            firstPermOrgNode = (OrgChartTreeNode)rootNode.getChildren().get(0);
        } else {
            this.setVirtualNode(virtualNode, (TreeNode)rootNode);
        }
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(10);
        LocalDate searchDate = TreeTemplateHelper.date2LocalDate((Date)searchChartData.getDateField());
        LocalDate today = TreeTemplateHelper.date2LocalDate((Date)new Date());
        if (!searchDate.isEqual(today)) {
            TreeNodeLabel searchDateLabel = new TreeNodeLabel(searchDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), "#666666");
            labelParaList.add(searchDateLabel);
        }
        if (rootNode != null && !CollectionUtils.isEmpty(labelParaList)) {
            rootNode.setLabelShowType(1);
            rootNode.setLabelPara(labelParaList);
        }
        this.setRootNodeToTreeView(rootNode, firstPermOrgNode);
        if (StringUtils.isEmpty((CharSequence)searchChartData.getCurrentOrgChartRootNodeId()) && firstPermOrgNode != null) {
            searchChartData.setCurrentOrgChartRootNodeId(firstPermOrgNode.getBoid());
        }
        if (!OrgChartServiceHelper.isMatchCondition((OrgChartTreeNode)(orgChartRootNode = this.getRightOrgChartRootNode(qFilter, searchChartData, searchChartData.getCurrentOrgChartRootNodeId())), (SearchChartData)searchChartData).booleanValue()) {
            orgChartRootNode = null;
        }
        if (orgChartRootNode != null) {
            OrgChartServiceHelper.findTreeNode((TreeNode)orgChartRootNode, (SearchChartData)searchChartData, (boolean)false);
            String currentRootParentOrg = OrgChartServiceHelper.getAdminOrgOrg((QFilter)qFilter, (String)orgChartRootNode.getParentid());
            OrgChartServiceHelper.setNodeIsUphole((OrgChartTreeNode)orgChartRootNode, (AuthorizedOrgResultWithSub)permOrgResultWithSub, permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermOrgs((AbstractFormPlugin)this), (String)currentRootParentOrg, (SearchChartData)searchChartData);
            this.focusNode(this.getTreeListView().getTreeView(), this.treeListView.getTreeModel().getRoot(), this.treeListView.getTreeModel().getRoot().getTreeNode(orgChartRootNode.getId()));
        }
        Map<String, Object> currentQueryShowParams = this.getQueryShowParams(null, searchChartData, null);
        if (orgChartRootNode == null) {
            currentQueryShowParams.put("maxLevel", 0);
        }
        Map<String, Object> result = this.setDataForCustomControl(dataFlag, (TreeNode)orgChartRootNode);
        currentQueryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty((Object)rootNode));
        List schemes = OrgChartServiceHelper.getSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (boolean)true, (String)this.getStructProjectId());
        currentQueryShowParams.put("schemes", schemes);
        result.putAll(currentQueryShowParams);
        CommonOrgChartServiceHelper.setTermRemaning(currentQueryShowParams, (String)this.getPageCache().get("termRemain"));
        this.getPageCache().remove("termRemain");
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)dataFlag, currentQueryShowParams, (CustomControl)customcontrol);
    }

    private void setRootNodeToTreeView(OrgChartTreeNode rootNode, OrgChartTreeNode firstPermOrgNode) {
        TreeView treeview = this.getTreeListView().getTreeView();
        treeview.deleteAllNodes();
        if (rootNode != null && firstPermOrgNode != null) {
            rootNode.setParentid("");
            treeview.addNode((TreeNode)rootNode);
            this.getTreeModel().setRoot((TreeNode)rootNode);
            this.getTreeModel().setCurrentNodeId((Object)firstPermOrgNode.getId());
            this.getPageCache().put("CURRENT_NODE_ID", firstPermOrgNode.getId());
        } else {
            OrgChartTreeNode notInitOrgNode = OrgChartServiceHelper.getNotInitOrgNode();
            if (notInitOrgNode != null) {
                treeview.addNode((TreeNode)notInitOrgNode);
            }
        }
    }

    private Map<String, Object> setDataForCustomControl(String dataFlag, TreeNode treeNode) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", treeNode);
        data.put("orgChart", dataFlag);
        data.put("code", "200");
        data.put("errorMessage", "");
        data.put("time", System.currentTimeMillis());
        data.put("maxLevel", this.getPageCache().get("MAX_LEVEL_KEY"));
        String chartStyleStr = this.getPageCache().get("MATCH_CHART_STYLE_KEY");
        ChartStyle chartStyle = StringUtils.isEmpty((CharSequence)chartStyleStr) ? OrgChartServiceHelper.getChartStyleById((String)"1001") : (ChartStyle)JSONObject.parseObject((String)this.getPageCache().get("MATCH_CHART_STYLE_KEY"), ChartStyle.class);
        this.getPageCache().put("currentChartStyleId", chartStyle != null ? chartStyle.getId() : "");
        data.put("MATCH_CHART_STYLE_KEY", chartStyle);
        data.put("CHART_STYLE_KEY", JSONObject.parseArray((String)this.getPageCache().get("CHART_STYLE_KEY"), ChartStyle.class));
        customcontrol.setData(data);
        return data;
    }

    private void setSimpleDataForCustomControl(String dataFlag, Map<String, Object> data) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)dataFlag, data, (CustomControl)customcontrol);
    }

    private void getAndSendResponseParams(boolean isQueryPerm, OrgChartQueryParam orgChartQueryParam, FilterScheme defaultScheme, String structProjectId, String eventKey) {
        boolean showAllFlag = "true".equals(this.getView().getFormShowParameter().getCustomParam("showAllAreas"));
        Map initQueryParams = OrgChartServiceHelper.getInitQueryParams((boolean)isQueryPerm, (String)structProjectId, (boolean)showAllFlag);
        HashMap<String, Object> result = new HashMap<String, Object>(initQueryParams);
        Map<String, Object> queryShowParams = this.getQueryShowParams(orgChartQueryParam, this.getSearchChartData(structProjectId), defaultScheme);
        result.putAll(queryShowParams);
        queryShowParams.put("showStructProjectType", OrgChartServiceHelper.getStructProjectTypeById((long)Long.parseLong(structProjectId)));
        result.putAll(queryShowParams);
        this.sendResponseParams(result, eventKey);
    }

    private void sendResponseParams(Map<String, Object> result, String eventKey) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)eventKey, result, (CustomControl)customcontrol);
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)eventKey, result, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
    }

    private Map<String, Object> getQueryShowParams(OrgChartQueryParam orgChartQueryParam, SearchChartData searchChartData, FilterScheme defaultScheme) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String maxLevel = this.getPageCache().get("MAX_LEVEL_KEY");
        maxLevel = StringUtils.isEmpty((CharSequence)maxLevel) ? "3" : maxLevel;
        result.put("maxLevel", maxLevel);
        if (orgChartQueryParam == null) {
            Map<String, Object> currentQueryShowParams = this.getCurrentQueryShowParams(searchChartData);
            result.putAll(currentQueryShowParams);
        } else {
            Map queryShowParamsByScheme = OrgChartServiceHelper.getQueryShowParamsByScheme((OrgChartQueryParam)orgChartQueryParam, (FilterScheme)defaultScheme);
            Date queryDate = OrgChartServiceHelper.getQueryDate((OrgChartQueryParam)orgChartQueryParam);
            JSONObject showOrgTeam = this.getShowOrgTeam(orgChartQueryParam.getCurrentOrgChartRootNodeId(), queryDate, orgChartQueryParam.getOrgs());
            result.put("showOrgTeam", showOrgTeam);
            result.putAll(queryShowParamsByScheme);
        }
        result.put("showLevel", Math.min(Integer.parseInt(result.get("showLevel").toString()), Integer.parseInt(maxLevel)));
        return result;
    }

    private Map<String, Object> getCurrentQueryShowParams(SearchChartData searchChartData) {
        ChartStyle virtualorgStyle;
        ChartStyle chartStyle;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("queryDate", searchChartData.getDateField());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            Map styleMap = OrgChartServiceHelper.getChartStyleByIds((String)searchChartData.getChartStyleId());
            chartStyle = (ChartStyle)styleMap.get(searchChartData.getChartStyleId());
            virtualorgStyle = (ChartStyle)styleMap.get("1004");
        } else {
            String chartStyleStr = this.getPageCache().get("MATCH_CHART_STYLE_KEY");
            if (StringUtils.isEmpty((CharSequence)chartStyleStr)) {
                Map styleMap = OrgChartServiceHelper.getChartStyleByIds((String)"1001");
                chartStyle = (ChartStyle)styleMap.get(searchChartData.getChartStyleId());
                virtualorgStyle = (ChartStyle)styleMap.get("1004");
            } else {
                chartStyle = (ChartStyle)JSONObject.parseObject((String)chartStyleStr, ChartStyle.class);
                virtualorgStyle = OrgChartServiceHelper.getChartStyleById((String)"1004");
            }
        }
        result.put("MATCH_CHART_STYLE_KEY", chartStyle);
        result.put("virtualorg_style", virtualorgStyle);
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye((ChartStyle)chartStyle, (List)OrgChartServiceHelper.getDesensitizeFields((long)OrgChartConstants.ORG_CARDDISSION)));
        PersonalStyleData personalStyleData = null;
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getPersonalStyleId())) {
            personalStyleData = OrgChartServiceHelper.getPersonalStyleById((String)searchChartData.getPersonalStyleId());
        } else {
            DynamicObject personalStyle = this.getDefaultPersonalStyle(chartStyle == null ? "" : chartStyle.getId(), searchChartData.getOrgs());
            if (personalStyle != null) {
                String content = personalStyle.getString("content_tag");
                personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
                personalStyleData.setId(personalStyle.getString("id"));
            }
        }
        result.put("personalStyle", personalStyleData);
        result.put("hasPersonalStyle", personalStyleData != null ? 1 : 0);
        if (searchChartData.isOpenPersonalStyle() != null) {
            result.put("isOpenPersonalStyle", searchChartData.isOpenPersonalStyle() != false ? 1 : 0);
        } else {
            String isOpenPersonalStyle = this.getPageCache().get("0");
            result.put("isOpenPersonalStyle", "1".equals(isOpenPersonalStyle) ? 1 : 0);
        }
        result.put("showLevel", searchChartData.getShowLevel());
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getTeamOtClassify())) {
            List otclassifyIds = searchChartData.getTeamOtClassify().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showOtclassifys", OrgChartServiceHelper.getOtClassifys(otclassifyIds));
        } else {
            result.put("showOtclassifys", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getAdminOrgTypes())) {
            List adminOrgTypeIds = searchChartData.getAdminOrgTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showAdminOrgTypes", OrgChartServiceHelper.getAdminOrgTypes(adminOrgTypeIds));
        } else {
            result.put("showAdminOrgTypes", new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getCoopRelTypes())) {
            List cooprelTypeIds = searchChartData.getCoopRelTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showCooprelTypes", OrgChartServiceHelper.getCoopRelTypes(cooprelTypeIds));
        } else {
            result.put("showCooprelTypes", new ArrayList());
        }
        result.put("orgchartdirection", searchChartData.getOrgChartDirection());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getSchemeId())) {
            result.put("showScheme", new SchemeQuery().getScheme(searchChartData.getSchemeId()));
        } else {
            result.put("showScheme", null);
        }
        result.put("orgs", OrgChartServiceHelper.getOrgInfo((List)searchChartData.getOrgs()));
        List schemes = OrgChartServiceHelper.getSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (boolean)false, (String)this.getStructProjectId());
        result.put("schemes", schemes);
        JSONObject showOrgTeam = this.getShowOrgTeam(searchChartData.getCurrentOrgChartRootNodeId(), searchChartData.getDateField(), searchChartData.getOrgs());
        result.put("showOrgTeam", showOrgTeam);
        return result;
    }

    private JSONObject getShowOrgTeam(String currentOrgId, Date queryDate, List<String> orgIds) {
        JSONObject showOrgTeam = null;
        if (!StringUtils.isEmpty((CharSequence)currentOrgId)) {
            showOrgTeam = OrgChartViewDetailsPlugin.getAdminOrgBaseInfo(currentOrgId, queryDate, orgIds);
        }
        return showOrgTeam;
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String operateName;
        String eventArgs = customEventArgs.getEventArgs();
        switch (operateName = customEventArgs.getEventName()) {
            case "initParamsKey": {
                this.initParams();
                break;
            }
            case "searchChartData": {
                SearchChartData searchChartData = (SearchChartData)JSONObject.parseObject((String)eventArgs, SearchChartData.class);
                this.queryChart(searchChartData);
                break;
            }
            case "refreshOrgChart": {
                this.refresh();
                break;
            }
            case "schemeQueryOrgChart": {
                this.schemeQuery(eventArgs);
                break;
            }
            case "analyseScheme": {
                this.analyseSchemeById(eventArgs);
                break;
            }
            case "changeQueryCondition": {
                this.changeQueryCondition(eventArgs);
                break;
            }
            case "commonConditionQuery": {
                this.refreshTreeData(OrgChartServiceHelper.getDefaultFilter((Date)new Date()), "commonConditionQuery", OrgChartServiceHelper.getDefaultSearchChartData((Date)new Date()));
                break;
            }
            case "nodeUpholeQuery": {
                HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IOrgChartCustomEventService.class, (String)IOrgChartCustomEventService.class.getName(), null);
                List plugins = pluginProxy.getPlugins();
                if (CollectionUtils.isEmpty((Collection)plugins)) {
                    this.upholeQuery(eventArgs);
                    break;
                }
                pluginProxy.callReplace(hrPlugin -> {
                    hrPlugin.nodeUpHoleQuery((AbstractTreeListPlugin)this, eventArgs);
                    return null;
                });
                break;
            }
            case "changeTopNodeQuery": {
                this.changeTopNodeQuery(eventArgs);
                break;
            }
            case "desensitizeInfoQuery": {
                this.desensitizeInfoQuery(eventArgs);
                break;
            }
            case "changeStructProjectQuery": {
                this.changeStructProjectQuery(eventArgs);
                break;
            }
            case "initDataQuery": {
                this.initDataQuery("initDataQuery");
                break;
            }
        }
    }

    private void initDataQuery(String dataFlag) {
        String structProjectId = this.getStructProjectId();
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (String)this.getStructProjectId());
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)new Date());
        this.getPageCache().put("termRemain", "1");
        if (defaultScheme != null) {
            OrgChartQueryParam orgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
            SearchChartData searchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            String error = OrgChartServiceHelper.checkScheme((SearchChartData)searchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, (HasPermOrgResult)this.permOrg, (String)structProjectId);
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                error = error.substring(0, error.length() - 1);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u201c%s\u201d\u9009\u5b9a\u7684\u503c\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5207\u6362\u5230\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u9ed8\u8ba4\u7684\u503c\u8fdb\u884c\u67e5\u770b\u3002", (String)"OrgChartPlugin_18", (String)"odc-homs-formplugin", (Object[])new Object[]{error}));
                this.refreshTreeByDefaultSearchChartData(defaultFilter, dataFlag);
            } else {
                this.queryOrgChartByScheme(orgChartQueryParam, searchChartData, defaultScheme, dataFlag);
            }
        } else {
            this.refreshTreeByDefaultSearchChartData(defaultFilter, dataFlag);
        }
    }

    public void desensitizeInfoQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String currentNodeId = jsonObject.getString("currentNodeId");
        String personName = jsonObject.getString("personname");
        int isDesensitize = jsonObject.getInteger("isDesensitize");
        Date queryDate = this.getDate();
        HashMap<String, String> result = new HashMap<String, String>();
        Object resultValue = personName;
        if (!StringUtils.isEmpty((CharSequence)personName)) {
            resultValue = OrgChartServiceHelper.getPersonDesensitizeValue((String)currentNodeId, (String)personName, (int)isDesensitize, (Date)queryDate);
        }
        result.put("personname", (String)resultValue);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"desensitizeInfoQuery", result, (CustomControl)customcontrol);
    }

    public void changeTopNodeQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String currentNodeId = jsonObject.getString("currentNodeId");
        boolean hasOrgPerm = this.checkNodePerm(currentNodeId);
        if (!StringUtils.isEmpty((CharSequence)currentNodeId) && hasOrgPerm) {
            SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
            TreeNode treeNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(currentNodeId);
            if (treeNode != null) {
                if (!searchChartData.getCoopRelTypes().contains("1010")) {
                    searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
                    this.queryChart(searchChartData);
                    this.focusNode(this.getTreeListView().getTreeView(), this.treeListView.getTreeModel().getRoot(), this.treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId));
                } else {
                    searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
                    this.nodeClick(currentNodeId, this.getTreeListView().getTreeView(), searchChartData, "queryTreeNodeData", null);
                }
            }
        }
    }

    private void upholeQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String parentNodeId = jsonObject.getString("parentNodeId");
        SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
        if (!searchChartData.getCoopRelTypes().contains("1010")) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            Long orgTeamCoopOregTeamId = OrgChartServiceHelper.getOrgTeamCoopOregTeamId((Long)Long.parseLong(searchChartData.getCurrentOrgChartRootNodeId()), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermOrgs((AbstractFormPlugin)this), (SearchChartData)searchChartData);
            if (orgTeamCoopOregTeamId != null) {
                searchChartData.setCurrentOrgChartRootNodeId(String.valueOf(orgTeamCoopOregTeamId));
                this.queryChart(searchChartData);
                this.buildTreeAndFocusNode(searchChartData, String.valueOf(orgTeamCoopOregTeamId));
            }
        } else {
            TreeNode treeNode;
            boolean hasOrgPerm = this.checkNodePerm(parentNodeId);
            if (!StringUtils.isEmpty((CharSequence)parentNodeId) && hasOrgPerm && (treeNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(parentNodeId)) != null) {
                searchChartData.setCurrentOrgChartRootNodeId(parentNodeId);
                this.nodeClick(parentNodeId, this.getTreeListView().getTreeView(), searchChartData, "queryTreeNodeData", null);
            }
        }
    }

    private boolean checkNodePerm(String nodeId) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!(StringUtils.isEmpty((CharSequence)nodeId) || permOrgResultWithSub.isHasAllOrgPerm() || this.getPermOrgs((AbstractFormPlugin)this).contains(Long.parseLong(nodeId)))) {
            SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
            QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
            defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
            DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(nodeId));
            String showErrorInfo = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u201c%s\u201d\u7684\u6743\u9650\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u4e3a\u56fe\u5f62\u9876\u70b9\u3002", (String)"OrgChartPlugin_27", (String)"odc-homs-formplugin", (Object[])new Object[0]), rootDyn.getString("name"));
            this.getView().showTipNotification(showErrorInfo);
            return false;
        }
        return true;
    }

    private void schemeQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterScheme scheme = new SchemeQuery().getScheme(schemeId);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"OrgChartPlugin_28", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        OrgChartQueryParam schemeOrgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)scheme);
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)schemeOrgChartQueryParam);
        if (this.validateScheme(schemeSearchChartData)) {
            this.queryOrgChartByScheme(schemeOrgChartQueryParam, schemeSearchChartData, scheme, "queryTreeNodeData");
        } else {
            this.getPageCache().put("schemeId", schemeId);
        }
    }

    private boolean validateScheme(SearchChartData schemeSearchChartData) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        String errorDesc = OrgChartServiceHelper.checkScheme((SearchChartData)schemeSearchChartData, (String)schemeSearchChartData.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, (HasPermOrgResult)this.permOrg, (String)this.getStructProjectId());
        if (HRStringUtils.isNotEmpty((String)errorDesc)) {
            errorDesc = errorDesc.substring(0, errorDesc.length() - 1);
            errorDesc = errorDesc + ResManager.loadKDString((String)"\u53d1\u751f\u53d8\u52a8\uff0c\u65b9\u6848\u4e0d\u53ef\u67e5\u8be2\uff0c\u53ef\u80fd\u4e3a\u4ee5\u4e0b\u539f\u56e0\uff1a\u2460\u6ca1\u6709\u5bf9\u5e94\u6743\u9650 \u2461\u5b57\u6bb5\u7684\u503c\u88ab\u5220\u9664\u3002", (String)"OrgChartPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0]) + "\n";
            errorDesc = errorDesc + ResManager.loadKDString((String)"\u60a8\u53ef\u5220\u9664\u65b9\u6848\u6216\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"OrgChartPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)errorDesc)) {
            this.showSchemeQueryErrorInfo(errorDesc);
            CustomControl customcontrol1 = (CustomControl)this.getView().getControl("customcontrolap1");
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            OrgChartServiceHelper.setErrorDataForSearchCustomControl((String)"queryError", new HashMap(), (CustomControl)customcontrol1, (String)" ");
            OrgChartServiceHelper.setSimpleDataForCustomControl((String)"queryError", new HashMap(), (CustomControl)customcontrol, (String)"500", (String)" ");
            return false;
        }
        return true;
    }

    private void initParams() {
        String structProjectId = this.getStructProjectId();
        this.initParams("initParamsKey", structProjectId);
    }

    private void changeStructProjectQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String structProjectId = jsonObject.getString("id");
        this.getView().getPageCache().put("STRUCT_PROJECT_KEY", structProjectId);
        this.getView().getPageCache().put("STRUCT_PROJECT_CHANGE_KEY", Boolean.TRUE.toString());
        this.getView().getPageCache().remove("real_rootorg_structlongnumber");
        this.initParams("changeStructProjectQuery", structProjectId);
    }

    private void initParams(String eventKey, String structProjectId) {
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (String)this.getStructProjectId());
        OrgChartQueryParam orgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
        if (defaultScheme != null) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            String error = OrgChartServiceHelper.checkScheme((SearchChartData)schemeSearchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, (HasPermOrgResult)this.permOrg, (String)structProjectId);
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                orgChartQueryParam = null;
                defaultScheme = null;
            }
        }
        this.getAndSendResponseParams(true, orgChartQueryParam, defaultScheme, structProjectId, eventKey);
        if (!HRObjectUtils.isEmpty((Object)orgChartQueryParam) && orgChartQueryParam != null && orgChartQueryParam.isOpenPersonalStyle()) {
            this.getPageCache().put("0", "1");
        }
    }

    private void changeQueryCondition(String eventArgs) {
        SearchChartData searchChartData = (SearchChartData)JSONObject.parseObject((String)eventArgs, SearchChartData.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.getChangeQueryConditionParams(searchChartData.getOrgs(), searchChartData.getDateField(), searchChartData.getCoopRelTypes(), searchChartData.getChartStyleId(), searchChartData.getCurrentOrgChartRootNodeId(), result);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"changeQueryCondition", result, (CustomControl)customcontrol);
    }

    private void refresh() {
        SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
        searchChartData.setCurrentOrgChartRootNodeId(null);
        String chartStyleId = this.checkChartStyleExistAndFindMatchChartStyle(searchChartData.getChartStyleId());
        if (!StringUtils.isEmpty((CharSequence)chartStyleId)) {
            searchChartData.setChartStyleId(chartStyleId);
        }
        this.getPageCache().put("termRemain", "1");
        this.refreshTreeData(OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField()), "refreshOrgChart", searchChartData);
    }

    private void analyseSchemeById(String eventArgs) {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterScheme scheme = new SchemeQuery().getScheme(schemeId);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"OrgChartPlugin_28", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        OrgChartQueryParam schemeOrgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)scheme);
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)schemeOrgChartQueryParam);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        String errorDesc = OrgChartServiceHelper.checkScheme((SearchChartData)schemeSearchChartData, (String)schemeOrgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, (HasPermOrgResult)this.permOrg, (String)this.getStructProjectId());
        if (StringUtils.isNotEmpty((CharSequence)errorDesc)) {
            return;
        }
        if (schemeOrgChartQueryParam.isOpenPersonalStyle()) {
            this.getPageCache().put("0", "1");
        } else {
            this.getPageCache().remove("0");
        }
        Map queryShowParamsByScheme = OrgChartServiceHelper.getQueryShowParamsByScheme((OrgChartQueryParam)schemeOrgChartQueryParam, (FilterScheme)scheme);
        Date queryDate = OrgChartServiceHelper.getQueryDate((OrgChartQueryParam)schemeOrgChartQueryParam);
        JSONObject showOrgTeam = this.getShowOrgTeam(schemeOrgChartQueryParam.getCurrentOrgChartRootNodeId(), queryDate, schemeOrgChartQueryParam.getOrgs());
        Object chartStyle = queryShowParamsByScheme.get("MATCH_CHART_STYLE_KEY");
        if (!HRObjectUtils.isEmpty(chartStyle)) {
            result.put("showOrgTeam", showOrgTeam);
            result.putAll(queryShowParamsByScheme);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"analyseScheme", result, (CustomControl)customcontrol);
    }

    private void queryOrgChartByScheme(OrgChartQueryParam schemeOrgChartQueryParam, SearchChartData schemeSearchChartData, FilterScheme scheme, String dataFlag) {
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)schemeSearchChartData));
        this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)schemeSearchChartData.getOrgs()));
        this.getPageCache().put("datefield", HRDateTimeUtils.format((Date)schemeSearchChartData.getDateField(), (String)"yyyy-MM-dd"));
        QFilter defaultFilter = OrgChartServiceHelper.getSchemeFilter((OrgChartQueryParam)schemeOrgChartQueryParam);
        OrgChartTreeNode virtualNode = this.getAllOrgNoParentVirtualNodes(defaultFilter, schemeOrgChartQueryParam.getOrgs(), schemeSearchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)schemeOrgChartQueryParam.getOrgs()));
        defaultFilter.and(this.buildStructProjectFilter());
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(schemeSearchChartData.getCurrentOrgChartRootNodeId()));
        OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(OrgChartServiceHelper.getSchemeFilter((OrgChartQueryParam)schemeOrgChartQueryParam), schemeSearchChartData.getOrgs(), schemeSearchChartData.getDateField());
        this.setVirtualNode(virtualNode, (TreeNode)rootNode);
        this.setRootNodeToTreeView(rootNode, rootNode);
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        this.searchBuildTree(selectFields, serviceHelper, rootDyn, schemeSearchChartData.getOrgs(), schemeSearchChartData.getDateField());
        Map<String, Object> queryShowParams = this.getQueryShowParams(schemeOrgChartQueryParam, null, scheme);
        this.nodeClick(rootDyn.getString("orgteam.boid"), this.getTreeListView().getTreeView(), schemeSearchChartData, dataFlag, queryShowParams);
    }

    private void setVirtualNode(OrgChartTreeNode virtualNode, TreeNode rootNode) {
        if (virtualNode != null && rootNode != null) {
            List children = rootNode.getChildren();
            if (children == null || children.isEmpty()) {
                OrgChartTreeNode lastNode = OrgChartServiceHelper.getVirtualNode();
                lastNode.setParentid(rootNode.getId());
                rootNode.addChild((TreeNode)lastNode);
                return;
            }
            Set nodeIds = children.stream().map(node -> node.getId()).collect(Collectors.toSet());
            if (!nodeIds.contains("virtual100000")) {
                OrgChartTreeNode lastNode = OrgChartServiceHelper.getVirtualNode();
                lastNode.setParentid(rootNode.getId());
                rootNode.addChild((TreeNode)lastNode);
            }
        }
    }

    private void queryChart(SearchChartData searchChartData) {
        if (this.checkSearchCharData(searchChartData)) {
            return;
        }
        String chartStyleId = this.checkChartStyleExistAndFindMatchChartStyle(searchChartData.getChartStyleId());
        if (!StringUtils.isEmpty((CharSequence)chartStyleId)) {
            searchChartData.setChartStyleId(chartStyleId);
        }
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)searchChartData));
        String queryOrgIds = this.getPageCache().get("queryOrgId");
        List orgIds = JSONObject.parseArray((String)queryOrgIds, String.class);
        boolean isChange = OrgChartServiceHelper.coreQueryConditionIsChange((Date)searchChartData.getDateField(), (Date)this.getDate(), (List)searchChartData.getOrgs(), (List)orgIds);
        LOG.info("queryChart isChange = {}", (Object)String.valueOf(isChange));
        if (isChange || HRStringUtils.isNotEmpty((String)this.getView().getPageCache().get("STRUCT_PROJECT_CHANGE_KEY"))) {
            this.getPageCache().put("datefield", HRDateTimeUtils.format((Date)(searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField()), (String)"yyyy-MM-dd"));
            this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)searchChartData.getOrgs()));
            searchChartData.setCurrentOrgChartRootNodeId(null);
            this.refreshTreeData(OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField()), "queryTreeNodeData", searchChartData);
            this.getView().getPageCache().remove("STRUCT_PROJECT_CHANGE_KEY");
        } else {
            String isOpenPersonal = this.getPageCache().get("0");
            OrgChartTreeNode currentNode = null;
            if ("1".equals(isOpenPersonal) && !StringUtils.isEmpty((CharSequence)searchChartData.getPersonalStyleId())) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_personalstyle");
                DynamicObject personalStyle = serviceHelper.queryOne("id,name,rootorg,content,content_tag", (Object)Long.parseLong(searchChartData.getPersonalStyleId()));
                if (personalStyle != null) {
                    String content = personalStyle.getString("content_tag");
                    PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
                    personalStyleData.setId(personalStyle.getString("id"));
                    personalStyleData.getSearchChartData().setCurrentOrgChartRootNodeId(personalStyle.getString("rootorg.id"));
                    personalStyleData.getSearchChartData().setPersonalStyleId(searchChartData.getPersonalStyleId());
                    searchChartData = personalStyleData.getSearchChartData();
                    LOG.info("queryRootOrgChartData begin.");
                    TreeNode rootOrgChartData = this.queryRootOrgChartData(searchChartData);
                    currentNode = this.queryCurrentOrgChartData(rootOrgChartData, searchChartData);
                    if (currentNode != null) {
                        this.buildTreeAndFocusNode(searchChartData, currentNode.getId());
                    }
                }
            } else {
                LOG.info("queryRootOrgChartData start.");
                TreeNode rootOrgChartData = this.queryRootOrgChartData(searchChartData);
                currentNode = this.queryCurrentOrgChartData(rootOrgChartData, searchChartData);
            }
            Map<String, Object> queryShowParams = this.getQueryShowParams(null, searchChartData, null);
            if (currentNode == null) {
                queryShowParams.put("maxLevel", 0);
            }
            queryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty((Object)currentNode));
            List schemes = OrgChartServiceHelper.getSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (boolean)true, (String)this.getStructProjectId());
            queryShowParams.put("schemes", schemes);
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"queryTreeNodeData", queryShowParams, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(queryShowParams);
            resultMap.put("data", currentNode);
            this.setSimpleDataForCustomControl("queryTreeNodeData", resultMap);
            resultMap.put("operateType", OrgChartOperateTypes.CONDITION_QUERY.getValue());
        }
    }

    public void buildTreeAndFocusNode(SearchChartData searchChartData, String currentNodeId) {
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper structureServiceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(currentNodeId));
        if (rootDyn != null) {
            this.searchBuildTree(selectFields, structureServiceHelper, rootDyn, searchChartData.getOrgs(), searchChartData.getDateField());
            this.focusNode(this.getTreeListView().getTreeView(), this.getTreeModel().getRoot(), this.getTreeModel().getRoot().getTreeNode(currentNodeId));
        }
    }

    private boolean checkSearchCharData(SearchChartData searchChartData) {
        String schemeDateFiled = ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u3001", (String)"OrgChartPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeAdminOrgTypeFiled = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3001", (String)"OrgChartPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeChartStyle = ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f\u3001", (String)"OrgChartPlugin_21", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeOrgFiled = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"OrgChartPlugin_22", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        if (HRObjectUtils.isEmpty((Object)searchChartData.getDateField())) {
            builder.append(schemeDateFiled);
        }
        if (CollectionUtils.isEmpty((Collection)searchChartData.getAdminOrgTypes())) {
            builder.append(schemeAdminOrgTypeFiled);
        }
        if (HRStringUtils.isEmpty((String)searchChartData.getChartStyleId())) {
            builder.append(schemeChartStyle);
        }
        if (CollectionUtils.isEmpty((Collection)searchChartData.getOrgs())) {
            builder.append(schemeOrgFiled);
        }
        if (builder.length() > 0) {
            String error = builder.substring(0, builder.length() - 1);
            String tipMessage = ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgChartPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[]{error});
            this.getView().showErrorNotification(tipMessage);
            OrgChartServiceHelper.setErrorDataForSearchCustomControl((String)"queryError", new HashMap(), (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")), (String)" ");
            OrgChartServiceHelper.setSimpleDataForCustomControl((String)"queryError", new HashMap(), (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")), (String)"500", (String)" ");
            return true;
        }
        return false;
    }

    private TreeNode queryRootOrgChartData(SearchChartData searchChartData) {
        OrgChartTreeNode rootNode;
        String currentNodeId = searchChartData.getCurrentOrgChartRootNodeId();
        if (StringUtils.isEmpty((CharSequence)currentNodeId)) {
            return null;
        }
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
        defaultFilter.and(this.buildStructProjectFilter());
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(currentNodeId));
        if (rootDyn == null) {
            return null;
        }
        if (!searchChartData.getCoopRelTypes().contains("1010")) {
            LOG.info("getOtherCoopRelOrgChartNode begin.");
            rootNode = this.getOtherCoopRelOrgChartNode(searchChartData, currentNodeId);
        } else {
            LOG.info("getOrgChartTreeNode begin.");
            rootNode = this.getOrgChartTreeNode(searchChartData, rootDyn, false);
        }
        return rootNode;
    }

    private OrgChartTreeNode getOrgChartTreeNode(SearchChartData searchChartData, DynamicObject rootDyn, boolean isLeftTree) {
        LOG.info("getOrgChartTreeNode begin.");
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
        defaultFilter.and(this.buildStructProjectFilter());
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(defaultFilter, rootDyn.getInt("level"), rootDyn.getString("structlongnumber"), isLeftTree, searchChartData.getOrgs(), searchChartData.getDateField());
        List<OrgChartTreeNode> treeNodes = this.getOrgChartChildTreeNode(defaultFilter, rootDyn, treeViewCollection);
        OrgChartTreeNode rootNode = treeNodes.get(treeNodes.size() - 1);
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, treeNodes);
        if (!isLeftTree) {
            LOG.info("getOrgChartTreeNode isLeftTree.");
            this.setShowFieldInfos(treeNodes, searchChartData, rootNode);
        }
        return rootNode;
    }

    private OrgChartTreeNode getOtherCoopRelOrgChartNode(SearchChartData searchChartData, String currentNodeId) {
        LOG.info("getOtherCoopRelOrgChartNode begin.");
        List<OrgChartTreeNode> treeNodes = this.getOtherCooprelTypeOrgNodes(searchChartData, currentNodeId);
        OrgChartTreeNode rootNode = treeNodes.get(0);
        this.setShowFieldInfos(treeNodes, searchChartData, rootNode);
        int mavLevel = OrgChartServiceHelper.calculateLevel((OrgChartTreeNode)rootNode);
        this.getPageCache().put("MAX_LEVEL_KEY", String.valueOf(mavLevel));
        return rootNode;
    }

    private List<OrgChartTreeNode> getOtherCoopRelTypeOrgChartChildTreeNode(Map<Long, Set<Long>> orgIdCoopOrgIdsMap, DynamicObjectCollection treeViewCollection, Long currentNodeId) {
        Map orgTeamIdOrgTypeMap = OrgChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)this.getDate());
        Map<Long, DynamicObject> orgIdOrgMap = treeViewCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("orgteam.boid"), dy1 -> dy1, (s1, s2) -> s2));
        ArrayList<OrgChartTreeNode> orgChartTreeNodes = new ArrayList<OrgChartTreeNode>();
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Object> permOrgs = new ArrayList();
        boolean chartAllCooperationOrgParameter = SystemParamHelper.getChartAllCooperationOrgParameter();
        if (chartAllCooperationOrgParameter && !permOrgResultWithSub.isHasAllOrgPerm()) {
            permOrgs = this.getPermOrgs((AbstractFormPlugin)this);
        }
        DynamicObject rootOrg = orgIdOrgMap.get(currentNodeId);
        OrgChartTreeNode rootNode = OrgChartServiceHelper.wrapTreeNode((DynamicObject)rootOrg, (Map)orgTeamIdOrgTypeMap);
        orgChartTreeNodes.add(rootNode);
        OrgChartServiceHelper.buildCoopRelOrgTreeNode(orgIdCoopOrgIdsMap, (Map)orgTeamIdOrgTypeMap, orgIdOrgMap, (OrgChartTreeNode)rootNode, orgChartTreeNodes);
        for (OrgChartTreeNode orgChartTreeNode : orgChartTreeNodes) {
            if (!chartAllCooperationOrgParameter || permOrgResultWithSub.isHasAllOrgPerm() || permOrgs.contains(Long.parseLong(orgChartTreeNode.getId()))) continue;
            orgChartTreeNode.setIsPermOrg(Integer.valueOf(0));
        }
        return orgChartTreeNodes;
    }

    private List<OrgChartTreeNode> getOtherCooprelTypeOrgNodes(SearchChartData searchChartData, String currentNodeId) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        DynamicObjectCollection cooperRelDys = OrgChartServiceHelper.getAllCoopRelInfos((List)searchChartData.getCoopRelTypes(), (Date)searchChartData.getDateField());
        Set<Long> orgIds = searchChartData.getOrgs().stream().map(Long::parseLong).collect(Collectors.toSet());
        Map<Long, Boolean> orgIdShowAllCoopOrgMap = this.getShowAllCoopOrgFlag((AbstractFormPlugin)this, orgIds);
        Map<Long, Set<Long>> orgIdCoopOrgIdsAllMap = this.getAcceptCoopRelOrgIds(permOrgResultWithSub, cooperRelDys, orgIdShowAllCoopOrgMap, searchChartData.getOrgs());
        ArrayList<Long> coopRelNodeIds = new ArrayList<Long>();
        HashMap<Long, Set<Long>> orgIdCoopOrgIdsMap = new HashMap<Long, Set<Long>>();
        OrgChartServiceHelper.findCoopOrgIds(orgIdCoopOrgIdsAllMap, orgIdCoopOrgIdsMap, coopRelNodeIds, (long)Long.parseLong(currentNodeId));
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
        DynamicObjectCollection treeViewCollection = this.getOtherCooprelTypeTreeViewCollection(defaultFilter, coopRelNodeIds);
        List<OrgChartTreeNode> treeNodes = this.getOtherCoopRelTypeOrgChartChildTreeNode(orgIdCoopOrgIdsMap, treeViewCollection, Long.parseLong(currentNodeId));
        return treeNodes;
    }

    private Map<Long, Set<Long>> getAcceptCoopRelOrgIds(AuthorizedOrgResultWithSub permOrgResultWithSub, DynamicObjectCollection cooperRelDys, Map<Long, Boolean> orgIdShowAllCoopOrgMap, List<String> orgIds) {
        HashMap<Long, Set<Long>> orgIdCoopOrgIdsMap = new HashMap<Long, Set<Long>>();
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            for (DynamicObject dObject : cooperRelDys) {
                Set coopOrgIds = orgIdCoopOrgIdsMap.getOrDefault(dObject.getLong("cooporgteam.id"), new HashSet());
                if (orgIds.contains(dObject.getString("org.org"))) {
                    coopOrgIds.add(dObject.getLong("org.id"));
                }
                orgIdCoopOrgIdsMap.put(dObject.getLong("cooporgteam.id"), coopOrgIds);
            }
        } else {
            List<Long> permOrgs = this.getPermOrgs((AbstractFormPlugin)this);
            for (DynamicObject dObject : cooperRelDys) {
                Boolean cooporgteamIsShowAllCoopOrg;
                Set coopOrgIds = orgIdCoopOrgIdsMap.getOrDefault(dObject.getLong("cooporgteam.id"), new HashSet());
                if (orgIds.contains(dObject.getString("org.org"))) {
                    Boolean isShowAllCoopOrg = orgIdShowAllCoopOrgMap.get(dObject.getLong("org.org"));
                    if (isShowAllCoopOrg != null && isShowAllCoopOrg.booleanValue()) {
                        coopOrgIds.add(dObject.getLong("org.id"));
                    } else if (permOrgs.contains(dObject.getLong("org.id"))) {
                        coopOrgIds.add(dObject.getLong("org.id"));
                    }
                }
                if ((cooporgteamIsShowAllCoopOrg = orgIdShowAllCoopOrgMap.get(dObject.getLong("cooporgteam.org"))) != null && cooporgteamIsShowAllCoopOrg.booleanValue()) {
                    orgIdCoopOrgIdsMap.put(dObject.getLong("cooporgteam.id"), coopOrgIds);
                    continue;
                }
                if (!permOrgs.contains(dObject.getLong("cooporgteam.id"))) continue;
                orgIdCoopOrgIdsMap.put(dObject.getLong("cooporgteam.id"), coopOrgIds);
            }
        }
        return orgIdCoopOrgIdsMap;
    }

    private DynamicObjectCollection getOtherCooprelTypeTreeViewCollection(QFilter qFilter, List<Long> cooprelNodeIds) {
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        QFilter orgFilter = new QFilter("orgteam.boid", "in", cooprelNodeIds);
        LOG.info("getOtherCooprelTypeTreeViewCollection orgFilter.and(qFilter)={}", (Object)JSONObject.toJSONString((Object)orgFilter.and(qFilter).toString()));
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        return structInstance.queryColl(selectFields, new QFilter[]{orgFilter, qFilter}, "index asc,orgteam.number asc");
    }

    private OrgChartTreeNode queryCurrentOrgChartData(TreeNode rootNode, SearchChartData searchChartData) {
        if (rootNode == null) {
            return null;
        }
        OrgChartTreeNode currentNode = (OrgChartTreeNode)rootNode.getTreeNode(searchChartData.getCurrentOrgChartRootNodeId());
        if (!OrgChartServiceHelper.isMatchCondition((OrgChartTreeNode)currentNode, (SearchChartData)searchChartData).booleanValue()) {
            currentNode = null;
        }
        if (currentNode != null) {
            OrgChartServiceHelper.findTreeNode((TreeNode)currentNode, (SearchChartData)searchChartData, (boolean)false);
            QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
            String currentRootParentOrg = OrgChartServiceHelper.getAdminOrgOrg((QFilter)defaultFilter, (String)currentNode.getParentid());
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            OrgChartServiceHelper.setNodeIsUphole((OrgChartTreeNode)currentNode, (AuthorizedOrgResultWithSub)permOrgResultWithSub, permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermOrgs((AbstractFormPlugin)this), (String)currentRootParentOrg, (SearchChartData)searchChartData);
        }
        return currentNode;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("openOrgTeamF7".equals(actionId)) {
            this.afterSelectOrgTeam(closedCallBackEvent);
        }
    }

    private void getChangeQueryConditionParams(List<String> orgIds, Date queryDate, List<String> coopreltypes, String chartStyleId, String currentNodeId, Map<String, Object> result) {
        OrgChartTreeNode firstPermOrgNode;
        DynamicObject personalStyle = this.getDefaultPersonalStyle(chartStyleId, orgIds);
        if (personalStyle != null) {
            String content = personalStyle.getString("content_tag");
            PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
            personalStyleData.setId(personalStyle.getString("id"));
            result.put("personalStyle", personalStyleData);
            String isOpenPersonalStyle = this.getPageCache().get("0");
            result.put("isOpenPersonalStyle", HRStringUtils.isNotEmpty((String)isOpenPersonalStyle) && HRStringUtils.equals((String)"1", (String)isOpenPersonalStyle));
        } else {
            result.put("personalStyle", null);
            result.put("isOpenPersonalStyle", false);
            this.getPageCache().remove("0");
        }
        result.put("hasPersonalStyle", personalStyle != null ? 1 : 0);
        QFilter qFilter = OrgChartServiceHelper.getDefaultFilter((Date)queryDate);
        if (StringUtils.isEmpty((CharSequence)currentNodeId)) {
            OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(qFilter, orgIds, queryDate);
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            firstPermOrgNode = OrgChartServiceHelper.findFirstPermOrgNode((OrgChartTreeNode)rootNode, permOrgResultWithSub.isHasAllOrgPerm() ? null : this.getPermOrgs((AbstractFormPlugin)this), orgIds, (boolean)permOrgResultWithSub.isHasAllOrgPerm());
            if (rootNode == null) {
                rootNode = this.getAllOrgNoParentVirtualNodes(qFilter, orgIds, queryDate);
                firstPermOrgNode = rootNode != null && rootNode.getChildren().size() > 0 ? (OrgChartTreeNode)rootNode.getChildren().get(0) : null;
            }
        } else {
            DynamicObject rootDyn = this.getRootDynByRootId(OrgChartServiceHelper.getDefaultFilter((Date)queryDate), Long.parseLong(currentNodeId));
            firstPermOrgNode = this.getLeftTreeNodes(qFilter, rootDyn, orgIds, queryDate);
        }
        JSONObject showOrgTeam = new JSONObject();
        if (firstPermOrgNode != null) {
            showOrgTeam.put("id", (Object)firstPermOrgNode.getId());
            showOrgTeam.put("name", (Object)firstPermOrgNode.getText());
            showOrgTeam.put("number", (Object)firstPermOrgNode.getNumber());
        }
        result.put("showOrgTeam", showOrgTeam);
        int showLevel = 3;
        int maxLevel = 5;
        if (coopreltypes.contains("1010")) {
            if (firstPermOrgNode != null) {
                DynamicObject rootDyn = this.getRootDynByRootId(OrgChartServiceHelper.getDefaultFilter((Date)queryDate), Long.parseLong(firstPermOrgNode.getId()));
                String structProjectId = this.getStructProjectId();
                AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
                List<Object> structLongNumberList = new ArrayList(16);
                ArrayList orgIdWithOutSub = new ArrayList(16);
                OrgChartServiceHelper.getHisPermStructLongNumberLikeAndOutSub((AuthorizedOrgResultWithSub)permOrgResultWithSub, orgIdWithOutSub, structLongNumberList, (Date)queryDate, (String)structProjectId);
                structLongNumberList = structLongNumberList.stream().map(dy -> dy + "%").collect(Collectors.toList());
                Set levels = OrgChartServiceHelper.calculateQueryLevelsByRootOrg((int)rootDyn.getInt("level"), (String)rootDyn.getString("structlongnumber"), (Date)this.getDate(), orgIdWithOutSub, structLongNumberList, Collections.singletonList(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID), (boolean)false, orgIds, (String)structProjectId);
                maxLevel = levels.size() + 1;
                showLevel = Math.min(maxLevel, 3);
            } else {
                showLevel = 0;
                maxLevel = 0;
            }
        }
        result.put("showLevel", showLevel);
        result.put("maxLevel", maxLevel);
    }

    private void afterSelectOrgTeam(ClosedCallBackEvent closedCallBackEvent) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject orgTeam;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows) && (orgTeam = (serviceHelper = new HRBaseServiceHelper("haos_adminorgteam")).queryOne("id,name,number,boid", selectedRows.get(0).getPrimaryKeyValue())) != null) {
            JSONObject orgTeamInfo = new JSONObject();
            orgTeamInfo.put("id", (Object)orgTeam.getString("boid"));
            orgTeamInfo.put("name", (Object)orgTeam.getString("name"));
            orgTeamInfo.put("number", (Object)orgTeam.getString("number"));
            HashMap<String, JSONObject> data = new HashMap<String, JSONObject>();
            data.put("data", orgTeamInfo);
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openOrgTeamF7", data, (CustomControl)customcontrol);
        }
    }

    protected TreeNode getLeftTreeRootNode(QFilter qFilter, List<String> orgIds, Date queryDate) {
        DynamicObject rootNodeDynamicObj;
        qFilter.and(this.buildStructProjectFilter());
        QFilter customFilter = ProxyUtils.getCustomFilter((String)this.getStructProjectId());
        if (customFilter != null) {
            qFilter.and(customFilter);
        }
        if ((rootNodeDynamicObj = this.getRootNodeDynamicObj(qFilter, orgIds, queryDate)) == null) {
            return null;
        }
        LOG.info("getLeftTreeRootNode rootId={}", (Object)rootNodeDynamicObj.getString("orgteam.id"));
        return this.getLeftTreeNodes(qFilter, rootNodeDynamicObj, orgIds, queryDate);
    }

    private OrgChartTreeNode getLeftTreeNodes(QFilter qFilter, DynamicObject rootNodeDynamicObj, List<String> orgIds, Date queryDate) {
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(qFilter, rootNodeDynamicObj.getInt("level"), rootNodeDynamicObj.getString("structlongnumber"), true, orgIds, queryDate);
        List<OrgChartTreeNode> treeNodes = this.getOrgChartChildTreeNode(qFilter, rootNodeDynamicObj, treeViewCollection);
        OrgChartTreeNode rootNode = treeNodes.get(treeNodes.size() - 1);
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, treeNodes);
        return rootNode;
    }

    protected OrgChartTreeNode getRightOrgChartRootNode(QFilter qFilter, SearchChartData searchChartData, String firstPermOrgNodeId) {
        OrgChartTreeNode rootNode;
        if (StringUtils.isEmpty((CharSequence)firstPermOrgNodeId)) {
            return null;
        }
        DynamicObject rootNodeDynamicObj = this.getRootDynByRootId(qFilter, Long.parseLong(firstPermOrgNodeId));
        if (rootNodeDynamicObj == null) {
            return null;
        }
        if (!searchChartData.getCoopRelTypes().contains("1010")) {
            rootNode = this.getOtherCoopRelOrgChartNode(searchChartData, firstPermOrgNodeId);
        } else {
            int rootLevel = rootNodeDynamicObj.getInt("level");
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            List<Object> structLongNumberList = new ArrayList(16);
            ArrayList orgIdWithOutSub = new ArrayList(16);
            String structProjectId = this.getStructProjectId();
            OrgChartServiceHelper.getHisPermStructLongNumberLikeAndOutSub((AuthorizedOrgResultWithSub)permOrgResultWithSub, orgIdWithOutSub, structLongNumberList, (Date)searchChartData.getDateField(), (String)structProjectId);
            structLongNumberList = structLongNumberList.stream().map(dy -> dy + "%").collect(Collectors.toList());
            Map levelAndOrgCountMap = OrgChartServiceHelper.getLevelAndOrgCountByRootOrg((int)rootNodeDynamicObj.getInt("level"), (String)rootNodeDynamicObj.getString("structlongnumber"), (Date)this.getDate(), orgIdWithOutSub, structLongNumberList, Collections.singletonList(1010L), (List)searchChartData.getOrgs(), (String)structProjectId);
            if (levelAndOrgCountMap.getOrDefault(rootLevel + 1, 0L) > 3000L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf\u8f83\u591a\uff0c\u4e3a\u4fdd\u8bc1\u60a8\u7684\u4f7f\u7528\u4f53\u9a8c\uff0c\u5df2\u81ea\u52a8\u5c06\u663e\u793a\u5c42\u7ea7\u8c03\u6574\u4e3a\u201c%s\u201d\u3002", (String)"OrgChartPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]), 1));
            }
            rootNode = this.getOrgChartTreeNode(searchChartData, rootNodeDynamicObj, false);
        }
        if (rootNode.getChildren() != null && rootNode.getChildren().size() == 0) {
            rootNode.setChildren(null);
        }
        return rootNode;
    }

    private List<OrgChartTreeNode> getOrgChartChildTreeNode(QFilter qFilter, DynamicObject rootNodeDynamicObj, DynamicObjectCollection treeViewCollection) {
        String treeNodeName;
        Date queryDate = this.getDate();
        treeViewCollection.add((Object)rootNodeDynamicObj);
        Map orgTeamIdOrgTypeMap = OrgChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)queryDate);
        List<OrgChartTreeNode> chartTreeNodeList = this.getOrgChartTreeNodes(qFilter, treeViewCollection, orgTeamIdOrgTypeMap, queryDate);
        OrgChartTreeNode treeNode = OrgChartServiceHelper.getRootTreeNode((DynamicObject)rootNodeDynamicObj, (Map)orgTeamIdOrgTypeMap, (boolean)true);
        if (chartTreeNodeList.size() < 1) {
            treeNode = OrgChartServiceHelper.getRootTreeNode((DynamicObject)rootNodeDynamicObj, (Map)orgTeamIdOrgTypeMap, (boolean)false);
        }
        if (this.isShowCompanyName() && HRStringUtils.isNotEmpty((String)(treeNodeName = ProxyUtils.getLeftTreeNodeName((Long)Long.parseLong(treeNode.getBoid()), (Date)queryDate, (String)this.getStructProjectId())))) {
            String name = String.format(Locale.ROOT, "%s\uff08%s\uff09", treeNode.getText(), treeNodeName);
            treeNode.setText(name);
        }
        chartTreeNodeList.add(treeNode);
        return chartTreeNodeList;
    }

    private List<OrgChartTreeNode> getOrgChartTreeNodes(QFilter qFilter, DynamicObjectCollection treeViewCollection, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap, Date queryDate) {
        ArrayList orgTeamIds = new ArrayList();
        HashMap orgTeamIdNodeMap = new HashMap();
        List<OrgChartTreeNode> chartTreeNodeList = treeViewCollection.stream().map(dy -> {
            OrgChartTreeNode orgChartTreeNode = OrgChartServiceHelper.wrapTreeNode((DynamicObject)dy, (Map)orgTeamIdOrgTypeMap);
            long orgTeamId = Long.parseLong(orgChartTreeNode.getId());
            orgTeamIds.add(orgTeamId);
            orgTeamIdNodeMap.put(orgTeamId, orgChartTreeNode);
            return orgChartTreeNode;
        }).collect(Collectors.toList());
        String structProjectId = this.getStructProjectId();
        OrgChartServiceHelper.calculateName(chartTreeNodeList, (Date)queryDate, (String)structProjectId, (boolean)this.isShowCompanyName());
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Object> permOrgIds = new ArrayList();
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            permOrgIds = this.getPermOrgs((AbstractFormPlugin)this);
        }
        if (!CollectionUtils.isEmpty(orgTeamIds)) {
            IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
            QFilter parentOrgTeamIdFilter = new QFilter("parentorgteam.id", "in", orgTeamIds);
            if (!CollectionUtils.isEmpty(permOrgIds)) {
                parentOrgTeamIdFilter.and(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)structProjectId));
            }
            DynamicObjectCollection dynamicObjects = structInstance.queryColl("orgteam.id,parentorgteam.id", new QFilter[]{parentOrgTeamIdFilter, qFilter}, "index asc,orgteam.number asc");
            HashSet parentOrgTeamIds = new HashSet();
            dynamicObjects.forEach(dy -> parentOrgTeamIds.add(dy.getLong("parentorgteam.id")));
            if (!CollectionUtils.isEmpty(orgTeamIds)) {
                orgTeamIds.forEach(orgTeamId -> {
                    OrgChartTreeNode orgChartTreeNode = (OrgChartTreeNode)orgTeamIdNodeMap.get(orgTeamId);
                    if (parentOrgTeamIds.contains(orgTeamId)) {
                        orgChartTreeNode.setLeaf(false);
                        orgChartTreeNode.setChildren(new ArrayList());
                    } else {
                        orgChartTreeNode.setLeaf(true);
                        orgChartTreeNode.setChildren(null);
                    }
                });
            }
        }
        return chartTreeNodeList;
    }

    public String checkChartStyleExistAndFindMatchChartStyle(String chartStyleId) {
        Map chartStyleIdChartStyleMap;
        if (!StringUtils.isEmpty((CharSequence)chartStyleId) && CollectionUtils.isEmpty((Map)(chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles(Collections.singleton(chartStyleId))))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u6784\u56fe\u6837\u5f0f\u201d\u9009\u5b9a\u7684\u503c\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5207\u6362\u5230\u5e38\u7528\u8fc7\u6ee4\u6761\u4ef6\u9ed8\u8ba4\u7684\u503c\u8fdb\u884c\u67e5\u770b\u3002", (String)"OrgChartPlugin_17", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)OrgChartConstants.ORG_CARDDISSION);
            chartStyleIds.add("1001");
            chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles((Collection)chartStyleIds);
            ChartStyle matchChartStyle = OrgChartServiceHelper.findBestMatchChartStyle((Map)chartStyleIdChartStyleMap, (String)"1001");
            return matchChartStyle != null ? matchChartStyle.getId() : null;
        }
        return null;
    }

    private void setShowFieldInfos(List<OrgChartTreeNode> chartTreeNodeList, SearchChartData searchChartData, OrgChartTreeNode treeNode) {
        LOG.info("setShowFieldInfos begin.");
        ChartStyle matchChartStyle = this.getMatchChartStyle(searchChartData);
        if (matchChartStyle != null) {
            LOG.info("setShowFieldInfos matchChartStyle is not null.");
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            List<Object> permOrgIds = new ArrayList();
            if (!permOrgResultWithSub.isHasAllOrgPerm()) {
                permOrgIds = this.getPermOrgs((AbstractFormPlugin)this);
            }
            this.getPageCache().put("MATCH_CHART_STYLE_KEY", JSONObject.toJSONString((Object)matchChartStyle));
            this.getPageCache().put("MATCH_CHART_STYLE_ID", matchChartStyle.getId());
            String structProjectId = this.getStructProjectId();
            OrgChartServiceHelper.setShowFieldInfoToTreeNodes(chartTreeNodeList, (ChartStyle)matchChartStyle, (OrgChartTreeNode)treeNode, (SearchChartData)searchChartData, (String)structProjectId, permOrgIds);
        }
    }

    private ChartStyle getMatchChartStyle(SearchChartData searchChartData) {
        ChartStyle matchChartStyle;
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)OrgChartConstants.ORG_CARDDISSION);
        chartStyleIds.add("1001");
        Map chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles((Collection)chartStyleIds);
        String matchChartStyleId = this.getPageCache().get("MATCH_CHART_STYLE_ID");
        if (!StringUtils.isEmpty((CharSequence)matchChartStyleId) && StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            searchChartData.setChartStyleId(matchChartStyleId);
        }
        if (StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            if (!CollectionUtils.isEmpty((Map)chartStyleIdChartStyleMap)) {
                chartStyleIdChartStyleMap.remove("1004");
            }
            if ((matchChartStyle = OrgChartServiceHelper.findBestMatchChartStyle((Map)chartStyleIdChartStyleMap, (String)"1001")) == null) {
                matchChartStyle = (ChartStyle)chartStyleIdChartStyleMap.get("1001");
            }
        } else {
            matchChartStyle = (ChartStyle)chartStyleIdChartStyleMap.get(searchChartData.getChartStyleId());
        }
        if (!CollectionUtils.isEmpty((Map)chartStyleIdChartStyleMap)) {
            this.getPageCache().put("CHART_STYLE_KEY", JSONObject.toJSONString(chartStyleIdChartStyleMap.values()));
        }
        return matchChartStyle;
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String isOpenPersonalStyle = this.getPageCache().get("0");
        if ("1".equals(isOpenPersonalStyle)) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("changeTreeRoot", (IFormPlugin)this);
            String message = ResManager.loadKDString((String)"\u5c06\u9000\u51fa\u5f53\u524d\u4e2a\u6027\u5316\u6837\u5f0f\u7684\u67e5\u770b\uff0c\u524d\u5f80\u4ee5\u9009\u5b9a\u7ec4\u7ec7\u4e3a\u6839\u8282\u70b9\u7684\u7ed3\u6784\u56fe\uff0c\u8bf7\u786e\u8ba4\uff1f", (String)"OrgChartPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, ConfirmTypes.Default, callBackListener);
            this.getPageCache().put("CLICK_NODE_ID", treeNodeEvent.getNodeId().toString());
        } else {
            String currentNodeId = treeNodeEvent.getNodeId().toString();
            SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
            searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
            this.nodeClick(currentNodeId, (TreeView)treeNodeEvent.getSource(), searchChartData, "queryTreeNodeData", null);
        }
    }

    public void showSchemeQueryErrorInfo(String errorDesc) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("schemeQueryCallbackKey", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bf4", (String)"OrgChartPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u5220\u9664", (String)"OrgChartPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u67e5\u8be2\u65b9\u6848\u7684\u6761\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u8be2\uff0c\u662f\u5426\u5220\u9664\u65b9\u6848\uff1f", (String)"OrgChartPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, errorDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void nodeClick(String currentNodeId, TreeView tv, SearchChartData searchChartData, String dataFlag, Map<String, Object> queryShowParams) {
        DynamicObject rootDyn;
        if ("notInit100000".equals(currentNodeId) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currentNodeId)) {
            return;
        }
        searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)searchChartData));
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)searchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
        defaultFilter.and(this.buildStructProjectFilter());
        if ("virtual100000".equals(currentNodeId)) {
            searchChartData.setCurrentOrgChartRootNodeId(null);
            this.expandVirtualNode(defaultFilter, searchChartData.getOrgs(), searchChartData.getDateField());
            rootDyn = null;
        } else {
            rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(currentNodeId));
        }
        OrgChartTreeNode orgChartRootNode = null;
        boolean hasOrgPerm = true;
        String showErrorInfo = "";
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (rootDyn != null) {
            List<Long> permOrgIds;
            if (!permOrgResultWithSub.isHasAllOrgPerm() && !(permOrgIds = this.getPermOrgs((AbstractFormPlugin)this)).contains(Long.parseLong(currentNodeId))) {
                hasOrgPerm = false;
                showErrorInfo = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u70b9\u51fb\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"OrgChartPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), rootDyn.getString("name"));
            }
            OrgChartTreeNode leftRootNode = this.getLeftTreeNodes(defaultFilter, rootDyn, searchChartData.getOrgs(), searchChartData.getDateField());
            if (this.getTreeModel().getRoot().getTreeNode(leftRootNode.getId()) != null) {
                TreeNode rootNode = this.getTreeModel().getRoot().getTreeNode(leftRootNode.getId());
                if (!CollectionUtils.isEmpty((Collection)leftRootNode.getChildren())) {
                    rootNode.setChildren(leftRootNode.getChildren());
                } else {
                    rootNode.setChildren(null);
                }
                TreeNode root = this.getTreeListView().getTreeModel().getRoot();
                this.setVirtualNode(this.getAllOrgNoParentVirtualNodes(defaultFilter, searchChartData.getOrgs(), searchChartData.getDateField()), root);
                this.getTreeListView().getTreeModel().setRoot(root);
            }
            this.getTreeModel().setCurrentNodeId((Object)currentNodeId);
            this.focusNode(tv, this.treeListView.getTreeModel().getRoot(), this.treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId));
            if (hasOrgPerm) {
                defaultFilter.and(this.buildStructProjectFilter());
                orgChartRootNode = this.getRightOrgChartRootNode(defaultFilter, searchChartData, leftRootNode.getId());
            }
            if (orgChartRootNode != null && !OrgChartServiceHelper.isMatchCondition(orgChartRootNode, (SearchChartData)searchChartData).booleanValue()) {
                orgChartRootNode = null;
            }
        } else if ("virtual100000".equals(currentNodeId)) {
            hasOrgPerm = false;
            showErrorInfo = ResManager.loadKDString((String)"\u672c\u8282\u70b9\u65e0\u6570\u636e\uff0c\u8bf7\u70b9\u51fb\u5176\u5b83\u7ec4\u7ec7\u3002", (String)"OrgChartPlugin_32", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        } else {
            hasOrgPerm = false;
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
            showErrorInfo = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u70b9\u51fb\u5176\u4ed6\u7ec4\u7ec7\u3002", (String)"OrgChartPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[0]), treeNode != null ? treeNode.getText() : "");
            LOG.info("orgChart nodeClick not find currentNodeId:{},defaultFilter={}", (Object)currentNodeId, (Object)defaultFilter.toString());
        }
        if (orgChartRootNode != null) {
            OrgChartServiceHelper.findTreeNode(orgChartRootNode, (SearchChartData)searchChartData, (boolean)false);
            String currentRootParentOrg = OrgChartServiceHelper.getAdminOrgOrg((QFilter)defaultFilter, (String)orgChartRootNode.getParentid());
            OrgChartServiceHelper.setNodeIsUphole(orgChartRootNode, (AuthorizedOrgResultWithSub)permOrgResultWithSub, permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermOrgs((AbstractFormPlugin)this), (String)currentRootParentOrg, (SearchChartData)searchChartData);
            this.getPageCache().put("CURRENT_NODE_ID", currentNodeId);
        }
        if (queryShowParams == null) {
            queryShowParams = this.getQueryShowParams(null, searchChartData, null);
        }
        queryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty(orgChartRootNode));
        String maxLevel = this.getPageCache().get("MAX_LEVEL_KEY");
        CommonOrgChartServiceHelper.setTermRemaning(queryShowParams, (String)this.getPageCache().get("termRemain"));
        this.getPageCache().remove("termRemain");
        queryShowParams.put("maxLevel", StringUtils.isEmpty((CharSequence)maxLevel) ? "3" : maxLevel);
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)dataFlag, queryShowParams, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(queryShowParams);
        resultMap.put("data", orgChartRootNode);
        resultMap.put("operateType", OrgChartOperateTypes.NODE_CLICK.getValue());
        resultMap.put("hasOrgPerm", hasOrgPerm ? 1 : 0);
        resultMap.put("showErrorInfo", showErrorInfo);
        this.setSimpleDataForCustomControl(dataFlag, resultMap);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)"changeTreeRoot", (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String currentNodeId = this.getPageCache().get("CLICK_NODE_ID");
                this.getPageCache().remove("0");
                SearchChartData searchChartData = this.getSearchChartData(this.getStructProjectId());
                searchChartData.setOpenPersonalStyle(Boolean.valueOf(false));
                searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
                this.nodeClick(currentNodeId, this.getTreeListView().getTreeView(), searchChartData, "queryTreeNodeData", null);
            }
        } else if (HRStringUtils.equals((String)"schemeQueryCallbackKey", (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String schemeId = this.getPageCache().get("schemeId");
                FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_adminorgchart");
                filterContainer.deleteScheme(schemeId);
                this.sendNewSchemesToCustom();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
                HashMap result = new HashMap();
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"donothing", result, (CustomControl)customcontrol);
            }
        }
    }

    private void sendNewSchemesToCustom() {
        HashMap<String, List> result = new HashMap<String, List>();
        List schemes = OrgChartServiceHelper.getSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (boolean)true, (String)this.getStructProjectId());
        result.put("schemes", schemes);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"updateSchemesList", result, (CustomControl)customcontrol);
    }

    private SearchChartData getSearchChartData(String structProjectId) {
        String searchChartDataStr = this.getPageCache().get("CURRENT_SEARCH_CHART_ID");
        if (StringUtils.isNotEmpty((CharSequence)searchChartDataStr)) {
            return (SearchChartData)JSONObject.parseObject((String)searchChartDataStr, SearchChartData.class);
        }
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultSchemeWithFilter((String)"homs_adminorgchart", (String)RequestContext.get().getUserId(), (String)this.getStructProjectId());
        OrgChartQueryParam orgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
        if (defaultScheme != null) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            String error = OrgChartServiceHelper.checkScheme((SearchChartData)schemeSearchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, (HasPermOrgResult)this.permOrg, (String)structProjectId);
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData(null);
            }
        }
        if (StringUtils.isEmpty((CharSequence)schemeSearchChartData.getChartStyleId())) {
            schemeSearchChartData.setChartStyleId(this.getPageCache().get("MATCH_CHART_STYLE_ID"));
        }
        return schemeSearchChartData;
    }

    public DynamicObjectCollection getTreeViewCollection(QFilter qFilter, long parentId, List<String> orgIds, Date queryDate) {
        QFilter orgFilter = new QFilter("parentorgteam.id", "=", (Object)parentId);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            orgFilter.and(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)this.getStructProjectId()));
        }
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        return structInstance.queryColl(selectFields, new QFilter[]{orgFilter, qFilter, this.buildStructProjectFilter(), OrgChartServiceHelper.getOrgFilter(orgIds)}, "index asc,orgteam.number asc");
    }

    public DynamicObjectCollection getTreeViewCollection(QFilter qFilter, int rootOrgLevel, String rootOrgStructLongNumber, boolean isLeftTree, List<String> orgIds, Date queryDate) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Object> structLongNumberList = new ArrayList(16);
        ArrayList orgIdWithOutSub = new ArrayList(16);
        OrgChartServiceHelper.getHisPermStructLongNumberLikeAndOutSub((AuthorizedOrgResultWithSub)permOrgResultWithSub, orgIdWithOutSub, structLongNumberList, (Date)queryDate, (String)this.getStructProjectId());
        structLongNumberList = structLongNumberList.stream().map(dy -> dy + "%").collect(Collectors.toList());
        String structProjectId = this.getStructProjectId();
        Set levels = OrgChartServiceHelper.calculateQueryLevelsByRootOrg((int)rootOrgLevel, (String)rootOrgStructLongNumber, (Date)queryDate, orgIdWithOutSub, structLongNumberList, Collections.singletonList(1010L), (boolean)isLeftTree, orgIds, (String)structProjectId);
        this.getPageCache().put("MAX_LEVEL_KEY", String.valueOf(levels.size() + 1));
        QFilter levelFilter = new QFilter("level", "in", (Object)levels);
        HashSet<QFilter> qFilters = new HashSet<QFilter>();
        qFilters.add(qFilter);
        qFilters.add(levelFilter);
        qFilters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
        DynamicObjectCollection belongAdminOrgStructCollection = this.getBuildTreeDynamicObjects(qFilters, queryDate);
        return this.queryTreeDynamicObjects(qFilter, rootOrgStructLongNumber, belongAdminOrgStructCollection);
    }

    private DynamicObjectCollection getBuildTreeDynamicObjects(Collection<QFilter> qFilters, Date queryDate) {
        qFilters.add(this.buildStructProjectFilter());
        String selectStructFields = "id,orgteam.id,orgteam.number,orgteam.boid ,orgteam.org, structlongnumber, parentorgteam,orgteam.name name,orgteam.otclassify, isleaf,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            qFilters.add(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)this.getStructProjectId()));
        }
        return structInstance.queryColl(selectStructFields, qFilters.toArray(new QFilter[0]), null);
    }

    private DynamicObjectCollection queryTreeDynamicObjects(QFilter qFilter, String rootOrgStructLongNumber, DynamicObjectCollection belongAdminOrgStructCollection) {
        Set<String> childStructLongNumbers = this.buildChildStructLongNumbers(belongAdminOrgStructCollection, rootOrgStructLongNumber);
        childStructLongNumbers.remove(rootOrgStructLongNumber);
        Set childStructNumbers = OrgChartServiceHelper.getChildStructNumbers(childStructLongNumbers);
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        QFilter orgFilter = new QFilter("orgteam.structnumber", "in", (Object)childStructNumbers);
        LOG.info("queryTreeDynamicObjects orgFilter.and(qFilter)={}", (Object)JSONObject.toJSONString((Object)orgFilter.toString()));
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        return structInstance.queryColl(selectFields, new QFilter[]{orgFilter, qFilter}, "index asc,orgteam.number asc");
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        String id = (String)event.getNodeId();
        String queryOrgIds = this.getPageCache().get("queryOrgId");
        Date queryDate = this.getDate();
        QFilter defaultFilter = OrgChartServiceHelper.getDefaultFilter((Date)queryDate);
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(id) || "notInit100000".equals(id)) {
            return;
        }
        if ("virtual100000".equals(id)) {
            defaultFilter.and(this.buildStructProjectFilter());
            OrgChartTreeNode virtualNode = this.getAllOrgNoParentVirtualNodes(defaultFilter, JSONObject.parseArray((String)queryOrgIds, String.class), queryDate);
            TreeNode treeNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(id);
            treeNode.setChildren(virtualNode.getChildren());
            this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
            return;
        }
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(defaultFilter, Long.parseLong(id), JSONObject.parseArray((String)queryOrgIds, String.class), queryDate);
        Map orgTeamIdOrgTypeMap = OrgChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)queryDate);
        List<OrgChartTreeNode> chartTreeNodeList = this.getOrgChartTreeNodes(defaultFilter, treeViewCollection, orgTeamIdOrgTypeMap, queryDate);
        List treeNodes = OrgChartServiceHelper.sortTreeNodes(chartTreeNodeList);
        TreeNode treeNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(id);
        treeNode.setChildren(treeNodes);
        this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        TreeView treeView = this.getTreeListView().getTreeView();
        String searchText = evt.getText();
        TreeNode rootNode = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        Date queryDate = this.getDate();
        String structProjectId = this.getStructProjectId();
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, this::loadChildNodes, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            QFilter orgTeamLikeFilter = new QFilter("orgteam.name", "like", (Object)("%" + searchText + "%"));
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            if (!permOrgResultWithSub.isHasAllOrgPerm()) {
                orgTeamLikeFilter.and(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)structProjectId));
            }
            String queryOrgIds = this.getPageCache().get("queryOrgId");
            QFilter[] filters = new QFilter[]{orgTeamLikeFilter, OrgChartServiceHelper.getDefaultFilter((Date)queryDate), OrgChartServiceHelper.getOrgFilter((List)JSONObject.parseArray((String)queryOrgIds, String.class))};
            Object[] dynamicObjects = serviceHelper.queryOriginalArray(selectFields, filters);
            if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
                this.searchBuildTree(selectFields, serviceHelper, (DynamicObject)dynamicObjects[0], JSONObject.parseArray((String)queryOrgIds, String.class), queryDate);
                SearchChartData searchChartData = this.getSearchChartData(structProjectId);
                searchChartData.setCurrentOrgChartRootNodeId(dynamicObjects[0].getString("orgteam.id"));
                this.nodeClick(dynamicObjects[0].getString("orgteam.boid"), this.getTreeListView().getTreeView(), searchChartData, "queryTreeNodeData", null);
            } else {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, this::loadChildNodes, 100);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"StandardTreeListPlugin_6", (String)"bos-form-core", (Object[])new Object[0]));
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void searchBuildTree(String selectFields, HRBaseServiceHelper serviceHelper, DynamicObject dynamicObject, List<String> orgIds, Date queryDate) {
        String structLongNumber = dynamicObject.getString("structlongnumber");
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(dynamicObject.getString("orgteam.boid"));
        if (treeNode == null) {
            QFilter qFilter = OrgChartServiceHelper.getDefaultFilter((Date)queryDate);
            String topParentStructLongNumber = OrgChartServiceHelper.findTopParentStructLongNumber((String)structLongNumber, (ITreeModel)this.getTreeModel(), (QFilter)qFilter);
            if (!StringUtils.isEmpty((CharSequence)topParentStructLongNumber)) {
                int treeMaxLevel = topParentStructLongNumber.split("!").length;
                QFilter topParentStructLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(topParentStructLongNumber + "%"));
                HashSet<QFilter> qFilters = new HashSet<QFilter>();
                qFilters.add(qFilter);
                qFilters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
                qFilters.add(new QFilter("level", ">", (Object)treeMaxLevel));
                qFilters.add(new QFilter("level", "<", (Object)dynamicObject.getInt("level")));
                qFilters.add(topParentStructLongNumberFilter);
                DynamicObjectCollection belongAdminOrgStructCollection = this.getBuildTreeDynamicObjects(qFilters, queryDate);
                QFilter parentOrgTeamFilter = new QFilter("parentorgteam.id", "=", (Object)dynamicObject.getLong("parentorgteam"));
                QFilter[] peerOrgsFilters = new QFilter[]{parentOrgTeamFilter, qFilter, OrgChartServiceHelper.getOrgFilter(orgIds)};
                AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
                if (!permOrgResultWithSub.isHasAllOrgPerm()) {
                    parentOrgTeamFilter.and(OrgChartServiceHelper.getPermOrgQFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Date)queryDate, (String)this.getStructProjectId()));
                }
                DynamicObjectCollection peerOrgs = serviceHelper.queryOriginalCollection(selectFields, peerOrgsFilters);
                belongAdminOrgStructCollection.addAll((Collection)peerOrgs);
                DynamicObjectCollection dynamicObjectCollection = this.queryTreeDynamicObjects(this.buildStructProjectFilter().and(qFilter), topParentStructLongNumber, belongAdminOrgStructCollection);
                DynamicObject topParentOrg = serviceHelper.queryOriginalOne(selectFields, new QFilter[]{new QFilter("structlongnumber", "=", (Object)topParentStructLongNumber), qFilter});
                List<OrgChartTreeNode> orgChartTreeNodes = this.getOrgChartChildTreeNode(this.buildStructProjectFilter().and(qFilter), topParentOrg, dynamicObjectCollection);
                OrgChartTreeNode root = orgChartTreeNodes.get(orgChartTreeNodes.size() - 1);
                if (this.getTreeModel().getRoot().getTreeNode(root.getId()) != null) {
                    TreeNode rootNode = this.getTreeModel().getRoot().getTreeNode(root.getId());
                    OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, orgChartTreeNodes);
                    this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
                }
            }
        }
    }

    protected void loadChildNodes(TreeNode node) {
        node.setType(node.getType() + "");
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        if (treeNode != null) {
            this.expandParents(treeView, rootNode, treeNode);
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
        }
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = rootNode.getTreeNode(parentid);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentid);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }

    public OrgChartTreeNode getAllOrgNoParentVirtualNodes(QFilter qFilter, List<String> orgIds, Date queryDate) {
        String realRootOrgStructLongNumber = this.getRealRootOrgStructLongNumber((AbstractFormPlugin)this, queryDate);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(qFilter);
        filters.add(new QFilter("structlongnumber", "not like", (Object)(realRootOrgStructLongNumber + "%")));
        if (!CollectionUtils.isEmpty(orgIds)) {
            filters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
        }
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            List hasPermOrgsWithSub = permOrgResultWithSub.getHasPermOrgsWithSub();
            ArrayList adminOrgs = new ArrayList(hasPermOrgsWithSub.size());
            hasPermOrgsWithSub.forEach(orgSubInfo -> {
                if (!orgSubInfo.isContainsSub()) {
                    adminOrgs.add(orgSubInfo.getOrgId());
                }
            });
            if (adminOrgs.isEmpty()) {
                return null;
            }
            filters.add(new QFilter("orgteam.boid", "in", adminOrgs));
        }
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        DynamicObjectCollection treeViewCollection = structInstance.queryColl(selectFields, filters.toArray(new QFilter[0]), "index asc,orgteam.number asc");
        if (treeViewCollection == null || treeViewCollection.isEmpty()) {
            return null;
        }
        Map orgTeamIdOrgTypeMap = OrgChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)this.getDate());
        List<OrgChartTreeNode> chartTreeNodeList = this.getOrgChartTreeNodes(qFilter, treeViewCollection, orgTeamIdOrgTypeMap, queryDate);
        chartTreeNodeList.forEach(orgChartTreeNode -> {
            if ("0".equals(orgChartTreeNode.getParentid())) {
                orgChartTreeNode.setParentid("virtual100000");
            }
        });
        OrgChartTreeNode rootNode = OrgChartServiceHelper.getVirtualNode();
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, chartTreeNodeList);
        return rootNode;
    }

    private void expandVirtualNode(QFilter defaultFilter, List<String> orgs, Date queryDate) {
        OrgChartTreeNode virtualNode = this.getAllOrgNoParentVirtualNodes(defaultFilter, orgs, queryDate);
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(virtualNode.getId());
        treeNode.setChildren(virtualNode.getChildren());
        this.getTreeListView().getTreeModel().setRoot(this.getTreeModel().getRoot());
        this.focusNode(this.getTreeListView().getTreeView(), this.treeListView.getTreeModel().getRoot(), this.treeListView.getTreeModel().getRoot().getTreeNode(virtualNode.getId()));
    }

    private QFilter buildStructProjectFilter() {
        return new QFilter("structproject", "=", (Object)Long.parseLong(this.getStructProjectId()));
    }

    private boolean isShowCompanyName() {
        Boolean companyNameVisibleCustomParam = this.getCompanyNameVisibleCustomParam();
        return companyNameVisibleCustomParam != null ? companyNameVisibleCustomParam : true;
    }

    private Boolean getCompanyNameVisibleCustomParam() {
        Boolean flag = null;
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("company_name_visible");
        if (customParam != null) {
            LOG.info(String.format("getCustomStructProjectControlFilter custom param: %s", customParam));
            try {
                flag = (Boolean)SerializationUtils.fromJsonString((String)customParam, Boolean.class);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                LOG.error(String.format("getCustomStructProjectControlFilter error with param: %s", customParam));
            }
        }
        return flag;
    }
}

