/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.common.model.OrgChartQueryParam;

public class OrgChartSchemePlugin
extends AbstractTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(OrgChartSchemePlugin.class);

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "saveOrUpdateScheme": {
                this.saveOrUpdateScheme(eventArgs);
                break;
            }
            case "setDefaultScheme": {
                CommonOrgChartServiceHelper.setDefaultScheme((String)eventArgs, (IFormView)this.getView(), (String)"homs_adminorgchart");
                break;
            }
            case "deleteScheme": {
                CommonOrgChartServiceHelper.deleteScheme((String)eventArgs, (IFormView)this.getView(), (String)"homs_adminorgchart");
                break;
            }
        }
    }

    private void saveOrUpdateScheme(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        HashMap<String, Object> filterSchemeMap = new HashMap<String, Object>();
        filterSchemeMap.put("schemeName", jsonObject.getString("schemeName").trim());
        filterSchemeMap.put("entryEntity", "homs_adminorgchart");
        ArrayList schemeRows = new ArrayList();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        schemeRows.add(map);
        OrgChartQueryParam orgChartQueryParam = (OrgChartQueryParam)jsonObject.getObject("scheme", OrgChartQueryParam.class);
        String isOpenPersonal = this.getPageCache().get("0");
        orgChartQueryParam.setOpenPersonalStyle("1".equals(isOpenPersonal));
        boolean isSameDay = CommonOrgChartServiceHelper.isSameDay((String)orgChartQueryParam.getQueryDate(), (Date)new Date());
        if (isSameDay) {
            orgChartQueryParam.setQueryDate("today");
        }
        map.put("FieldName", Collections.singletonList(JSONObject.toJSONString((Object)orgChartQueryParam)));
        map.put("Compare", Lists.newArrayList((Object[])new Object[]{""}));
        map.put("Value", new ArrayList());
        filterSchemeMap.put("scheme", schemeRows);
        if (!StringUtils.isEmpty((CharSequence)jsonObject.getString("schemeId"))) {
            filterSchemeMap.put("id", jsonObject.getString("schemeId"));
        }
        boolean checkResult = this.checkSchemeContent(orgChartQueryParam, jsonObject);
        CommonOrgChartServiceHelper.checkSchemeAndSendMessage((JSONObject)jsonObject, filterSchemeMap, (boolean)checkResult, (IFormView)this.getView(), (String)"homs_adminorgchart");
    }

    private boolean checkSchemeContent(OrgChartQueryParam orgChartQueryParam, JSONObject jsonObject) {
        String schemeName = jsonObject.getString("schemeName");
        StringBuilder builder = new StringBuilder();
        boolean errorMessage = false;
        String schemeNameFiled = ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u3001", (String)"OrgChartPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeDateFiled = ResManager.loadKDString((String)"\u67e5\u8be2\u65e5\u671f\u3001", (String)"OrgChartPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeAdminOrgTypeFiled = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3001", (String)"OrgChartPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeOrgFiled = ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"OrgChartPlugin_22", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeRootNode = ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7\u3001", (String)"OrgChartPlugin_23", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)schemeName)) {
            builder.append(schemeNameFiled);
            errorMessage = true;
        }
        if (HRObjectUtils.isEmpty((Object)orgChartQueryParam.getQueryDate())) {
            builder.append(schemeDateFiled);
            errorMessage = true;
        }
        if (CollectionUtils.isEmpty((Collection)orgChartQueryParam.getAdminOrgTypes())) {
            builder.append(schemeAdminOrgTypeFiled);
            errorMessage = true;
        }
        if (CollectionUtils.isEmpty((Collection)orgChartQueryParam.getOrgs())) {
            builder.append(schemeOrgFiled);
            errorMessage = true;
        }
        if (HRStringUtils.isEmpty((String)orgChartQueryParam.getCurrentOrgChartRootNodeId())) {
            builder.append(schemeRootNode);
            errorMessage = true;
        }
        if (errorMessage) {
            String error = builder.substring(0, builder.length() - 1);
            String tipMessage = ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgChartPlugin_16", (String)"odc-homs-formplugin", (Object[])new Object[]{error});
            this.getView().showErrorNotification(tipMessage);
        }
        return errorMessage;
    }
}

