/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.homs.business.service.orgchart.OrgChartNewServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.model.CardStyle;
import kd.hr.homs.formplugin.web.newcardstyle.vo.NewCardConfig;
import kd.hr.homs.formplugin.web.neworgchart.vo.NewChartHelper;
import kd.hr.homs.formplugin.web.orgchart.ChartHelper;
import kd.hr.homs.formplugin.web.orgchart.OrgChartBase;

public class OrgChartStyleEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(OrgChartStyleEditPlugin.class);
    private static final String ORGTEAMADD = "orgteamadd";
    private static final String ORGTEAMTOENTRY = "orgteamtoentry";
    private static final String FLAG = "flag";
    private static final Long VIRTUAL_ORG_TYPE_ID = 1010L;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = e.getFormShowParameter().getFormId();
        if (e.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            if (HRStringUtils.equals((String)formId, (String)"homs_position_chartstyle")) {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5173\u7cfb\u7ed3\u6784\u6837\u5f0f", (String)"OrgChartStyleEditPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            } else {
                e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u7ed3\u6784\u56fe\u6837\u5f0f", (String)"OrgChartStyleEditPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            }
        } else if (OperationStatus.EDIT == e.getFormShowParameter().getStatus()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_chartstyle");
            DynamicObject dy = helper.queryOne("name", ((BaseShowParameter)e.getSource()).getPkId());
            if (HRStringUtils.equals((String)formId, (String)"homs_position_chartstyle")) {
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u7cfb\u7ed3\u6784\u6837\u5f0f-%s", (String)"OrgChartStyleEditPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), dy.getString("name"));
                e.getFormShowParameter().setCaption(message);
            } else {
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f-%s", (String)"OrgChartStyleEditPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), dy.getString("name"));
                e.getFormShowParameter().setCaption(message);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)"carddimensionid", (String)name)) {
            this.showConfirm(args);
        }
        if (HRStringUtils.equals((String)"orgteam", (String)name)) {
            String orgteamToEntry = this.getPageCache().get(ORGTEAMTOENTRY);
            if (HRStringUtils.isNotEmpty((String)orgteamToEntry) && HRStringUtils.equals((String)"1", (String)orgteamToEntry)) {
                DynamicObject orgTeam = this.getModel().getDataEntity().getDynamicObject("orgteam");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("chastyorgentry");
                if (!HRObjectUtils.isEmpty((Object)orgTeam) && entryEntity.size() == 0) {
                    this.getModel().createNewEntryRow("chastyorgentry");
                    this.getModel().setValue("adminorg", (Object)orgTeam, 0);
                    this.getModel().setValue("adminorgnumber", (Object)orgTeam.getString("number").substring(4), 0);
                    this.getPageCache().put(ORGTEAMTOENTRY, "0");
                }
            }
        } else if (HRStringUtils.equals((String)"adminorg", (String)name)) {
            String orgNumber;
            IDataModel dataModel = this.getModel();
            int chaStyOrgEntryRowIndex = dataModel.getEntryCurrentRowIndex("chastyorgentry");
            DynamicObject org = (DynamicObject)dataModel.getValue("adminorg", chaStyOrgEntryRowIndex);
            String adminOrgNumber = null;
            if (!HRObjectUtils.isEmpty((Object)org) && HRStringUtils.isNotEmpty((String)(orgNumber = org.getString("number"))) && orgNumber.length() > 4) {
                adminOrgNumber = orgNumber.substring(4);
            }
            dataModel.setValue("adminorgnumber", adminOrgNumber, chaStyOrgEntryRowIndex);
        }
    }

    private void showConfirm(PropertyChangedArgs e) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("carddimensionidChange", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u66f4\u6362\u5361\u7247\u7ef4\u5ea6, \u5df2\u9009\u62e9\u7684\u5361\u7247\u6837\u5f0f\u3001\u6240\u5c5e\u7ec4\u7ec7\u548c\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u5c06\u88ab\u6e05\u7a7a\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgChartStyleEditPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("carddimensionidChange".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IDataModel model = this.getModel();
            model.setValue("orgteam", null);
            DynamicObject dataEntity = model.getDataEntity(true);
            int size = dataEntity.getDynamicObjectCollection("chastyorgentry").size();
            this.getModel().deleteEntryRows("chastyorgentry", this.getIntArray(size));
            int cardStyleEntrySize = dataEntity.getDynamicObjectCollection("chartstyleentry").size();
            this.getModel().deleteEntryRows("chartstyleentry", this.getIntArray(cardStyleEntrySize));
            this.getView().updateView("chastyorgentry");
            this.getView().updateView("chartstyleentry");
            this.afterCarddimensionChange(false);
        }
    }

    private void afterCarddimensionChange(boolean initevents) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("carddimensionid");
        if (!HRObjectUtils.isEmpty((Object)dynamicObject)) {
            ArrayList<Map<String, Object>> numberList = new ArrayList<Map<String, Object>>();
            ArrayList<String> cardDimensionList = new ArrayList<String>();
            HashMap<String, Object> cardDimensionMap = new HashMap<String, Object>();
            cardDimensionMap.put("carddimensionId", dynamicObject.getString("id"));
            String localeValue = dynamicObject.getLocaleString("name").getLocaleValue();
            if (HRStringUtils.isEmpty((String)localeValue)) {
                cardDimensionMap.put("carddimensionName", dynamicObject.getLocaleString("name").toString());
            } else {
                cardDimensionMap.put("carddimensionName", localeValue);
            }
            JSONObject defaultColor = (JSONObject)OrgChartServiceHelper.CARDDIMENSION_ID_DEFAULT_COLOR.get(dynamicObject.getString("id"));
            cardDimensionMap.put("defaultColor", defaultColor);
            numberList.add(cardDimensionMap);
            cardDimensionList.add(dynamicObject.get("id").toString());
            this.getPageCache().put("carddimensionlist", String.valueOf(cardDimensionList));
            this.checkCardDimension(cardDimensionList);
            boolean newStructureChart = OrgChartNewServiceHelper.isUseNewStructureChart();
            if (newStructureChart) {
                cardDimensionMap.put("cardStyleRule", "{\"id\":\"10001\",\"name\":\"\u6837\u5f0f\u4e00\",\"card\":{\"border\":[1,\"#d9d9d9\",\"\",0],\"background\":\"#fff\",\"cardSize\":{\"w\":180,\"xSpace\":20,\"ySpace\":66,\"xSpace2r\":36,\"ySpace2v\": 36},\"mark\":{\"tag\":\"rect\",\"x\":0,\"y\":0,\"w\":\"1\",\"h\":28,\"rx\":0,\"fill\":\"#276FF5\",\"stroke\":\"#276FF5\"}},\"sortValues\":[\"0\",\"1\",\"3\",\"2\"],\"fieldGroupMap\":{\"0\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":false},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1\",\"h\":28,\"fontSize\":14,\"fontWeight\":600,\"color\":\"#fff\",\"valign\":\"center\",\"textAnchor\":\"middle\"}}},\"1\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true,\"dy\":4},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"2/3\",\"h\":18,\"dx\":4,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\",\"valueRule\":{\"onlyOne\":true,\"sort\":\"time\"}},\"2\":{\"tag\":\"img\",\"dy\":0,\"dx\":16,\"w\":36,\"h\":36,\"rx\":18}}},\"2\":{\"toggleIcon\":true,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1/2\",\"h\":18,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\"}}},\"3\":{\"toggleIcon\":false,\"groupStyle\":{\"color\":\"#212121\",\"fontSize\":14,\"endLine\":true},\"fieldRender\":{\"1\":{\"tag\":\"text\",\"w\":\"1\",\"h\":18,\"fontSize\":12,\"color\":\"#212121\",\"valign\":\"center\",\"textAnchor\":\"start\"}}}},\"defaultData\":{\"presetFields\":[\"name\",\"personname\",\"personavtor\",\"positionname\",\"personcount\"],\"showIcon\":1}}");
                cardDimensionMap.put("cardStyleSelectFields", new CardStyle().getCardStyleSelectFields());
            }
            this.setMapDataForCustomControl("carddimensionid", numberList, initevents, newStructureChart);
        } else {
            this.setDataForCustomControl("carddimensionid", null, initevents, OrgChartNewServiceHelper.isUseNewStructureChart());
            this.getModel().deleteEntryData("chartstyleentry");
        }
    }

    private List<Map<String, Object>> getCardDimensionInfo() {
        DynamicObject row = this.getModel().getDataEntity().getDynamicObject("carddimensionid");
        ArrayList<Map<String, Object>> cardDimensionList = new ArrayList<Map<String, Object>>();
        if (!HRObjectUtils.isEmpty((Object)row)) {
            Map<String, Object> cardDimensionMap = this.getDimensionMap(row);
            cardDimensionList.add(cardDimensionMap);
        }
        return cardDimensionList;
    }

    private Map<String, Object> getDimensionMap(DynamicObject dynamicObject) {
        HashMap<String, Object> cardDimensionMap = new HashMap<String, Object>();
        cardDimensionMap.put("carddimensionId", dynamicObject.getString("id"));
        String localeValue = dynamicObject.getLocaleString("name").getLocaleValue();
        if (HRStringUtils.isEmpty((String)localeValue)) {
            cardDimensionMap.put("carddimensionName", dynamicObject.getLocaleString("name").toString());
        } else {
            cardDimensionMap.put("carddimensionName", localeValue);
        }
        return cardDimensionMap;
    }

    private void checkCardDimension(List<String> cardDimensionList) {
        DynamicObjectCollection cardStyleCollection = this.getModel().getEntryEntity("chartstyleentry");
        for (int index = 0; index < cardStyleCollection.size(); ++index) {
            DynamicObject dynamicObject = ((DynamicObject)cardStyleCollection.get(index)).getDynamicObject("carddimension");
            String id = dynamicObject.getString("id");
            if (cardDimensionList.contains(id)) continue;
            this.getModel().deleteEntryRow("chartstyleentry", index);
        }
    }

    public void customEvent(CustomEventArgs args) {
        if (HRStringUtils.equals((String)"cardstyleselect", (String)args.getEventName())) {
            String data = args.getEventArgs();
            Map map = (Map)JSONObject.parse((String)data);
            Long cardDimensionId = Long.parseLong(map.get("carddimensionId").toString());
            this.showCardStyleVie(cardDimensionId);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable", "bar_disable"});
        }
    }

    private void showCardStyleVie(Long cardDimensionId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_listf7");
        String formId = this.getView().getFormShowParameter().getFormId();
        boolean isNewStructChart = OrgChartNewServiceHelper.isUseNewStructureChart();
        if (HRStringUtils.equals((String)"homs_chartstyle", (String)formId)) {
            if (isNewStructChart) {
                showParameter.setBillFormId("homs_cardstyle_new");
            } else {
                showParameter.setBillFormId("homs_cardstyle");
            }
        } else if (HRStringUtils.equals((String)"homs_position_chartstyle", (String)formId)) {
            showParameter.setBillFormId("homs_position_cardstyle");
        }
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        showParameter.getOpenStyle().setInlineStyleCss(cssValue);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        ListFilterParameter listFilterParameter = this.buildCardStyleFilter(cardDimensionId);
        showParameter.setListFilterParameter(listFilterParameter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        enableFilter.and(new QFilter("id", "!=", (Object)VIRTUAL_ORG_TYPE_ID));
        if (isNewStructChart && "homs_cardstyle_new".equals(showParameter.getBillFormId())) {
            enableFilter.and(new QFilter("cardstyleflag", "in", Arrays.asList("1", "2")));
        } else if ("homs_cardstyle_new".equals(showParameter.getBillFormId())) {
            enableFilter.and(new QFilter("cardstyleflag", "!=", (Object)"1"));
        }
        listFilterParameter.setFilter(enableFilter);
        listFilterParameter.setOrderBy("number asc");
        showParameter.setMultiSelect(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, cardDimensionId.toString()));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<NewCardConfig> getAllFields() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_cardconfig");
        long carddimensionid = this.getModel().getDataEntity(true).getLong("carddimensionid.id");
        QFilter cardDimensionFilter = new QFilter("carddimension", "=", (Object)carddimensionid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] allFieldConfig = helper.queryOriginalArray("id,name,fieldidentifier,fieldtype,fieldgroup,iconcode,iconclassname,iconurl,index,sampledate", new QFilter[]{cardDimensionFilter, enableFilter}, "index");
        return Arrays.stream(allFieldConfig).map(dy -> {
            NewCardConfig cardConfig = new NewCardConfig();
            cardConfig.setId(dy.getString("id"));
            cardConfig.setName(dy.getString("name"));
            cardConfig.setKey(dy.getString("fieldidentifier"));
            cardConfig.setRender(Integer.parseInt(dy.getString("fieldtype")));
            cardConfig.setFieldSort(dy.getString("fieldgroup"));
            cardConfig.setIndex(dy.getInt("index"));
            cardConfig.setIconClassName(dy.getString("iconclassname"));
            cardConfig.setIconCode(dy.getString("iconcode"));
            cardConfig.setIconUrl(dy.getString("iconurl"));
            if ("name".equals(dy.getString("fieldidentifier"))) {
                cardConfig.setIsEdit(0);
            } else {
                cardConfig.setIsEdit(1);
            }
            return cardConfig;
        }).collect(Collectors.toList());
    }

    private void setDataForCustomControl(String dataFlag, List<CardStyle> dataList, boolean initevents, boolean isUseNewChart) {
        CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        String formId = this.getView().getFormShowParameter().getFormId();
        if (isUseNewChart && HRStringUtils.equals((String)"homs_chartstyle", (String)formId)) {
            data.put("exampleTreeData", NewChartHelper.getExampleTreeData());
            data.put("dataVersion", 2);
        } else {
            data.put("dataVersion", 1);
        }
        data.put("data", dataList);
        data.put(FLAG, dataFlag);
        if (initevents) {
            data.put("initevents", initevents);
            data.put("cardDimensionInfo", this.getCardDimensionInfo());
            data.put("allFields", this.getAllFields());
        }
        customControl.setData(data);
    }

    private void setSingleDataForCustomControl(String dataFlag, CardStyle cardStyle) {
        CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataVersion", 1);
        data.put("data", cardStyle);
        data.put(FLAG, dataFlag);
        customControl.setData(data);
    }

    private void setMapDataForCustomControl(String dataFlag, List<Map<String, Object>> dataList, boolean initevents, boolean isNewStructure) {
        CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (isNewStructure) {
            data.put("dataVersion", 2);
            data.put("exampleTreeData", NewChartHelper.getExampleTreeData());
        } else {
            data.put("dataVersion", 1);
        }
        data.put("data", dataList);
        data.put(FLAG, dataFlag);
        data.put("allFields", this.getAllFields());
        if (initevents) {
            data.put("initevents", initevents);
            data.put("cardDimensionInfo", this.getCardDimensionInfo());
        }
        customControl.setData(data);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long carddimensionId;
        int entryCount;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && (entryCount = this.getModel().getEntryRowCount("chartstyleentry")) < 1) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5361\u7247\u6837\u5f0f\u3002", (String)"OrgChartStyleEditPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if ("disable".equals(operateKey) || "enable".equals(operateKey) || "modify".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (!ChartHelper.checkOrgTeamPerm(dataEntity, this.getView().getFormShowParameter(), "carddimensionid", "orgteam")) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\uff1a\u65e0\u6570\u636e\u7684\u6240\u5c5e\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgChartStyleEditPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("number")}));
            }
        } else if (ORGTEAMADD.equals(operateKey) && (carddimensionId = this.getModel().getDataEntity().getLong("carddimensionid.id")) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5361\u7247\u7ef4\u5ea6\u3002", (String)"CardStylePlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "modify": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable", "bar_disable"});
                this.setDataForCustomControl("modify", null, false, OrgChartNewServiceHelper.isUseNewStructureChart());
                break;
            }
            case "enable": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable", "bar_modify"});
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
                break;
            }
            case "disable": {
                boolean success;
                if (args.getOperationResult() == null || !(success = args.getOperationResult().isSuccess())) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_enable"});
                this.getView().setStatus(OperationStatus.VIEW);
                break;
            }
            case "orgteamadd": {
                this.showOrgTeamView();
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable", "bar_disable"});
                break;
            }
            case "save": 
            case "adminorgdeleteentry": {
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                LOG.info("adminorgdeleteentry" + status.toString());
                this.getView().setStatus(status);
                break;
            }
        }
    }

    private void showOrgTeamView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_listf7");
        showParameter.setBillFormId("haos_adminorgteam");
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("960px");
        cssValue.setHeight("620px");
        showParameter.getOpenStyle().setInlineStyleCss(cssValue);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"OrgChartStyleEditPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = this.setListFilter();
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ListFilterParameter setListFilter() {
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        long carddimensionId = this.getModel().getDataEntity().getLong("carddimensionid.id");
        ChartHelper helper = new ChartHelper();
        QFilter qFilter = helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter());
        QFilter selectedOrgFilter = this.buildSelectedFilter("chastyorgentry", "adminorg");
        qFilter.and(selectedOrgFilter);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        listFilterParameter.setFilter(qFilter);
        return listFilterParameter;
    }

    public void beforeBindData(EventObject e) {
        Boolean iscopy;
        super.beforeBindData(e);
        Long id = this.getModel().getDataEntity().getLong("id");
        if (id != 0L) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ((iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")) != null && iscopy.booleanValue()) {
            this.setCardStyleToCustom("copy");
        }
        if (id == 0L && iscopy == null) {
            this.getPageCache().put(ORGTEAMTOENTRY, "1");
        } else {
            this.getPageCache().put(ORGTEAMTOENTRY, "0");
        }
        this.updateOrgEntryNumber();
        this.getModel().setDataChanged(false);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)formId, (String)"homs_position_chartstyle")) {
            this.getView().getPageCache().put("ue_param", "true");
        }
    }

    private void updateOrgEntryNumber() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("chastyorgentry");
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getModel().beginInit();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject entryDy = (DynamicObject)dynamicObjectCollection.get(i);
                this.getModel().setValue("adminorgnumber", (Object)entryDy.getString("adminorg.number").substring(4), i);
            }
            this.getModel().endInit();
            this.getView().updateView("chastyorgentry");
        }
    }

    private void setCardDimensionCache() {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("carddimensionid");
        if (dynamicObject != null) {
            ArrayList<String> cardDimension = new ArrayList<String>();
            cardDimension.add(dynamicObject.get("id").toString());
            this.getPageCache().put("carddimensionlist", String.valueOf(cardDimension));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBillStatus();
    }

    private void setBillStatus() {
        Long id = this.getModel().getDataEntity().getLong("id");
        if (id != 0L) {
            this.getView().setStatus(OperationStatus.VIEW);
            String enable = this.getModel().getDataEntity().getString("enable");
            if (HRStringUtils.equals((String)"1", (String)enable)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_enable"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify"});
            }
            Boolean isSysPreset = this.getModel().getDataEntity().getBoolean("issyspreset");
            if (isSysPreset.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable", "bar_modify"});
            }
            this.setCardStyleToCustom("initialize");
        }
    }

    private void setCardStyleToCustom(String event) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("chartstyleentry");
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList cardStyleList = new ArrayList();
            ArrayList<CardStyle> cardStyles = new ArrayList<CardStyle>();
            entryEntity.forEach(entry -> cardStyleList.add(entry.getDynamicObject("cardstyle").getString("id")));
            boolean useNewStructureChart = OrgChartNewServiceHelper.isUseNewStructureChart();
            String formId = this.getView().getFormShowParameter().getFormId();
            if (useNewStructureChart && HRStringUtils.equals((String)"homs_chartstyle", (String)formId)) {
                DynamicObject[] cardStyleById = OrgChartNewServiceHelper.getCardStyleById(cardStyleList);
                Arrays.stream(cardStyleById).forEach(cardStyle -> {
                    CardStyle card = new CardStyle();
                    card.setId(cardStyle.getString("id"));
                    card.setName(cardStyle.getString("name"));
                    card.setNumber(cardStyle.getString("number"));
                    card.setCarddimensionId(cardStyle.getString("carddimension.id"));
                    card.setCarddimensionName(cardStyle.getString("carddimension.name"));
                    card.setCardStyleRule(cardStyle.getString("cardstyle_tag"));
                    cardStyles.add(card);
                });
            } else {
                Map longCardStyleMap = OrgChartServiceHelper.toCardStyle(cardStyleList);
                cardStyleList.forEach(card -> cardStyles.add((CardStyle)longCardStyleMap.get(card)));
            }
            this.setDataForCustomControl(event, cardStyles, true, useNewStructureChart);
        }
        this.setCardDimensionCache();
    }

    public void afterCreateNewData(EventObject e) {
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            Boolean iscopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
            if (iscopy == null || !iscopy.booleanValue()) {
                this.getModel().deleteEntryData("chastyorgentry");
                this.getModel().deleteEntryData("chartstyleentry");
            }
            this.afterCarddimensionChange(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgTeam = (BasedataEdit)this.getView().getControl("orgteam");
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl("adminorg");
        orgTeam.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        long carddimensionId = this.getModel().getDataEntity().getLong("carddimensionid.id");
        ChartHelper helper = new ChartHelper();
        switch (fieldKey) {
            case "orgteam": {
                if (carddimensionId == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5361\u7247\u7ef4\u5ea6\u3002", (String)"CardStylePlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setFormId("bos_listf7");
                QFilter orgTeamFilter = helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter());
                this.setListShowFilter(beforeF7SelectEvent, orgTeamFilter);
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7", (String)"OrgChartStyleEditPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                break;
            }
            case "adminorg": {
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setFormId("bos_listf7");
                QFilter adminOrgFilter = helper.getPermFilter(carddimensionId, this.getView().getFormShowParameter());
                QFilter selectedOrgFilter = this.buildSelectedFilter("chastyorgentry", "adminorg");
                adminOrgFilter.and(selectedOrgFilter);
                this.setListShowFilter(beforeF7SelectEvent, adminOrgFilter);
                beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"OrgChartStyleEditPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void setListShowFilter(BeforeF7SelectEvent beforeF7SelectEvent, QFilter qFilter) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter buildSelectedFilter(String entry, String field) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(entry);
        HashSet idSet = new HashSet();
        collection.stream().forEach(dy -> {
            DynamicObject data = dy.getDynamicObject(field);
            if (!HRObjectUtils.isEmpty((Object)data)) {
                Long id = data.getLong("id");
                idSet.add(id);
            }
        });
        return new QFilter("id", "not in", idSet);
    }

    private ListFilterParameter buildCardStyleFilter(long cardDimesion) {
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        OrgChartBase chartBase = new OrgChartBase();
        Set<Object> cardStyleIds = new HashSet();
        cardStyleIds = cardDimesion == OrgChartConstants.PROJECT_CARDDISSION ? ChartHelper.getPermCardStyleIds(this.getView().getFormShowParameter()) : OrgChartServiceHelper.getCardStyleIds((AuthorizedOrgResultWithSub)chartBase.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView()));
        LOG.info("buildCardStyleFilter:" + cardStyleIds.toString());
        if (cardStyleIds.isEmpty()) {
            cardStyleIds.addAll(OrgChartServiceHelper.getAllCardStyleIds((QFilter)new QFilter("issyspreset", "=", (Object)"1")));
        }
        QFilter idFilter = new QFilter("id", "in", cardStyleIds);
        idFilter.and(new QFilter("carddimension", "=", (Object)cardDimesion));
        listFilterParameter.setFilter(idFilter);
        return listFilterParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(closedCallBackEvent);
        String carddimensionlist = this.getPageCache().get("carddimensionlist");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setStatus(status);
        if (HRStringUtils.equals((String)"close", (String)closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection selectedRows2 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (!CollectionUtils.isEmpty((Collection)selectedRows2)) {
                this.setChastyorgentry(selectedRows2);
            }
        } else if (!HRStringUtils.isEmpty((String)carddimensionlist) && carddimensionlist.contains(closedCallBackEvent.getActionId()) && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            String cardStyleId = listSelectedRow.getPrimaryKeyValue().toString();
            this.setCardStyleEntry(cardStyleId, closedCallBackEvent.getActionId());
            boolean isNewStructChart = OrgChartNewServiceHelper.isUseNewStructureChart();
            if (isNewStructChart && carddimensionlist.contains("1010")) {
                DynamicObject cardStyleById = OrgChartNewServiceHelper.getCardStyleById((String)cardStyleId);
                CardStyle cardStyle = new CardStyle();
                cardStyle.setId(cardStyleById.getString("id"));
                cardStyle.setName(cardStyleById.getString("name"));
                cardStyle.setNumber(cardStyleById.getString("number"));
                cardStyle.setCardStyleRule(cardStyleById.getString("cardstyle_tag"));
                cardStyle.setCarddimensionId(cardStyleById.getString("carddimension.id"));
                cardStyle.setCarddimensionName(cardStyleById.getString("carddimension.name"));
                CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("dataVersion", 2);
                data.put("data", cardStyle);
                data.put(FLAG, "cardstyle");
                data.put("allFields", this.getAllFields());
                customControl.setData(data);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(cardStyleId);
                Map longCardStyleMap = OrgChartServiceHelper.toCardStyle(list);
                this.setSingleDataForCustomControl("cardstyle", (CardStyle)longCardStyleMap.get(cardStyleId));
            }
        }
    }

    private void setChastyorgentry(ListSelectedRowCollection selectedRows) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        selectedRows.forEach(selectRow -> {
            vs.addField("adminorg", new Object[]{selectRow});
            vs.addField("adminorgnumber", new Object[]{selectRow.getNumber()});
        });
        model.batchCreateNewEntryRow("chastyorgentry", vs);
        model.endInit();
        this.getView().updateView("chastyorgentry");
        this.getPageCache().put(ORGTEAMTOENTRY, "0");
    }

    private void setCardStyleEntry(String cardStyleId, String actionId) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("chartstyleentry");
        if (collection != null && collection.size() > 0) {
            int rowCount = collection.getRowCount();
            int index = this.getCardStyleIndex(collection, actionId);
            if (index == -1) {
                this.getModel().createNewEntryRow("chartstyleentry");
                this.getModel().setValue("cardstyle", (Object)cardStyleId, rowCount);
                this.getModel().setValue("carddimension", (Object)Long.parseLong(actionId), rowCount);
            } else {
                this.getModel().setValue("cardstyle", (Object)cardStyleId, index);
                this.getModel().setValue("carddimension", (Object)Long.parseLong(actionId), index);
            }
        } else {
            this.getModel().createNewEntryRow("chartstyleentry");
            this.getModel().setValue("cardstyle", (Object)cardStyleId, 0);
            this.getModel().setValue("carddimension", (Object)Long.parseLong(actionId), 0);
        }
    }

    private int getCardStyleIndex(DynamicObjectCollection collection, String actionId) {
        for (int index = 0; index < collection.size(); ++index) {
            DynamicObject cardDy = (DynamicObject)collection.get(index);
            DynamicObject carDimensionDy = cardDy.getDynamicObject("carddimension");
            String cardDimensionId = carDimensionDy.getString("id");
            if (!HRStringUtils.equals((String)actionId, (String)cardDimensionId)) continue;
            return index;
        }
        return -1;
    }

    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }
}

