/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hr.homs.business.service.orgchart.OrgChartNewServiceHelper;
import kd.hr.homs.formplugin.web.orgchart.ChartHelper;

public class OrgChartStyleListPlugin
extends HRDataBaseList {
    private static final String HRCS = "hrcs";
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    public static final String HOMS_PERSONALSTYLE = "homs_personalstyle";
    private static final Long VIRTUAL_ORG_CHART_TYPE_ID = 1004L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        QFilter cardIdFilter;
        QFilter permissionFilter;
        List filters = setFilterEvent.getQFilters();
        super.setFilter(setFilterEvent);
        if (HRStringUtils.equals((String)"bos_list", (String)this.getView().getFormShowParameter().getFormId()) && !HRObjectUtils.isEmpty((Object)(permissionFilter = ChartHelper.buildPermissionFilter(this.getView().getFormShowParameter(), "carddimensionid", "orgteam")))) {
            filters.add(permissionFilter);
        }
        filters.add(new QFilter("id", "!=", (Object)VIRTUAL_ORG_CHART_TYPE_ID));
        if (OrgChartNewServiceHelper.isUseNewStructureChart()) {
            cardIdFilter = new QFilter("cardstyleflag", "in", Arrays.asList("1", "2"));
            DynamicObject[] query = OrgChartNewServiceHelper.getCardStyleNewHelper().query("id", new QFilter[]{cardIdFilter});
            List idList = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            if (!idList.isEmpty()) {
                filters.add(new QFilter("chartstyleentry.cardstyle", "in", idList));
            }
        } else {
            cardIdFilter = new QFilter("cardstyleflag", "!=", (Object)"1");
            DynamicObject[] query = OrgChartNewServiceHelper.getCardStyleNewHelper().query("id", new QFilter[]{cardIdFilter});
            List idList = Arrays.stream(query).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            if (!idList.isEmpty()) {
                filters.add(new QFilter("chartstyleentry.cardstyle", "in", idList));
            }
        }
    }

    private AuthorizedOrgResult getAuthorizedOrgResult() {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appIdFromShowParam = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)appIdFromShowParam, (String)permEntityId);
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, permEntityId, permItemId, "boid"});
        return permResult;
    }

    private List<Long> getPermOrgs() {
        AuthorizedOrgResult orgResult = this.getAuthorizedOrgResult();
        List orgIds = !orgResult.isHasAllOrgPerm() ? orgResult.getHasPermOrgs() : (List)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAllAdminOrgs", (Object[])new Object[]{Boolean.FALSE});
        return orgIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null) {
            List pkIds = operationResult.getSuccessPkIds();
            if (HRStringUtils.equals((String)"viewdetails", (String)operateKey)) {
                this.viewDetails(pkIds);
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        listColumns.removeIf(listColumn -> listColumn instanceof ListOperationColumn && OrgChartNewServiceHelper.isUseNewStructureChart() && "listoperationcolumnap".equals(((ListOperationColumn)listColumn).getKey()));
    }

    private void viewDetails(List<Object> pkIds) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId("bos_list");
        lsp.setBillFormId(HOMS_PERSONALSTYLE);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("chartstyle", "=", pkIds.get(0)));
        listFilterParameter.setFilter(new QFilter("rootorg", "in", this.getPermOrgs()));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String caption = ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u6837\u5f0f\u5217\u8868", (String)"OrgChartStyleListPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        lsp.setCaption(this.getChartStyleName(pkIds.get(0)) + "-" + caption);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private String getChartStyleName(Object pkId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("homs_chartstyle");
        DynamicObject dy = helper.queryOne("name", pkId);
        return dy.getString("name");
    }
}

