/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.model.PersonalStyleData;
import kd.hr.homs.formplugin.web.orgchart.OrgChartBase;

public class OrgChartViewDetailsPlugin
extends OrgChartBase {
    private static final Log LOG = LogFactory.getLog(OrgChartViewDetailsPlugin.class);
    private static final String VIEWDETAILS = "viewdetails";
    private static final Long VIRTUAL_ORG_CHART_TYPE_ID = 1004L;

    public void customEvent(CustomEventArgs args) {
        String eventArgs = args.getEventArgs();
        String operateName = args.getEventName();
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        switch (operateName) {
            case "viewdetails": {
                this.openOrgDetail(eventArgs);
                break;
            }
            case "cardedit": {
                this.openCardEditView(eventArgs);
                break;
            }
            case "openPersonalStyle": {
                this.openPersonalStyle(eventArgs);
                break;
            }
            case "closePersonalStyle": {
                this.getPageCache().remove("0");
                break;
            }
            case "openPersonalStyleF7": {
                this.openPersonalF7(eventArgs);
                break;
            }
            case "openOrgChartStyleF7": {
                this.openOrgChartStyleF7();
                break;
            }
            case "openAdminOrgTypeF7": {
                JSONArray adminorgTypes = jsonObject.getJSONArray("showAdminOrgTypes");
                this.openAdminOrgTypeF7(adminorgTypes);
                break;
            }
            case "openTeamCooprelTypeF7": {
                this.openTeamCoopRelTypeF7(Collections.singleton(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID));
                break;
            }
            case "openOrgTeamF7": {
                this.openOrgTeamF7();
                break;
            }
            case "dataRouteKey": {
                this.dataRoute(eventArgs);
                break;
            }
            case "orgChartPermQuery": {
                this.permQuery();
                break;
            }
            case "closeOrgChart": {
                this.getView().close();
                break;
            }
            case "openOrgF7": {
                JSONArray orgList = jsonObject.getJSONArray("orgs");
                this.openOrgF7(orgList);
                break;
            }
            case "addChartExportOperateLog": {
                CommonOrgChartServiceHelper.addChartExportOperateLog((String)"homs_orgchart", (String)operateName);
                break;
            }
        }
    }

    private void openOrgF7(JSONArray orgList) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = new QFilter("id", "in", (Object)OrgChartServiceHelper.getDefaultOrg());
        enableFilter.and(qFilter);
        ListShowParameter showParameter = OrgChartServiceHelper.getListShowParameter((String)"bos_org", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        showParameter.setListSelectedRowCollection(OrgChartServiceHelper.getListSelectedRowCollection((JSONArray)orgList));
        showParameter.setMultiSelect(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"OrgChartPlugin_24", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgF7"));
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void permQuery() {
        HashMap result = new HashMap(16);
        OrgChartServiceHelper.orgChartPermQuery(result);
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"orgChartPermQuery", result, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"orgChartPermQuery", result, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
    }

    private void dataRoute(String eventArgs) {
        JSONObject parseObject = JSONObject.parseObject((String)eventArgs);
        Integer routeTarget = parseObject.getInteger("routeTarget");
        String data = parseObject.getString("data");
        HashMap<String, String> dataInfo = new HashMap<String, String>();
        dataInfo.put("data", data);
        switch (routeTarget) {
            case 1: {
                OrgChartServiceHelper.setSimpleDataForCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
                break;
            }
            case 2: {
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
                break;
            }
            default: {
                OrgChartServiceHelper.setSimpleDataForCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
            }
        }
    }

    private void openOrgTeamF7() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            QFilter permFilter = new QFilter("id", "in", this.getPermOrgs((AbstractFormPlugin)this));
            enableFilter.and(permFilter);
        }
        ListShowParameter orgteamShowParameter = OrgChartServiceHelper.getListShowParameter((String)"haos_adminorgteam", (String)"haos_orgteamf7", (QFilter)enableFilter, (String)"number asc");
        orgteamShowParameter.setCustomParam("searchdate", (Object)this.getDate());
        orgteamShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgTeamF7"));
        orgteamShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)orgteamShowParameter);
    }

    private void openTeamCoopRelTypeF7(Collection<Long> otclassifyIds) {
        QFilter filter = OrgChartServiceHelper.getTeamCoopRelTypeFilters(otclassifyIds);
        ListShowParameter teamCoopRelTypeShowParameter = OrgChartServiceHelper.getListShowParameter((String)"haos_teamcoopreltype", (String)"bos_listf7", (QFilter)filter, (String)"number asc");
        teamCoopRelTypeShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openTeamCooprelTypeF7"));
        teamCoopRelTypeShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)teamCoopRelTypeShowParameter);
    }

    private void openAdminOrgTypeF7(JSONArray adminorgTypes) {
        QFilter filter = OrgChartServiceHelper.getAdminOrgTypeFilter();
        ListShowParameter adminOrgShowParameter = OrgChartServiceHelper.getListShowParameter((String)"haos_adminorgtype", (String)"bos_listf7", (QFilter)filter, (String)"number asc");
        adminOrgShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openAdminOrgTypeF7"));
        adminOrgShowParameter.setListSelectedRowCollection(OrgChartServiceHelper.getListSelectedRowCollection((JSONArray)adminorgTypes));
        adminOrgShowParameter.setMultiSelect(true);
        adminOrgShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)adminOrgShowParameter);
    }

    private void openPersonalStyle(String eventArgs) {
        this.getPageCache().put("0", "1");
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        String chartStyleId = jsonObject.getString("chartStyleId");
        List orgIds = jsonObject.getJSONArray("orgs").toJavaList(String.class);
        DynamicObject personalStyle = this.getDefaultPersonalStyle(chartStyleId, orgIds);
        if (personalStyle != null) {
            String content = personalStyle.getString("content_tag");
            PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
            personalStyleData.setId(personalStyle.getString("id"));
            HashMap<String, PersonalStyleData> data = new HashMap<String, PersonalStyleData>();
            data.put("data", personalStyleData);
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"personalStyleData", data, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
        }
    }

    private void openOrgChartStyleF7() {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)OrgChartConstants.ORG_CARDDISSION);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        List<Object> chartStyleIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)chartStyleIds)) {
            chartStyleIdList = chartStyleIds.stream().map(Long::parseLong).filter(id -> !id.equals(VIRTUAL_ORG_CHART_TYPE_ID)).collect(Collectors.toList());
        }
        QFilter idFilter = new QFilter("id", "in", chartStyleIdList);
        enableFilter.and(idFilter);
        ListShowParameter chartStyleShowParameter = OrgChartServiceHelper.getListShowParameter((String)"homs_chartstyle", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        chartStyleShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgChartStyleF7"));
        chartStyleShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)chartStyleShowParameter);
    }

    private void openPersonalF7(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        String chartStyleId = jsonObject.getString("chartStyleId");
        QFilter idFilter = new QFilter("chartstyle", "=", (Object)Long.parseLong(chartStyleId));
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            QFilter rootIdFilter = new QFilter("rootorg.boid", "in", this.getPermOrgs((AbstractFormPlugin)this));
            idFilter.and(rootIdFilter);
            HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg((String)"homs_orgchart");
            QFilter rootOrgOrgFilter = new QFilter("rootorg.org.id", "in", (Object)hrPermOrg.getHasPermOrgs());
            idFilter.and(rootOrgOrgFilter);
        }
        QFilter enableFilter = new QFilter("rootorg.enable", "=", (Object)Character.valueOf('1'));
        idFilter.and(enableFilter);
        ListShowParameter personalStyleShowParameter = OrgChartServiceHelper.getListShowParameter((String)"homs_personalstyle", (String)"bos_listf7", (QFilter)idFilter, (String)"createtime asc");
        personalStyleShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPersonalStyleF7"));
        this.getView().showForm((FormShowParameter)personalStyleShowParameter);
    }

    private void openOrgDetail(String eventArgs) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_orgchart");
        boolean hasAdminOrgDetailsPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_orgchart", (String)"2IGF5UN0V4EG");
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        Long nodeId = jsonObject.getLong("boid");
        Date date = jsonObject.getDate("date");
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (!hasAdminOrgDetailsPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u884c\u653f\u7ec4\u7ec7\u8be6\u60c5\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u5982\u6709\u9700\u8981\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgChartViewDetailsPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        } else if (!permOrgResultWithSub.isHasAllOrgPerm() && !this.getPermOrgs((AbstractFormPlugin)this).contains(nodeId)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObject queryResult = serviceHelper.queryOne("name", new QFilter[]{new QFilter("boid", "=", (Object)nodeId).and(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)date))});
            String tipMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u6682\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5\uff0c\u5982\u6709\u9700\u8981\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgChartViewDetailsPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), queryResult.getString("name"));
            this.getView().showTipNotification(tipMsg);
        } else {
            this.openOrgDetailsView(eventArgs);
        }
    }

    private void openOrgDetailsView(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        Long boid = jsonObject.getLong("boid");
        Date date = jsonObject.getDate("date");
        String isvirtualorg = jsonObject.getString("isvirtualorg");
        String structprojectId = this.getView().getPageCache().get("STRUCT_PROJECT_KEY");
        LOG.info("OrgChartViewDetailsPlugin boid:{},date:{}", (Object)boid, (Object)date);
        if (boid != 0L && !HRObjectUtils.isEmpty((Object)date)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            DynamicObject orgInfo = this.getAdminOrgInfo(boid, date);
            LOG.info("OrgChartViewDetailsPlugin info:{}", (Object)orgInfo);
            if ("\u5426".equals(isvirtualorg) && !HRObjectUtils.isEmpty((Object)orgInfo)) {
                showParameter.setFormId("haos_adminorgdetail");
                showParameter.setCustomParam("hideSafeInfo", (Object)"1");
                showParameter.setCustomParam("currentObjectPKId", (Object)boid.toString());
                showParameter.setCustomParam("boid", (Object)boid.toString());
                showParameter.setCustomParam("searchdate", (Object)date);
                showParameter.setCustomParam("structProjectId", (Object)structprojectId);
                showParameter.setCustomParam("searchdate", (Object)date);
                showParameter.setCustomParam("ue_param", (Object)"true");
                showParameter.setPkId((Object)orgInfo.getLong("id"));
                String prefix = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"OrgChartViewDetailsPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                showParameter.setCaption(prefix + "-" + orgInfo.getString("name"));
                showParameter.setHasRight(true);
            } else if ("\u662f".equals(isvirtualorg)) {
                showParameter.setFormId("haos_virtualorgdetail");
                if (this.getView().getMainView() != null) {
                    showParameter.setPageId(boid.toString() + "_" + this.getView().getMainView().getPageId());
                }
                showParameter.setCustomParam("structproject", (Object)structprojectId);
                showParameter.setCustomParam("soucce", (Object)"1");
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setPkId((Object)boid);
            }
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private DynamicObject getAdminOrgInfo(Long boid, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter boidFilter = new QFilter("boid", "=", (Object)boid);
        QFilter isCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter beginFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter endFilter = new QFilter("bsled", ">=", (Object)date);
        return helper.queryOne("id,name", new QFilter[]{boidFilter, isCurrentVersion, datastatusFilter, initStatusFilter, beginFilter, endFilter});
    }

    private void openCardEditView(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        JSONObject showFieldMap = jsonObject.getJSONObject("needShowFields");
        this.getPageCache().put("cardEditType", jsonObject.get((Object)"cardEditType").toString());
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("homs_cardedit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cardedit"));
        showParameter.setCustomParam("needShowFields", (Object)JSONObject.toJSONString((Object)showFieldMap));
        if ("add".equals(jsonObject.getString("type"))) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5361\u7247\u65b0\u589e", (String)"OrgChartPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u8f91", (String)"OrgChartPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("cardedit".equals(actionId)) {
            this.afterCardEdit(closedCallBackEvent);
        } else if ("openPersonalStyleF7".equals(actionId)) {
            this.afterSelectPersonalStyle(closedCallBackEvent);
        } else if ("openOrgChartStyleF7".equals(actionId)) {
            this.afterSelectChartStyle(closedCallBackEvent);
        } else if ("openAdminOrgTypeF7".equals(actionId)) {
            this.afterSelectAdminOrgType(closedCallBackEvent);
        } else if ("openTeamCooprelTypeF7".equals(actionId)) {
            this.afterSelectTeamCoopRelType(closedCallBackEvent);
        } else if ("openOrgF7".equals(actionId)) {
            this.afterOrgF7Select(closedCallBackEvent);
        }
    }

    private void afterOrgF7Select(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            ArrayList orgTeamInfos = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            selectedRows.forEach(org -> {
                JSONObject orgTeamInfo = new JSONObject();
                orgTeamInfo.put("id", (Object)String.valueOf(org.getPrimaryKeyValue()));
                orgTeamInfo.put("name", (Object)org.getName());
                orgTeamInfo.put("number", (Object)org.getName());
                orgIds.add(org.getPrimaryKeyValue().toString());
                orgTeamInfos.add(orgTeamInfo);
            });
            HashMap<String, ArrayList> result = new HashMap<String, ArrayList>();
            result.put("orgs", orgTeamInfos);
            this.getPageCache().put("newOrgId", JSONObject.toJSONString((Object)orgIds));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openOrgF7", result, (CustomControl)customcontrol);
        }
    }

    private void afterSelectTeamCoopRelType(ClosedCallBackEvent closedCallBackEvent) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject teamCoopRelTypeObj;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows) && (teamCoopRelTypeObj = (serviceHelper = new HRBaseServiceHelper("haos_teamcoopreltype")).queryOne("id,name,number", selectedRows.get(0).getPrimaryKeyValue())) != null) {
            JSONObject teamCoopRelType = new JSONObject();
            teamCoopRelType.put("id", (Object)teamCoopRelTypeObj.getString("id"));
            teamCoopRelType.put("name", (Object)teamCoopRelTypeObj.getString("name"));
            teamCoopRelType.put("number", (Object)teamCoopRelTypeObj.getString("number"));
            HashMap<String, JSONObject> data = new HashMap<String, JSONObject>();
            data.put("data", teamCoopRelType);
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openTeamCooprelTypeF7", data, (CustomControl)customcontrol);
        }
    }

    private void afterSelectAdminOrgType(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            ArrayList adminOrgTypes = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            selectedRows.forEach(dy -> {
                JSONObject adminOrgType = new JSONObject();
                adminOrgType.put("id", (Object)dy.getPrimaryKeyValue().toString());
                adminOrgType.put("name", (Object)dy.getName());
                adminOrgType.put("number", (Object)dy.getNumber());
                adminOrgTypes.add(adminOrgType);
            });
            HashMap<String, ArrayList> result = new HashMap<String, ArrayList>();
            result.put("showAdminOrgTypes", adminOrgTypes);
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openAdminOrgTypeF7", result, (CustomControl)customcontrol);
        }
    }

    private void afterSelectChartStyle(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            List orgIds;
            DynamicObject personalStyle;
            HashMap<String, Object> data = new HashMap<String, Object>();
            String chartStyleId = selectedRows.get(0).getPrimaryKeyValue().toString();
            this.getPageCache().put("currentChartStyleId", chartStyleId);
            String queryOrgIds = this.getPageCache().get("newOrgId");
            if (StringUtils.isEmpty((CharSequence)queryOrgIds)) {
                queryOrgIds = this.getPageCache().get("queryOrgId");
            }
            if ((personalStyle = this.getDefaultPersonalStyle(chartStyleId, orgIds = JSONObject.parseArray((String)queryOrgIds, String.class))) != null) {
                String content = personalStyle.getString("content_tag");
                PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
                personalStyleData.setId(personalStyle.getString("id"));
                data.put("personalStyle", personalStyleData);
                String isOpenPersonalStyle = this.getPageCache().get("0");
                if (HRStringUtils.isNotEmpty((String)isOpenPersonalStyle) && HRStringUtils.equals((String)"1", (String)isOpenPersonalStyle)) {
                    data.put("isOpenPersonalStyle", true);
                } else {
                    data.put("isOpenPersonalStyle", false);
                }
            } else {
                data.put("personalStyle", null);
                data.put("isOpenPersonalStyle", false);
                this.getPageCache().remove("0");
            }
            data.put("hasPersonalStyle", personalStyle != null ? 1 : 0);
            ArrayList<String> chartStyleIds = new ArrayList<String>();
            chartStyleIds.add(chartStyleId);
            Map chartStyles = OrgChartServiceHelper.getChartStyles(chartStyleIds);
            data.put("data", chartStyles.get(chartStyleId));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openOrgChartStyleF7", data, (CustomControl)customcontrol);
        }
    }

    private void afterSelectPersonalStyle(ClosedCallBackEvent closedCallBackEvent) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject personalStyle;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows) && (personalStyle = (serviceHelper = new HRBaseServiceHelper("homs_personalstyle")).queryOne("id,name,content,content_tag", selectedRows.get(0).getPrimaryKeyValue())) != null) {
            String content = personalStyle.getString("content_tag");
            PersonalStyleData personalStyleData = (PersonalStyleData)JSONObject.parseObject((String)content, PersonalStyleData.class);
            personalStyleData.setId(personalStyle.getString("id"));
            HashMap<String, PersonalStyleData> data = new HashMap<String, PersonalStyleData>();
            data.put("data", personalStyleData);
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"personalStyleData", data, (CustomControl)customcontrol);
        }
    }

    private void afterCardEdit(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        String cardEditType = this.getPageCache().get("cardEditType");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", returnData);
        data.put("cardEditType", cardEditType);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"cardedit", data, (CustomControl)customcontrol);
    }

    public static JSONObject getAdminOrgBaseInfo(String currentOrgId, Date queryDate, List<String> orgIds) {
        QFilter baseCommonFilterWithDate = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate);
        ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)orgIds.size());
        orgIds.forEach(orgId -> orgIdList.add(Long.parseLong(orgId)));
        QFilter orgIdFilter = new QFilter("org", "in", (Object)orgIdList);
        QFilter boIdFilter = new QFilter("boid", "=", (Object)Long.parseLong(currentOrgId));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter[] filters = new QFilter[]{baseCommonFilterWithDate, orgIdFilter, boIdFilter};
        DynamicObject currentOrgTeam = serviceHelper.queryOne("id,name,number,boid", filters);
        if (currentOrgTeam != null) {
            JSONObject currentOrgTeamInfo = new JSONObject();
            currentOrgTeamInfo.put("id", (Object)currentOrgTeam.getString("boid"));
            currentOrgTeamInfo.put("name", (Object)currentOrgTeam.getString("name"));
            currentOrgTeamInfo.put("number", (Object)currentOrgTeam.getString("number"));
            return currentOrgTeamInfo;
        }
        return null;
    }
}

