/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class OrgChartWaitPlugin
extends HRDynamicFormBasePlugin {
    private static final String CLOSE_CALLBACK_ID = "f7_close_callback_id";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean showAllFlag = "true".equals(this.getView().getFormShowParameter().getCustomParam("showAllAreas"));
        DynamicObject[] structProjectTypes = StructProjectRepository.getInstance().getUserStructProject(showAllFlag);
        if (structProjectTypes.length == 1) {
            DynamicObject structProjectType = structProjectTypes[0];
            String param = structProjectType.getString("id");
            this.showOrgChart(param);
        } else {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("haos_structproject");
            listShowParameter.setFormId("bos_listf7");
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss cssValue = new StyleCss();
            cssValue.setWidth("1000px");
            cssValue.setHeight("580px");
            listShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
            listShowParameter.setLookUp(true);
            String caption = ResManager.loadKDString((String)"\u7ba1\u7406\u67b6\u6784", (String)"OrgChartWaitPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            listShowParameter.setCaption(caption);
            listShowParameter.setShowTitle(false);
            listShowParameter.setMultiSelect(false);
            listShowParameter.setHasRight(true);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_ID));
            listShowParameter.getCustomParams().put("f7_admin_org_chart", Boolean.TRUE.toString());
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            listFilterParameter.getQFilters().addAll(StructProjectRepository.getInstance().createUserStructProjectFilter(showAllFlag));
            listFilterParameter.setOrderBy("issyspreset desc, number asc");
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)CLOSE_CALLBACK_ID)) {
            ListSelectedRowCollection listSelectedRows;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof ListSelectedRowCollection && (listSelectedRows = (ListSelectedRowCollection)returnData).size() == 1) {
                this.showOrgChart(listSelectedRows.get(0).getPrimaryKeyValue());
                return;
            }
            this.getView().close();
        }
    }

    private void showOrgChart(Object param) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("homs_orgchart");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCustomParam("showStructProjectType", param);
        showParameter.setCustomParam("showAllAreas", this.getView().getFormShowParameter().getCustomParam("showAllAreas"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

