/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgchart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hr.homs.business.service.helper.SystemParamHelper;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.PositionRelationServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartQueryParam;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.SearchChartData;

public class PositionRelationChartPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(PositionRelationChartPlugin.class);
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String HRCS = "hrcs";
    private static final String POSITION_FIELD = "id,boid,name,number,parent,workrole,workrole,isleader,org";
    private static final HRBaseServiceHelper POSITION_HELPER = new HRBaseServiceHelper("hbpm_positionhr");
    private static final String POSITION_CHART_COOPPERM = "positionchartcoopperm";
    private static final String CACHE_PERM_ORG_RESULT_WITHSUB = "perm_org_result_withsub";
    private static final String CACHE_PERM_ORG_RESULT_ALL = "cache_perm_org_result_all";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"homs_position");
        e.getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"adminorg");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId());
        OrgChartQueryParam orgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
        AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
        this.getPageCache().put("termRemain", "1");
        SearchChartData schemeSearchChartData = PositionRelationServiceHelper.getPositionSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
        if (schemeSearchChartData.getChartStyleId() == null) {
            this.setChartStyleId(schemeSearchChartData);
        }
        if (defaultScheme != null && !this.checkSearchChartData(schemeSearchChartData, "initData")) {
            defaultScheme = null;
            schemeSearchChartData = PositionRelationServiceHelper.getPositionSchemeSearchChartData(null);
            this.setChartStyleId(schemeSearchChartData);
        }
        if (defaultScheme != null) {
            schemeSearchChartData.setSchemeId(defaultScheme.getId());
        }
        Map<String, Object> result = this.getQueryShowParams(schemeSearchChartData);
        this.cachePositionChartCoopPerm();
        OrgChartTreeNode rootTreeNode = null;
        if (defaultScheme == null) {
            DynamicObject rootDy = this.getRootNodeDynamic(authorizedOrgResult);
            if (rootDy != null) {
                rootTreeNode = PositionRelationServiceHelper.getRootTreeNode((DynamicObject)rootDy, (SearchChartData)schemeSearchChartData, (AuthorizedOrgResult)authorizedOrgResult);
                result.put("positionId", PositionRelationServiceHelper.getPositionInfo((String)rootDy.getString("boid"), (Date)schemeSearchChartData.getDateField()));
                schemeSearchChartData.setPositionId(rootDy.getString("boid"));
            }
        } else {
            rootTreeNode = this.getRootNodeDynamicByScheme(schemeSearchChartData, authorizedOrgResult);
        }
        this.getPageCache().put("CURRENT_SEARCH_POSITION_ID", JSONObject.toJSONString((Object)schemeSearchChartData));
        result.put("positionNodeData", rootTreeNode);
        if (rootTreeNode == null) {
            result.put("hasOrgPerm", 1);
            result.put("showErrorInfo", ResManager.loadKDString((String)"\u60a8\u6743\u9650\u8303\u56f4\u5185\u65e0\u5c97\u4f4d\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u6216\u83b7\u53d6\u3002", (String)"PositionRelationChartPlugin_19", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        PositionRelationServiceHelper.positionPermQuery(result);
        this.setDataToCustomControl("initData", result, "200", "init");
    }

    private void cachePositionChartCoopPerm() {
        String orgs = this.getView().getPageCache().get("orgs");
        List orgIds = SerializationUtils.fromJsonStringToList((String)orgs, String.class);
        Set orgSet = orgIds.stream().map(orgId -> Long.parseLong(orgId)).collect(Collectors.toSet());
        Map chartParameter = SystemParamHelper.getBatchOrgParameter(orgSet, (String)POSITION_CHART_COOPPERM);
        Iterator iterator = chartParameter.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            iterator.remove();
        }
        this.getView().getPageCache().remove("orgs");
        if (chartParameter == null || chartParameter.isEmpty()) {
            return;
        }
        LOG.info("positionchartcoopperm = {}", (Object)SerializationUtils.toJsonString((Object)chartParameter));
        this.getView().getPageCache().put(POSITION_CHART_COOPPERM, SerializationUtils.toJsonString((Object)chartParameter));
    }

    private OrgChartTreeNode getRootNodeDynamicByScheme(SearchChartData schemeSearchChartData, AuthorizedOrgResult authorizedOrgResult) {
        QFilter filter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)schemeSearchChartData.getDateField());
        filter.and(new QFilter("boid", "=", (Object)Long.parseLong(schemeSearchChartData.getPositionId())));
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
            filter.and(new QFilter("adminorg", "in", (Object)hasPermOrgs));
        }
        List orgsIdList = schemeSearchChartData.getOrgs().stream().map(Long::parseLong).collect(Collectors.toList());
        filter.and(new QFilter("org", "in", orgsIdList));
        DynamicObject rootDy = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{filter});
        if (HRObjectUtils.isEmpty((Object)rootDy)) {
            LOG.info("getRootNodeDynamicByScheme rootDy is null");
            return null;
        }
        List cooprelTypes = schemeSearchChartData.getCoopRelTypes();
        if (!CollectionUtils.isEmpty((Collection)cooprelTypes)) {
            String cooprelTypeId = (String)cooprelTypes.get(0);
            if (HRStringUtils.equals((String)"1010", (String)cooprelTypeId)) {
                return PositionRelationServiceHelper.getRootTreeNode((DynamicObject)rootDy, (SearchChartData)schemeSearchChartData, (AuthorizedOrgResult)authorizedOrgResult);
            }
            String batchOrgParameter = this.getView().getPageCache().get(POSITION_CHART_COOPPERM);
            Map positionCooppermMap = StringUtils.isEmpty((CharSequence)batchOrgParameter) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(POSITION_CHART_COOPPERM), Map.class);
            return PositionRelationServiceHelper.getRootTreeNodeByCooperationType((DynamicObject)rootDy, (SearchChartData)schemeSearchChartData, (AuthorizedOrgResult)authorizedOrgResult, positionCooppermMap);
        }
        LOG.info("getRootNodeDynamicByScheme cooprelTypes is null");
        return null;
    }

    private void setChartStyleId(SearchChartData schemeSearchChartData) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)Long.parseLong("1110"));
        chartStyleIds.add("1002");
        Map chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles((Collection)chartStyleIds);
        ChartStyle matchChartStyle = OrgChartServiceHelper.findBestMatchChartStyle((Map)chartStyleIdChartStyleMap, (String)"1002");
        if (matchChartStyle == null) {
            matchChartStyle = (ChartStyle)chartStyleIdChartStyleMap.get("1002");
        }
        schemeSearchChartData.setChartStyleId(matchChartStyle.getId());
    }

    private Map<String, Object> getQueryShowParams(SearchChartData searchChartData) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("queryDate", searchChartData.getDateField());
        result.put("orgs", OrgChartServiceHelper.getOrgInfo((List)searchChartData.getOrgs()));
        this.getView().getPageCache().put("orgs", SerializationUtils.toJsonString((Object)searchChartData.getOrgs()));
        result.put("positionId", PositionRelationServiceHelper.getPositionInfo((String)searchChartData.getPositionId(), (Date)searchChartData.getDateField()));
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getCoopRelTypes())) {
            List cooprelTypeIds = searchChartData.getCoopRelTypes().stream().map(Long::parseLong).collect(Collectors.toList());
            result.put("showCooprelTypes", PositionRelationServiceHelper.getCoopRelTypes(cooprelTypeIds));
        } else {
            result.put("showCooprelTypes", new ArrayList());
        }
        ChartStyle chartStyle = OrgChartServiceHelper.getChartStyleById((String)searchChartData.getChartStyleId());
        result.put("MATCH_CHART_STYLE_KEY", chartStyle);
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye((ChartStyle)chartStyle, (List)OrgChartServiceHelper.getDesensitizeFields((long)OrgChartConstants.POSITION_CARDDISSION)));
        result.put("showLevel", searchChartData.getShowLevel());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getSchemeId())) {
            result.put("showScheme", new SchemeQuery().getScheme(searchChartData.getSchemeId()));
        } else {
            result.put("showScheme", null);
        }
        result.put("orgchartdirection", searchChartData.getOrgChartDirection());
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
        result.put("schemes", schemes);
        CommonOrgChartServiceHelper.setTermRemaning(result, (String)this.getPageCache().get("termRemain"));
        this.getPageCache().remove("termRemain");
        return result;
    }

    private DynamicObject getRootNodeDynamic(AuthorizedOrgResult authorizedOrgResult) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            QFilter orgFilter = new QFilter("org", "in", (Object)OrgChartServiceHelper.getDefaultOrg((String)"homs_positionrelation"));
            QFilter leaderFilter = new QFilter("isleader", "=", (Object)"1");
            QFilter adminOrgFilter = new QFilter("adminorg", "=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
            DynamicObject positionDy = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{adminOrgFilter, orgFilter, leaderFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date())}, "number");
            if (!HRObjectUtils.isEmpty((Object)positionDy)) {
                return positionDy;
            }
            DynamicObject positionNotLeader = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{adminOrgFilter, orgFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date())}, "number");
            if (!HRObjectUtils.isEmpty((Object)positionDy)) {
                return positionNotLeader;
            }
            DynamicObject positionNotRoot = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{orgFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date())}, "number");
            if (!HRObjectUtils.isEmpty((Object)positionNotRoot)) {
                return positionNotRoot;
            }
        } else {
            QFilter currentFilter;
            List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
            QFilter adminOrgFilter = new QFilter("orgteam", "in", (Object)hasPermOrgs);
            DynamicObject[] query = serviceHelper.query("id,boid,level,orgteam", new QFilter[]{adminOrgFilter, currentFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1')), (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get()});
            if (query != null && query.length > 0) {
                Map<Integer, List<Long>> levelToOrgIds = Arrays.stream(query).collect(Collectors.groupingBy(dy -> dy.getInt("level"), Collectors.mapping(dy -> dy.getLong("orgteam.id"), Collectors.toList())));
                ArrayList<Integer> levelList = new ArrayList<Integer>(levelToOrgIds.keySet());
                Collections.sort(levelList);
                return this.getPositionRootId(levelToOrgIds, levelList);
            }
        }
        return null;
    }

    private DynamicObject getPositionRootId(Map<Integer, List<Long>> levelToOrgIds, List<Integer> levelList) {
        if (CollectionUtils.isEmpty(levelToOrgIds) || CollectionUtils.isEmpty(levelList)) {
            return null;
        }
        List defaultOrg = OrgChartServiceHelper.getDefaultOrg((String)"homs_positionrelation");
        QFilter orgFilter = new QFilter("org", "in", (Object)defaultOrg);
        for (Integer level : levelList) {
            QFilter leaderFilter;
            List<Long> adminOrgIds = levelToOrgIds.get(level);
            QFilter adminOrgFilter = new QFilter("adminorg", "in", adminOrgIds);
            DynamicObject positionDy = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{orgFilter, adminOrgFilter, leaderFilter = new QFilter("isleader", "=", (Object)"1"), OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date())}, "number");
            if (!HRObjectUtils.isEmpty((Object)positionDy)) {
                return positionDy;
            }
            DynamicObject positionNotLeader = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{orgFilter, adminOrgFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date())}, "number");
            if (HRObjectUtils.isEmpty((Object)positionNotLeader)) continue;
            return positionNotLeader;
        }
        return null;
    }

    private AuthorizedOrgResult getAuthorizedOrgResult() {
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT_ALL);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResult.class);
        }
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appIdFromShowParam = HRPermUtil.getAppIdFromShowParam((FormShowParameter)formShowParameter);
        String appId = AppIdServiceHelper.getPermAppId((String)appIdFromShowParam, (String)permEntityId);
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, appId, permEntityId, permItemId, "boid"});
        this.getPageCache().put(CACHE_PERM_ORG_RESULT_ALL, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "openOrgF7": {
                JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
                this.getPageCache().put("queryDate", jsonObject.getString("queryDate"));
                this.getPageCache().put("positionId", jsonObject.getString("positionId"));
                JSONArray orgList = jsonObject.getJSONArray("orgs");
                this.openOrgsF7(orgList);
                break;
            }
            case "openPositionF7": {
                this.openPositionF7(eventArgs);
                break;
            }
            case "openOrgChartStyleF7": {
                this.openOrgChartStyleF7(OrgChartConstants.POSITION_CARDDISSION);
                break;
            }
            case "searchChartData": {
                SearchChartData searchChartData = (SearchChartData)JSONObject.parseObject((String)eventArgs, SearchChartData.class);
                this.queryChart(searchChartData);
                break;
            }
            case "schemeQueryOrgChart": {
                JSONObject schemeObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
                String schemeId = schemeObject.getString("schemeId");
                this.getPageCache().put("schemeId", schemeId);
                this.queryOrgChartByScheme(schemeId);
                break;
            }
            case "saveOrUpdateScheme": {
                this.saveOrUpdateScheme(eventArgs);
                break;
            }
            case "setDefaultScheme": {
                this.setDefaultScheme(eventArgs);
                break;
            }
            case "deleteScheme": {
                this.deleteScheme(eventArgs);
                break;
            }
            case "viewdetails": {
                this.openPositionDetailView(eventArgs);
                break;
            }
            case "closePositionChart": {
                this.getView().close();
                break;
            }
            case "refreshPositionChart": {
                this.refresh(eventArgs);
                break;
            }
            case "openTeamCooprelTypeF7": {
                this.openTeamCoopRelTypeF7(Collections.singleton(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID));
                break;
            }
            case "positionChartPermQuery": {
                this.positionChartPermQuery();
                break;
            }
            case "desensitizeInfoQuery": {
                this.desensitizeInfoQuery(eventArgs);
                break;
            }
            case "nodeUpholeQuery": {
                String parentNodeId = ((JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class)).getString("parentNodeId");
                this.changeTopNodeQuery(parentNodeId);
                break;
            }
            case "changeTopNodeQuery": {
                String currentNodeId = ((JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class)).getString("currentNodeId");
                this.changeTopNodeQuery(currentNodeId);
                break;
            }
            case "addChartExportOperateLog": {
                CommonOrgChartServiceHelper.addChartExportOperateLog((String)"homs_positionrelation", (String)operateName);
                break;
            }
        }
    }

    private void changeTopNodeQuery(String currentNodeId) {
        String searchChartDataStr = this.getPageCache().get("CURRENT_SEARCH_POSITION_ID");
        if (StringUtils.isNotEmpty((CharSequence)searchChartDataStr) && StringUtils.isNotEmpty((CharSequence)currentNodeId)) {
            SearchChartData searchChartData = (SearchChartData)JSONObject.parseObject((String)searchChartDataStr, SearchChartData.class);
            searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
            searchChartData.setPositionId(currentNodeId);
            this.queryChart(searchChartData);
        }
    }

    private void desensitizeInfoQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String currentNodeId = jsonObject.getString("positionId");
        String personName = jsonObject.getString("personname");
        String datefieldStr = this.getPageCache().get("datefield");
        Date queryDate = new Date();
        if (!StringUtils.isEmpty((CharSequence)datefieldStr)) {
            try {
                queryDate = HRDateTimeUtils.parseDate((String)datefieldStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("date:{0}", datefieldStr));
            }
        }
        int isDesensitize = jsonObject.getInteger("isDesensitize");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object resultValue = PositionRelationServiceHelper.getPersonDesensitizeValue((String)currentNodeId, (String)personName, (int)isDesensitize, (Date)queryDate);
        result.put("personname", resultValue);
        this.setDataToCustomControl("desensitizeInfoQuery", result, "200", "update");
    }

    private void positionChartPermQuery() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PositionRelationServiceHelper.positionPermQuery(result);
        int hasPositionExportPerm = result.getOrDefault("hasPositionExportPerm", 0);
        if (hasPositionExportPerm != 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5c97\u4f4d\u5173\u7cfb\u56fe\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionRelationChartPlugin_16", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
        }
        this.setDataToCustomControl("positionChartPermQuery", result, "200", "update");
    }

    private void openTeamCoopRelTypeF7(Collection<Long> otclassifyIds) {
        QFilter filter = this.getTeamCoopRelTypeQFilter(otclassifyIds);
        ListShowParameter teamCoopRelTypeShowParameter = OrgChartServiceHelper.getListShowParameter((String)"hbpm_reportcoreltype", (String)"bos_listf7", (QFilter)filter, (String)"number asc");
        teamCoopRelTypeShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openTeamCooprelTypeF7"));
        teamCoopRelTypeShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)teamCoopRelTypeShowParameter);
    }

    private QFilter getTeamCoopRelTypeQFilter(Collection<Long> otclassifyIds) {
        HasPermOrgResult permOrg;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportcoreltype");
        QFilter filter = new QFilter("enable", "in", Arrays.asList("1", "0"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(filter.toArray());
        HashSet teamCoopRelTypeIds = new HashSet();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("orgteamtype");
            dynamicObjectCollection.forEach(dy -> {
                if (otclassifyIds.contains(dy.getLong("fbasedataid.id"))) {
                    teamCoopRelTypeIds.add(dynamicObject.getLong("id"));
                }
            });
        }
        if (!CollectionUtils.isEmpty(teamCoopRelTypeIds)) {
            QFilter idFilter = new QFilter("id", "in", teamCoopRelTypeIds);
            filter.and(idFilter);
        }
        if (!(permOrg = OrgPermHelper.getHRPermOrg((String)"homs_positionrelation")).hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrg.getHasPermOrgs())) {
            QFilter baseDataFilter = BaseDataHelper.getBaseDataFilter((String)"hbpm_reportcoreltype", (List)permOrg.getHasPermOrgs());
            filter.and(baseDataFilter);
        }
        return filter;
    }

    private void refresh(String eventArgs) {
        this.removePageCache();
        SearchChartData searchChartData = this.getSearchChartDate();
        this.getPageCache().put("termRemain", "1");
        Map<Object, Object> result = new HashMap();
        OrgChartTreeNode rootTreeNode = null;
        AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
        if (this.checkSearchChartData(searchChartData, "refreshPositionChart")) {
            rootTreeNode = this.getRootNodeDynamicByScheme(searchChartData, authorizedOrgResult);
            result = this.getQueryShowParams(searchChartData);
        } else {
            SearchChartData schemeSearchChartData = PositionRelationServiceHelper.getPositionSchemeSearchChartData(null);
            DynamicObject rootDy = this.getRootNodeDynamic(authorizedOrgResult);
            if (rootDy != null) {
                rootTreeNode = PositionRelationServiceHelper.getRootTreeNode((DynamicObject)rootDy, (SearchChartData)schemeSearchChartData, (AuthorizedOrgResult)authorizedOrgResult);
                schemeSearchChartData.setPositionId(rootDy.getString("id"));
                result = this.getQueryShowParams(schemeSearchChartData);
            } else {
                schemeSearchChartData.setChartStyleId("1002");
                result = this.getQueryShowParams(schemeSearchChartData);
            }
        }
        result.put("positionNodeData", rootTreeNode);
        PositionRelationServiceHelper.positionPermQuery(result);
        this.setDataToCustomControl("refreshPositionChart", result, "200", "update");
    }

    private void removePageCache() {
        this.getPageCache().remove(CACHE_PERM_ORG_RESULT_WITHSUB);
        this.getPageCache().remove(CACHE_PERM_ORG_RESULT_ALL);
    }

    private SearchChartData getSearchChartDate() {
        String searchChartDataStr = this.getPageCache().get("CURRENT_SEARCH_POSITION_ID");
        if (HRStringUtils.isNotEmpty((String)searchChartDataStr)) {
            return (SearchChartData)JSONObject.parseObject((String)searchChartDataStr, SearchChartData.class);
        }
        SearchChartData searchChartData = new SearchChartData();
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId());
        if (defaultScheme != null) {
            OrgChartQueryParam orgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
            searchChartData = PositionRelationServiceHelper.getPositionSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
            searchChartData.setSchemeId(defaultScheme.getId());
        } else {
            searchChartData = PositionRelationServiceHelper.getPositionSchemeSearchChartData(null);
            this.setChartStyleId(searchChartData);
        }
        return searchChartData;
    }

    private void openOrgChartStyleF7(long crtsStyDimensionId) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)crtsStyDimensionId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        List<Object> chartStyleIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)chartStyleIds)) {
            chartStyleIdList = chartStyleIds.stream().map(Long::parseLong).collect(Collectors.toList());
        }
        QFilter idFilter = new QFilter("id", "in", chartStyleIdList);
        enableFilter.and(idFilter);
        ListShowParameter chartStyleShowParameter = OrgChartServiceHelper.getListShowParameter((String)"homs_position_chartstyle", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        chartStyleShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgChartStyleF7"));
        chartStyleShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)chartStyleShowParameter);
    }

    private void openPositionDetailView(String eventArgs) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_positionrelation");
        boolean hasPositionDetailsPerm = PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_positionrelation", (String)"2O23NJWUF=WK");
        if (!hasPositionDetailsPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5c97\u4f4d\u5173\u7cfb\u56fe\u201d\u7684\u201c\u67e5\u8be2\u5c97\u4f4d\u8be6\u60c5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionRelationChartPlugin_15", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        String positionId = jsonObject.getString("id");
        Date date = jsonObject.getDate("date");
        if (HRStringUtils.isNotEmpty((String)positionId) && !HRObjectUtils.isEmpty((Object)date)) {
            QFilter boidFilter = new QFilter("boid", "=", (Object)Long.parseLong(positionId));
            DynamicObject dy = POSITION_HELPER.queryOne(POSITION_FIELD, new QFilter[]{boidFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)date)});
            if (HRObjectUtils.isEmpty((Object)dy)) {
                LOG.info("openPositionDetailView get positionInfo is null");
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("homs_positionbill");
            showParameter.setCustomParam("position_chart_hideInfo", (Object)"1");
            showParameter.setCustomParam("position", (Object)dy.getString("id"));
            showParameter.setCustomParam("hasPositionBill", (Object)"false");
            showParameter.setCustomParam("historyDate", (Object)date);
            showParameter.setCustomParam("historyField", (Object)"adminorg,parent");
            showParameter.setCustomParam("operationStatus", (Object)"showHistory");
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5c97\u4f4d - %1$s", (String)"PositionRelationChartPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), dy.getString("name"));
            showParameter.setCaption(message);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void deleteScheme(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_positionrelation");
        filterContainer.deleteScheme(schemeId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
        result.put("schemes", schemes);
        this.setDataToCustomControl("deleteScheme", result, "200", "update");
    }

    private void setDefaultScheme(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        Boolean isDefault = jsonObject.getBoolean("isDefault");
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_positionrelation");
        filterContainer.setDefaultScheme(schemeId, isDefault.booleanValue());
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("schemes", schemes);
        result.put("showScheme", new SchemeQuery().getScheme(schemeId));
        this.setDataToCustomControl("setDefaultScheme", result, "200", "update");
    }

    private void saveOrUpdateScheme(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> filterSchemeMap = new HashMap<String, Object>();
        filterSchemeMap.put("schemeName", jsonObject.getString("schemeName").trim());
        filterSchemeMap.put("entryEntity", "homs_positionrelation");
        ArrayList schemeRows = new ArrayList();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        schemeRows.add(map);
        OrgChartQueryParam orgChartQueryParam = (OrgChartQueryParam)jsonObject.getObject("scheme", OrgChartQueryParam.class);
        boolean isSameDay = CommonOrgChartServiceHelper.isSameDay((String)orgChartQueryParam.getQueryDate(), (Date)new Date());
        if (isSameDay) {
            orgChartQueryParam.setQueryDate("today");
        }
        map.put("FieldName", Collections.singletonList(JSONObject.toJSONString((Object)orgChartQueryParam)));
        map.put("Compare", Lists.newArrayList((Object[])new Object[]{""}));
        map.put("Value", new ArrayList());
        filterSchemeMap.put("scheme", schemeRows);
        if (!StringUtils.isEmpty((CharSequence)jsonObject.getString("schemeId"))) {
            filterSchemeMap.put("id", jsonObject.getString("schemeId"));
        }
        FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_positionrelation");
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)orgChartQueryParam);
        if (!this.schemeCheck(filterSchemeMap, schemeSearchChartData)) {
            filterContainer.saveScheme(filterSchemeMap);
            List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
            result.put("schemes", schemes);
            for (FilterScheme filterScheme : schemes) {
                if (!filterScheme.getSchemeName().equals(jsonObject.getString("schemeName"))) continue;
                String scheme = filterScheme.getScheme();
                OrgChartQueryParam positionQueryParam = (OrgChartQueryParam)JSONObject.parseObject((String)scheme, OrgChartQueryParam.class);
                SearchChartData searchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)positionQueryParam);
                searchChartData.setSchemeId(filterScheme.getId());
                Map<String, Object> showParams = this.getQueryShowParams(searchChartData);
                result.put("showScheme", showParams);
                break;
            }
        }
        this.setDataToCustomControl("saveOrUpdateScheme", result, "200", "update");
    }

    private void queryOrgChartByScheme(String schemeId) {
        FilterScheme scheme = new SchemeQuery().getScheme(schemeId);
        Map<String, Object> result = new HashMap<String, Object>();
        OrgChartQueryParam schemeOrgChartQueryParam = OrgChartServiceHelper.analyzeScheme((FilterScheme)scheme);
        SearchChartData schemeSearchChartData = OrgChartServiceHelper.getSchemeSearchChartData((OrgChartQueryParam)schemeOrgChartQueryParam);
        if (this.checkSearchChartData(schemeSearchChartData, "schemeQueryOrgChart")) {
            AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
            schemeSearchChartData.setSchemeId(schemeId);
            OrgChartTreeNode rootTreeNode = this.getRootNodeDynamicByScheme(schemeSearchChartData, authorizedOrgResult);
            result = this.getQueryShowParams(schemeSearchChartData);
            result.put("positionNodeData", rootTreeNode);
            this.getPageCache().put("CURRENT_SEARCH_POSITION_ID", JSONObject.toJSONString((Object)schemeSearchChartData));
            this.setDataToCustomControl("schemeQueryOrgChart", result, "200", "update");
            return;
        }
        this.setDataToCustomControl("schemeQueryOrgChart", result, "200", "update");
    }

    private void showSchemeQueryErrorInfo(String errorDesc) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("schemeQueryCallbackKey", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bf4", (String)"PositionRelationChartPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u5220\u9664", (String)"PositionRelationChartPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u67e5\u8be2\u65b9\u6848\u7684\u6761\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u8be2\uff0c\u662f\u5426\u5220\u9664\u65b9\u6848\uff1f", (String)"PositionRelationChartPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, errorDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (HRStringUtils.equals((String)"schemeQueryCallbackKey", (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String schemeId = this.getPageCache().get("schemeId");
                FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_positionrelation");
                filterContainer.deleteScheme(schemeId);
                List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
                result.put("schemes", schemes);
                result.put("updateSchemeList", true);
                this.setDataToCustomControl("dealtScheme", result, "200", "update");
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                result.put("updateSchemeList", false);
                this.setDataToCustomControl("dealtScheme", result, "200", "update");
            }
        }
    }

    private void queryChart(SearchChartData searchChartData) {
        this.getPageCache().put("datefield", HRDateTimeUtils.format((Date)(searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField()), (String)"yyyy-MM-dd"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (searchChartData != null && this.checkQueryParam(searchChartData)) {
            AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
            OrgChartTreeNode rootNodeDynamicByScheme = this.getRootNodeDynamicByScheme(searchChartData, authorizedOrgResult);
            ChartStyle chartStyle = OrgChartServiceHelper.getChartStyleById((String)searchChartData.getChartStyleId());
            List cardStyles = chartStyle.getCardStyles();
            if (cardStyles != null && !cardStyles.isEmpty()) {
                result.put("cardstyle", cardStyles.get(0));
            }
            result.put("isShowEye", OrgChartServiceHelper.getIsShowEye((ChartStyle)chartStyle, (List)OrgChartServiceHelper.getDesensitizeFields((long)OrgChartConstants.POSITION_CARDDISSION)));
            result.put("positionId", PositionRelationServiceHelper.getPositionInfo((String)searchChartData.getPositionId(), (Date)searchChartData.getDateField()));
            result.put("positionNodeData", rootNodeDynamicByScheme);
            this.getPageCache().put("CURRENT_SEARCH_POSITION_ID", JSONObject.toJSONString((Object)searchChartData));
        }
        this.setDataToCustomControl("searchChartData", result, "200", "update");
    }

    private boolean checkSearchChartData(SearchChartData searchChartData, String event) {
        StringBuilder sb = new StringBuilder();
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_positionrelation");
        Set orgs = searchChartData.getOrgs().stream().map(org -> Long.parseLong(org)).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty((Collection)searchChartData.getOrgs()) || !permOrg.hasAllOrgPerm() && !permOrg.getHasPermOrgs().containsAll(orgs)) {
            sb.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"PositionRelationChartPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (!this.checkQueryPosition(searchChartData, event, permOrg)) {
            sb.append(ResManager.loadKDString((String)"\u67e5\u8be2\u5c97\u4f4d\u3001", (String)"PositionRelationChartPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (!this.checkChartStyle(searchChartData)) {
            sb.append(ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f\u3001", (String)"PositionRelationChartPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (!this.checkCoopRelTypes(searchChartData)) {
            sb.append(ResManager.loadKDString((String)"\u6c47\u62a5\u53ca\u534f\u4f5c\u5173\u7cfb\u3001", (String)"PositionRelationChartPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            String error = sb.substring(0, sb.length() - 1);
            if (HRStringUtils.equals((String)"schemeQueryOrgChart", (String)event)) {
                error = error.concat(ResManager.loadKDString((String)"\u53d1\u751f\u53d8\u52a8\uff0c\u65b9\u6848\u4e0d\u53ef\u67e5\u8be2\uff0c\u53ef\u80fd\u4e3a\u4ee5\u4e0b\u539f\u56e0\uff1a\u2460\u6ca1\u6709\u5bf9\u5e94\u6743\u9650 \u2461\u5b57\u6bb5\u7684\u503c\u88ab\u5220\u9664\u3002", (String)"OrgChartPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0])).concat("\n").concat(ResManager.loadKDString((String)"\u60a8\u53ef\u5220\u9664\u65b9\u6848\u6216\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"OrgChartPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                this.showSchemeQueryErrorInfo(error);
                return false;
            }
            if (HRStringUtils.equals((String)"refreshPositionChart", (String)event) || HRStringUtils.equals((String)"initData", (String)event)) {
                String tipMessage = ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u201c%s\u201d\u9009\u5b9a\u7684\u503c\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5207\u6362\u5230\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u9ed8\u8ba4\u7684\u503c\u8fdb\u884c\u67e5\u770b\u3002", (String)"PositionRelationChartPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[]{error});
                this.getView().showTipNotification(tipMessage);
            }
            return false;
        }
        return true;
    }

    private boolean checkQueryPosition(SearchChartData searchChartData, String event, HasPermOrgResult permOrg) {
        List hasPermOrgs;
        if (StringUtils.isEmpty((CharSequence)searchChartData.getPositionId())) {
            return false;
        }
        Date date = searchChartData.getDateField();
        String positionId = searchChartData.getPositionId();
        QFilter filter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)date);
        AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
            filter.and(new QFilter("adminorg", "in", (Object)hasPermOrgs));
        }
        if (!permOrg.hasAllOrgPerm()) {
            hasPermOrgs = permOrg.getHasPermOrgs();
            filter.and(new QFilter("org", "in", (Object)hasPermOrgs));
        }
        filter.and("boid", "=", (Object)Long.parseLong(positionId));
        return POSITION_HELPER.isExists(new QFilter[]{filter});
    }

    private boolean checkCoopRelTypes(SearchChartData searchChartData) {
        if (!CollectionUtils.isEmpty((Collection)searchChartData.getCoopRelTypes())) {
            String coopRelType = (String)searchChartData.getCoopRelTypes().get(0);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportcoreltype");
            QFilter filter = this.getTeamCoopRelTypeQFilter(Collections.singleton(OrgChartConstants.DEFAULT_OTCCLASSIFY_ID));
            DynamicObject[] coopRelTypes = helper.query(filter.toArray());
            return Arrays.stream(coopRelTypes).map(dy -> dy.getString("id")).anyMatch(id -> id.equals(coopRelType));
        }
        return false;
    }

    private boolean checkChartStyle(SearchChartData searchChartData) {
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
            Set chartStyleIds = OrgChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, (Long)Long.parseLong("1110"));
            chartStyleIds.add("1002");
            return chartStyleIds.contains(searchChartData.getChartStyleId());
        }
        return false;
    }

    private void openPositionF7(String eventArgs) {
        List orgList;
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        AuthorizedOrgResult authorizedOrgResult = this.getAuthorizedOrgResult();
        QFilter enableQfilter = new QFilter("enable", "=", (Object)"1");
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            enableQfilter.and(new QFilter("adminorg", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
        }
        if (!CollectionUtils.isEmpty((Collection)(orgList = jsonObject.getJSONArray("orgs").toJavaList(String.class)))) {
            List orgIds = orgList.stream().map(Long::parseLong).collect(Collectors.toList());
            enableQfilter.and(new QFilter("org", "in", orgIds));
        }
        String queryDate = jsonObject.getString("queryDate");
        Date date = new Date();
        if (HRStringUtils.isNotEmpty((String)queryDate)) {
            try {
                date = HRDateTimeUtils.parseDate((String)queryDate, (String)"yyyy-MM-dd");
            }
            catch (Exception exception) {
                LOG.error("isUpdatePositionByOrgs date error" + queryDate);
            }
            enableQfilter.and(PositionRelationServiceHelper.getDateFilterWithDate((Date)date));
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
            QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
            QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            enableQfilter.and(dataStatusFilter);
            enableQfilter.and(initStatusFilter);
            enableQfilter.and(currentVersionFilter);
        }
        ListShowParameter showParameter = OrgChartServiceHelper.getListShowParameter((String)"hbpm_positionhr", (String)"hbpm_positiontreelistf7", (QFilter)enableQfilter, (String)"number asc");
        showParameter.setCustomParam("selData", (Object)false);
        showParameter.setCustomParam("showEnableDate", (Object)"1");
        showParameter.setCustomParam("positionChartDate", (Object)date);
        showParameter.setCustomParam("useDefaultDate", (Object)false);
        showParameter.setCustomParam("effDateFieldType", (Object)"effDate");
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openPositionF7"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openOrgsF7(JSONArray orgList) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        HasPermOrgResult permOrg = OrgPermHelper.getHRPermOrg((String)"homs_positionrelation");
        if (!permOrg.hasAllOrgPerm() && !permOrg.getHasPermOrgs().isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", (Object)permOrg.getHasPermOrgs());
            enableFilter.and(qFilter);
        }
        ListShowParameter showParameter = OrgChartServiceHelper.getListShowParameter((String)"bos_org", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        showParameter.setListSelectedRowCollection(OrgChartServiceHelper.getListSelectedRowCollection((JSONArray)orgList));
        showParameter.setMultiSelect(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"PositionRelationChartPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgF7"));
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("openOrgF7".equals(actionId)) {
            this.afterOrgF7Select(closedCallBackEvent);
        } else if ("openPositionF7".equals(actionId)) {
            this.afterPositionF7Select(closedCallBackEvent);
        } else if ("openOrgChartStyleF7".equals(actionId)) {
            this.afterSelectChartStyle(closedCallBackEvent);
        } else if ("openTeamCooprelTypeF7".equals(actionId)) {
            this.afterSelectTeamCoopRelType(closedCallBackEvent);
        }
    }

    private void afterSelectTeamCoopRelType(ClosedCallBackEvent closedCallBackEvent) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject teamCoopRelTypeObj;
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)selectedRows) && (teamCoopRelTypeObj = (serviceHelper = new HRBaseServiceHelper("hbpm_reportcoreltype")).queryOne("id,name,number", selectedRows.get(0).getPrimaryKeyValue())) != null) {
            JSONObject teamCoopRelType = new JSONObject();
            teamCoopRelType.put("id", (Object)teamCoopRelTypeObj.getString("id"));
            teamCoopRelType.put("name", (Object)teamCoopRelTypeObj.getString("name"));
            teamCoopRelType.put("number", (Object)teamCoopRelTypeObj.getString("number"));
            data.put("data", teamCoopRelType);
        }
        this.setDataToCustomControl("openTeamCooprelTypeF7", data, "200", "update");
    }

    private void afterSelectChartStyle(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            String chartStyleId = selectedRows.get(0).getPrimaryKeyValue().toString();
            ArrayList<String> chartStyleIds = new ArrayList<String>();
            chartStyleIds.add(chartStyleId);
            Map chartStyles = OrgChartServiceHelper.getChartStyles(chartStyleIds);
            result.put("data", chartStyles.get(chartStyleId));
            this.setDataToCustomControl("openOrgChartStyleF7", result, "200", "update");
        } else {
            this.setDataToCustomControl("openOrgChartStyleF7", result, "200", "update");
        }
    }

    private void afterPositionF7Select(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)selectedRows) && selectedRows.size() > 0) {
            JSONObject positionInfo = new JSONObject();
            DynamicObject positionDy = POSITION_HELPER.queryOne(POSITION_FIELD, selectedRows.get(0).getPrimaryKeyValue());
            positionInfo.put("id", (Object)positionDy.getString("boid"));
            positionInfo.put("number", (Object)selectedRows.get(0).getNumber());
            positionInfo.put("name", (Object)selectedRows.get(0).getName());
            result.put("positionInfo", positionInfo);
        }
        this.setDataToCustomControl("openPositionF7", result, "200", "update");
    }

    private void afterOrgF7Select(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            ArrayList orgInfos = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            selectedRows.forEach(org -> {
                JSONObject orgInfo = new JSONObject();
                orgInfo.put("id", (Object)String.valueOf(org.getPrimaryKeyValue()));
                orgInfo.put("number", (Object)org.getNumber());
                orgInfo.put("name", (Object)org.getName());
                orgInfos.add(orgInfo);
                orgIds.add(Long.parseLong(org.getPrimaryKeyValue().toString()));
            });
            result.put("orgs", orgInfos);
            result.put("existPosition", this.isExistPositionByOrgs(orgIds));
        }
        this.setDataToCustomControl("openOrgF7", result, "200", "update");
    }

    private boolean isExistPositionByOrgs(List<Long> orgIds) {
        String positionId = this.getPageCache().get("positionId");
        String queryDate = this.getPageCache().get("queryDate");
        if (!CollectionUtils.isEmpty(orgIds) && HRStringUtils.isNotEmpty((String)positionId) && HRStringUtils.isNotEmpty((String)queryDate)) {
            this.getPageCache().remove("positionId");
            this.getPageCache().remove("queryDate");
            Date date = new Date();
            try {
                date = HRDateTimeUtils.parseDate((String)queryDate, (String)"yyyy-MM-dd");
            }
            catch (Exception exception) {
                LOG.error("isUpdatePositionByOrgs date error" + queryDate);
            }
            QFilter orgsFilter = new QFilter("org", "in", orgIds);
            QFilter dateFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)date);
            QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
            DynamicObject[] query = POSITION_HELPER.query("id,boid", new QFilter[]{orgsFilter, dateFilter, currentFilter});
            if (query != null && query.length > 0) {
                List idList = Arrays.stream(query).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
                return idList.contains(Long.parseLong(positionId));
            }
            return false;
        }
        return true;
    }

    private void setDataToCustomControl(String dataFlag, Map<String, Object> data, String code, String status) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("success", true);
        result.put("data", data);
        result.put("eventName", dataFlag);
        result.put("eventStatus", status);
        result.put("time", System.currentTimeMillis());
        DateFormat dateFormat = KDDateFormatUtils.getUserZoneDateFormat();
        result.put("today", dateFormat.format(new Date()));
        result.put("dateFormat", InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
        CustomControl customControl = (CustomControl)this.getView().getControl("customcontrolap");
        customControl.setData(result);
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT_WITHSUB);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp(formShowParameter, permEntityId);
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, "boid"});
        this.getPageCache().put(CACHE_PERM_ORG_RESULT_WITHSUB, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    private boolean schemeCheck(Map<String, Object> filterSchemeMap, SearchChartData searchChartData) {
        String defaultSchemeName;
        StringBuilder sb = this.checkFieldsIfEmpty(searchChartData);
        Object schemeNameObject = filterSchemeMap.get("schemeName");
        if (HRStringUtils.isEmpty((String)schemeNameObject.toString().trim())) {
            sb.append(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u3001", (String)"PositionRelationChartPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            String error = sb.substring(0, sb.length() - 1);
            sb = new StringBuilder(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionRelationChartPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{error}));
        }
        if (schemeNameObject.toString().length() > 100) {
            sb.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u65b9\u6848\u540d\u79f0\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]", (String)"PositionRelationChartPlugin_12", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)(defaultSchemeName = ResManager.loadKDString((String)"\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4", (String)"PositionRelationChartPlugin_17", (String)"odc-homs-formplugin", (Object[])new Object[0])), (String)schemeNameObject.toString().trim())) {
            sb.append(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u201c\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionRelationChartPlugin_18", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_positionrelation", (String)RequestContext.get().getUserId(), (boolean)true);
        for (FilterScheme scheme : schemes) {
            if (!schemeNameObject.toString().equalsIgnoreCase(scheme.getSchemeName()) || filterSchemeMap.get("id") != null && (filterSchemeMap.get("id") == null || HRStringUtils.equals((String)filterSchemeMap.get("id").toString(), (String)scheme.getId()))) continue;
            sb.append(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionRelationChartPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            this.getView().showErrorNotification(sb.toString());
            return true;
        }
        return false;
    }

    private StringBuilder checkFieldsIfEmpty(SearchChartData searchChartData) {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isEmpty((Collection)searchChartData.getOrgs())) {
            sb.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"PositionRelationChartPlugin_4", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)searchChartData.getPositionId())) {
            sb.append(ResManager.loadKDString((String)"\u67e5\u8be2\u5c97\u4f4d\u3001", (String)"PositionRelationChartPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)searchChartData.getChartStyleId())) {
            sb.append(ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f\u3001", (String)"PositionRelationChartPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty((Collection)searchChartData.getCoopRelTypes())) {
            sb.append(ResManager.loadKDString((String)"\u6c47\u62a5\u53ca\u534f\u4f5c\u5173\u7cfb\u3001", (String)"PositionRelationChartPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
        return sb;
    }

    private boolean checkQueryParam(SearchChartData searchChartData) {
        StringBuilder sb = this.checkFieldsIfEmpty(searchChartData);
        if (sb.length() > 0) {
            String error = sb.substring(0, sb.length() - 1);
            error = ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PositionRelationChartPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[]{error});
            this.getView().showErrorNotification(error);
            return false;
        }
        return true;
    }
}

