/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgdifftemp;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.homs.business.service.orgdifftemp.OrgDiffTempHelper;
import kd.hr.homs.common.constants.orgdifftemp.OrgDiffTempConstants;

public class OrgDiffTempEditPlugin
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener,
OrgDiffTempConstants {
    private static final String PAGE_CACHE_KEY_OLD_ORGTYPE = "orgTypeOld";
    private static final String PAGE_CACHE_KEY_ORGTYPE_STD = "orgTypeStd";
    private static final String CALLBACK_ID_SELECT_ORGTYPE = "select_orgtype";
    public static final String MASTER_ORG = "masterOrg";

    public void beforeBindData(EventObject e) {
        String enable = this.getModel().getDataEntity().getString("enable");
        if ("1".equals(enable)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        OrgDiffTempHelper.setTips((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        List permOrgs;
        OrgDiffTempHelper.setAdminorgType((IFormView)this.getView());
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        String orgId = dataEntity.getString("org.id");
        if (HRStringUtils.isNotEmpty((String)orgId)) {
            this.getPageCache().put("orgId", orgId);
        }
        DynamicObject orgType = dataEntity.getDynamicObject("adminorgtype");
        long adminOrgTypeStd = orgType.getLong("adminorgtypestd.id");
        OrgDiffTempHelper.setOrgInfoViewByType((Long)adminOrgTypeStd, (IFormView)this.getView());
        OrgDiffTempHelper.anchorCtlByType((int)((int)adminOrgTypeStd), (IFormView)this.getView());
        OrgDiffTempHelper.setIndexBefore((IFormView)this.getView());
        OrgDiffTempHelper.setToBeDisableDateEnable((IFormView)this.getView());
        HasPermOrgResult hasHrOrgResult = OrgPermHelper.getHRPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgdifftemp", (String)"47150e89000000ac");
        if (!hasHrOrgResult.hasAllOrgPerm() && !(permOrgs = hasHrOrgResult.getHasPermOrgs()).contains(Long.parseLong(orgId))) {
            this.getModel().setValue("org", null);
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String fieldKey;
        switch (fieldKey = changedArgs.getProperty().getName()) {
            case "adminorgtype": {
                this.orgTypeChange(changedArgs);
                break;
            }
            case "companyarea": {
                OrgDiffTempHelper.propChgForCountryArea((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel());
                break;
            }
            case "city": {
                OrgDiffTempHelper.propChgForCity((PropertyChangedArgs)changedArgs, (IDataModel)this.getModel());
                break;
            }
            case "tobedisableflag": {
                OrgDiffTempHelper.propChgForToBeDiableFlag((PropertyChangedArgs)changedArgs, (IFormView)this.getView());
                break;
            }
            case "parentorg": {
                OrgDiffTempHelper.propChgForParentOrg((PropertyChangedArgs)changedArgs, (IFormView)this.getView());
                break;
            }
            case "org": {
                ChangeData changeData = changedArgs.getChangeSet()[0];
                DynamicObject newDy = (DynamicObject)changeData.getNewValue();
                DynamicObject oldDy = (DynamicObject)changeData.getOldValue();
                String masterOrg = this.getPageCache().get(MASTER_ORG);
                if (oldDy == null) {
                    if (masterOrg == null) {
                        return;
                    }
                } else {
                    Long orgIDOld = oldDy.getLong("id");
                    this.getPageCache().put(MASTER_ORG, String.valueOf(orgIDOld));
                }
                if (newDy == null) {
                    return;
                }
                Long orgIdNew = newDy.getLong("id");
                if (HRStringUtils.equals((String)masterOrg, (String)String.valueOf(orgIdNew))) break;
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(MASTER_ORG, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u540e\uff0c\u9875\u9762\u5c06\u91cd\u65b0\u663e\u793a\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u539f\u6765\u7684\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgDiffTempListPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                break;
            }
        }
    }

    private void orgTypeChange(PropertyChangedArgs changedArgs) {
        String oldOrgTypeStd = this.getPageCache().get(PAGE_CACHE_KEY_ORGTYPE_STD);
        if (changedArgs.getChangeSet()[0].getNewValue() == null || HRStringUtils.isEmpty((String)oldOrgTypeStd)) {
            return;
        }
        Long orgTypeStd = this.getModel().getDataEntity().getDynamicObject("adminorgtype").getLong("adminorgtypestd.id");
        String orgTypeStdStr = String.valueOf(orgTypeStd);
        if (!oldOrgTypeStd.equals(orgTypeStdStr)) {
            DynamicObject adminOrgTypeDyn = (DynamicObject)changedArgs.getChangeSet()[0].getOldValue();
            long orgTypeOld = adminOrgTypeDyn == null ? 0L : adminOrgTypeDyn.getLong("id");
            this.getPageCache().put(PAGE_CACHE_KEY_OLD_ORGTYPE, String.valueOf(orgTypeOld));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CALLBACK_ID_SELECT_ORGTYPE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u540e\uff0c\u9875\u9762\u5c06\u91cd\u65b0\u663e\u793a\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u539f\u6765\u7684\u4fe1\u606f\u5c06\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"OrgDiffTempEditPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (callBackId.equals(CALLBACK_ID_SELECT_ORGTYPE)) {
            int result = event.getResult().getValue();
            if (result == MessageBoxResult.Yes.getValue()) {
                Long adminOrgTypeId = this.getModel().getDataEntity().getLong("adminorgtype.id");
                this.getView().getFormShowParameter().setCustomParam("adminorgtype.id", (Object)String.valueOf(adminOrgTypeId));
                this.cleanAddOrgInfo();
                DynamicObject adminOrgTypeDyn = this.getModel().getDataEntity().getDynamicObject("adminorgtype");
                Long adminOrgTypeStd = adminOrgTypeDyn.getLong("adminorgtypestd.id");
                this.getPageCache().put(PAGE_CACHE_KEY_ORGTYPE_STD, String.valueOf(adminOrgTypeStd));
                OrgDiffTempHelper.setOrgInfoViewByType((Long)adminOrgTypeStd, (IFormView)this.getView());
                OrgDiffTempHelper.anchorCtlByType((int)adminOrgTypeStd.intValue(), (IFormView)this.getView());
            } else {
                Long orgTypeId = Long.valueOf(this.getPageCache().get(PAGE_CACHE_KEY_OLD_ORGTYPE));
                this.getModel().setValue("adminorgtype", (Object)(orgTypeId.equals(0L) ? null : orgTypeId));
            }
        } else if (callBackId.equals(MASTER_ORG)) {
            int result = event.getResult().getValue();
            if (result == MessageBoxResult.Yes.getValue()) {
                this.getView().getPageCache().put(MASTER_ORG, String.valueOf(this.getModel().getDataEntity().getLong("org.id")));
                BASE_DATA_MAP.forEach((k, v) -> this.getModel().setValue(v, null));
            } else {
                Long masterOrgId = Long.valueOf(this.getPageCache().get(MASTER_ORG));
                this.getModel().setValue("org", (Object)(masterOrgId.equals(0L) ? null : masterOrgId));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit city = (BasedataEdit)this.getView().getControl("city");
        city.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit parentOrg = (BasedataEdit)this.getView().getControl("parentorg");
        parentOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        for (String baseName : BASE_DATA_MAP.values()) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(baseName);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldName, (String)"org")) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setFormId("bos_listf7");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8d23\u4efb\u89c4\u5212\u5355\u4f4d", (String)"OrgDiffTempEditPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            QFilter filter = new QFilter("fishrod", "=", (Object)Boolean.TRUE);
            HasPermOrgResult hasHrOrgResult = OrgPermHelper.getHRPermOrg((long)RequestContext.get().getCurrUserId(), (String)"homs", (String)"homs_orgdifftemp", (String)"47150e89000000ac");
            if (!hasHrOrgResult.hasAllOrgPerm()) {
                List hasPermOrgs = hasHrOrgResult.getHasPermOrgs();
                filter.and("id", "in", (Object)hasPermOrgs);
            }
            listShowParameter.setLookUp(true);
            listShowParameter.setShowTitle(false);
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
            return;
        }
        if (BASE_DATA_MAP.containsValue(fieldName)) {
            DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgDy == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"AdminorgFastChgPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String entityId = BASE_DATA_MAP.keySet().stream().filter(key -> HRStringUtils.equals((String)((String)BASE_DATA_MAP.get(key)), (String)fieldName)).findFirst().orElse("");
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)orgDy.getLong("id"));
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
        switch (fieldName) {
            case "city": {
                OrgDiffTempHelper.setCityF7Filter((BeforeF7SelectEvent)beforeF7SelectEvent, (IDataModel)this.getModel());
                break;
            }
            case "parentorg": {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setShowUsed(false);
                formShowParameter.setShowApproved(false);
                long id = this.getView().getModel().getDataEntity().getLong("id");
                HRBaseServiceHelper adminOrgDetailHelper = new HRBaseServiceHelper("haos_adminorgdetail");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
                QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                DynamicObject[] adminOrgDetailDyns = adminOrgDetailHelper.query("id", new QFilter[]{enableFilter, isCurrentVersionFilter});
                List disableIdList = Arrays.stream(adminOrgDetailDyns).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                disableIdList.add(id);
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "not in", disableIdList));
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("isfreeze", "=", (Object)"0"));
                break;
            }
        }
    }

    private void cleanAddOrgInfo() {
        this.getModel().setValue("companytype", null);
        this.getModel().setValue("industrytype", null);
        this.getModel().setValue("groupvision", null);
        this.getModel().setValue("groupleader", null);
        this.getModel().setValue("groupmission", null);
        this.getModel().setValue("departmenttype", null);
    }
}

