/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.orgdifftemp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.structproject.StructProjectCapable;
import kd.hr.hbp.formplugin.web.org.structproject.imp.DefaultNoStructProjectProcessor;
import kd.hr.hbp.formplugin.web.org.template.TreeListTemplateBase;
import kd.hr.homs.business.service.batcheffect.util.TimeLogger;
import kd.hr.homs.business.service.utils.OrgDiffPermHelper;

public class OrgDiffTreeList
extends TreeListTemplateBase {
    private static String SUB_TREE_ORDER_BY = "number";

    public OrgDiffTreeList() {
        super(new OrgTreeModel("homs_orgdiffstruct", "homs_orgdifftemp", Boolean.FALSE, Boolean.TRUE, Boolean.FALSE.booleanValue()), "adminOrg", "parentorg", "adminorg.id");
        this.orgStructNumberProperty = "adminorg.structnumber";
        this.queryHisTreeDateCount = 8;
        this.setStructProjectCapable((StructProjectCapable)new DefaultNoStructProjectProcessor());
    }

    protected DynamicObject getRootDynByRootId() {
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOriginalOne("adminorg.id id, adminorg.id boid, adminorg.name name, structlongnumber, adminorg.enable enable", new QFilter("adminorg.id", "=", (Object)PlatformRootUtils.getLongRootIdOfPlatform()).toArray());
    }

    protected DynamicObject getRootNodeDyn() {
        return this.getCurTreeRootNodeDyn("adminorg.id id, adminorg.id boid,adminorg.name name, structlongnumber, adminorg.enable enable");
    }

    public DynamicObject getCurVerTreeNodeDynInPerm(QFilter structLongNumberAndSubFilter, QFilter commonFilter) {
        if (structLongNumberAndSubFilter == null) {
            DynamicObject virtualRoot = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorgstruct"));
            virtualRoot.set("name", (Object)ResManager.loadKDString((String)"\u672a\u5206\u914d\u6570\u636e\u8303\u56f4\u3002", (String)"OrgDiffTreeList_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return virtualRoot;
        }
        return TreeTemplateHelper.getCurTreeRootNodeDynamicObj((String)this.getEntityName(), (String)"adminorg.id id, adminorg.id boid, adminorg.name name, structlongnumber, adminorg.enable enable", (QFilter)structLongNumberAndSubFilter, (QFilter)commonFilter);
    }

    public Long getCurNodeIdByRowClick(ListRowClickEvent evt) {
        return Long.valueOf(evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
    }

    protected DynamicObjectCollection queryCurTreeViewDynamicCollection(QFilter[] qFilters) {
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg.id id, adminorg.id boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable", qFilters, null);
        if (dynCol == null) {
            return null;
        }
        Map<Long, DynamicObject> dynBoMap = dynCol.stream().collect(Collectors.toMap(dynx -> dynx.getLong("boid"), dynx -> dynx));
        QFilter sortCodeAdminOrgFilter = new QFilter("adminorg.id", "in", dynBoMap.keySet());
        DynamicObjectCollection sortCodeCol = HRBaseDaoFactory.getInstance((String)"homs_orgdiffstruct").queryColl("id,adminorg.id orgId, adminorg.number number", new QFilter[]{sortCodeAdminOrgFilter, this.getDataStatusAndBSedFilter()}, null);
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)sortCodeCol, (String)SUB_TREE_ORDER_BY);
        DynamicObjectCollection retDynCol = new DynamicObjectCollection();
        for (DynamicObject dyn : sortCodeCol) {
            long orgId = dyn.getLong("orgId");
            DynamicObject treeNodeDyn = dynBoMap.get(orgId);
            if (treeNodeDyn == null) continue;
            retDynCol.add((Object)treeNodeDyn);
        }
        return retDynCol;
    }

    protected DynamicObjectCollection getCurChildDynCol(Set<Long> orgBoIdSet) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        QFilter structLongNumberAndSubFilter = null;
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm()) {
            structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (String)"adminorg.id");
        }
        QFilter parentBoIdFilter = new QFilter("parentorg", "in", orgBoIdSet);
        QFilter[] qFilters = new QFilter[]{this.getDataStatusAndBSedFilter(), parentBoIdFilter, structLongNumberAndSubFilter};
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber, isleaf,adminorg.id boid, parentorg.id parentorg", qFilters, null);
    }

    protected List<String> getAllPermissionStructLongNumbers() {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber", new QFilter[]{this.commonQFilter()}, null);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    protected void queryTreeNodeChildrenByStructNumbers(OrgTreeSearchParam searchParam, List<String> structNumbers, TreeNode node) {
        if (!structNumbers.isEmpty()) {
            String selectFields = "adminorg.id, adminorg.id boid, parentorg.id parentorg, structlongnumber, isleaf";
            QFilter numberFilter = new QFilter(this.orgStructNumberProperty, "in", structNumbers);
            DynamicObjectCollection retDynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(selectFields, new QFilter[]{this.getDataStatusAndBSedFilter(), numberFilter}, (String)null);
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)"structlongnumber");
            this.setOrgLeaf(retDynCol, "parentorg");
            TreeTemplateHelper.lazyCurTreeNodeChildren((DynamicObjectCollection)retDynCol, (OrgTreeSearchParam)searchParam, (TreeNode)node, (String)"adminorg.id", (String)"parentorg.id");
        }
    }

    protected QFilter getSearchTreeStructFilter() {
        List<String> structLongNumbers = this.getOrgStructLongNumberByPermOrg();
        if (null != structLongNumbers && structLongNumbers.size() != 0) {
            List allSubStructNumbers = OrgTreeUtils.getAllSubStructNumbers((String)this.getRootNode().getLongNumber(), structLongNumbers, (boolean)true);
            return new QFilter("adminorg.structnumber", "in", (Object)allSubStructNumbers);
        }
        return null;
    }

    protected List<String> getSearchTreeStructNumberList() {
        List<String> structLongNumbers = this.getOrgStructLongNumberByPermOrg();
        if (null != structLongNumbers && structLongNumbers.size() != 0) {
            return OrgTreeUtils.getAllSubStructNumbers((String)this.getRootNode().getLongNumber(), structLongNumbers, (boolean)true);
        }
        return null;
    }

    protected List<TreeNode> searchCurTreeNode(String searchText, QFilter structFilter) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter nameFilter = new QFilter("adminorg.name", "like", (Object)("%" + searchText + "%"));
        QFilter[] filters = new QFilter[]{nameFilter, structFilter, this.getOrgTreeFilter()};
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg.id id, adminorg.id boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable", filters, null);
        if (dynCol != null) {
            this.setOrgLeaf(dynCol, "parentorg");
            Map<Long, DynamicObject> dynBoMap = dynCol.stream().collect(Collectors.toMap(dynx -> dynx.getLong("boid"), dynx -> dynx));
            QFilter sortCodeAdminOrgFilter = new QFilter("adminorg.id", "in", dynBoMap.keySet());
            DynamicObjectCollection sortCodeCol = HRBaseDaoFactory.getInstance((String)"homs_orgdiffstruct").queryColl("id,adminorg.id orgId, adminorg.number number", new QFilter[]{sortCodeAdminOrgFilter, this.getDataStatusAndBSedFilter()}, null);
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)sortCodeCol, (String)SUB_TREE_ORDER_BY);
            ArrayList<DynamicObject> dynColList = new ArrayList<DynamicObject>();
            for (DynamicObject dyn : sortCodeCol) {
                long orgId = dyn.getLong("orgId");
                DynamicObject treeNodeDyn = dynBoMap.get(orgId);
                if (treeNodeDyn == null) continue;
                dynColList.add(treeNodeDyn);
            }
            dynColList.forEach(dynamicObject -> {
                String orgId = dynamicObject.getString("id");
                TreeNode treeNode = new TreeNode(dynamicObject.getString("parentorg"), orgId, dynamicObject.getString("name"));
                treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
                treeNode.setData((Object)dynamicObject.getString("boid"));
                treeNodes.add(treeNode);
            });
        }
        return treeNodes;
    }

    public List<TreeNode> getSearchNodesBySearchId(Long searchIdVal) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        if (null == searchIdVal) {
            return treeNodes;
        }
        DynamicObject orgMainDyn = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getMainEntityName()).queryOriginalOne("id, id boid", new QFilter[]{new QFilter("id", "=", (Object)searchIdVal), this.getOrgEnableFilter(), this.getDataStatusAndBSedFilter()});
        if (orgMainDyn == null) {
            return treeNodes;
        }
        QFilter orgIdFilter = new QFilter("adminorg.id", "=", (Object)orgMainDyn.getLong("boid"));
        if (!this.orgTreeModel.isHisTree()) {
            QFilter[] filters = new QFilter[]{orgIdFilter, this.getDataStatusAndBSedFilter(), this.getOrgEnableFilter()};
            TreeTemplateHelper.assemblyCurTreeSearchNodes(treeNodes, (String)this.getEntityName(), (String)"adminorg.id id, adminorg.id boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable", (String)"parentorg", (QFilter[])filters, null);
            return treeNodes;
        }
        return this.getHisTreeSearchDynCol(searchIdVal, "parentorg", this.queryHisTreeDateCount, SUB_TREE_ORDER_BY);
    }

    protected QFilter getOrgEnableFilter() {
        return new QFilter("adminorg.isfreeze", "=", (Object)"0");
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        Object currentNodeId;
        String propertyName = changedArgs.getProperty().getName();
        if ("chkincludechild".equals(propertyName) && StringUtils.isNotBlank((Object)(currentNodeId = this.getTreeModel().getCurrentNodeId()))) {
            TreeNode currentTreeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId.toString(), 15);
            this.treeListView.getTreeView().treeNodeClick(currentTreeNode.getParentid(), currentNodeId.toString());
        }
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        return new QFilter("id", "in", this.getAllOrgBoIdList());
    }

    protected List<TreeNode> searchHisTreeNode(String s) {
        return null;
    }

    protected QFilter getDataStatusAndBSedFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    protected List<Long> getAllOrgBoIdList() {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        logger.error(String.format("OrgDiffTreeList.getAllOrgBoIdList currentNodeId=:%s", currentNodeId));
        this.orgTreeModel.setIncludeChild(this.isInCludeChild());
        if (!this.getPermOrgResultWithSub().isHasAllOrgPerm() && CollectionUtils.isEmpty((Collection)this.getPermOrgResultWithSub().getHasPermOrgsWithSub())) {
            return Collections.emptyList();
        }
        return TreeTemplateHelper.getAllOrgBoId((ITreeModel)this.getTreeModel(), (OrgTreeModel)this.orgTreeModel, (AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (Map)this.getOrgSubStructLongNumberPermMap(), (QFilter)this.getOrgTreeFilter(), (String)"adminorg.id", (boolean)this.isDefDirectlySubOrg(), (String)"parentorg.id");
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity(true).getBoolean("chkincludechild");
    }

    protected boolean isDefDirectlySubOrg() {
        return true;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        if (this.permOrgResultWithSub == null) {
            this.permOrgResultWithSub = this.getBosPermOrgWithBizRule();
        }
        return this.permOrgResultWithSub;
    }

    private AuthorizedOrgResultWithSub getBosPermOrgWithBizRule() {
        AuthorizedOrgResultWithSub authorizedOrgResultWithSub;
        TimeLogger timeLogger = TimeLogger.create();
        timeLogger.start();
        HasPermOrgResult permResult = OrgDiffPermHelper.getHasPermOrg((long)RequestContext.get().getCurrUserId());
        timeLogger.check("OrgDiffPermHelper.getHasPermOrg");
        logger.info(String.format("OrgDiffTreeList.getBosPermOrg HasPermOrgResult=:%s", permResult));
        if (permResult.hasAllOrgPerm()) {
            authorizedOrgResultWithSub = AuthorizedOrgResultWithSub.allOrg();
        } else {
            List<OrgSubInfo> orgSubInfoList = this.getOrgSubInfoList(permResult.getHasPermOrgs());
            authorizedOrgResultWithSub = new AuthorizedOrgResultWithSub(false, orgSubInfoList);
            timeLogger.check("getOrgSubInfoList");
        }
        return authorizedOrgResultWithSub;
    }

    private List<OrgSubInfo> getOrgSubInfoList(List<Long> orgIdList) {
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg.id id,adminorg.structnumber structnumber,structlongnumber,isleaf", new QFilter[]{new QFilter("adminorg.id", "in", orgIdList), this.commonQFilter()}, null);
        return dynCol.stream().map(dy -> new OrgSubInfo(Long.valueOf(dy.getLong("id")), false, dy.getString("structnumber"), dy.getString("structlongnumber"))).collect(Collectors.toList());
    }

    private QFilter commonQFilter() {
        return new QFilter("status", "=", (Object)"C").and("adminorg.isfreeze", "=", (Object)"0");
    }

    private List<String> getOrgStructLongNumberByPermOrg() {
        return TreeTemplateHelper.getAllPermissionStructLongNumbers((String)this.getEntityName(), (QFilter[])new QFilter[]{this.getOrgEnableFilter(), this.getDataStatusAndBSedFilter()}, null);
    }
}

