/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.org.template.OrgTreeListFilterTemplatePlugin;

public class HomsOrgTreeFilterPlugin
extends OrgTreeListFilterTemplatePlugin {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"closetag"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        String searchDateStr = (String)this.getView().getFormShowParameter().getCustomParam("searchdate");
        if (!StringUtils.isEmpty((CharSequence)searchDateStr)) {
            try {
                Date searchDate = HRDateTimeUtils.parseDate((String)searchDateStr);
                this.getModel().setValue("searchdate", (Object)searchDate);
            }
            catch (ParseException var5) {
                logger.error("AdminOrgPageRightDynamicPlugin parse date error!");
            }
        }
        super.afterCreateNewData(eventObject);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        if ("searchdate".equals(propName)) {
            if (this.getView().getParentView() instanceof IListView) {
                IListView iListView = (IListView)this.getView().getParentView();
                if (iListView == null) {
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    logger.info("propertyChanged,iListView is null,getParentFormId={}, getFormId={}", (Object)formShowParameter.getParentFormId(), (Object)formShowParameter.getFormId());
                    return;
                }
                Date searchDate = (Date)this.getModel().getValue("searchdate");
                ITreeListView adminOrgTreeView = iListView.getTreeListView();
                Map customParamMap = this.getView().getParentView().getFormShowParameter().getCustomParams();
                customParamMap.put("searchdate", searchDate);
                this.getView().getParentView().getModel().setValue("searchdate", (Object)searchDate);
                TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getView().getParentView().getPageCache());
                adminOrgTreeView.focusRootNode();
                adminOrgTreeView.refresh();
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            } else {
                Date searchDate = (Date)this.getModel().getValue("searchdate");
                this.getView().returnDataToParent((Object)searchDate);
                this.getView().close();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("closetag".equals(control.getKey())) {
            this.getView().getFormShowParameter().setCustomParam("closeFlag", (Object)"true");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        String closeFlag = (String)this.getView().getFormShowParameter().getCustomParam("closeFlag");
        if ("true".equals(closeFlag)) {
            event.setCancel(false);
        } else {
            event.setCancel(true);
        }
    }
}

