/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.homs.business.service.position.PositionInvokeMserviceHelper;
import kd.hr.homs.business.service.position.PositionValidateServiceImpl;
import kd.hrmp.hbpm.business.service.position.PositionTplApplicationScopeServiceImpl;
import kd.hrmp.hbpm.business.utils.PermHelper;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class PositionAddDiaLogEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PositionAddDiaLogEdit.class);
    private HasPermOrgResult hasPermOrgResult;
    public static final String ORG_PERM_CACHE_KEY = "org_perm_result";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit adminorg = (BasedataEdit)this.getView().getControl("adminorg");
        adminorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit positiontpl = (BasedataEdit)this.getView().getControl("positiontpl");
        positiontpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject event) {
        super.afterBindData(event);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object adminorg = view.getFormShowParameter().getCustomParam("orgId");
        model.setValue("adminorg", adminorg);
        this.getView().updateView("adminorg");
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Long adminorgId = this.getModel().getDataEntity().getLong("adminorg.id");
        Long orgId = this.getModel().getDataEntity().getLong("adminorg.org.id");
        this.setPositionTplVisable(adminorgId, orgId);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        super.propertyChanged(event);
        String operationKey = event.getProperty().getName();
        if ("adminorg".equals(operationKey)) {
            Long adminorgId = this.getModel().getDataEntity().getLong("adminorg.id");
            Long orgId = this.getModel().getDataEntity().getLong("adminorg.org.id");
            this.getModel().setValue("positiontpl", null);
            this.getView().updateView("positiontpl");
            if (adminorgId != null && adminorgId != 0L) {
                this.setPositionTplVisable(adminorgId, orgId);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"positiontpl"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (null != args.getOperationResult() && args.getOperationResult().isSuccess() && StringUtils.equals((CharSequence)"donothing_comfirm", (CharSequence)operateKey)) {
            Long adminorgId = this.getModel().getDataEntity().getLong("adminorg.id");
            this.showNewPositionPage(adminorgId);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        if (HRStringUtils.equals((String)property.getName(), (String)"adminorg")) {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"homs_positionbill");
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"adminorg");
            this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().cacheFormShowParameter();
            HasPermOrgResult permOrgResult = this.getPermOrgResult();
            if (!permOrgResult.hasAllOrgPerm()) {
                QFilter baseDataFilter = PermHelper.getBaseDataFilter((String)"haos_adminorghr", (List)permOrgResult.getHasPermOrgs());
                beforeF7SelectEvent.getCustomQFilters().add(baseDataFilter);
            }
        }
        if (HRStringUtils.equals((String)property.getName(), (String)"positiontpl")) {
            DynamicObject adminorg = this.getModel().getDataEntity().getDynamicObject("adminorg");
            long adminorgId = adminorg.getLong("id");
            String structlongnumber = adminorg.getString("structlongnumber");
            PositionTplApplicationScopeServiceImpl positionTplApplicationScopeService = new PositionTplApplicationScopeServiceImpl();
            List longs = positionTplApplicationScopeService.queryApplicationScope(Long.valueOf(adminorgId), structlongnumber);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", (Object)longs));
        }
    }

    private void showNewPositionPage(Long focusNodeId) {
        if (focusNodeId != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("homs_positionbill");
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5c97\u4f4d", (String)"PositionEntityTreeList_3", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("operationStatus", (Object)"new");
            String positionTplId = this.getModel().getDataEntity().getString("positiontpl.id");
            showParameter.setCustomParam("positiontpl", (Object)positionTplId);
            LOGGER.info("positiontpl showNewPositionPage  positiontpl param : {}", (Object)String.valueOf(positionTplId));
            PositionInvokeMserviceHelper positionInvokeMserviceHelper = new PositionInvokeMserviceHelper();
            Map adminOrg = positionInvokeMserviceHelper.adminOrgInfoQuery(Collections.singletonList(focusNodeId), new Date());
            if (!adminOrg.isEmpty() && ((Map)adminOrg.get(String.valueOf(focusNodeId))).get("isvirtualorg").equals("false")) {
                showParameter.setCustomParam("adminorg", (Object)(focusNodeId + ""));
            }
            this.getView().getParentView().showForm((FormShowParameter)showParameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void setPositionTplVisable(Long adminorgId, Long orgId) {
        Map batchParameter = SystemParamHelper.getBatchParameter(Collections.singletonList(orgId));
        Map parameter = batchParameter.getOrDefault(String.valueOf(orgId), Maps.newHashMap());
        PositionValidateServiceImpl positionValidateService = new PositionValidateServiceImpl();
        boolean isOpenDailog = positionValidateService.openDialogOrPositionBill(adminorgId).test(parameter);
        boolean openpositiontpl = (Boolean)parameter.get("openpositiontpl");
        BasedataEdit positiontpl = (BasedataEdit)this.getView().getControl("positiontpl");
        if (openpositiontpl) {
            String radiogroupfield = (String)parameter.get("radiogroupfield");
            this.getView().setEnable(Boolean.TRUE, new String[]{"positiontpl"});
            positiontpl.setMustInput(Boolean.TRUE.booleanValue());
            if ("2".equals(radiogroupfield)) {
                if (!isOpenDailog) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"positiontpl"});
                    positiontpl.setMustInput(Boolean.FALSE.booleanValue());
                }
            } else if ("3".equals(radiogroupfield)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"positiontpl"});
                positiontpl.setMustInput(Boolean.FALSE.booleanValue());
            }
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"positiontpl"});
            positiontpl.setMustInput(Boolean.FALSE.booleanValue());
        }
    }

    public HasPermOrgResult getPermOrgResult() {
        if (this.hasPermOrgResult == null) {
            String orgPermString = this.getPageCache().get(ORG_PERM_CACHE_KEY);
            if (orgPermString == null) {
                this.hasPermOrgResult = PermHelper.getHRPermOrg((String)this.getView().getFormShowParameter().getAppId(), (String)"homs_positionbill");
                this.getPageCache().put(ORG_PERM_CACHE_KEY, ((HasPermOrgResultImpl)this.hasPermOrgResult).toSerializeStr());
            } else {
                this.hasPermOrgResult = HasPermOrgResultImpl.fromSerializeStr((String)orgPermString);
                if (!this.hasPermOrgResult.hasAllOrgPerm()) {
                    List hasPermOrgs = this.hasPermOrgResult.getHasPermOrgs();
                    for (int i = 0; i < hasPermOrgs.size(); ++i) {
                        hasPermOrgs.set(i, Long.parseLong(hasPermOrgs.get(i) + ""));
                    }
                }
            }
        }
        return this.hasPermOrgResult;
    }
}

