/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.homs.business.service.position.PositionValidateServiceImpl;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplFieldRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionTplRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.service.utils.PositionFieldValueConverter;
import kd.hrmp.hbpm.business.utils.JobLevelGradeRangeUtil;
import kd.hrmp.hbpm.business.utils.PositionHisQueryPageUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class PositionBillEdit
extends HRCoreBaseBillEdit
implements UploadListener {
    private static final Log logger = LogFactory.getLog(PositionBillEdit.class);
    private static final String CHANGEINFO_FLEXPANELAP = "changeinfoflexpanelap";
    private static final String anchor_controlap = "anchorcontrolap";
    private static final String BAR_PRINT = "bar_print";
    private Map<String, Object> recycleMap;
    private static final String CACHE_KEY_RECYCLEMAP = "recycleMap";
    private static final List<String> POSITIONTPL_FILED_KEYS = Arrays.asList("orgdesignbu", "jobscm", "job", "lowjoblevel", "highjoblevel", "lowjobgrade", "highjobgrade");
    private static final List<String> EXINCLUDE_POSITIONTPL_FILED_KEYS = Arrays.asList("joblevelrange", "jobgraderange");

    public void preOpenForm(PreOpenFormEventArgs args) {
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        showParameter.setCustomParam("hbss_entitytype_id", (Object)"1021");
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"joblevelrange", "jobgraderange"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String hasPositionBill = (String)formShowParameter.getCustomParam("hasPositionBill");
        if (hasPositionBill != null && hasPositionBill.equals("false")) {
            this.beforeBindDataInitData(this.getModel(), formShowParameter);
            this.putDataToPageCache(this.getModel());
            this.reNameSubPageCaption();
        }
    }

    public void afterLoadData(EventObject eventObject) {
        this.reNameSubPageCaption();
    }

    private void reNameSubPageCaption() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String message = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09-{2}\uff08{3}\uff09", (String)"PositionBillEdit_10", (String)"odc-homs-formplugin", (Object[])new Object[0]), dataEntity.getString("name"), dataEntity.getString("number"), dataEntity.getString("adminorg.name"), dataEntity.getString("adminorg.number"));
        this.getView().getFormShowParameter().setCustomParam("caption", (Object)message);
        String id = (String)this.getView().getFormShowParameter().getCustomParam("position");
        this.getView().getFormShowParameter().setCustomParam("currentObjectPKId", (Object)id);
        String operation = (String)this.getView().getFormShowParameter().getCustomParam("operationStatus");
        if (HRStringUtils.equals((String)"showHistory", (String)operation)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("searchdate", this.getView().getFormShowParameter().getCustomParam("historyDate"));
            this.getView().getFormShowParameter().setCustomParam("customvariables", map);
            DynamicObject position = PositionQueryRepository.getInstance().queryBoIdById(Long.valueOf(Long.parseLong(id)));
            if (Objects.nonNull(position)) {
                this.getView().getFormShowParameter().setCustomParam("currentObjectPKId", (Object)position.getString("boid"));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String showFuture;
        super.beforeBindData(e);
        this.setTips();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject adminorg = dataEntity.getDynamicObject("adminorg");
        if (adminorg != null) {
            this.setPositionTplVisable(adminorg.getLong("id"), adminorg.getLong("org.id"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"positiontpl"});
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String fromRevise = (String)formShowParameter.getCustomParam("fromRevise");
        if (fromRevise != null && fromRevise.equals("true")) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel", "future_modify", "future_save"});
        this.afterLoadDataDeal();
        OperationStatus operationStatus = formShowParameter.getStatus();
        String operation = (String)formShowParameter.getCustomParam("operationStatus");
        if (StringUtils.equals((CharSequence)"readOnly", (CharSequence)operation)) {
            this.beforeBindDataRealOnly(dataEntity);
        }
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operation)) {
            this.beforeBindDataNew(formShowParameter);
        }
        if (HRStringUtils.equals((String)"showHistory", (String)operation)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelrightcontainer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANGEINFO_FLEXPANELAP, BAR_PRINT});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelrightcontainer"});
        }
        String skiporigin = (String)formShowParameter.getCustomParam("skiporigin");
        if (HRStringUtils.equals((String)"homs_positionchangerecord", (String)skiporigin)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PRINT});
            this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
        if (StringUtils.equals((CharSequence)"true", (CharSequence)(showFuture = (String)formShowParameter.getCustomParam("showfuture")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"future_modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelrightcontainer"});
        }
        AnchorControl anchorCtl = (AnchorControl)this.getControl(anchor_controlap);
        this.initAnchor(anchorCtl, operationStatus.name());
    }

    public void afterBindData(EventObject eventObject) {
        String hideInfo;
        DynamicObject parent;
        if (this.codeRuleExist()) {
            this.setPositionNumber();
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        JobLevelGradeRangeUtil.getInstance().afterBindData((IDataModel)model, this.getView());
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String operation = (String)formShowParameter.getCustomParam("operationStatus");
        if (HRStringUtils.equals((String)"showHistory", (String)operation)) {
            String dateStr;
            String fields = (String)formShowParameter.getCustomParam("historyField");
            String showFuture = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("showfuture");
            Date date = HRStringUtils.equals((String)showFuture, (String)"true") ? this.getModel().getDataEntity().getDate("bsed") : (HRStringUtils.isEmpty((String)(dateStr = (String)formShowParameter.getCustomParam("historyDate"))) ? null : PositionUtils.formatDate((String)dateStr));
            PositionHisQueryPageUtil.positionHisFieldFill((String)fields, (IDataModel)this.getModel(), (Date)date);
        }
        if (!ObjectUtils.isEmpty((Object)(parent = model.getDataEntity().getDynamicObject("parent")))) {
            parent.set("name", (Object)this.buildParentName(parent));
            this.getView().updateView("parent");
        }
        if (HRStringUtils.isNotEmpty((String)(hideInfo = (String)formShowParameter.getCustomParam("position_chart_hideInfo"))) && HRStringUtils.equals((String)"1", (String)hideInfo)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"issensitive", "attachmentpanel"});
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        this.setVisbleBaseOrigin(formShowParameter);
    }

    private void setVisbleBaseOrigin(FormShowParameter formShowParameter) {
        String skiporigin = (String)formShowParameter.getCustomParam("skiporigin");
        if (!HRStringUtils.isEmpty((String)skiporigin) && (skiporigin.equals("homs_positionchangerecord") || skiporigin.equals("homs_positionhis") || skiporigin.equals("hbpm_positionlist"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelrightcontainer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"propertychange"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportchange"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String operateKey;
        super.beforeDoOperation(beforeDoOperationEventArgs);
        AbstractOperate operate = (AbstractOperate)beforeDoOperationEventArgs.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "propertychange": 
            case "reportchange": {
                this.doMutex(beforeDoOperationEventArgs);
                break;
            }
            case "modify": {
                if (!this.doMutex(beforeDoOperationEventArgs).booleanValue()) break;
                this.beforeDoOperationForModify();
                this.getView().cacheFormShowParameter();
                break;
            }
            case "dochange": 
            case "save": {
                if (this.getModel().getValue("bsed") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PositionBillEdit_11", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    beforeDoOperationEventArgs.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                if (!this.getModel().getDataChanged()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PositionBillEdit_8", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                    beforeDoOperationEventArgs.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                String changeType = this.getPageCache().get("changetype");
                if (HRStringUtils.isEmpty((String)changeType)) {
                    operate.getOption().setVariableValue("changetype", "save");
                } else {
                    operate.getOption().setVariableValue("changetype", this.getPageCache().get("changetype"));
                }
                this.changeDataModifier();
                this.getModel().setValue("billno", (Object)this.getSubStringNumber());
                break;
            }
            case "future_save": 
            case "revisesave": {
                this.getModel().setValue("billno", (Object)this.getSubStringNumber());
                break;
            }
        }
    }

    private String getSubStringNumber() {
        String number = this.getModel().getDataEntity().getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            return number;
        }
        if (number.length() <= 30) {
            return number;
        }
        return number.substring(0, 27) + "...";
    }

    private void afterDoOperationForPropertyChange(String operateKey) {
        this.setPositionTplFiledEnalbe(true);
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.TRUE, new String[]{"confirm", CHANGEINFO_FLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", BAR_PRINT});
        if (this.codeRuleExist()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"adminorg", "establishmentdate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"roleflexpanelap", "attachmentpanel", "flexpanelrightcontainer"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"propertychange", "reportchange"});
        if (HRStringUtils.equals((String)operateKey, (String)"propertychange")) {
            this.getModel().setValue("bsed", (Object)PositionUtils.getCurrentDate());
            this.getModel().setValue("changetype", (Object)1020L);
        }
        AnchorControl anchorCtl = (AnchorControl)this.getControl(anchor_controlap);
        this.initAnchor(anchorCtl, "changeProperty");
        this.getPageCache().put("changetype", "propertychange");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"2DNXSYJWDART");
        this.getView().cacheFormShowParameter();
        String showFuture = (String)this.getView().getFormShowParameter().getCustomParam("showfuture");
        if (StringUtils.equals((CharSequence)"true", (CharSequence)showFuture)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"future_modify", "confirm"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"future_save"});
            if (HRStringUtils.equals((String)this.getCurrentBoDatastatus(), (String)"0")) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"adminorg", "establishmentdate"});
            }
        } else {
            this.showFutureTips();
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"positiontpl"});
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private String getCurrentBoDatastatus() {
        String positionId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        HashSet<Long> set = new HashSet<Long>();
        set.add(Long.valueOf(positionId));
        DynamicObject[] position = PositionQueryRepository.getInstance().queryPositionsPropsByIds("datastatus", set);
        if (position != null && position.length == 1) {
            return position[0].getString("datastatus");
        }
        return "";
    }

    private void showFutureTips() {
        String positionIdStr = (String)this.getView().getFormShowParameter().getCustomParam("position");
        if (HRStringUtils.isNotEmpty((String)positionIdStr)) {
            Long positionId = Long.parseLong(positionIdStr);
            DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionFutureVersion(Collections.singletonList(positionId));
            if (positions.length == 0) {
                return;
            }
            List hasFutureVersionList = Arrays.stream(positions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
            if (hasFutureVersionList.contains(positionId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u5c97\u4f4d\u5b58\u5728\u5f85\u751f\u6548\u7248\u672c\u3002", (String)"PositionBillEdit_15", (String)"odc-homs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
        }
    }

    private void afterDoOperationForReportChange() {
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.TRUE, new String[]{"confirm", CHANGEINFO_FLEXPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", BAR_PRINT});
        this.getView().setVisible(Boolean.FALSE, new String[]{"propertychange", "reportchange"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"baseinfoflexpanelap", "attachmentpanel", "jobinfoflexpanelap", "dutyinfoflexpanelap", "qualinfoflexpanelap", "flexpanelrightcontainer"});
        this.getModel().setValue("bsed", (Object)PositionUtils.getCurrentDate());
        this.getView().setVisible(Boolean.FALSE, new String[]{anchor_controlap});
        this.getPageCache().put("changetype", "reportchange");
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"2DNXU/27ZSXL");
        this.getView().cacheFormShowParameter();
        this.getModel().setValue("changetype", (Object)1030L);
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void beforeDoOperationForModify() {
        this.getView().setStatus(OperationStatus.EDIT);
        if (this.codeRuleExist()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"establishmentdate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "flexpanelrightcontainer"});
        this.getModel().setValue("bsed", (Object)PositionUtils.getCurrentDate());
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        this.getPageCache().put("changetype", "modify");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.recoverDataModifier();
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"propertychange") || HRStringUtils.equals((String)operateKey, (String)"reviseedit") || HRStringUtils.equals((String)operateKey, (String)"future_modify")) {
            this.afterDoOperationForPropertyChange(operateKey);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"reportchange")) {
            this.afterDoOperationForReportChange();
        }
        if (HRStringUtils.equals((String)operateKey, (String)"dochange")) {
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\u3002", (String)"PositionBillEdit_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        } else if (HRStringUtils.equals((String)operateKey, (String)"printbill")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String positionId = (String)formShowParameter.getCustomParam("position");
            DynamicObject data = this.getModel().getDataEntity();
            Object id = data.get("id");
            data.set("id", (Object)positionId);
            this.getView().invokeOperation("printpreview");
            data.set("id", id);
        } else if (HRStringUtils.equals((String)operateKey, (String)"future_save")) {
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String operationKey = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        JobLevelGradeRangeUtil.getInstance().click(model, view, operationKey, (IFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String operationkey = propertyChangedArgs.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataModel model = this.getModel();
        String isNew = this.getPageCache().get("isNew");
        JobLevelGradeRangeUtil.getInstance().propertyChanged(model, this.getView(), operationkey);
        switch (operationkey) {
            case "adminorg": {
                DynamicObject adminorg = dataEntity.getDynamicObject("adminorg");
                if (adminorg != null) {
                    this.getModel().setValue("countryregion", (Object)adminorg.getDynamicObject("companyarea"));
                    this.getModel().setValue("city", (Object)adminorg.getDynamicObject("city"));
                    this.getModel().setValue("workplace", (Object)adminorg.getDynamicObject("workplace"));
                    if (this.isChangeOrg(adminorg)) {
                        PositionServiceHelper.recycleNumber((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
                        this.getModel().setValue("org", (Object)adminorg.getDynamicObject("org"));
                    } else if (HRStringUtils.equals((String)"true", (String)isNew)) {
                        this.changeOrg();
                    }
                } else {
                    this.setAllTplFieldEnable();
                    PositionServiceHelper.recycleNumber((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
                    this.getModel().setValue("number", null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
                    this.getModel().setValue("org", null);
                }
                this.getModel().setValue("positiontpl", null);
                this.getView().updateView("positiontpl");
                if (adminorg != null) {
                    this.setPositionTplVisable(adminorg.getLong("id"), adminorg.getLong("org.id"));
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"positiontpl"});
                break;
            }
            case "city": {
                this.handleCity(dataEntity);
                break;
            }
            case "countryregion": {
                this.getModel().setValue("city", null);
                break;
            }
            case "org": {
                this.changeOrg();
                break;
            }
            case "parent": {
                DynamicObject parent = dataEntity.getDynamicObject("parent");
                if (ObjectUtils.isEmpty((Object)parent)) break;
                parent.set("name", (Object)this.buildParentName(parent));
                this.getView().updateView("parent");
                break;
            }
            case "bsed": {
                Date establishmentDate = dataEntity.getDate("establishmentdate");
                if (establishmentDate != null) break;
                this.getModel().setValue("establishmentdate", (Object)dataEntity.getDate("bsed"));
                this.getView().updateView("establishmentdate");
                break;
            }
            case "positiontpl": {
                this.changePositionTpl(dataEntity);
                break;
            }
        }
    }

    private void changePositionTpl(DynamicObject dataEntity) {
        DynamicObject positiontpl = dataEntity.getDynamicObject("positiontpl");
        Set positiontplfields = PositionTplFieldRepository.getInstance().queryAllNumber();
        if (positiontpl == null) {
            positiontplfields.stream().filter(key -> !EXINCLUDE_POSITIONTPL_FILED_KEYS.contains(key)).forEach(key -> {
                if (this.getModel().getDataEntity().containsProperty(key)) {
                    this.getModel().setValue(key, null);
                    this.getView().updateView(key);
                }
            });
            this.setAllTplFieldEnable();
            return;
        }
        HashSet<String> positiontplfieldSet = new HashSet<String>(POSITIONTPL_FILED_KEYS);
        positiontplfieldSet.addAll(positiontplfields);
        DynamicObject[] positiontplFromDB = PositionTplRepository.getInstance().queryPositionTplPosFieldById(Collections.singletonList(positiontpl.getLong("id")), positiontplfieldSet);
        if (positiontplFromDB == null || positiontplFromDB.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c97\u4f4d\u6a21\u677f\u7684\u6570\u636e\u672a\u627e\u5230\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5c97\u4f4d\u6a21\u677f\u3002", (String)"PositionBillEdit_13", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> positiontplfieldList = new ArrayList<String>(positiontplfields);
        positiontplfieldList.removeAll(POSITIONTPL_FILED_KEYS);
        positiontplfieldList.addAll(POSITIONTPL_FILED_KEYS);
        positiontplfieldList.stream().filter(key -> !EXINCLUDE_POSITIONTPL_FILED_KEYS.contains(key)).forEach(key -> {
            if (this.getModel().getDataEntity().containsProperty(key) && positiontplFromDB[0].containsProperty(key)) {
                this.getModel().setValue(key, positiontplFromDB[0].get(key));
                this.getView().updateView(key);
            }
        });
        JobLevelGradeRangeUtil.getInstance().setFieldRange("joblevelrange", this.getModel().getDataEntity(true).getDynamicObject("lowjoblevel"), "lowjoblevel", this.getModel().getDataEntity(true).getDynamicObject("highjoblevel"), "highjoblevel", this.getModel());
        JobLevelGradeRangeUtil.getInstance().setFieldRange("jobgraderange", this.getModel().getDataEntity(true).getDynamicObject("lowjobgrade"), "lowjobgrade", this.getModel().getDataEntity(true).getDynamicObject("highjobgrade"), "highjobgrade", this.getModel());
        this.setTplFieldEnable(positiontpl);
        DynamicObject orgdesignbu = this.getModel().getDataEntity(true).getDynamicObject("orgdesignbu");
        if (orgdesignbu == null) {
            this.getModel().setValue("orgdesignbu", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u4e3a\u7a7a\u6216\u8005\u6ca1\u6709\u5c97\u4f4d\u6a21\u677f\u5bf9\u5e94\u7684\u804c\u4f4d\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u7684\u6743\u9650\u3002", (String)"PositionBillEdit_14", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isChangeOrg(DynamicObject adminOrg) {
        DynamicObject oldValue = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject newValue = adminOrg.getDynamicObject("org");
        if (Objects.isNull(oldValue) && Objects.isNull(newValue)) {
            return false;
        }
        if (Objects.nonNull(oldValue) && Objects.nonNull(newValue)) {
            return !HRStringUtils.equals((String)oldValue.getString("id"), (String)newValue.getString("id"));
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        JobLevelGradeRangeUtil.getInstance().closedCallBack(model, returnData, actionId);
    }

    private void initAnchor(AnchorControl anchorCtl, String operationStatus) {
        ArrayList anchorItemlist = null;
        AnchorItems changeinfoAnchorItem = new AnchorItems(CHANGEINFO_FLEXPANELAP, ResManager.loadKDString((String)"\u53d8\u52a8\u4fe1\u606f", (String)"PositionBillEdit_1", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems baseinfoAnchorItem = new AnchorItems("baseinfoflexpanelap", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"PositionBillEdit_2", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems jobInfoAnchorItem = new AnchorItems("jobinfoflexpanelap", ResManager.loadKDString((String)"\u804c\u4f4d\u4fe1\u606f", (String)"PositionBillEdit_3", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems dutyinfoAnchorItem = new AnchorItems("dutyinfoflexpanelap", ResManager.loadKDString((String)"\u804c\u8d23\u4fe1\u606f", (String)"PositionBillEdit_4", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems qualAnchorItem = new AnchorItems("qualflexpanelap", ResManager.loadKDString((String)"\u4efb\u804c\u8981\u6c42", (String)"PositionBillEdit_5", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems roleAnchorItem = new AnchorItems("roleflexpanelap", ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb", (String)"PositionBillEdit_6", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        AnchorItems attachmentpanel = new AnchorItems("attachmentpanel", ResManager.loadKDString((String)"\u9644\u4ef6", (String)"PositionBillEdit_7", (String)"odc-homs-formplugin", (Object[])new Object[0]), null);
        if (HRStringUtils.equals((String)operationStatus, (String)"ADDNEW")) {
            anchorItemlist = Lists.newArrayList(Arrays.asList(changeinfoAnchorItem, baseinfoAnchorItem, jobInfoAnchorItem, dutyinfoAnchorItem, qualAnchorItem, roleAnchorItem, attachmentpanel));
        } else if (HRStringUtils.equals((String)operationStatus, (String)"changeProperty")) {
            anchorItemlist = Lists.newArrayList(Arrays.asList(changeinfoAnchorItem, baseinfoAnchorItem, jobInfoAnchorItem, dutyinfoAnchorItem, qualAnchorItem));
        } else {
            anchorItemlist = Lists.newArrayList(Arrays.asList(baseinfoAnchorItem, jobInfoAnchorItem, dutyinfoAnchorItem, qualAnchorItem, roleAnchorItem));
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String skiporigin = (String)formShowParameter.getCustomParam("skiporigin");
            if (HRStringUtils.equals((String)skiporigin, (String)"homs_positionchangerecord")) {
                anchorItemlist.add(attachmentpanel);
            }
        }
        anchorCtl.addItems((List)anchorItemlist);
        anchorCtl.setHighlight(true);
    }

    private void beforeBindDataInitData(IDataModel dataModel, FormShowParameter formShowParameter) {
        String hasPositionBill = (String)formShowParameter.getCustomParam("hasPositionBill");
        if (hasPositionBill != null && hasPositionBill.equals("false")) {
            String positionId = (String)formShowParameter.getCustomParam("position");
            ArrayList positionIds = Lists.newArrayListWithCapacity((int)1);
            positionIds.add(Long.parseLong(positionId));
            DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionsById((List)positionIds);
            PositionFieldValueConverter positionFieldValueConverter = new PositionFieldValueConverter();
            positionFieldValueConverter.assembleHistoryDynamicObjectToDataModel(dataModel, positions[0]);
            this.especialValue(dataModel, positions[0]);
            String fromRevise = (String)formShowParameter.getCustomParam("fromRevise");
            String showfuture = (String)formShowParameter.getCustomParam("showfuture");
            if (HRStringUtils.equals((String)fromRevise, (String)"true") || HRStringUtils.equals((String)showfuture, (String)"true")) {
                dataModel.setValue("hisnewversion", (Object)positionId);
            }
        }
    }

    private void especialValue(IDataModel dataModel, DynamicObject dynamicObject) {
        dataModel.setValue("hisnewversion", (Object)(dynamicObject.getLong("sourcevid") > 0L ? dynamicObject.getLong("sourcevid") : dynamicObject.getLong("id")));
        dataModel.setValue("billno", (Object)PositionServiceHelper.getRandomNumber((int)8));
        if (dynamicObject.getLong("orgdesignbu.id") == 0L) {
            dataModel.setValue("orgdesignbu", null);
        }
    }

    private void beforeBindDataRealOnly(DynamicObject dataEntity) {
        String enable = dataEntity.getString("enable");
        if (HRStringUtils.equals((String)"1", (String)enable)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"propertychange", "reportchange"});
        } else if (HRStringUtils.equals((String)"10", (String)enable)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{CHANGEINFO_FLEXPANELAP});
    }

    private void beforeBindDataNew(FormShowParameter formShowParameter) {
        String positiontplId;
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelrightcontainer", BAR_PRINT});
        this.getView().setVisible(Boolean.TRUE, new String[]{CHANGEINFO_FLEXPANELAP});
        this.getPageCache().put("isNew", "true");
        String adminorg = (String)formShowParameter.getCustomParam("adminorg");
        if (StringUtils.isNotEmpty((CharSequence)adminorg)) {
            this.getModel().setValue("adminorg", (Object)adminorg);
            Object[] dynamicObjects = PositionQueryRepository.getInstance().queryOrgFirstPosition(Long.valueOf(Long.parseLong(adminorg)));
            if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
                this.getModel().setValue("isleader", (Object)"1");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(positiontplId = (String)formShowParameter.getCustomParam("positiontpl")))) {
            this.getModel().setValue("positiontpl", (Object)positiontplId);
        }
        if (!this.codeRuleExist()) {
            this.getModel().setValue("billno", (Object)PositionServiceHelper.getRandomNumber((int)8));
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
        this.getPageCache().put("isNew", "false");
        this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanel"});
        this.setPositionTplFiledEnalbe(false);
    }

    private void changeOrg() {
        if (this.codeRuleExist()) {
            this.setPositionNumber();
        } else {
            Map<String, Object> recycleMap = this.getRecycleCache();
            String number = (String)this.getModel().getValue("number");
            if (recycleMap != null && HRStringUtils.equals((String)number, (String)((String)recycleMap.get("number")))) {
                this.getModel().setValue("number", null);
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
            this.clearRecycleCache();
        }
    }

    private void setPositionNumber() {
        String number;
        block5: {
            String operation = (String)this.getView().getFormShowParameter().getCustomParam("operationStatus");
            if (!StringUtils.equals((CharSequence)"new", (CharSequence)operation)) {
                return;
            }
            String billNo = this.getModel().getDataEntity().getString("billno");
            if (HRStringUtils.isEmpty((String)billNo)) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject org = dataEntity.getDynamicObject("org");
            String orgValue = null;
            if (Objects.nonNull(org)) {
                orgValue = org.getString("id");
            }
            number = null;
            try {
                number = CodeRuleServiceHelper.getNumber((String)"homs_positionbill", (DynamicObject)dataEntity, (String)orgValue);
            }
            catch (KDException exception) {
                if (!exception.getErrorCode().equals((Object)"ErrCode_CodeRule")) break block5;
                this.getView().showErrorNotification(exception.getMessage());
            }
        }
        this.getModel().setValue("number", (Object)number);
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        this.setRecycleCache();
    }

    private void afterLoadDataDeal() {
        boolean isChanged = this.getModel().getDataChanged();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Long workRoleId = model.getDataEntity().getLong("workrole.id");
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object skiporigin = formShowParameter.getCustomParam("skiporigin");
        if (Objects.isNull(skiporigin) || !((String)skiporigin).equals("homs_positionchangerecord")) {
            this.getModel().setValue("changedesc", null);
            this.getModel().setValue("changeexplain", null);
        }
        if (workRoleId != null && workRoleId > 0L) {
            List reportRelations;
            ArrayList<Long> workRoleIds = new ArrayList<Long>();
            workRoleIds.add(workRoleId);
            Object customParam = this.getView().getFormShowParameter().getCustomParam("historyDate");
            if ("homs_positionchangerecord".equals(skiporigin) || Objects.nonNull(customParam)) {
                Date bsed = (Date)this.getModel().getValue("bsed");
                if (Objects.nonNull(customParam)) {
                    try {
                        bsed = HRDateTimeUtils.parseDate((String)customParam.toString());
                    }
                    catch (ParseException exception) {
                        logger.error(exception.getMessage());
                    }
                }
                reportRelations = ReportingrelationQueryRepository.getInstance().queryChangeRelationhis(workRoleIds, bsed);
            } else {
                reportRelations = ReportingrelationQueryRepository.getInstance().queryReportRelationByWorkRoleIds(workRoleIds);
            }
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", this.insertEntryEntity(reportRelations));
            model.endInit();
            this.getView().updateView("entryentity");
        }
        if (!isChanged) {
            this.getView().getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    private TableValueSetter insertEntryEntity(List<DynamicObject> reportRelations) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("boid", new Object[0]);
        tableValueSetter.addField("reporttype", new Object[0]);
        tableValueSetter.addField("targetworkrole", new Object[0]);
        for (DynamicObject reportRelation : reportRelations) {
            tableValueSetter.addRow(new Object[]{reportRelation.getLong("id"), reportRelation.getDynamicObject("reportingtype").getLong("id"), reportRelation.getDynamicObject("parent").getLong("id")});
        }
        return tableValueSetter;
    }

    private String buildParentName(DynamicObject parent) {
        StringBuilder sb = new StringBuilder();
        String positionName = parent.getString("name");
        DynamicObject adminOrg = parent.getDynamicObject("adminorg");
        if (adminOrg != null && !positionName.startsWith(adminOrg.getString("name") + "/")) {
            String adminorgName = adminOrg.getString("name");
            sb.append(adminorgName).append("/").append(positionName);
        } else {
            sb.append(positionName);
        }
        return sb.toString();
    }

    private boolean codeRuleExist() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        String orgValue = null;
        if (Objects.nonNull(org)) {
            orgValue = org.getString("id");
        }
        return CodeRuleServiceHelper.isExist((String)"homs_positionbill", (DynamicObject)dataEntity, (String)orgValue);
    }

    private void handleCity(DynamicObject dataEntity) {
        DynamicObject workPlace;
        DynamicObject countryregion = dataEntity.getDynamicObject("countryregion");
        DynamicObject city = dataEntity.getDynamicObject("city");
        if (ObjectUtils.isEmpty((Object)countryregion) && !ObjectUtils.isEmpty((Object)city)) {
            this.getModel().beginInit();
            this.getModel().setValue("countryregion", (Object)city.getDynamicObject("country"));
            this.getView().updateView("countryregion");
            this.getModel().endInit();
        } else if (!ObjectUtils.isEmpty((Object)countryregion) && !ObjectUtils.isEmpty((Object)city) && (workPlace = PositionBillQueryRepository.getInstance().queryWorkPlace(Long.valueOf(countryregion.getLong("id")), Long.valueOf(city.getLong("id")))) != null) {
            this.getModel().setValue("workplace", (Object)workPlace);
        }
    }

    private Boolean doMutex(BeforeDoOperationEventArgs args) {
        StringBuilder errMsg = new StringBuilder();
        String entityId = "hbpm_positionhr";
        String positionId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        if (!MutexHelper.require((String)entityId, (Object)positionId, (String)"modify", (boolean)true, (StringBuilder)errMsg)) {
            args.setCancel(true);
            this.getView().showTipNotification(errMsg.toString());
            return false;
        }
        this.getView().getPageCache().put("isMutex", "true");
        return true;
    }

    private void changeDataModifier() {
        this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    private void recoverDataModifier() {
        String modifier = this.getPageCache().get("modifier");
        if (!HRStringUtils.isEmpty((String)modifier)) {
            this.getModel().setValue("modifier", (Object)Long.parseLong(modifier));
        }
    }

    private void putDataToPageCache(IDataModel dataModel) {
        String modifier = dataModel.getDataEntity().getString("modifier.id");
        this.getPageCache().put("modifier", modifier);
    }

    public void pageRelease(EventObject e) {
        String isMutex = this.getView().getPageCache().get("isMutex");
        if (StringUtils.equals((CharSequence)"true", (CharSequence)isMutex)) {
            String entityId = "hbpm_positionhr";
            String positionId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
            MutexHelper.release((String)entityId, (String)"modify", (String)positionId);
        }
        String operation = (String)this.getView().getFormShowParameter().getCustomParam("operationStatus");
        Map<String, Object> recycleMap = this.getRecycleCache();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operation) && recycleMap != null) {
            DynamicObject billEntity = new HRBaseServiceHelper("homs_positionbill").generateEmptyDynamicObject();
            billEntity.set("number", recycleMap.get("number"));
            billEntity.set("org", (Object)BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", recycleMap.get("org"))}));
            PositionServiceHelper.recycleNumber((DynamicObject[])new DynamicObject[]{billEntity});
        }
    }

    private void setRecycleCache() {
        if (this.recycleMap == null) {
            this.recycleMap = new HashMap<String, Object>();
        }
        this.recycleMap.put("number", this.getModel().getDataEntity().getString("number"));
        this.recycleMap.put("org", this.getModel().getDataEntity().getLong("org.id"));
        this.getView().getPageCache().put(CACHE_KEY_RECYCLEMAP, SerializationUtils.toJsonString(this.recycleMap));
    }

    private void clearRecycleCache() {
        this.recycleMap = null;
        this.getView().getPageCache().put(CACHE_KEY_RECYCLEMAP, null);
    }

    private Map<String, Object> getRecycleCache() {
        String cache = this.getView().getPageCache().get(CACHE_KEY_RECYCLEMAP);
        if (cache == null) {
            return null;
        }
        return (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
    }

    private void setPositionTplFiledEnalbe(boolean changeOperate) {
        logger.info("start setPositionTplFiledEnalbe");
        String positiontplInvisible = this.getView().getPageCache().get("positiontpl_invisible");
        if (changeOperate && HRStringUtils.isEmpty((String)positiontplInvisible) || HRStringUtils.equals((String)positiontplInvisible, (String)"0")) {
            return;
        }
        long positiontplId = this.getModel().getDataEntity(true).getLong("positiontpl.id");
        if (positiontplId != 0L) {
            DynamicObject[] tplDys = PositionTplRepository.getInstance().queryPositionTplByIds(Collections.singletonList(positiontplId));
            if (tplDys == null || tplDys.length == 0) {
                return;
            }
            DynamicObject tplDy = tplDys[0];
            this.setTplFieldEnable(tplDy);
        }
    }

    private void setTplFieldEnable(DynamicObject tplDy) {
        IFormView view = this.getView();
        boolean ablemodifyfield = tplDy.getBoolean("ablemodifyfield");
        HashSet allField = (HashSet)PositionTplFieldRepository.getInstance().queryAllNumber();
        if (!ablemodifyfield) {
            view.setEnable(Boolean.FALSE, allField.toArray(new String[allField.size()]));
        } else {
            DynamicObjectCollection fieldrange = tplDy.getDynamicObjectCollection("fieldrange");
            Set<String> enableSet = fieldrange.stream().map(temp -> temp.getString("fbasedataid.number")).collect(Collectors.toSet());
            HashSet disableSet = (HashSet)Sets.difference((Set)allField, enableSet).copyInto(new HashSet());
            if (enableSet.contains("joblevelrange")) {
                enableSet.add("joblevelscm");
            }
            if (enableSet.contains("jobgraderange")) {
                enableSet.add("jobgradescm");
            }
            if (disableSet.contains("joblevelrange")) {
                disableSet.add("joblevelscm");
            }
            if (disableSet.contains("jobgraderange")) {
                disableSet.add("jobgradescm");
            }
            view.setEnable(Boolean.TRUE, enableSet.toArray(new String[enableSet.size()]));
            view.setEnable(Boolean.FALSE, disableSet.toArray(new String[disableSet.size()]));
        }
    }

    private void setPositionTplVisable(Long adminorgId, Long orgId) {
        Map batchParameter = SystemParamHelper.getBatchParameter(Collections.singletonList(orgId));
        Map parameter = batchParameter.getOrDefault(String.valueOf(orgId), Maps.newHashMap());
        PositionValidateServiceImpl positionValidateService = new PositionValidateServiceImpl();
        boolean isOpenDailog = positionValidateService.openDialogOrPositionBill(adminorgId).test(parameter);
        boolean openpositiontpl = parameter.getOrDefault("openpositiontpl", false);
        BasedataEdit positiontpl = (BasedataEdit)this.getView().getControl("positiontpl");
        if (openpositiontpl) {
            this.getView().getPageCache().put("positiontpl_invisible", "1");
            String radiogroupfield = (String)parameter.get("radiogroupfield");
            this.getView().setVisible(Boolean.TRUE, new String[]{"positiontpl"});
            positiontpl.setMustInput(Boolean.TRUE.booleanValue());
            if ("2".equals(radiogroupfield)) {
                if (!isOpenDailog) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"positiontpl"});
                    this.getView().getPageCache().put("positiontpl_invisible", "0");
                    positiontpl.setMustInput(Boolean.FALSE.booleanValue());
                }
            } else if ("3".equals(radiogroupfield)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"positiontpl"});
                positiontpl.setMustInput(Boolean.FALSE.booleanValue());
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"positiontpl"});
            this.getView().getPageCache().put("positiontpl_invisible", "0");
            positiontpl.setMustInput(Boolean.FALSE.booleanValue());
            this.setAllTplFieldEnable();
        }
    }

    private void setAllTplFieldEnable() {
        List number = PositionTplFieldRepository.getInstance().queryAllNumberList();
        Object[] objects = number.toArray();
        String[] disableFieldGroup = (String[])Arrays.copyOf(objects, objects.length, String[].class);
        this.getView().setEnable(Boolean.TRUE, disableFieldGroup);
    }

    private void setTips() {
        Tips tips = new Tips();
        List tipsStr = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{this.getModel().getDataEntityType().getName(), "parent", this.getModel().getDataEntity()});
        if (!CollectionUtils.isEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            TipsSupport control = (TipsSupport)this.getControl("parent");
            control.addTips(tips);
        }
    }
}

