/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.formplugin.web.position.PositionEntityList;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PermHelper;
import kd.hrmp.hbpm.business.utils.PositionHisQueryPageUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.constants.PositionHisEnum;

public class PositionEntityHistList
extends PositionEntityList {
    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }

    @Override
    protected void subBindShowParameter(BillShowParameter showParameter, IListView listview) {
        showParameter.setCustomParam("operationStatus", (Object)"showHistory");
        showParameter.setCustomParam("historyDate", (Object)this.getSearchDate());
        showParameter.setCustomParam("historyField", (Object)"adminorg,parent");
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter hisFilter = PositionUtils.getHisFilter((Date)PositionUtils.formatDate((String)this.getSearchDate()));
        List qFilters = setFilterEvent.getQFilters();
        qFilters.add(hisFilter);
        String queryData = this.getView().getPageCache().get("queryData");
        this.bindFilterByQueryFlex(qFilters, queryData);
        qFilters.add(PermHelper.getHrPermFilter((String)"homs_positionhis", (String)"org"));
    }

    private void bindFilterByQueryFlex(List<QFilter> qFilters, String queryData) {
        if (HRStringUtils.isEmpty((String)queryData)) {
            return;
        }
        JSONObject data = (JSONObject)JSONObject.parse((String)queryData);
        if (Objects.isNull(data)) {
            return;
        }
        for (PositionHisEnum en : PositionHisEnum.values()) {
            Object ob;
            String key = en.getOperateName();
            if (Collections.singletonList("isleader").contains(key) ? HRStringUtils.isEmpty((String)((String)(ob = data.getString(key)))) : Objects.isNull(ob = data.getLong(key)) || (Long)ob == 0L) continue;
            if (Arrays.asList("jobclass", "jobseq", "jobfamily").contains(key)) {
                key = "job." + key;
            }
            qFilters.add(new QFilter(key, "=", ob));
        }
    }

    public void beforeBindData(EventObject e) {
        String cache = this.getPageCache().get("positionHisQueryCache");
        if (HRStringUtils.isEmpty((String)cache)) {
            this.getPageCache().put("positionHisQueryCache", this.getView().getPageId());
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        List boIds = pageData.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionInfo(boIds);
        HashMap boToFirstBsedMap = Maps.newHashMapWithExpectedSize((int)positions.length);
        for (DynamicObject position : positions) {
            boToFirstBsedMap.put(position.getLong("id"), position.getDate("firstbsed"));
        }
        pageData.forEach(dy -> dy.set("firstbsed", boToFirstBsedMap.get(dy.getLong("boid"))));
        String date = this.getSearchDate();
        PositionHisQueryPageUtil.batchPositionHisList((String)"adminorg", (DynamicObjectCollection)pageData, (Date)PositionUtils.formatDate((String)date));
    }

    private String getSearchDate() {
        String searchDateStr = this.getPageCache().get("searchdate");
        if (searchDateStr == null) {
            return HRDateTimeUtils.format((Date)HRDateTimeUtils.getNowDate());
        }
        Date date = (Date)JSON.parseObject((String)searchDateStr, Date.class);
        return HRDateTimeUtils.format((Date)date);
    }
}

