/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PermHelper;
import kd.hrmp.hbpm.business.utils.PositionPermissionUtil;

public class PositionHomePagePlugin
extends GridCardPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(PositionHomePagePlugin.class);
    private static final String ENTITY_NAME = "homs_positionhis";
    private static final String HOMS_POSITION_HIS_TREE = "homs_positionhistree";
    private static final String VECTORAP_UPDATE = "vectorap_update";
    private static final String SELECT_NUMBER = "select_number";
    private static final String SELECT_NAME = "select_name";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VECTORAP_UPDATE, SELECT_NUMBER, SELECT_NAME});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateSelectPositionNumber();
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button button = (Button)evt.getSource();
            String buttonType = button.getKey();
            if (buttonType.equals(VECTORAP_UPDATE)) {
                this.updateSelectPositionNumber();
                return;
            }
            if (buttonType.equals(SELECT_NUMBER) || buttonType.equals(SELECT_NAME)) {
                this.openPositionListPage();
                return;
            }
        }
    }

    private void updateSelectPositionNumber() {
        String appId = this.getAppIdWithDealThirdApp(this.getView().getFormShowParameter(), ENTITY_NAME);
        boolean entityPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)ENTITY_NAME, (String)"47150e89000000ac");
        Integer enablePositionCount = 0;
        if (entityPermission) {
            AuthorizedOrgResult permResult = PositionPermissionUtil.getHasPermAdminOrg((long)RequestContext.get().getCurrUserId());
            logger.info("PositionHomePagePlugin getAuthorizedAdminOrgs : " + permResult.isHasAllOrgPerm());
            HasPermOrgResult hrPermOrg = PermHelper.getHRPermOrg((String)ENTITY_NAME);
            enablePositionCount = PositionQueryRepository.getInstance().getAllEnablePositionCountByPerm(permResult, hrPermOrg);
        }
        Label label = (Label)this.getView().getControl(SELECT_NUMBER);
        label.setText(enablePositionCount.toString());
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    private void openPositionListPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setFormId(HOMS_POSITION_HIS_TREE);
        listShowParameter.setBillFormId(ENTITY_NAME);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

