/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import java.sql.Timestamp;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.BeforeExportEvent;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PositionPrintServicePlugin
extends AbstractPrintPlugin {
    private static final ThreadLocal<QFilter> threadLocal = new ThreadLocal();

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource source = evt.getDataSource();
        Object id = evt.getDataSource().getPkId();
        QFilter idFilter = !ObjectUtils.isEmpty((Object)id) ? new QFilter("id", "=", id) : threadLocal.get();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        DynamicObject position = hrBaseServiceHelper.loadDynamicObject(idFilter);
        if (ObjectUtils.isEmpty((Object)position)) {
            hrBaseServiceHelper = new HRBaseServiceHelper("homs_positionbill");
            position = hrBaseServiceHelper.loadDynamicObject(idFilter);
        }
        if (!ObjectUtils.isEmpty((Object)position)) {
            DataRowSet row = new DataRowSet();
            List queryFields = source.getQueryField();
            this.setValueByDataSource(row, position, queryFields);
            this.setSpecialColByDataSource(row, position, queryFields);
            evt.getCustomDataRows().add(row);
        }
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        if (evt.getDataSource() instanceof MainDataSource) {
            MainDataSource source = (MainDataSource)evt.getDataSource();
            threadLocal.set(source.getQFilter());
        }
    }

    public void setValueByDataSource(DataRowSet row, DynamicObject position, List<String> queryFields) {
        if (ObjectUtils.isEmpty((Object)row) || ObjectUtils.isEmpty((Object)position) || ObjectUtils.isEmpty(queryFields)) {
            return;
        }
        for (String field : queryFields) {
            Object value = position.get(field);
            if (ObjectUtils.isEmpty((Object)value)) continue;
            if (value instanceof DateTimeField) {
                row.put(field, (Field)new kd.bos.print.core.data.field.DateTimeField((Timestamp)value));
                continue;
            }
            if (value instanceof OrmLocaleValue) {
                row.put(field, (Field)new TextField(position.getString(field)));
                continue;
            }
            if (!HRStringUtils.isNotEmpty((String)String.valueOf(value))) continue;
            row.put(field, (Field)new TextField(String.valueOf(value)));
        }
    }

    public void setSpecialColByDataSource(DataRowSet row, DynamicObject position, List<String> queryFields) {
        String isleader;
        if (ObjectUtils.isEmpty((Object)row) || ObjectUtils.isEmpty((Object)position) || ObjectUtils.isEmpty(queryFields)) {
            return;
        }
        String parentOrgName = position.getString("parent.adminorg.name");
        String parentName = position.getString("parent.name");
        if (!ObjectUtils.isEmpty((Object)parentOrgName) && !ObjectUtils.isEmpty((Object)parentName)) {
            row.put("parent.name", (Field)new TextField(parentOrgName + " | " + parentName));
        }
        String isleaderStr = HRStringUtils.equals((String)"1", (String)String.valueOf(isleader = position.getString("isleader"))) ? ResManager.loadKDString((String)"\u662f", (String)"PositionPrintServicePlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PositionPrintServicePlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        row.put("isleader", (Field)new TextField(isleaderStr));
        String lowjoblevelname = position.getString("lowjoblevel.name");
        String highjoblevelname = position.getString("highjoblevel.name");
        if (!ObjectUtils.isEmpty((Object)lowjoblevelname) && !ObjectUtils.isEmpty((Object)highjoblevelname)) {
            row.put("joblevelrange", (Field)new TextField(lowjoblevelname + "-" + highjoblevelname));
        }
        String lowjobgradename = position.getString("lowjobgrade.name");
        String highjobgradename = position.getString("highjobgrade.name");
        if (!ObjectUtils.isEmpty((Object)lowjobgradename) && !ObjectUtils.isEmpty((Object)highjobgradename)) {
            row.put("jobgraderange", (Field)new TextField(lowjobgradename + "-" + highjobgradename));
        }
    }

    public void beforeExport(BeforeExportEvent evt) {
        super.beforeExport(evt);
        if (!ObjectUtils.isEmpty((Object)threadLocal.get())) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hbpm_positionhr");
            QFilter idFilter = threadLocal.get();
            Object[] positions = hrBaseServiceHelper.query("name", new QFilter[]{idFilter});
            if (ObjectUtils.isEmpty((Object[])positions)) {
                hrBaseServiceHelper = new HRBaseServiceHelper("homs_positionbill");
                positions = hrBaseServiceHelper.query("name", new QFilter[]{idFilter});
            }
            if (!ObjectUtils.isEmpty((Object[])positions) && positions.length == 1) {
                evt.setFileTplName(positions[0].getString("name"));
            }
            threadLocal.remove();
        }
    }
}

