/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.hr.homs.business.service.position.PositionReviseService;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;

public class PositionReviseInfoPlugin
extends HRCoreBaseBillEdit {
    public void afterCreateNewData(EventObject e) {
        Long positionHisId = this.getPositionHisIdFromView();
        DynamicObject his = PositionQueryRepository.getInstance().queryDataById(positionHisId);
        DynamicObject bo = PositionQueryRepository.getInstance().queryDataById(Long.valueOf(his.getLong("boid")));
        Date firstEffdt = bo.getDate("firstbsed");
        this.getModel().setValue("firstbsed", (Object)firstEffdt);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long positionHisId = this.getPositionHisIdFromView();
        DynamicObject his = PositionQueryRepository.getInstance().queryDataById(positionHisId);
        if (!HRStringUtils.equals((String)his.getString("enable"), (String)"1") || !Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(his.getString("datastatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reviseedit"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"revisesave", "revisecancel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"changeinfoflexpanelap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"future_modify", "future_save"});
        this.getModel().setValue("changedesc", null);
        this.getModel().setValue("changeexplain", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"revisecancel") && this.getModel().getDataChanged()) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_cancel", (IFormPlugin)this);
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u53d6\u6d88\uff1f{0}\u82e5\u53d6\u6d88\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PositionReviceInfoPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), System.lineSeparator());
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        }
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"revisesave")) {
            HashSet<String> prop = new HashSet<String>();
            for (IDataEntityProperty property : this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties()) {
                String propName = property.getName();
                if (HRStringUtils.equals((String)propName, (String)"changedesc") || HRStringUtils.equals((String)propName, (String)"changeexplain")) continue;
                prop.add(propName);
            }
            if (prop.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PositionReviceInfoPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"reviselog")) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("hbpm_reviselog");
            if (this.getView().getMainView() != null) {
                showParameter.setPageId("hbpm_reviselog_" + this.getView().getMainView().getPageId());
            }
            Long positionHisId = this.getPositionHisIdFromView();
            DynamicObject his = PositionQueryRepository.getInstance().queryDataById(positionHisId);
            long positionId = his.getLong("boid");
            showParameter.setCustomParam("position", Collections.singletonList(positionId));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("continue_cancel".equals(callBackId) && evt.getResult() == MessageBoxResult.Yes) {
            this.showOperationView(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey;
        super.afterDoOperation(eventArgs);
        switch (operateKey = eventArgs.getOperateKey()) {
            case "revisesave": {
                if (!eventArgs.getOperationResult().isSuccess()) break;
                String newPosHisId = this.getModel().getDataEntity().getString("id");
                boolean isAdd = this.getModel().getDataEntity().getBoolean("isadd");
                this.updateParentViewCustomControl(newPosHisId, isAdd);
                this.showOperationView(OperationStatus.VIEW);
                this.getView().getFormShowParameter().setCustomParam("position", (Object)newPosHisId);
                this.getModel().getDataEntity().set("id", (Object)0);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "revisecancel": {
                this.showOperationView(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "reviseedit": {
                this.showOperationView(OperationStatus.EDIT);
                this.setFieldEnable();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)"firstbsed", (String)fieldKey)) {
            this.getModel().getDataEntity().set("bsed", (Object)this.getModel().getDataEntity().getDate("firstbsed"));
        }
    }

    private void showOperationView(OperationStatus status) {
        IFormView parentView = this.getView().getParentView();
        if (status == OperationStatus.EDIT) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"revisesave", "revisecancel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reviseedit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reviselog"});
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{"changeinfoflexpanelap"});
            parentView.getPageCache().put("isediting", "1");
        }
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"revisesave", "revisecancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reviseedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reviselog"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"changeinfoflexpanelap"});
            parentView.getPageCache().put("isediting", "0");
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void setFieldEnable() {
        Date firstEffdt;
        Long positionHisId = this.getPositionHisIdFromView();
        DynamicObject his = PositionQueryRepository.getInstance().queryDataById(positionHisId);
        DynamicObject bo = PositionQueryRepository.getInstance().queryDataById(Long.valueOf(his.getLong("boid")));
        Date bsed = HRDateTimeUtils.truncateDate((Date)his.getDate("bsed"));
        if (HRDateTimeUtils.dayEquals((Date)bsed, (Date)(firstEffdt = HRDateTimeUtils.truncateDate((Date)bo.getDate("firstbsed"))))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"establishmentdate", "firstbsed"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"establishmentdate", "firstbsed"});
        }
    }

    private Long getPositionHisIdFromView() {
        String positionHisId = (String)this.getView().getFormShowParameter().getCustomParam("position");
        return Long.valueOf(positionHisId);
    }

    private void updateParentViewCustomControl(String newPosHisId, boolean isAdd) {
        PositionReviseService service = new PositionReviseService(true);
        DynamicObject hisVersion = service.getHisVersionById(newPosHisId);
        service.customControlUpdateVersion(hisVersion, isAdd, this.getView().getParentView());
    }
}

