/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.position.PositionReviseService;

public class PositionRevisePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PositionReviseService reviseService = new PositionReviseService(true);
        Long positionId = (Long)this.getView().getFormShowParameter().getCustomParam("position");
        DynamicObject[] hisVersions = reviseService.getHisVersions(positionId);
        String selectedHisId = hisVersions[0].getString("id");
        reviseService.customControlInitData(hisVersions, selectedHisId, this.getView());
        reviseService.openDetailRevise(selectedHisId, this.getView());
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        if (!HRStringUtils.equals((String)customEventArgs.getKey(), (String)"customcontrolap") || !HRStringUtils.equals((String)customEventArgs.getEventName(), (String)"changeselect")) {
            return;
        }
        Map paramsMap = (Map)JSONObject.parseObject((String)customEventArgs.getEventArgs(), Map.class);
        if (paramsMap == null) {
            return;
        }
        String hisId = paramsMap.get("id").toString();
        this.getPageCache().put("toChangeHisid", hisId);
        String isEditing = this.getPageCache().get("isediting");
        PositionReviseService reviseService = new PositionReviseService(false);
        if (HRStringUtils.equals((String)isEditing, (String)"1")) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_change", (IFormPlugin)this);
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6b63\u5728\u4fee\u8ba2\u7f16\u8f91\u4e2d\uff0c\u662f\u5426\u5207\u6362\uff1f{0}\u82e5\u5207\u6362\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PositionRevisePlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]), System.lineSeparator());
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
        } else {
            reviseService.customControlChangeSelect(hisId, this.getView());
            reviseService.openDetailRevise(hisId, this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("continue_change".equals(callBackId)) {
            PositionReviseService reviseService = new PositionReviseService(false);
            if (evt.getResult() == MessageBoxResult.Yes) {
                String hisId = this.getPageCache().get("toChangeHisid");
                this.getPageCache().remove("toChangeHisid");
                this.getPageCache().remove("isediting");
                reviseService.customControlChangeSelect(hisId, this.getView());
                reviseService.openDetailRevise(hisId, this.getView());
            } else {
                reviseService.customControlChangeSelect(null, this.getView());
            }
        }
    }

    public void pageRelease(EventObject e) {
        String entityId = "hbpm_positionhr";
        Long positionId = (Long)this.getView().getFormShowParameter().getCustomParam("position");
        MutexHelper.release((String)entityId, (String)"modify", (String)String.valueOf(positionId));
    }
}

