/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.projectchart;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.ProjectChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.constants.orgchart.ProjectChartConstants;

public class ProjectChartBase
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final Log LOG = LogFactory.getLog(ProjectChartBase.class);
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String HRCS = "hrcs";
    private static final String PERM_PROJECT_ORGIDS = "perm_project_org_ids";
    private static final String CACHE_PERM_PROJECT_ORG_RESULT = "perm_project_org_result";
    private static final String CACHE_PERM_ADMIN_ORG_RESULT = "perm_admin_org_result";
    private static final String CACHE_PERM_PROJECT_ORG_RESULT_WITHSUB = "perm_project_org_result_withsub";
    private static final String CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER = "real_rootorg_structlongnumber";

    protected void removePermPageCache(AbstractFormPlugin plugin) {
        plugin.getPageCache().remove(PERM_PROJECT_ORGIDS);
        plugin.getPageCache().remove(CACHE_PERM_PROJECT_ORG_RESULT);
        plugin.getPageCache().remove(CACHE_PERM_PROJECT_ORG_RESULT_WITHSUB);
        plugin.getPageCache().remove(CACHE_PERM_ADMIN_ORG_RESULT);
    }

    protected Set<String> buildChildStructLongNumbers(DynamicObjectCollection belongAdminOrgStructCollection, String parentStructLongNumber) {
        HashSet<String> childLongNumbers = new HashSet<String>();
        belongAdminOrgStructCollection.forEach(belongAdminOrgStruct -> {
            int tempIndex;
            String structLongNumber = belongAdminOrgStruct.getString("structlongnumber");
            if (structLongNumber.length() > parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                childLongNumbers.add(structLongNumber);
            }
            while (-1 != (tempIndex = structLongNumber.lastIndexOf(33)) && !structLongNumber.equals(parentStructLongNumber) && structLongNumber.length() >= parentStructLongNumber.length() && structLongNumber.startsWith(parentStructLongNumber)) {
                structLongNumber = structLongNumber.substring(0, tempIndex);
                childLongNumbers.add(structLongNumber);
            }
        });
        return childLongNumbers;
    }

    protected String getRealRootOrgStructLongNumber(AbstractFormPlugin plugin) {
        String realRootOrgStructLongNumber = plugin.getPageCache().get(CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER);
        if (!HRStringUtils.isEmpty((String)realRootOrgStructLongNumber)) {
            return realRootOrgStructLongNumber;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter orgTeamFilter = new QFilter("orgteam", "=", (Object)PlatformRootUtils.getLongRootIdOfPlatform());
        QFilter structProjectFilter = new QFilter("structproject", "=", (Object)OrgChartConstants.DEFAULT_OTCCLASSIFY_ID);
        DynamicObject rootOrgTeam = serviceHelper.queryOne("structlongnumber", new QFilter[]{currentVersionFilter, orgTeamFilter, structProjectFilter});
        if (rootOrgTeam != null) {
            realRootOrgStructLongNumber = rootOrgTeam.getString("structlongnumber");
            plugin.getPageCache().put(CACHE_REAL_ROOT_ORG_STRUCT_LONG_NUMBER, realRootOrgStructLongNumber);
        }
        return realRootOrgStructLongNumber;
    }

    public List<Long> getPermProjectOrgs(AbstractFormPlugin plugin) {
        String projectOrgIdsString = plugin.getPageCache().get(PERM_PROJECT_ORGIDS);
        if (!HRStringUtils.isEmpty((String)projectOrgIdsString)) {
            List projectOrgIds = SerializationUtils.fromJsonStringToList((String)projectOrgIdsString, Long.class);
            return projectOrgIds;
        }
        Map hasPermOrgTeamMap = this.getPermProjectResult(plugin).getHasPermOrgTeamMap();
        List projectOrgIds = hasPermOrgTeamMap.getOrDefault(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID, new ArrayList());
        plugin.getPageCache().put(PERM_PROJECT_ORGIDS, SerializationUtils.toJsonString((Object)projectOrgIds));
        LOG.info("getPermProjectOrgs projectOrgIds={}", (Object)JSONObject.toJSONString((Object)projectOrgIds));
        return projectOrgIds;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub(AbstractFormPlugin plugin, IFormView view) {
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = plugin.getPageCache().get(CACHE_PERM_PROJECT_ORG_RESULT_WITHSUB);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp(formShowParameter, permEntityId);
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedAdminOrgsWithSubInfo", (Object[])new Object[]{userId, appId, permEntityId, permItemId, Boolean.TRUE});
        plugin.getPageCache().put(CACHE_PERM_PROJECT_ORG_RESULT_WITHSUB, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    public DynamicObject getRootDynByRootId(QFilter qFilter, Long rootId) {
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter[] filters = new QFilter[]{new QFilter("orgteam.boid", "=", (Object)rootId), qFilter};
        return serviceHelper.queryOriginalOne(selectFields, filters);
    }

    public DynamicObject getRootNodeDynamicObj(QFilter qFilter, List<String> orgIds) {
        QFilter realRootOrgStructLongNumberFilter;
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(qFilter);
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            List<Long> permOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
            QFilter permOrgFilter = new QFilter("orgteam.boid", "in", permOrgIds);
            filters.add(permOrgFilter);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            filters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
        }
        if ((realRootOrgStructLongNumberFilter = OrgChartServiceHelper.getRealRootOrgStructLongNumberQFilter((String)this.getRealRootOrgStructLongNumber((AbstractFormPlugin)this))) != null) {
            filters.add(realRootOrgStructLongNumberFilter);
        }
        filters.add(ProjectChartServiceHelper.getOtClassifyFilter());
        DynamicObjectCollection projectOrgCollection = serviceHelper.queryOriginalCollection(selectFields, filters.toArray(new QFilter[0]));
        if (null == projectOrgCollection || projectOrgCollection.size() == 0) {
            return null;
        }
        ArrayList structLongNumberList = new ArrayList(16);
        projectOrgCollection.forEach(dyn -> {
            String structLongNumber = dyn.getString("structlongnumber");
            structLongNumberList.add(structLongNumber);
        });
        String commonPrefixStructLongNumber = OrgTreeUtils.getCommonPrefixStructLongNumber(structLongNumberList);
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "=", (Object)commonPrefixStructLongNumber);
        if (HRStringUtils.isEmpty((String)commonPrefixStructLongNumber)) {
            LOG.info("getRootNodeDynamicObj.commonPrefixStructLongNumber is null");
            return null;
        }
        return serviceHelper.queryOriginalOne(selectFields, new QFilter[]{structLongNumberFilter, qFilter});
    }

    public AuthorizedOrgTeamResult getPermProjectResult(AbstractFormPlugin plugin) {
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = plugin.getPageCache().get(CACHE_PERM_PROJECT_ORG_RESULT);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgTeamResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgTeamResult.class);
        }
        AuthorizedOrgTeamResult permResult = this.invokeProjectPerm(plugin.getView().getFormShowParameter());
        plugin.getPageCache().put(CACHE_PERM_PROJECT_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }

    public AuthorizedOrgTeamResult invokeProjectPerm(FormShowParameter formShowParameter) {
        String permItemId = "47150e89000000ac";
        String permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)"haos_projteambaseinfo");
        String appId = this.getAppIdWithDealThirdApp(formShowParameter, "haos_projteambaseinfo");
        Date searchDate = new Date();
        AuthorizedOrgTeamResult permResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getAuthorizedOrgTeamsWithDate", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, permEntityId, permItemId, "boid", searchDate, searchDate});
        return permResult;
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    protected Date getDate() {
        String datefieldStr = this.getPageCache().get("datefield");
        Date datefield = new Date();
        if (!StringUtils.isEmpty((CharSequence)datefieldStr)) {
            try {
                datefield = HRDateTimeUtils.parseDate((String)datefieldStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error(MessageFormat.format("getDate.date:{0}", datefieldStr));
            }
        }
        return datefield;
    }
}

