/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.projectchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.query.SchemeQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.dao.IHRBaseDao;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.ProjectChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.OrgChartConstants;
import kd.hr.homs.common.constants.orgchart.ProjectChartConstants;
import kd.hr.homs.common.enums.OrgChartOperateTypes;
import kd.hr.homs.common.model.ChartOrgInfo;
import kd.hr.homs.common.model.ChartStyle;
import kd.hr.homs.common.model.OrgChartTreeNode;
import kd.hr.homs.common.model.ProjectChartQueryParam;
import kd.hr.homs.common.model.ProjectSearchChartData;
import kd.hr.homs.formplugin.web.projectchart.ProjectChartBase;

public class ProjectChartPlugin
extends ProjectChartBase
implements TreeNodeQueryListener {
    private static final Log LOG = LogFactory.getLog(ProjectChartPlugin.class);
    private List<Long> defaultOrgs = OrgChartServiceHelper.getDefaultOrg((String)"homs_projectchart");
    private List<String> orgIds = this.defaultOrgs.stream().map(String::valueOf).collect(Collectors.toList());

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", "treeview");
        hashMap.put("labelShowType", 1);
        service.addAction("u", hashMap);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.getTreeListView().getTreeView().addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put("termRemain", "1");
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date());
        if (defaultScheme != null) {
            ProjectChartQueryParam orgChartQueryParam = ProjectChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
            ProjectSearchChartData searchChartData = ProjectChartServiceHelper.getSchemeSearchChartData((ProjectChartQueryParam)orgChartQueryParam.setOrgs(this.orgIds), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds);
            String errorDesc = ProjectChartServiceHelper.checkScheme((ProjectSearchChartData)searchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, this.orgIds);
            if (StringUtils.isNotEmpty((CharSequence)errorDesc)) {
                errorDesc = errorDesc.substring(0, errorDesc.length() - 1);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e2d\uff0c\u201c%s\u201d\u9009\u5b9a\u7684\u503c\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5207\u6362\u5230\u5e38\u7528\u6761\u4ef6\u8fc7\u6ee4\u9ed8\u8ba4\u7684\u503c\u8fdb\u884c\u67e5\u770b\u3002", (String)"ProjectChartPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[]{errorDesc}));
                this.refreshTreeByDefaultSearchChartData(permOrgResultWithSub, permProjectOrgIds, defaultFilter);
            } else {
                this.queryOrgChartByScheme(orgChartQueryParam, searchChartData, defaultScheme, "initData");
            }
        } else {
            this.refreshTreeByDefaultSearchChartData(permOrgResultWithSub, permProjectOrgIds, defaultFilter);
        }
    }

    private void refreshTreeByDefaultSearchChartData(AuthorizedOrgResultWithSub permOrgResultWithSub, List<Long> permProjectOrgIds, QFilter defaultFilter) {
        ProjectSearchChartData searchChartData = ProjectChartServiceHelper.getDefaultSearchChartData((Date)new Date(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds);
        this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)searchChartData.getOrgs()));
        this.refreshTreeData(defaultFilter, "initData", searchChartData);
    }

    private void refreshTreeData(QFilter qFilter, String dataFlag, ProjectSearchChartData searchChartData) {
        OrgChartTreeNode orgChartRootNode;
        this.removePermPageCache((AbstractFormPlugin)this);
        OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(qFilter, searchChartData.getOrgs());
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        OrgChartTreeNode firstPermOrgNode = ProjectChartServiceHelper.findFirstPermOrgNode((OrgChartTreeNode)rootNode, permOrgResultWithSub.isHasAllOrgPerm() ? null : this.getPermProjectOrgs((AbstractFormPlugin)this), (List)searchChartData.getOrgs(), (boolean)permOrgResultWithSub.isHasAllOrgPerm());
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(10);
        LocalDate searchDate = TreeTemplateHelper.date2LocalDate((Date)searchChartData.getDateField());
        LocalDate today = TreeTemplateHelper.date2LocalDate((Date)new Date());
        if (!searchDate.isEqual(today)) {
            TreeNodeLabel searchDateLabel = new TreeNodeLabel(searchDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), "#666666");
            labelParaList.add(searchDateLabel);
        }
        if (rootNode != null && !CollectionUtils.isEmpty(labelParaList)) {
            rootNode.setLabelPara(labelParaList);
        }
        this.setRootNodeToTreeView(rootNode, firstPermOrgNode);
        if (StringUtils.isEmpty((CharSequence)searchChartData.getCurrentOrgChartRootNodeId()) && firstPermOrgNode != null) {
            searchChartData.setCurrentOrgChartRootNodeId(firstPermOrgNode.getBoid());
        }
        if ((orgChartRootNode = this.getRightOrgChartRootNode(qFilter, searchChartData, searchChartData.getCurrentOrgChartRootNodeId())) != null) {
            this.focusNode(this.getTreeListView().getTreeView(), this.getTreeListView().getTreeModel().getRoot(), (TreeNode)orgChartRootNode);
        }
        Map<String, Object> currentQueryShowParams = this.getQueryShowParams(null, searchChartData, null);
        if (orgChartRootNode == null) {
            currentQueryShowParams.put("maxLevel", 0);
        }
        Map<String, Object> result = this.setDataForCustomControl(dataFlag, (TreeNode)orgChartRootNode);
        currentQueryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty((Object)rootNode));
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId(), (boolean)true);
        currentQueryShowParams.put("schemes", schemes);
        result.putAll(currentQueryShowParams);
        CommonOrgChartServiceHelper.setTermRemaning(currentQueryShowParams, (String)this.getPageCache().get("termRemain"));
        this.getPageCache().remove("termRemain");
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)dataFlag, currentQueryShowParams, (CustomControl)customcontrol);
    }

    private void setRootNodeToTreeView(OrgChartTreeNode rootNode, OrgChartTreeNode firstPermOrgNode) {
        TreeView treeview = this.getTreeListView().getTreeView();
        treeview.deleteAllNodes();
        if (rootNode != null && firstPermOrgNode != null) {
            treeview.addNode((TreeNode)rootNode);
            rootNode.setParentid("");
            this.getTreeModel().setRoot((TreeNode)rootNode);
            this.getTreeModel().setCurrentNodeId((Object)firstPermOrgNode.getId());
            this.getPageCache().put("CURRENT_NODE_ID", firstPermOrgNode.getId());
        } else {
            OrgChartTreeNode notInitOrgNode = OrgChartServiceHelper.getNotInitOrgNode();
            if (notInitOrgNode != null) {
                treeview.addNode((TreeNode)notInitOrgNode);
            }
        }
    }

    private Map<String, Object> setDataForCustomControl(String dataFlag, TreeNode treeNode) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", treeNode);
        data.put("orgChart", dataFlag);
        data.put("code", "200");
        data.put("errorMessage", "");
        data.put("time", System.currentTimeMillis());
        customcontrol.setData(data);
        return data;
    }

    private void setSimpleDataForCustomControl(String dataFlag, Map<String, Object> data) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)dataFlag, data, (CustomControl)customcontrol);
    }

    private void getAndSendInitParams(ProjectChartQueryParam orgChartQueryParam, FilterScheme defaultScheme) {
        Map initQueryParams = ProjectChartServiceHelper.getInitQueryParams((boolean)true);
        HashMap<String, Object> result = new HashMap<String, Object>(initQueryParams);
        Map<String, Object> queryShowParams = this.getQueryShowParams(orgChartQueryParam, this.getSearchChartData(), defaultScheme);
        result.putAll(queryShowParams);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"initParamsKey", result, (CustomControl)customcontrol);
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"initParamsKey", (Map)initQueryParams, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
        result.put("desensitizeFields", OrgChartServiceHelper.getDesensitizeFields((long)OrgChartConstants.PROJECT_CARDDISSION));
    }

    private Map<String, Object> getQueryShowParams(ProjectChartQueryParam orgChartQueryParam, ProjectSearchChartData searchChartData, FilterScheme defaultScheme) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String maxLevel = this.getPageCache().get("MAX_LEVEL_KEY");
        maxLevel = StringUtils.isEmpty((CharSequence)maxLevel) ? "3" : maxLevel;
        result.put("maxLevel", maxLevel);
        if (orgChartQueryParam == null) {
            Map<String, Object> currentQueryShowParams = this.getCurrentQueryShowParams(searchChartData);
            result.putAll(currentQueryShowParams);
        } else {
            Map queryShowParamsByScheme = ProjectChartServiceHelper.getQueryShowParamsByScheme((ProjectChartQueryParam)orgChartQueryParam.setOrgs(this.orgIds), (FilterScheme)defaultScheme);
            Date queryDate = ProjectChartServiceHelper.getQueryDate((ProjectChartQueryParam)orgChartQueryParam);
            JSONObject showOrgTeam = this.getShowOrgTeam(orgChartQueryParam.getCurrentOrgChartRootNodeId(), queryDate, orgChartQueryParam.getOrgs());
            result.put("showOrgTeam", showOrgTeam);
            result.putAll(queryShowParamsByScheme);
        }
        result.put("showLevel", Math.min(Integer.parseInt(result.get("showLevel").toString()), Integer.parseInt(maxLevel)));
        return result;
    }

    private Map<String, Object> getCurrentQueryShowParams(ProjectSearchChartData searchChartData) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("queryDate", searchChartData.getDateField());
        ChartStyle chartStyle = OrgChartServiceHelper.getChartStyleById((String)searchChartData.getChartStyleId());
        result.put("MATCH_CHART_STYLE_KEY", chartStyle);
        result.put("isShowEye", OrgChartServiceHelper.getIsShowEye((ChartStyle)chartStyle, (List)OrgChartServiceHelper.getDesensitizeFields((long)OrgChartConstants.PROJECT_CARDDISSION)));
        result.put("showLevel", searchChartData.getShowLevel());
        result.put("orgchartdirection", searchChartData.getOrgChartDirection());
        if (!StringUtils.isEmpty((CharSequence)searchChartData.getSchemeId())) {
            result.put("showScheme", new SchemeQuery().getScheme(searchChartData.getSchemeId()));
        } else {
            result.put("showScheme", null);
        }
        result.put("orgs", OrgChartServiceHelper.getOrgInfo((List)searchChartData.getOrgs()));
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId(), (boolean)false);
        result.put("schemes", schemes);
        JSONObject showOrgTeam = this.getShowOrgTeam(searchChartData.getCurrentOrgChartRootNodeId(), searchChartData.getDateField(), searchChartData.getOrgs());
        result.put("showOrgTeam", showOrgTeam);
        return result;
    }

    private JSONObject getShowOrgTeam(String currentOrgId, Date queryDate, List<String> orgIds) {
        JSONObject showOrgTeam = null;
        if (!StringUtils.isEmpty((CharSequence)currentOrgId)) {
            QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate);
            ArrayList orgIdList = Lists.newArrayListWithExpectedSize((int)orgIds.size());
            orgIds.forEach(orgId -> orgIdList.add(Long.parseLong(orgId)));
            QFilter orgIdFilter = new QFilter("org", "in", (Object)orgIdList);
            defaultFilter.and(orgIdFilter);
            HashSet<Long> orgBoIds = new HashSet<Long>();
            orgBoIds.add(Long.parseLong(currentOrgId));
            Map projectBaseInfoMap = ProjectChartServiceHelper.getProjectBaseInfo(orgBoIds, (QFilter)defaultFilter);
            if (!CollectionUtils.isEmpty((Map)projectBaseInfoMap)) {
                DynamicObject currentOrgTeam = (DynamicObject)projectBaseInfoMap.get(Long.parseLong(currentOrgId));
                JSONObject currentOrgTeamInfo = new JSONObject();
                currentOrgTeamInfo.put("id", (Object)currentOrgTeam.getString("boid"));
                currentOrgTeamInfo.put("name", (Object)currentOrgTeam.getString("name"));
                currentOrgTeamInfo.put("number", (Object)currentOrgTeam.getString("number"));
                showOrgTeam = currentOrgTeamInfo;
            }
        }
        return showOrgTeam;
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        String operateName;
        String eventArgs = customEventArgs.getEventArgs();
        switch (operateName = customEventArgs.getEventName()) {
            case "initParamsKey": {
                this.initParams();
                break;
            }
            case "searchChartData": {
                this.queryChart(eventArgs);
                break;
            }
            case "refreshProjectChart": {
                this.refresh();
                break;
            }
            case "schemeQueryProjectChart": {
                this.schemeQuery(eventArgs);
                break;
            }
            case "analyseScheme": {
                this.analyseSchemeById(eventArgs);
                break;
            }
            case "changeQueryCondition": {
                this.changeQueryCondition(eventArgs);
                break;
            }
            case "commonConditionQuery": {
                AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
                List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
                this.refreshTreeData(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)new Date()), "commonConditionQuery", ProjectChartServiceHelper.getDefaultSearchChartData((Date)new Date(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds));
                break;
            }
            case "desensitizeInfoQuery": {
                this.desensitizeInfoQuery(eventArgs);
                break;
            }
        }
    }

    private void desensitizeInfoQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String currentNodeId = jsonObject.getString("currentNodeId");
        String personName = jsonObject.getString("personname");
        int isDesensitize = jsonObject.getInteger("isDesensitize");
        Date queryDate = this.getDate();
        HashMap<String, String> result = new HashMap<String, String>();
        Object resultValue = personName;
        if (!StringUtils.isEmpty((CharSequence)personName)) {
            resultValue = ProjectChartServiceHelper.getPersonDesensitizeValue((String)currentNodeId, (String)personName, (int)isDesensitize, (Date)queryDate);
        }
        result.put("personname", (String)resultValue);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"desensitizeInfoQuery", result, (CustomControl)customcontrol);
    }

    private void schemeQuery(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterScheme scheme = new SchemeQuery().getScheme(schemeId);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"ProjectChartPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        ProjectChartQueryParam schemeOrgChartQueryParam = ProjectChartServiceHelper.analyzeScheme((FilterScheme)scheme);
        ProjectSearchChartData schemeSearchChartData = ProjectChartServiceHelper.getSchemeSearchChartData((ProjectChartQueryParam)schemeOrgChartQueryParam.setOrgs(this.orgIds), null, null);
        if (this.validateScheme(schemeSearchChartData)) {
            this.queryOrgChartByScheme(schemeOrgChartQueryParam, schemeSearchChartData, scheme, "queryTreeNodeData");
        } else {
            this.getPageCache().put("schemeId", schemeId);
        }
    }

    private boolean validateScheme(ProjectSearchChartData schemeSearchChartData) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        String errorDesc = ProjectChartServiceHelper.checkScheme((ProjectSearchChartData)schemeSearchChartData, (String)schemeSearchChartData.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, this.orgIds);
        if (HRStringUtils.isNotEmpty((String)errorDesc)) {
            errorDesc = errorDesc.substring(0, errorDesc.length() - 1);
            errorDesc = errorDesc + ResManager.loadKDString((String)"\u53d1\u751f\u53d8\u52a8\uff0c\u65b9\u6848\u4e0d\u53ef\u67e5\u8be2\uff0c\u53ef\u80fd\u4e3a\u4ee5\u4e0b\u539f\u56e0\uff1a\u2460\u6ca1\u6709\u5bf9\u5e94\u6743\u9650 \u2461\u5b57\u6bb5\u7684\u503c\u88ab\u5220\u9664\u3002", (String)"OrgChartPlugin_30", (String)"odc-homs-formplugin", (Object[])new Object[0]) + "\n";
            errorDesc = errorDesc + ResManager.loadKDString((String)"\u60a8\u53ef\u5220\u9664\u65b9\u6848\u6216\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"OrgChartPlugin_31", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        }
        if (!StringUtils.isEmpty((CharSequence)errorDesc)) {
            this.showSchemeQueryErrorInfo(errorDesc);
            CustomControl customcontrol1 = (CustomControl)this.getView().getControl("customcontrolap1");
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            OrgChartServiceHelper.setErrorDataForSearchCustomControl((String)"queryError", new HashMap(), (CustomControl)customcontrol1, (String)" ");
            OrgChartServiceHelper.setSimpleDataForCustomControl((String)"queryError", new HashMap(), (CustomControl)customcontrol, (String)"500", (String)" ");
            return false;
        }
        return true;
    }

    private void initParams() {
        String error;
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId());
        ProjectChartQueryParam orgChartQueryParam = ProjectChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        ProjectSearchChartData schemeSearchChartData = ProjectChartServiceHelper.getSchemeSearchChartData((ProjectChartQueryParam)orgChartQueryParam, (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds);
        if (defaultScheme != null && StringUtils.isNotEmpty((CharSequence)(error = ProjectChartServiceHelper.checkScheme((ProjectSearchChartData)schemeSearchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, this.orgIds)))) {
            orgChartQueryParam = null;
            defaultScheme = null;
        }
        this.getAndSendInitParams(orgChartQueryParam, defaultScheme);
    }

    private void changeQueryCondition(String eventArgs) {
        ProjectSearchChartData searchChartData = (ProjectSearchChartData)JSONObject.parseObject((String)eventArgs, ProjectSearchChartData.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.getChangeQueryConditionParams(searchChartData.getOrgs(), searchChartData.getDateField(), searchChartData.getCurrentOrgChartRootNodeId(), result);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"changeQueryCondition", result, (CustomControl)customcontrol);
    }

    private void refresh() {
        ProjectSearchChartData searchChartData = this.getSearchChartData();
        searchChartData.setCurrentOrgChartRootNodeId(null);
        String chartStyleId = this.checkChartStyleExistAndFindMatchChartStyle(searchChartData.getChartStyleId());
        if (!StringUtils.isEmpty((CharSequence)chartStyleId)) {
            searchChartData.setChartStyleId(chartStyleId);
        }
        this.getPageCache().put("termRemain", "1");
        this.refreshTreeData(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)searchChartData.getDateField()), "refreshProjectChart", searchChartData);
    }

    private void analyseSchemeById(String eventArgs) {
        HashMap<String, JSONObject> result = new HashMap<String, JSONObject>();
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        String schemeId = jsonObject.getString("schemeId");
        FilterScheme scheme = new SchemeQuery().getScheme(schemeId);
        if (scheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u5207\u6362\u5176\u5b83\u65b9\u6848\u8fdb\u884c\u67e5\u8be2\u3002", (String)"ProjectChartPlugin_15", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            return;
        }
        ProjectChartQueryParam schemeOrgChartQueryParam = ProjectChartServiceHelper.analyzeScheme((FilterScheme)scheme);
        ProjectSearchChartData schemeSearchChartData = ProjectChartServiceHelper.getSchemeSearchChartData((ProjectChartQueryParam)schemeOrgChartQueryParam.setOrgs(this.orgIds), null, null);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        String errorDesc = ProjectChartServiceHelper.checkScheme((ProjectSearchChartData)schemeSearchChartData, (String)schemeOrgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, this.orgIds);
        if (StringUtils.isNotEmpty((CharSequence)errorDesc)) {
            return;
        }
        Map queryShowParamsByScheme = ProjectChartServiceHelper.getQueryShowParamsByScheme((ProjectChartQueryParam)schemeOrgChartQueryParam, (FilterScheme)scheme);
        Date queryDate = ProjectChartServiceHelper.getQueryDate((ProjectChartQueryParam)schemeOrgChartQueryParam);
        JSONObject showOrgTeam = this.getShowOrgTeam(schemeOrgChartQueryParam.getCurrentOrgChartRootNodeId(), queryDate, schemeOrgChartQueryParam.getOrgs());
        Object chartStyle = queryShowParamsByScheme.get("MATCH_CHART_STYLE_KEY");
        if (!HRObjectUtils.isEmpty(chartStyle)) {
            result.put("showOrgTeam", showOrgTeam);
            result.putAll(queryShowParamsByScheme);
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"analyseScheme", result, (CustomControl)customcontrol);
    }

    private void queryOrgChartByScheme(ProjectChartQueryParam schemeOrgChartQueryParam, ProjectSearchChartData schemeSearchChartData, FilterScheme scheme, String dataFlag) {
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)schemeSearchChartData));
        this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)schemeSearchChartData.getOrgs()));
        this.getPageCache().put("datefield", HRDateTimeUtils.format((Date)schemeSearchChartData.getDateField(), (String)"yyyy-MM-dd"));
        QFilter defaultFilter = ProjectChartServiceHelper.getSchemeFilter((ProjectChartQueryParam)schemeOrgChartQueryParam);
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)schemeOrgChartQueryParam.getOrgs()));
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(schemeSearchChartData.getCurrentOrgChartRootNodeId()));
        OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(ProjectChartServiceHelper.getSchemeFilter((ProjectChartQueryParam)schemeOrgChartQueryParam), schemeSearchChartData.getOrgs());
        this.setRootNodeToTreeView(rootNode, rootNode);
        String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        this.searchBuildTree(selectFields, serviceHelper, rootDyn, schemeSearchChartData.getOrgs(), schemeSearchChartData.getDateField());
        Map<String, Object> queryShowParams = this.getQueryShowParams(schemeOrgChartQueryParam, null, scheme);
        this.nodeClick(rootDyn.getString("orgteam.boid"), this.getTreeListView().getTreeView(), schemeSearchChartData, dataFlag, queryShowParams);
    }

    private void queryChart(String eventArgs) {
        ProjectSearchChartData searchChartData = (ProjectSearchChartData)JSONObject.parseObject((String)eventArgs, ProjectSearchChartData.class);
        if (this.checkSearchCharData(searchChartData)) {
            return;
        }
        String chartStyleId = this.checkChartStyleExistAndFindMatchChartStyle(searchChartData.getChartStyleId());
        if (!StringUtils.isEmpty((CharSequence)chartStyleId)) {
            searchChartData.setChartStyleId(chartStyleId);
        }
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)searchChartData));
        boolean isChange = !OrgChartServiceHelper.isEquals((Date)searchChartData.getDateField(), (Date)this.getDate());
        OrgChartTreeNode currentNode = null;
        if (isChange) {
            this.getPageCache().put("datefield", HRDateTimeUtils.format((Date)(searchChartData.getDateField() == null ? new Date() : searchChartData.getDateField()), (String)"yyyy-MM-dd"));
            this.getPageCache().put("queryOrgId", JSONObject.toJSONString((Object)searchChartData.getOrgs()));
            searchChartData.setCurrentOrgChartRootNodeId(null);
            this.refreshTreeData(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)searchChartData.getDateField()), "queryTreeNodeData", searchChartData);
        } else {
            TreeNode rootOrgChartData = this.queryRootOrgChartData(searchChartData);
            currentNode = this.queryCurrentOrgChartData(rootOrgChartData, searchChartData);
            Map<String, Object> queryShowParams = this.getQueryShowParams(null, searchChartData, null);
            if (currentNode == null) {
                queryShowParams.put("maxLevel", 0);
            }
            queryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty((Object)currentNode));
            List schemes = OrgChartServiceHelper.getScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId(), (boolean)true);
            queryShowParams.put("schemes", schemes);
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"queryTreeNodeData", queryShowParams, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
            HashMap<String, Object> resultMap = new HashMap<String, Object>(queryShowParams);
            resultMap.put("data", currentNode);
            this.setSimpleDataForCustomControl("queryTreeNodeData", resultMap);
            resultMap.put("operateType", OrgChartOperateTypes.CONDITION_QUERY.getValue());
        }
    }

    private boolean checkSearchCharData(ProjectSearchChartData searchChartData) {
        String schemeDateFiled = ResManager.loadKDString((String)"\u201c\u67e5\u8be2\u65e5\u671f\u201d", (String)"ProjectChartPlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeChartStyle = ResManager.loadKDString((String)"\u201c\u7ed3\u6784\u56fe\u6837\u5f0f\u201d", (String)"ProjectChartPlugin_13", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        if (HRObjectUtils.isEmpty((Object)searchChartData.getDateField())) {
            builder.append(schemeDateFiled);
        }
        if (HRStringUtils.isEmpty((String)searchChartData.getChartStyleId())) {
            builder.append(schemeChartStyle);
        }
        if (builder.length() > 0) {
            String tipMessage = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectChartPlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            builder.append(tipMessage);
            this.getView().showErrorNotification(builder.toString());
            OrgChartServiceHelper.setErrorDataForSearchCustomControl((String)"queryError", new HashMap(), (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")), (String)" ");
            OrgChartServiceHelper.setSimpleDataForCustomControl((String)"queryError", new HashMap(), (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")), (String)"500", (String)" ");
            return true;
        }
        return false;
    }

    private TreeNode queryRootOrgChartData(ProjectSearchChartData searchChartData) {
        String currentNodeId = searchChartData.getCurrentOrgChartRootNodeId();
        if (StringUtils.isEmpty((CharSequence)currentNodeId)) {
            return null;
        }
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)searchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(currentNodeId));
        if (rootDyn == null) {
            return null;
        }
        return this.getOrgChartTreeNode(searchChartData, rootDyn, true);
    }

    private OrgChartTreeNode getOrgChartTreeNode(ProjectSearchChartData searchChartData, DynamicObject rootDyn, boolean isLeftTree) {
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)searchChartData.getDateField());
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(defaultFilter, rootDyn.getInt("level"), rootDyn.getString("structlongnumber"), isLeftTree, searchChartData.getOrgs());
        List<OrgChartTreeNode> treeNodes = this.getOrgChartChildTreeNode(defaultFilter, rootDyn, treeViewCollection);
        OrgChartTreeNode rootNode = treeNodes.get(treeNodes.size() - 1);
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, treeNodes);
        if (!isLeftTree) {
            this.setShowFieldInfos(treeNodes, searchChartData);
        }
        if (rootNode.getChildren() != null && rootNode.getChildren().size() == 0) {
            rootNode.setChildren(null);
        }
        return rootNode;
    }

    private OrgChartTreeNode queryCurrentOrgChartData(TreeNode rootNode, ProjectSearchChartData searchChartData) {
        if (rootNode == null) {
            return null;
        }
        return (OrgChartTreeNode)rootNode.getTreeNode(searchChartData.getCurrentOrgChartRootNodeId());
    }

    private void getChangeQueryConditionParams(List<String> orgIds, Date queryDate, String currentNodeId, Map<String, Object> result) {
        OrgChartTreeNode firstPermOrgNode;
        QFilter qFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate);
        if (StringUtils.isEmpty((CharSequence)currentNodeId)) {
            OrgChartTreeNode rootNode = (OrgChartTreeNode)this.getLeftTreeRootNode(qFilter, orgIds);
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            firstPermOrgNode = ProjectChartServiceHelper.findFirstPermOrgNode((OrgChartTreeNode)rootNode, permOrgResultWithSub.isHasAllOrgPerm() ? null : this.getPermProjectOrgs((AbstractFormPlugin)this), orgIds, (boolean)permOrgResultWithSub.isHasAllOrgPerm());
        } else {
            DynamicObject rootDyn = this.getRootDynByRootId(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate), Long.parseLong(currentNodeId));
            firstPermOrgNode = this.getLeftTreeNodes(qFilter, rootDyn, orgIds);
        }
        JSONObject showOrgTeam = new JSONObject();
        if (firstPermOrgNode != null) {
            showOrgTeam.put("id", (Object)firstPermOrgNode.getId());
            showOrgTeam.put("name", (Object)firstPermOrgNode.getText());
            showOrgTeam.put("number", (Object)firstPermOrgNode.getNumber());
        }
        result.put("showOrgTeam", showOrgTeam);
        int showLevel = 0;
        int maxLevel = 0;
        if (firstPermOrgNode != null) {
            DynamicObject rootDyn = this.getRootDynByRootId(OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate), Long.parseLong(firstPermOrgNode.getId()));
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            Set levels = OrgChartServiceHelper.calculateQueryLevelsByRootOrg((int)rootDyn.getInt("level"), (String)rootDyn.getString("structlongnumber"), (Date)this.getDate(), permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermProjectOrgs((AbstractFormPlugin)this), new ArrayList(), Collections.singletonList(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID), (boolean)false, orgIds, null);
            maxLevel = levels.size() + 1;
            showLevel = Math.min(maxLevel, 3);
        }
        result.put("showLevel", showLevel);
        result.put("maxLevel", maxLevel);
    }

    protected TreeNode getLeftTreeRootNode(QFilter qFilter, List<String> orgIds) {
        DynamicObject rootNodeDynamicObj = this.getRootNodeDynamicObj(qFilter, orgIds);
        if (rootNodeDynamicObj == null) {
            return null;
        }
        LOG.info("getLeftTreeRootNode rootId={}", (Object)rootNodeDynamicObj.getString("orgteam.id"));
        return this.getLeftTreeNodes(qFilter, rootNodeDynamicObj, orgIds);
    }

    private OrgChartTreeNode getLeftTreeNodes(QFilter qFilter, DynamicObject rootNodeDynamicObj, List<String> orgIds) {
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(qFilter, rootNodeDynamicObj.getInt("level"), rootNodeDynamicObj.getString("structlongnumber"), true, orgIds);
        List<OrgChartTreeNode> treeNodes = this.getOrgChartChildTreeNode(qFilter, rootNodeDynamicObj, treeViewCollection);
        OrgChartTreeNode rootNode = treeNodes.get(treeNodes.size() - 1);
        OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, treeNodes);
        return rootNode;
    }

    protected OrgChartTreeNode getRightOrgChartRootNode(QFilter qFilter, ProjectSearchChartData searchChartData, String firstPermOrgNodeId) {
        if (StringUtils.isEmpty((CharSequence)firstPermOrgNodeId)) {
            return null;
        }
        DynamicObject rootNodeDynamicObj = this.getRootDynByRootId(qFilter, Long.parseLong(firstPermOrgNodeId));
        if (rootNodeDynamicObj == null) {
            return null;
        }
        int rootLevel = rootNodeDynamicObj.getInt("level");
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        Map levelAndOrgCountMap = OrgChartServiceHelper.getLevelAndOrgCountByRootOrg((int)rootNodeDynamicObj.getInt("level"), (String)rootNodeDynamicObj.getString("structlongnumber"), (Date)this.getDate(), permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermProjectOrgs((AbstractFormPlugin)this), new ArrayList(), Collections.singletonList(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID), (List)searchChartData.getOrgs(), null);
        if (levelAndOrgCountMap.getOrDefault(rootLevel + 1, 0L) > 3000L) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf\u8f83\u591a\uff0c\u4e3a\u4fdd\u8bc1\u60a8\u7684\u4f7f\u7528\u4f53\u9a8c\uff0c\u5df2\u81ea\u52a8\u5c06\u663e\u793a\u5c42\u7ea7\u8c03\u6574\u4e3a\u201c%s\u201d\u3002", (String)"ProjectChartPlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]), 1));
        }
        OrgChartTreeNode rootNode = this.getOrgChartTreeNode(searchChartData, rootNodeDynamicObj, false);
        return rootNode;
    }

    private List<OrgChartTreeNode> getOrgChartChildTreeNode(QFilter qFilter, DynamicObject rootNodeDynamicObj, DynamicObjectCollection treeViewCollection) {
        treeViewCollection.add((Object)rootNodeDynamicObj);
        Map orgTeamIdOrgTypeMap = ProjectChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)this.getDate());
        List<OrgChartTreeNode> chartTreeNodeList = this.getOrgChartTreeNodes(qFilter, treeViewCollection, orgTeamIdOrgTypeMap);
        OrgChartTreeNode treeNode = ProjectChartServiceHelper.getRootTreeNode((DynamicObject)rootNodeDynamicObj, (Map)orgTeamIdOrgTypeMap, (boolean)true);
        if (chartTreeNodeList.size() < 1) {
            treeNode = ProjectChartServiceHelper.getRootTreeNode((DynamicObject)rootNodeDynamicObj, (Map)orgTeamIdOrgTypeMap, (boolean)false);
        }
        chartTreeNodeList.add(treeNode);
        return chartTreeNodeList;
    }

    private List<OrgChartTreeNode> getOrgChartTreeNodes(QFilter qFilter, DynamicObjectCollection treeViewCollection, Map<Long, ChartOrgInfo> orgTeamIdOrgTypeMap) {
        ArrayList orgTeamIds = new ArrayList();
        HashMap orgTeamIdNodeMap = new HashMap();
        List<OrgChartTreeNode> chartTreeNodeList = treeViewCollection.stream().map(dy -> {
            OrgChartTreeNode orgChartTreeNode = ProjectChartServiceHelper.wrapTreeNode((DynamicObject)dy, (Map)orgTeamIdOrgTypeMap);
            long orgTeamId = Long.parseLong(orgChartTreeNode.getId());
            orgTeamIds.add(orgTeamId);
            orgTeamIdNodeMap.put(orgTeamId, orgChartTreeNode);
            return orgChartTreeNode;
        }).collect(Collectors.toList());
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Object> permOrgIds = new ArrayList();
        if (!permOrgResultWithSub.isHasAllOrgPerm()) {
            permOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        }
        if (!CollectionUtils.isEmpty(orgTeamIds)) {
            IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
            QFilter parentOrgTeamIdFilter = new QFilter("parentorgteam.id", "in", orgTeamIds);
            if (!CollectionUtils.isEmpty(permOrgIds)) {
                QFilter orgTeamIdFilter = new QFilter("orgteam.boid", "in", this.getPermProjectOrgs((AbstractFormPlugin)this));
                parentOrgTeamIdFilter.and(orgTeamIdFilter);
            }
            DynamicObjectCollection dynamicObjects = structInstance.queryColl("orgteam.id,parentorgteam.id", new QFilter[]{parentOrgTeamIdFilter, qFilter}, "index asc,orgteam.number asc");
            HashSet parentOrgTeamIds = new HashSet();
            dynamicObjects.forEach(dy -> parentOrgTeamIds.add(dy.getLong("parentorgteam.id")));
            if (!CollectionUtils.isEmpty(orgTeamIds)) {
                orgTeamIds.forEach(orgTeamId -> {
                    OrgChartTreeNode orgChartTreeNode = (OrgChartTreeNode)orgTeamIdNodeMap.get(orgTeamId);
                    if (parentOrgTeamIds.contains(orgTeamId)) {
                        orgChartTreeNode.setLeaf(false);
                        orgChartTreeNode.setChildren(new ArrayList());
                    } else {
                        orgChartTreeNode.setLeaf(true);
                        orgChartTreeNode.setChildren(null);
                    }
                });
            }
        }
        return chartTreeNodeList;
    }

    public String checkChartStyleExistAndFindMatchChartStyle(String chartStyleId) {
        Map chartStyleIdChartStyleMap;
        if (!StringUtils.isEmpty((CharSequence)chartStyleId) && CollectionUtils.isEmpty((Map)(chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles(Collections.singleton(chartStyleId))))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u6784\u56fe\u6837\u5f0f\u201d\u9009\u5b9a\u7684\u503c\u53d1\u751f\u53d8\u52a8\uff0c\u65e0\u6cd5\u6b63\u5e38\u663e\u793a\uff0c\u5df2\u4e3a\u60a8\u81ea\u52a8\u5207\u6362\u5230\u5e38\u7528\u8fc7\u6ee4\u6761\u4ef6\u9ed8\u8ba4\u7684\u503c\u8fdb\u884c\u67e5\u770b\u3002", (String)"ProjectChartPlugin_7", (String)"odc-homs-formplugin", (Object[])new Object[0]));
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
            List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
            Set chartStyleIds = ProjectChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, (Long)ProjectChartConstants.DEFAULT_CARD_DIMENSION_ID);
            chartStyleIds.add("1003");
            chartStyleIdChartStyleMap = OrgChartServiceHelper.getChartStyles((Collection)chartStyleIds);
            ChartStyle matchChartStyle = OrgChartServiceHelper.findBestMatchChartStyle((Map)chartStyleIdChartStyleMap, (String)"1003");
            return matchChartStyle != null ? matchChartStyle.getId() : null;
        }
        return null;
    }

    private void setShowFieldInfos(List<OrgChartTreeNode> chartTreeNodeList, ProjectSearchChartData searchChartData) {
        ChartStyle chartStyle = OrgChartServiceHelper.getChartStyleById((String)searchChartData.getChartStyleId());
        if (chartStyle != null) {
            ProjectChartServiceHelper.setShowFieldInfoToTreeNodes(chartTreeNodeList, (ChartStyle)chartStyle, (ProjectSearchChartData)searchChartData);
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String currentNodeId = treeNodeEvent.getNodeId().toString();
        ProjectSearchChartData searchChartData = this.getSearchChartData();
        searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
        String showErrorInfo = "";
        if (this.treeListView.getTreeModel().getRoot() != null) {
            TreeNode treeNode = this.treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId);
            if (treeNode != null && !"1020".equals(treeNode.getData())) {
                showErrorInfo = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjectChartPlugin_14", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("showErrorInfo", ProjectChartServiceHelper.getShowErrorInfo((String)"1", (String)showErrorInfo));
                this.setSimpleDataForCustomControl("queryTreeNodeData", resultMap);
            } else {
                this.nodeClick(currentNodeId, (TreeView)treeNodeEvent.getSource(), searchChartData, "queryTreeNodeData", null);
            }
        }
    }

    public void showSchemeQueryErrorInfo(String errorDesc) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("schemeQueryCallbackKey", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7a0d\u540e\u518d\u8bf4", (String)"ProjectChartPlugin_8", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7acb\u5373\u5220\u9664", (String)"ProjectChartPlugin_9", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u67e5\u8be2\u65b9\u6848\u7684\u6761\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u8be2\uff0c\u662f\u5426\u5220\u9664\u65b9\u6848\uff1f", (String)"ProjectChartPlugin_10", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, errorDesc, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void nodeClick(String currentNodeId, TreeView tv, ProjectSearchChartData searchChartData, String dataFlag, Map<String, Object> queryShowParams) {
        if ("notInit100000".equals(currentNodeId) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currentNodeId)) {
            return;
        }
        searchChartData.setCurrentOrgChartRootNodeId(currentNodeId);
        this.getPageCache().put("CURRENT_SEARCH_CHART_ID", JSONObject.toJSONString((Object)searchChartData));
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)searchChartData.getDateField());
        defaultFilter.and(OrgChartServiceHelper.getOrgFilter((List)searchChartData.getOrgs()));
        defaultFilter.and(ProjectChartServiceHelper.getOtClassifyFilter());
        DynamicObject rootDyn = this.getRootDynByRootId(defaultFilter, Long.parseLong(currentNodeId));
        OrgChartTreeNode orgChartRootNode = null;
        boolean hasOrgPerm = true;
        String showErrorInfo = "";
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        if (rootDyn != null) {
            List<Long> permOrgIds;
            if (!permOrgResultWithSub.isHasAllOrgPerm() && !(permOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this)).contains(Long.parseLong(currentNodeId))) {
                LOG.info("nodeClick not find1 currentNodeId:{}", (Object)currentNodeId);
                hasOrgPerm = false;
                showErrorInfo = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u70b9\u51fb\u5176\u4ed6\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjectChartPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), rootDyn.getString("name"));
            }
            OrgChartTreeNode leftRootNode = this.getLeftTreeNodes(defaultFilter, rootDyn, searchChartData.getOrgs());
            if (this.getTreeModel().getRoot().getTreeNode(leftRootNode.getId()) != null) {
                TreeNode rootNode = this.getTreeModel().getRoot().getTreeNode(leftRootNode.getId());
                if (!CollectionUtils.isEmpty((Collection)leftRootNode.getChildren())) {
                    rootNode.setChildren(leftRootNode.getChildren());
                } else {
                    rootNode.setChildren(null);
                }
                this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
            }
            this.getTreeModel().setCurrentNodeId((Object)currentNodeId);
            this.focusNode(tv, this.treeListView.getTreeModel().getRoot(), this.treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId));
            if (hasOrgPerm) {
                orgChartRootNode = this.getRightOrgChartRootNode(defaultFilter, searchChartData, leftRootNode.getId());
            }
        } else {
            hasOrgPerm = false;
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
            showErrorInfo = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u6570\u636e\u6743\u9650\uff0c\u8bf7\u70b9\u51fb\u5176\u4ed6\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjectChartPlugin_11", (String)"odc-homs-formplugin", (Object[])new Object[0]), treeNode != null ? treeNode.getText() : "");
            LOG.info("nodeClick not find2 currentNodeId:{},defaultFilter={}", (Object)currentNodeId, (Object)defaultFilter.toString());
        }
        if (orgChartRootNode != null) {
            this.getPageCache().put("CURRENT_NODE_ID", currentNodeId);
        }
        if (queryShowParams == null) {
            queryShowParams = this.getQueryShowParams(null, searchChartData, null);
        }
        queryShowParams.put("currentNodeIsNull", HRObjectUtils.isEmpty(orgChartRootNode));
        String maxLevel = this.getPageCache().get("MAX_LEVEL_KEY");
        queryShowParams.put("maxLevel", StringUtils.isEmpty((CharSequence)maxLevel) ? "3" : maxLevel);
        CommonOrgChartServiceHelper.setTermRemaning(queryShowParams, (String)this.getPageCache().get("termRemain"));
        this.getPageCache().remove("termRemain");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)dataFlag, queryShowParams, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(queryShowParams);
        resultMap.put("data", orgChartRootNode);
        resultMap.put("operateType", OrgChartOperateTypes.NODE_CLICK.getValue());
        resultMap.put("hasOrgPerm", hasOrgPerm ? 1 : 0);
        resultMap.put("showErrorInfo", ProjectChartServiceHelper.getShowErrorInfo((String)"1", (String)showErrorInfo));
        this.setSimpleDataForCustomControl(dataFlag, resultMap);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)"schemeQueryCallbackKey", (String)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String schemeId = this.getPageCache().get("schemeId");
                FilterContainer filterContainer = OrgChartServiceHelper.getFilterContainer((IFormView)this.getView(), (String)"homs_projectchart");
                filterContainer.deleteScheme(schemeId);
                this.sendNewSchemesToCustom();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
                CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
                HashMap result = new HashMap();
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"donothing", result, (CustomControl)customcontrol);
            }
        }
    }

    private void sendNewSchemesToCustom() {
        HashMap<String, List> result = new HashMap<String, List>();
        List schemes = OrgChartServiceHelper.getScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId(), (boolean)true);
        result.put("schemes", schemes);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"updateSchemesList", result, (CustomControl)customcontrol);
    }

    private ProjectSearchChartData getSearchChartData() {
        String error;
        String searchChartDataStr = this.getPageCache().get("CURRENT_SEARCH_CHART_ID");
        if (StringUtils.isNotEmpty((CharSequence)searchChartDataStr)) {
            return (ProjectSearchChartData)JSONObject.parseObject((String)searchChartDataStr, ProjectSearchChartData.class);
        }
        FilterScheme defaultScheme = OrgChartServiceHelper.getDefaultScheme((String)"homs_projectchart", (String)RequestContext.get().getUserId());
        ProjectChartQueryParam orgChartQueryParam = ProjectChartServiceHelper.analyzeScheme((FilterScheme)defaultScheme);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        ProjectSearchChartData schemeSearchChartData = ProjectChartServiceHelper.getSchemeSearchChartData((ProjectChartQueryParam)orgChartQueryParam, (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds);
        if (defaultScheme != null && StringUtils.isNotEmpty((CharSequence)(error = ProjectChartServiceHelper.checkScheme((ProjectSearchChartData)schemeSearchChartData, (String)orgChartQueryParam.getCurrentOrgChartRootNodeId(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, this.orgIds)))) {
            schemeSearchChartData = ProjectChartServiceHelper.getDefaultSearchChartData((Date)new Date(), (AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds);
        }
        if (StringUtils.isEmpty((CharSequence)schemeSearchChartData.getChartStyleId())) {
            schemeSearchChartData.setChartStyleId(this.getPageCache().get("MATCH_CHART_STYLE_ID"));
        }
        return schemeSearchChartData;
    }

    public DynamicObjectCollection getTreeViewCollection(QFilter qFilter, long parentId, List<String> orgIds) {
        QFilter orgFilter = new QFilter("parentorgteam.id", "=", (Object)parentId);
        if (!this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView()).isHasAllOrgPerm()) {
            QFilter orgTeamIdFilter = new QFilter("orgteam.boid", "in", this.getPermProjectOrgs((AbstractFormPlugin)this));
            orgFilter.and(orgTeamIdFilter);
        }
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        return structInstance.queryColl(selectFields, new QFilter[]{orgFilter, qFilter, OrgChartServiceHelper.getOrgFilter(orgIds), ProjectChartServiceHelper.getOtClassifyFilter()}, "index asc,orgteam.number asc");
    }

    public DynamicObjectCollection getTreeViewCollection(QFilter qFilter, int rootOrgLevel, String rootOrgStructLongNumber, boolean isLeftTree, List<String> orgIds) {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        Set levels = OrgChartServiceHelper.calculateQueryLevelsByRootOrg((int)rootOrgLevel, (String)rootOrgStructLongNumber, (Date)this.getDate(), permOrgResultWithSub.isHasAllOrgPerm() ? new ArrayList() : this.getPermProjectOrgs((AbstractFormPlugin)this), new ArrayList(), Collections.singletonList(ProjectChartConstants.DEFAULT_OTCCLASSIFY_ID), (boolean)isLeftTree, orgIds, null);
        if (isLeftTree) {
            this.getPageCache().put("MAX_LEVEL_KEY", String.valueOf(levels.size() + 1));
        }
        QFilter levelFilter = new QFilter("level", "in", (Object)levels);
        HashSet<QFilter> qFilters = new HashSet<QFilter>();
        qFilters.add(qFilter);
        qFilters.add(levelFilter);
        qFilters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
        qFilters.add(ProjectChartServiceHelper.getOtClassifyFilter());
        DynamicObjectCollection belongAdminOrgStructCollection = this.getBuildTreeDynamicObjects(qFilters);
        return this.queryTreeDynamicObjects(qFilter, rootOrgStructLongNumber, belongAdminOrgStructCollection);
    }

    private DynamicObjectCollection getBuildTreeDynamicObjects(Collection<QFilter> qFilters) {
        String selectStructFields = "id,orgteam.id,orgteam.number,orgteam.boid ,orgteam.org, structlongnumber, parentorgteam,orgteam.name name,orgteam.otclassify, isleaf,level";
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        if (!this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView()).isHasAllOrgPerm()) {
            QFilter orgTeamIdFilter = new QFilter("orgteam.boid", "in", this.getPermProjectOrgs((AbstractFormPlugin)this));
            qFilters.add(orgTeamIdFilter);
        }
        return structInstance.queryColl(selectStructFields, qFilters.toArray(new QFilter[0]), null);
    }

    private DynamicObjectCollection queryTreeDynamicObjects(QFilter qFilter, String rootOrgStructLongNumber, DynamicObjectCollection belongAdminOrgStructCollection) {
        Set<String> childStructLongNumbers = this.buildChildStructLongNumbers(belongAdminOrgStructCollection, rootOrgStructLongNumber);
        childStructLongNumbers.remove(rootOrgStructLongNumber);
        Set childStructNumbers = OrgChartServiceHelper.getChildStructNumbers(childStructLongNumbers);
        String selectFields = "orgteam.id,orgteam.boid,orgteam.org,orgteam.name name,orgteam.number number,parentorgteam,isleaf,enable,orgteam.otclassify,level";
        QFilter orgFilter = new QFilter("orgteam.structnumber", "in", (Object)childStructNumbers);
        QFilter otClassifyFilter = new QFilter("orgteam.otclassify", "in", (Object)new Long[]{1010L, 1020L});
        LOG.info("queryTreeDynamicObjects orgFilter.and(qFilter)={}", (Object)JSONObject.toJSONString((Object)orgFilter.and(qFilter).toString()));
        IHRBaseDao structInstance = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure");
        return structInstance.queryColl(selectFields, new QFilter[]{orgFilter, qFilter, otClassifyFilter, (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get()}, "index asc,orgteam.number asc");
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        String id = (String)event.getNodeId();
        String queryOrgIds = this.getPageCache().get("queryOrgId");
        QFilter defaultFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)this.getDate());
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(id) || "notInit100000".equals(id)) {
            return;
        }
        DynamicObjectCollection treeViewCollection = this.getTreeViewCollection(defaultFilter, Long.parseLong(id), JSONObject.parseArray((String)queryOrgIds, String.class));
        Map orgTeamIdOrgTypeMap = ProjectChartServiceHelper.getOrgTeamOrgType((DynamicObjectCollection)treeViewCollection, (Date)this.getDate());
        List<OrgChartTreeNode> chartTreeNodeList = this.getOrgChartTreeNodes(defaultFilter, treeViewCollection, orgTeamIdOrgTypeMap);
        List treeNodes = OrgChartServiceHelper.sortTreeNodes(chartTreeNodeList);
        TreeNode treeNode = this.getTreeListView().getTreeModel().getRoot().getTreeNode(id);
        treeNode.setChildren(treeNodes);
        this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
    }

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        TreeView treeView = this.getTreeListView().getTreeView();
        String searchText = evt.getText();
        TreeNode rootNode = this.getTreeModel().getRoot();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, this::loadChildNodes, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            String selectFields = "id,orgteam.id,orgteam.number number, orgteam.boid ,orgteam.org,orgteam.name name,orgteam.otclassify,structlongnumber,parentorgteam,isleaf,level";
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgstructure");
            QFilter orgTeamLikeFilter = new QFilter("orgteam.name", "like", (Object)("%" + searchText + "%"));
            if (!this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView()).isHasAllOrgPerm()) {
                QFilter orgTeamIdFilter = new QFilter("orgteam.boid", "in", this.getPermProjectOrgs((AbstractFormPlugin)this));
                orgTeamLikeFilter.and(orgTeamIdFilter);
            }
            String queryOrgIds = this.getPageCache().get("queryOrgId");
            QFilter[] filters = new QFilter[]{orgTeamLikeFilter, OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)this.getDate()), OrgChartServiceHelper.getOrgFilter((List)JSONObject.parseArray((String)queryOrgIds, String.class)), ProjectChartServiceHelper.getOtClassifyFilter()};
            Object[] dynamicObjects = serviceHelper.queryOriginalArray(selectFields, filters);
            if (!ArrayUtils.isEmpty((Object[])dynamicObjects)) {
                this.searchBuildTree(selectFields, serviceHelper, (DynamicObject)dynamicObjects[0], JSONObject.parseArray((String)queryOrgIds, String.class), this.getDate());
                ProjectSearchChartData searchChartData = this.getSearchChartData();
                searchChartData.setCurrentOrgChartRootNodeId(dynamicObjects[0].getString("orgteam.id"));
                this.nodeClick(dynamicObjects[0].getString("orgteam.boid"), this.getTreeListView().getTreeView(), searchChartData, "queryTreeNodeData", null);
            } else {
                treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, this::loadChildNodes, 100);
                pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"ProjectChartPlugin_12", (String)"bos-form-core", (Object[])new Object[0]));
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void searchBuildTree(String selectFields, HRBaseServiceHelper serviceHelper, DynamicObject dynamicObject, List<String> orgIds, Date queryDate) {
        String structLongNumber = dynamicObject.getString("structlongnumber");
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(dynamicObject.getString("orgteam.boid"));
        if (treeNode == null) {
            QFilter qFilter = OrgChartServiceHelper.getBaseCommonFilterWithDate((Date)queryDate);
            String topParentStructLongNumber = OrgChartServiceHelper.findTopParentStructLongNumber((String)structLongNumber, (ITreeModel)this.getTreeModel(), (QFilter)qFilter);
            if (!StringUtils.isEmpty((CharSequence)topParentStructLongNumber)) {
                int treeMaxLevel = topParentStructLongNumber.split("!").length;
                QFilter topParentStructLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(topParentStructLongNumber + "%"));
                HashSet<QFilter> qFilters = new HashSet<QFilter>();
                qFilters.add(qFilter);
                qFilters.add(OrgChartServiceHelper.getOrgFilter(orgIds));
                qFilters.add(ProjectChartServiceHelper.getOtClassifyFilter());
                qFilters.add(new QFilter("level", ">", (Object)treeMaxLevel));
                qFilters.add(new QFilter("level", "<", (Object)dynamicObject.getInt("level")));
                qFilters.add(topParentStructLongNumberFilter);
                DynamicObjectCollection belongAdminOrgStructCollection = this.getBuildTreeDynamicObjects(qFilters);
                QFilter parentOrgTeamFilter = new QFilter("parentorgteam.id", "=", (Object)dynamicObject.getLong("parentorgteam"));
                QFilter[] peerOrgsFilters = new QFilter[]{parentOrgTeamFilter, qFilter, OrgChartServiceHelper.getOrgFilter(orgIds)};
                if (!this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView()).isHasAllOrgPerm()) {
                    QFilter orgTeamIdFilter = new QFilter("orgteam.boid", "in", this.getPermProjectOrgs((AbstractFormPlugin)this));
                    parentOrgTeamFilter.and(orgTeamIdFilter);
                }
                DynamicObjectCollection peerOrgs = serviceHelper.queryOriginalCollection(selectFields, peerOrgsFilters);
                belongAdminOrgStructCollection.addAll((Collection)peerOrgs);
                DynamicObjectCollection dynamicObjectCollection = this.queryTreeDynamicObjects(qFilter, topParentStructLongNumber, belongAdminOrgStructCollection);
                DynamicObject topParentOrg = serviceHelper.queryOriginalOne(selectFields, new QFilter[]{new QFilter("structlongnumber", "=", (Object)topParentStructLongNumber), qFilter});
                List<OrgChartTreeNode> orgChartTreeNodes = this.getOrgChartChildTreeNode(qFilter, topParentOrg, dynamicObjectCollection);
                OrgChartTreeNode root = orgChartTreeNodes.get(orgChartTreeNodes.size() - 1);
                if (this.getTreeModel().getRoot().getTreeNode(root.getId()) != null) {
                    TreeNode rootNode = this.getTreeModel().getRoot().getTreeNode(root.getId());
                    OrgChartServiceHelper.addChildNodes((TreeNode)rootNode, orgChartTreeNodes);
                    this.getTreeListView().getTreeModel().setRoot(this.getTreeListView().getTreeModel().getRoot());
                }
            }
        }
    }

    protected void loadChildNodes(TreeNode node) {
        node.setType(node.getType() + "");
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        if (treeNode != null) {
            this.expandParents(treeView, rootNode, treeNode);
            treeView.showNode(treeNode.getParentid());
            treeView.focusNode(treeNode);
        }
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode p = rootNode.getTreeNode(parentid);
            if (p != null) {
                this.expandParents(treeView, rootNode, p);
                treeView.expand(parentid);
                if (p == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }
}

