/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.projectchart;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.common.model.ProjectChartQueryParam;

public class ProjectChartSchemePlugin
extends AbstractTreeListPlugin {
    private static final Log LOG = LogFactory.getLog(ProjectChartSchemePlugin.class);

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "saveOrUpdateScheme": {
                this.saveOrUpdateScheme(eventArgs);
                break;
            }
            case "setDefaultScheme": {
                CommonOrgChartServiceHelper.setDefaultScheme((String)eventArgs, (IFormView)this.getView(), (String)"homs_projectchart");
                break;
            }
            case "deleteScheme": {
                CommonOrgChartServiceHelper.deleteScheme((String)eventArgs, (IFormView)this.getView(), (String)"homs_projectchart");
                break;
            }
        }
    }

    private void saveOrUpdateScheme(String eventArgs) {
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
        HashMap<String, Object> filterSchemeMap = new HashMap<String, Object>();
        filterSchemeMap.put("schemeName", jsonObject.getString("schemeName").trim());
        filterSchemeMap.put("entryEntity", "homs_projectchart");
        ArrayList schemeRows = new ArrayList();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        schemeRows.add(map);
        ProjectChartQueryParam orgChartQueryParam = (ProjectChartQueryParam)jsonObject.getObject("scheme", ProjectChartQueryParam.class);
        boolean isSameDay = CommonOrgChartServiceHelper.isSameDay((String)orgChartQueryParam.getQueryDate(), (Date)new Date());
        if (isSameDay) {
            orgChartQueryParam.setQueryDate("today");
        }
        map.put("FieldName", Collections.singletonList(JSONObject.toJSONString((Object)orgChartQueryParam.removeOrgs())));
        map.put("Compare", Lists.newArrayList((Object[])new Object[]{""}));
        map.put("Value", new ArrayList());
        filterSchemeMap.put("scheme", schemeRows);
        if (!StringUtils.isEmpty((CharSequence)jsonObject.getString("schemeId"))) {
            filterSchemeMap.put("id", jsonObject.getString("schemeId"));
        }
        boolean checkResult = this.checkSchemeContent(orgChartQueryParam, jsonObject);
        CommonOrgChartServiceHelper.checkSchemeAndSendMessage((JSONObject)jsonObject, filterSchemeMap, (boolean)checkResult, (IFormView)this.getView(), (String)"homs_projectchart");
    }

    private boolean checkSchemeContent(ProjectChartQueryParam orgChartQueryParam, JSONObject jsonObject) {
        String schemeName = jsonObject.getString("schemeName");
        StringBuilder builder = new StringBuilder();
        boolean errorMessage = false;
        String schemeNameFiled = ResManager.loadKDString((String)"\u201c\u65b9\u6848\u540d\u79f0\u201d", (String)"ProjectChartSchemePlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeDateFiled = ResManager.loadKDString((String)"\u201c\u67e5\u8be2\u65e5\u671f\u201d", (String)"ProjectChartSchemePlugin_3", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        String schemeRootNode = ResManager.loadKDString((String)"\u201c\u67e5\u8be2\u7ec4\u7ec7\u201d", (String)"ProjectChartSchemePlugin_5", (String)"odc-homs-formplugin", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)schemeName)) {
            builder.append(schemeNameFiled);
            errorMessage = true;
        }
        if (HRObjectUtils.isEmpty((Object)orgChartQueryParam.getQueryDate())) {
            builder.append(schemeDateFiled);
            errorMessage = true;
        }
        if (HRStringUtils.isEmpty((String)orgChartQueryParam.getCurrentOrgChartRootNodeId())) {
            builder.append(schemeRootNode);
            errorMessage = true;
        }
        if (errorMessage) {
            String tipMessage = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProjectChartSchemePlugin_6", (String)"odc-homs-formplugin", (Object[])new Object[0]);
            builder.append(tipMessage);
            this.getView().showErrorNotification(builder.toString());
        }
        return errorMessage;
    }
}

