/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.projectchart;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.homs.business.service.orgchart.CommonOrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.OrgChartServiceHelper;
import kd.hr.homs.business.service.orgchart.ProjectChartServiceHelper;
import kd.hr.homs.common.constants.orgchart.ProjectChartConstants;
import kd.hr.homs.formplugin.web.projectchart.ProjectChartBase;

public class ProjectChartViewDetailsPlugin
extends ProjectChartBase {
    private static final Log LOG = LogFactory.getLog(ProjectChartViewDetailsPlugin.class);

    public void customEvent(CustomEventArgs args) {
        String operateName;
        String eventArgs = args.getEventArgs();
        switch (operateName = args.getEventName()) {
            case "viewdetails": {
                this.openOrgDetail(eventArgs);
                break;
            }
            case "openOrgChartStyleF7": {
                this.openOrgChartStyleF7();
                break;
            }
            case "dataRouteKey": {
                this.dataRoute(eventArgs);
                break;
            }
            case "projectChartPermQuery": {
                this.permQuery();
                break;
            }
            case "closeProjectChart": {
                this.getView().close();
                break;
            }
            case "openOrgF7": {
                JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)eventArgs, JSONObject.class);
                JSONArray orgList = jsonObject.getJSONArray("orgs");
                this.openOrgF7(orgList);
                break;
            }
            case "addChartExportOperateLog": {
                CommonOrgChartServiceHelper.addChartExportOperateLog((String)"homs_projectchart", (String)operateName);
                break;
            }
        }
    }

    private void openOrgF7(JSONArray orgList) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = new QFilter("id", "in", (Object)OrgChartServiceHelper.getDefaultOrg((String)"homs_projectchart"));
        enableFilter.and(qFilter);
        ListShowParameter showParameter = OrgChartServiceHelper.getListShowParameter((String)"bos_org", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        showParameter.setListSelectedRowCollection(OrgChartServiceHelper.getListSelectedRowCollection((JSONArray)orgList));
        showParameter.setMultiSelect(true);
        showParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7", (String)"ProjectChartViewDetailsPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgF7"));
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void permQuery() {
        HashMap result = new HashMap(16);
        ProjectChartServiceHelper.projectChartPermQuery(result);
        OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"projectChartPermQuery", result, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
        OrgChartServiceHelper.setSimpleDataForCustomControl((String)"projectChartPermQuery", result, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
    }

    private void dataRoute(String eventArgs) {
        JSONObject parseObject = JSONObject.parseObject((String)eventArgs);
        Integer routeTarget = parseObject.getInteger("routeTarget");
        String data = parseObject.getString("data");
        HashMap<String, String> dataInfo = new HashMap<String, String>();
        dataInfo.put("data", data);
        switch (routeTarget) {
            case 1: {
                OrgChartServiceHelper.setSimpleDataForCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
                break;
            }
            case 2: {
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
                break;
            }
            default: {
                OrgChartServiceHelper.setSimpleDataForCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap")));
                OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"dataRouteKey", dataInfo, (CustomControl)((CustomControl)this.getView().getControl("customcontrolap1")));
            }
        }
    }

    private void openOrgChartStyleF7() {
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub((AbstractFormPlugin)this, this.getView());
        List<Long> permProjectOrgIds = this.getPermProjectOrgs((AbstractFormPlugin)this);
        Set chartStyleIds = ProjectChartServiceHelper.getChartStyleIds((AuthorizedOrgResultWithSub)permOrgResultWithSub, permProjectOrgIds, (Long)ProjectChartConstants.DEFAULT_CARD_DIMENSION_ID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        chartStyleIds.add("1003");
        List<Object> chartStyleIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)chartStyleIds)) {
            chartStyleIdList = chartStyleIds.stream().map(Long::parseLong).collect(Collectors.toList());
        }
        QFilter idFilter = new QFilter("id", "in", chartStyleIdList);
        enableFilter.and(idFilter);
        ListShowParameter chartStyleShowParameter = OrgChartServiceHelper.getListShowParameter((String)"homs_chartstyle", (String)"bos_listf7", (QFilter)enableFilter, (String)"number asc");
        chartStyleShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOrgChartStyleF7"));
        chartStyleShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)chartStyleShowParameter);
    }

    private void openOrgDetail(String eventArgs) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)"homs_projectchart");
        boolean hasAdminOrgDetailsPerm = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"11", (String)appId, (String)"homs_projectchart", (String)"2O23MLUIT2BS");
        if (!hasAdminOrgDetailsPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u9879\u76ee\u56e2\u961f\u8be6\u60c5\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u5982\u6709\u9700\u8981\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectChartViewDetailsPlugin_2", (String)"odc-homs-formplugin", (Object[])new Object[0]));
        } else {
            this.openOrgDetailsView(eventArgs);
        }
    }

    private void openOrgDetailsView(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        Long boId = jsonObject.getLong("boid");
        Date date = jsonObject.getDate("date");
        LOG.info("ProjectChartViewDetailsPlugin.openOrgDetailsView boid:{},date:{}", (Object)boId, (Object)date);
        if (boId != 0L && !HRObjectUtils.isEmpty((Object)date)) {
            DynamicObject orgInfo = this.getAdminOrgInfo(boId, date);
            LOG.info("ProjectChartViewDetailsPlugin info:{}", (Object)orgInfo);
            if (!HRObjectUtils.isEmpty((Object)orgInfo)) {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("haos_projteambaseinfo");
                showParameter.setCustomParam("hideSafeInfo", (Object)"1");
                showParameter.setCustomParam("currentObjectPKId", (Object)boId.toString());
                showParameter.setCustomParam("boid", (Object)boId.toString());
                showParameter.setCustomParam("searchdate", (Object)date);
                showParameter.setPkId((Object)orgInfo.getLong("id"));
                String prefix = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f", (String)"ProjectChartViewDetailsPlugin_0", (String)"odc-homs-formplugin", (Object[])new Object[0]);
                showParameter.setCaption(prefix + "-" + orgInfo.getString("name"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private DynamicObject getAdminOrgInfo(Long boid, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
        QFilter boidFilter = new QFilter("boid", "=", (Object)boid);
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)date);
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)date);
        return helper.queryOne("id,name", new QFilter[]{boidFilter, bsedFilter, bsledFilter});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("openOrgChartStyleF7".equals(actionId)) {
            this.afterSelectChartStyle(closedCallBackEvent);
        } else if ("openOrgF7".equals(actionId)) {
            this.afterOrgF7Select(closedCallBackEvent);
        }
    }

    private void afterOrgF7Select(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            ArrayList orgTeamInfos = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)selectedRows.size());
            selectedRows.forEach(org -> {
                JSONObject orgTeamInfo = new JSONObject();
                orgTeamInfo.put("id", (Object)String.valueOf(org.getPrimaryKeyValue()));
                orgTeamInfo.put("name", (Object)org.getName());
                orgTeamInfo.put("number", (Object)org.getName());
                orgIds.add(org.getPrimaryKeyValue().toString());
                orgTeamInfos.add(orgTeamInfo);
            });
            HashMap<String, ArrayList> result = new HashMap<String, ArrayList>();
            result.put("orgs", orgTeamInfos);
            this.getPageCache().put("newOrgId", JSONObject.toJSONString((Object)orgIds));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openOrgF7", result, (CustomControl)customcontrol);
        }
    }

    private void afterSelectChartStyle(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            HashMap data = new HashMap();
            String chartStyleId = selectedRows.get(0).getPrimaryKeyValue().toString();
            ArrayList<String> chartStyleIds = new ArrayList<String>();
            chartStyleIds.add(chartStyleId);
            Map chartStyles = OrgChartServiceHelper.getChartStyles(chartStyleIds);
            data.put("data", chartStyles.get(chartStyleId));
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap1");
            OrgChartServiceHelper.setSimpleDataForSearchCustomControl((String)"openOrgChartStyleF7", data, (CustomControl)customcontrol);
        }
    }
}

