/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.typeselect;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.homs.common.constants.fastchg.OrgFastChgBillConstants;

public class AdminOrgTypeSelectPlugin
extends HRDynamicFormBasePlugin {
    private static final String PANEL_KEY = "flexpanelap";
    private static final String RADIOGOUP_KEY = "radiogroupfield";
    private static final String LABEL_CLOSE = "labelclose";
    private static final String BTN_OK = "btnok";
    private static final String PANEL_USERGUIDE = "flexpanelap2";
    private static final String CHK_TIPNOMORE = "checkboxfield";
    private static final Log logger = LogFactory.getLog(AdminOrgTypeSelectPlugin.class);
    public static final String SELECT_ORG_TYPE = "haos_selectorgtype_userguide";
    public static final String CURRENT_PROJECT = "hrmp-haos-formplugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        this.addClickListeners(new String[]{LABEL_CLOSE});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter parameter = (FormShowParameter)args.getSource();
        DynamicObject[] results = this.getOrgTypeDys(parameter);
        FlexPanelAp panel = this.createPanel(results);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", PANEL_KEY);
        List items = (List)panel.createControl().get("items");
        for (Map item : items) {
            Map subItem = (Map)item.get("item");
            String type = (String)subItem.get("type");
            if (!HRStringUtils.equals((String)type, (String)"radio")) continue;
            subItem.put("group", RADIOGOUP_KEY);
        }
        mapHead.put("items", items);
        args.getItems().add(mapHead);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ArrayList users = (ArrayList)HRAppCache.get((String)"homs").get(SELECT_ORG_TYPE, List.class);
        if (users != null && users.contains(RequestContext.get().getUserId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_USERGUIDE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap21"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
    }

    private DynamicObject[] getOrgTypeDys(FormShowParameter parameter) {
        Boolean orgFilter;
        Long parentOrgType;
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        String parentOrgTypeStr = (String)parameter.getCustomParam("parentOrgType");
        String enable = (String)parameter.getCustomParam("enable");
        Boolean auth = (Boolean)parameter.getCustomParam("auth");
        if (!HRStringUtils.isEmpty((String)parentOrgTypeStr) && "1".equals(enable) && auth.booleanValue() && !(parentOrgType = Long.valueOf(parentOrgTypeStr)).equals(1010L)) {
            if (parentOrgType.equals(1020L)) {
                filter.and(new QFilter("adminorgtypestd", "in", (Object)new long[]{1020L, 1030L, 1040L}));
            } else if (!parentOrgType.equals(1030L) && parentOrgType.equals(1040L)) {
                filter.and(new QFilter("adminorgtypestd", "in", (Object)new long[]{1030L, 1040L}));
            }
        }
        if ((orgFilter = (Boolean)parameter.getCustomParam("orgFilter")) != null && orgFilter.booleanValue()) {
            String orgid = (String)parameter.getCustomParam("master_org");
            if (!StringUtils.isEmpty((CharSequence)orgid)) {
                filter.and(BaseDataHelper.getBaseDataFilter((String)"haos_adminorgtype", (long)Long.parseLong(orgid)));
            } else {
                HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg();
                if (!hrPermOrg.hasAllOrgPerm()) {
                    filter.and(BaseDataHelper.getAdminOrgBaseDataFilter((String)"haos_adminorgtype", (List)hrPermOrg.getHasPermOrgs()));
                }
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgtype");
        DynamicObject[] results = serviceHelper.query(filter.toArray(), "adminorgtypestd, id asc");
        return results;
    }

    private FlexPanelAp createPanel(DynamicObject[] orgTypeDys) {
        FlexPanelAp panel = new FlexPanelAp();
        panel.setId(PANEL_KEY);
        panel.setKey(PANEL_KEY);
        for (DynamicObject dy : orgTypeDys) {
            FieldAp radioField = this.getRadioField(dy.getString("id"), dy.getString("name"));
            radioField = this.modifyStyle(radioField, orgTypeDys.length);
            panel.getItems().add(radioField);
        }
        return panel;
    }

    private FieldAp modifyStyle(FieldAp radioField, int length) {
        Style style = new Style();
        Margin margin = new Margin();
        radioField.setWidth(new LocaleString("120px"));
        if (length < 6) {
            margin.setLeft("145px");
            margin.setTop(100 / length - 15 + "px");
            margin.setBottom(100 / length - 15 + "px");
        } else {
            margin.setLeft("55px");
            margin.setRight("0px");
            int size = 100 / ((length + 1) / 2) - 15;
            if (size > 0) {
                margin.setTop(100 / ((length + 1) / 2) - 15 + "px");
                margin.setBottom(100 / ((length + 1) / 2) - 15 + "px");
            } else {
                margin.setTop("1px");
                margin.setBottom("1px");
            }
        }
        style.setMargin(margin);
        radioField.setStyle(style);
        return radioField;
    }

    private FieldAp getRadioField(String id, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(id);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setAutoWrap(false);
        RadioField rf = new RadioField();
        rf.setId(id);
        rf.setKey(id);
        rf.setName(new LocaleString(name));
        rf.setItems(id);
        fieldAp.setField((Field)rf);
        return fieldAp;
    }

    public void getEntityType(GetEntityTypeEventArgs args) {
        DynamicObject[] orgTypes;
        MainEntityType oldMainType = args.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            logger.error(exp.getMessage());
        }
        for (DynamicObject dy : orgTypes = this.getOrgTypeDys(this.getView().getFormShowParameter())) {
            String txtHidden = dy.getString("name");
            TextProp textProp = new TextProp();
            textProp.setName(txtHidden);
            if (newMainType == null) continue;
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        args.setNewEntityType(newMainType);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String clickingButton = source.getKey();
        if (clickingButton.equals(LABEL_CLOSE)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_USERGUIDE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap21"});
        } else {
            Long createOrgTypeId;
            if (((Boolean)this.getModel().getValue(CHK_TIPNOMORE)).booleanValue()) {
                this.setTipNomore();
            }
            if ((createOrgTypeId = this.getAdminOrgTypeId()) == null || createOrgTypeId.equals(0L)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3002", (String)"AdminOrgSelectOrgtypePlugIn_1", (String)CURRENT_PROJECT, (Object[])new Object[0]));
                return;
            }
            if (this.isOrgAllowed()) {
                this.showPage(true, createOrgTypeId);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7c7b\u578b\u9ad8\u4e8e\u5de6\u4fa7\u884c\u653f\u7ec4\u7ec7\u6811\u6240\u5b9a\u4f4d\u7ec4\u7ec7\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AdminOrgSelectOrgtypePlugIn_0", (String)CURRENT_PROJECT, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    private void setTipNomore() {
        ArrayList<String> users = (ArrayList<String>)HRAppCache.get((String)"homs").get(SELECT_ORG_TYPE, List.class);
        if (users == null) {
            users = new ArrayList<String>();
        }
        users.add(RequestContext.get().getUserId());
        HRAppCache.get((String)"homs").put(SELECT_ORG_TYPE, users);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getCallBackId().equals("callBackId") && event.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            Long createOrgTypeId = this.getAdminOrgTypeId();
            this.showPage(false, createOrgTypeId);
        }
    }

    private boolean isOrgAllowed() {
        Long createOrgTypeId = this.getAdminOrgTypeId();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter filter = new QFilter("id", "=", (Object)createOrgTypeId);
        DynamicObject dy = helper.queryOne("adminorgtypestd.id", new QFilter[]{filter});
        Long stdId = dy.getLong("adminorgtypestd.id");
        Long orgtypestdId = this.getParentOrgTypeId();
        return this.isContains(orgtypestdId, stdId);
    }

    private Long getParentOrgTypeId() {
        String adminOrgTypeId = (String)this.getView().getFormShowParameter().getCustomParam("parent");
        QFilter filter = new QFilter("id", "=", (Object)adminOrgTypeId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject dy = helper.queryOne("adminorgtype.adminorgtypestd.id", filters);
        if (dy == null) {
            return null;
        }
        long orgtypestdId = dy.getLong("adminorgtype.adminorgtypestd.id");
        return orgtypestdId;
    }

    private boolean isContains(Long parentTypeId, Long targetId) {
        if (parentTypeId == null || parentTypeId == 0L || targetId == null || targetId == 0L) {
            return true;
        }
        if (parentTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_GROUP) || parentTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_REGION)) {
            return true;
        }
        if (parentTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_COMPANY)) {
            return !OrgFastChgBillConstants.ID_ORGTYPE_GROUP.equals(targetId);
        }
        if (parentTypeId.equals(OrgFastChgBillConstants.ID_ORGTYPE_DEPARTMENT)) {
            return !OrgFastChgBillConstants.ID_ORGTYPE_GROUP.equals(targetId) && !OrgFastChgBillConstants.ID_ORGTYPE_COMPANY.equals(targetId);
        }
        return false;
    }

    private void showPage(boolean allow, Long adminorglayerStdId) {
        Long typeId = this.getAdminOrgTypeId();
        Long typeStdId = this.getOrgTypeStd(typeId);
        String pageInfoString = this.getOpenPageString(typeStdId);
        if (pageInfoString == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b\u3002", (String)"AdminOrgSelectOrgtypePlugIn_2", (String)CURRENT_PROJECT, (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)adminorglayerStdId);
        IDataModel model = this.getModel();
        model.setDataChanged(false);
        this.getView().close();
    }

    public Long getOrgTypeStd(Long typeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgtype");
        QFilter filter = new QFilter("id", "=", (Object)typeId);
        DynamicObject dy = helper.queryOne("adminorgtypestd.id", new QFilter[]{filter});
        return dy.getLong("adminorgtypestd.id");
    }

    private Long getAdminOrgTypeId() {
        return this.getModel().getDataEntity().getLong(RADIOGOUP_KEY);
    }

    private String getOpenPageString(Long orgStd) {
        Long key = this.getAdminOrgTypeId();
        if (key == null) {
            return null;
        }
        if (OrgFastChgBillConstants.ID_ORGTYPE_GROUP.equals(orgStd)) {
            return "OrgFastChgBillConstants.PAGE_ORG_GROUP";
        }
        if (OrgFastChgBillConstants.ID_ORGTYPE_REGION.equals(orgStd)) {
            return "OrgFastChgBillConstants.PAGE_ORG_REGION";
        }
        if (OrgFastChgBillConstants.ID_ORGTYPE_COMPANY.equals(orgStd)) {
            return "OrgFastChgBillConstants.PAGE_ORG_COMPANY";
        }
        if (OrgFastChgBillConstants.ID_ORGTYPE_DEPARTMENT.equals(orgStd)) {
            return "OrgFastChgBillConstants.PAGE_ORG_DEPARTMENT";
        }
        return null;
    }
}

