/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.homs.formplugin.web.typeselect;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class StructProjectTypeSelectPlugin
extends HRDynamicFormBasePlugin {
    private static final String PANEL_KEY = "flexpanelap";
    private static final String RADIOGOUP_KEY = "radiogroupfield";
    private static final String LABEL_CLOSE = "labelclose";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        this.addClickListeners(new String[]{LABEL_CLOSE});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)BTN_OK)) {
            Object selectValue = this.getModel().getValue(RADIOGOUP_KEY);
            if (Objects.isNull(selectValue)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67b6\u6784\u3002", (String)"StructProjectTypeSelectPlugin_1", (String)"odc-homs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(selectValue);
            this.getView().close();
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        DynamicObject[] structProjectTypes = StructProjectRepository.getInstance().getUserStructProject(false);
        FlexPanelAp panel = this.createPanel(structProjectTypes);
        List items = (List)panel.createControl().get("items");
        for (Map item : items) {
            Map subItem = (Map)item.get("item");
            String type = (String)subItem.get("type");
            if (!HRStringUtils.equals((String)type, (String)"radio")) continue;
            subItem.put("group", RADIOGOUP_KEY);
        }
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", PANEL_KEY);
        mapHead.put("items", items);
        args.getItems().add(mapHead);
    }

    private FlexPanelAp createPanel(DynamicObject[] structProjects) {
        FlexPanelAp panel = new FlexPanelAp();
        panel.setId(PANEL_KEY);
        panel.setKey(PANEL_KEY);
        for (DynamicObject dy : structProjects) {
            FieldAp radioField = this.createRadioField(dy.getString("id"), dy.getString("name"));
            Style style = new Style();
            Margin margin = new Margin();
            radioField.setWidth(new LocaleString("230px"));
            margin.setLeft("15px");
            margin.setRight("15px");
            margin.setTop("10px");
            margin.setBottom("10px");
            style.setMargin(margin);
            radioField.setStyle(style);
            panel.getItems().add(radioField);
        }
        return panel;
    }

    private FieldAp createRadioField(String id, String name) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(id);
        fieldAp.setKey(id);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setAutoWrap(false);
        RadioField rf = new RadioField();
        rf.setId(id);
        rf.setKey(id);
        rf.setName(new LocaleString(name));
        rf.setItems(id);
        fieldAp.setField((Field)rf);
        return fieldAp;
    }
}

