/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;

public class AddActivityGroupFlowPlugin
extends HRDynamicFormBasePlugin {
    private static final AssessRuleApplicationService ASSESS_RULE_APPLICATION_SERVICE = AssessRuleApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY_SERVICE = ExecuteSchemeEntityService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    protected static final String FLOW_ENTRY = "flowentry";
    private static final String STR_CONFIRM = "confirm";

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.queryRuleFlow();
    }

    private void queryRuleFlow() {
        Map<Long, Tuple<Long, Boolean>> flowIdMap = this.getFlowIdMap();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        model.beginInit();
        setter.addField("flowid", new Object[0]);
        setter.addField("flowvid", new Object[0]);
        setter.addField("isdefault", new Object[0]);
        for (Map.Entry<Long, Tuple<Long, Boolean>> entry : flowIdMap.entrySet()) {
            setter.addRow(new Object[]{entry.getKey(), entry.getValue().item1, entry.getValue().item2});
        }
        model.batchCreateNewEntryRow(FLOW_ENTRY, setter);
        model.endInit();
        this.getView().updateView(FLOW_ENTRY);
    }

    private Map<Long, Tuple<Long, Boolean>> getFlowIdMap() {
        DynamicObjectCollection flowEntry;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long activityId = (Long)customParams.get("activityId");
        DynamicObject activityDy = ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        long perfWorkFlowId = activityDy.getLong("perfworkflow.id");
        if (perfWorkFlowId == 0L) {
            perfWorkFlowId = activityDy.getLong("executescheme.perfworkflow.id");
        }
        if (CollectionUtils.isEmpty((Collection)(flowEntry = PERF_WORK_FLOW_DOMAIN_SERVICE.queryAssFlowById(perfWorkFlowId, "2")))) {
            return new HashMap<Long, Tuple<Long, Boolean>>(16);
        }
        return flowEntry.stream().collect(Collectors.toMap(item1 -> item1.getLong("flowid"), item2 -> new Tuple((Object)item2.getLong("flowvid"), (Object)item2.getBoolean("isdefaultflow"))));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid flowEntry;
        int[] selectRows;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (STR_CONFIRM.equals(source.getOperateKey()) && (selectRows = (flowEntry = (EntryGrid)this.getView().getControl(FLOW_ENTRY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AddActivityGroupFlowPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        if (STR_CONFIRM.equals(source.getOperateKey())) {
            EntryGrid flowEntry = (EntryGrid)this.getView().getControl(FLOW_ENTRY);
            int[] selectRows = flowEntry.getSelectRows();
            HashMap<Long, Long> returnData = new HashMap<Long, Long>(16);
            for (int selectRow : selectRows) {
                DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity(FLOW_ENTRY).get(selectRow);
                returnData.put(entry.getLong("flowid"), entry.getLong("flowvid.id"));
            }
            this.getView().returnDataToParent(returnData);
        }
    }
}

