/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;

public class AddEvaluationActivityPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AddEvaluationActivityPlugin.class);
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APP = AssessActivityApplicationService.getInstance();
    private static final AssessSchemeApplicationService SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final String DATE_FIELD = "datefield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit executeScheme = (BasedataEdit)this.getControl("executescheme");
        executeScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl("scheme");
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getModel().getValue("scheme") == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"executescheme"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        Object oldValue;
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String dateField = e.getProperty().getName();
        if (DATE_FIELD.equals(dateField)) {
            changeSet = e.getChangeSet();
            oldValue = changeSet[0].getOldValue();
            newValue = changeSet[0].getNewValue();
            if (oldValue == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"executescheme"});
            } else {
                this.getModel().setValue("executescheme", null);
            }
            if (newValue == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"executescheme"});
            }
        }
        if ("scheme".equals(dateField)) {
            changeSet = e.getChangeSet();
            oldValue = changeSet[0].getOldValue();
            newValue = changeSet[0].getNewValue();
            if (oldValue == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"executescheme"});
            } else {
                this.getModel().setValue("executescheme", null);
            }
            if (newValue == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"executescheme"});
            } else if (!newValue.equals(oldValue)) {
                this.getModel().setValue("executescheme", null);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        ListFilterParameter listFilterParameter;
        ListShowParameter showParameter;
        String name = event.getProperty().getName();
        Object dateField = this.getModel().getValue(DATE_FIELD);
        if ("executescheme".equals(name) && dateField != null) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            Date dateTime = this.getModel().getDataEntity().getDate(DATE_FIELD);
            int year = HRDateTimeUtils.getYear((Date)dateTime);
            DynamicObjectCollection executeSchemeDynObjColl = ASSESS_ACTIVITY_APP.queryExecuteSchemeByPeriod(String.valueOf(year));
            List executedSchemeIdList = executeSchemeDynObjColl.stream().map(dynObj -> dynObj.getLong("executescheme.id")).collect(Collectors.toList());
            DynamicObject[] executeSchemeArr = ASSESS_ACTIVITY_APP.queryAssessSchemeArr(executedSchemeIdList);
            HashSet<Long> executeSchemeIdSet = new HashSet<Long>(executeSchemeArr.length);
            for (DynamicObject executeSchemeDynObj : executeSchemeArr) {
                if (executeSchemeDynObj.getDynamicObject("scheme") == null) continue;
                Date startYear = executeSchemeDynObj.getDate("scheme.startyear");
                Date endYear = executeSchemeDynObj.getDate("scheme.endyear");
                if (dateTime.compareTo(startYear) >= 0) {
                    executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
                }
                if (endYear == null || dateTime.compareTo(endYear) > 0) continue;
                executeSchemeIdSet.add(executeSchemeDynObj.getLong("id"));
            }
            listFilterParameter.setFilter(new QFilter("id", "in", executeSchemeIdSet));
            if (this.getModel().getValue("scheme") != null) {
                listFilterParameter.setFilter(new QFilter("scheme.id", "=", (Object)((DynamicObject)this.getModel().getValue("scheme")).getLong("id")));
            } else {
                listFilterParameter.setFilter(new QFilter("scheme.id", "=", (Object)0L));
            }
            String appId = DataValidateServiceHelper.getBizAppId((String)"epa_activity");
            String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)"epa_activity");
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)"epa_activity", (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                listFilterParameter.setFilter(new QFilter("scheme.org", "in", (Object)result.getHasPermOrgs()));
            }
        }
        if ("scheme".equals(name)) {
            showParameter = (ListShowParameter)event.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            String appId = DataValidateServiceHelper.getBizAppId((String)"epa_activity");
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"36", (String)appId, (String)"epa_activity", (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                listFilterParameter.setFilter(new QFilter("org", "in", (Object)result.getHasPermOrgs()));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("donothing_ok".equals(operateKey)) {
            Object executeScheme;
            long executeSchemeId = this.getModel().getDataEntity().getLong("executescheme.id");
            Object[] activityDynObjArr = ASSESS_ACTIVITY_APP.queryActivityBySchemeId(Long.valueOf(executeSchemeId));
            if (!HRArrayUtils.isEmpty((Object[])activityDynObjArr)) {
                String errorNotification = String.format(ResManager.loadKDString((String)"%s-\u5df2\u751f\u6210\u8003\u6838\u6d3b\u52a8\u3002", (String)"AddEvaluationActivityPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("executescheme.name"));
                this.getView().showErrorNotification(errorNotification);
                args.setCancel(true);
            }
            if ((executeScheme = this.getModel().getDataEntity().get("executescheme")) == null) {
                String tipNotificationMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8003\u6838\u6267\u884c\u8ba1\u5212\u201d\u3002", (String)"AddEvaluationActivityPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tipNotificationMsg);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "donothing_ok".equals(operateKey = args.getOperateKey())) {
            HashMap<String, Object> executeSchemeMap = new HashMap<String, Object>(16);
            executeSchemeMap.put("executescheme", this.getModel().getDataEntity().getLong("executescheme.id"));
            executeSchemeMap.put("year", this.getModel().getDataEntity().get(DATE_FIELD));
            this.getView().getParentView().setReturnData(executeSchemeMap);
            this.getView().returnDataToParent(executeSchemeMap);
        }
    }
}

