/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.constants.AssessTableConfConstants;
import kd.opmc.epa.formplugin.web.activity.extpoint.AreaIndicatorPermissionService;
import kd.opmc.epa.formplugin.web.activity.extpoint.impl.AreaIndicatorPermissionServiceImpl;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class AddSubAreaIndicatorEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(AddSubAreaIndicatorEdit.class);
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final IndicatorGroupApplicationService indicatorService = IndicatorGroupApplicationService.getInstance();
    private final Set<String> validateNumberFiled = Sets.newHashSet((Object[])new String[]{"qualitytarget", "qualitydare", "qualitybase", "qualityres"});
    private static final String MUST_INPUT = "mustinput";
    private static final String[] TEXTS = new String[]{"indctrname", "indctrnumber", "indctrsource", "unit"};
    private static final String[] BIGTEXTS = new String[]{"evaldesc"};
    private static final String[] MULLINE_TEXTS = new String[]{"indctrdesc", "evalcriteria", "remarks", "finishdesc", "qualitytarget"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryPlusMinusConfigByPk(confId);
        DrawAreaUtils.drawIndicatorField(args, conf, AssessTableConfConstants.ADD_SUB_IGNORE_FIELD);
    }

    private boolean isInIgnore(String[] ignores, String fieldKey) {
        for (String str : ignores) {
            if (HRStringUtils.isEmpty((String)fieldKey) || !HRStringUtils.equals((String)str, (String)fieldKey)) continue;
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status != OperationStatus.ADDNEW) {
            return;
        }
        Long instanceId = (Long)parameter.getCustomParam("instanceid");
        this.getModel().setValue("instanceid", (Object)instanceId);
        Integer indReqSize = null == parameter.getCustomParam("indReqSize") ? Integer.valueOf(0) : (Integer)parameter.getCustomParam("indReqSize");
        this.getModel().setValue("entryseq", (Object)(indReqSize + 1));
        this.getModel().setValue("evaltype", (Object)"10");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String value;
        String evalType;
        String name = e.getProperty().getName();
        if (this.validateNumberFiled.contains(name) && HRStringUtils.equals((String)(evalType = (String)this.getModel().getValue("evaltype")), (String)"20") && !ObjectUtils.isEmpty((Object)(value = (String)this.getModel().getValue(name))) && !DrawAreaUtils.validateNumber(value)) {
            String displayName = this.getModel().getProperty(name).getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(ResManager.loadKDString((String)"[{0}}]\u53ea\u80fd\u8f93\u5165\u6570\u5b57", (String)"AddSubAreaIndicatorEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[]{displayName}));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTips();
        this.getView().updateControlMetadata("subscoremin", DrawAreaUtils.getSubScoreMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("addscoremax", DrawAreaUtils.getAddScoreMap(this.getView().getFormShowParameter()));
        this.getModel().setDataChanged(false);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.service.queryPlusMinusConfigByPk(confId);
        this.setTitleText(formShowParameter.getStatus(), conf);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        HashSet<String> mustInputs = new HashSet<String>(16);
        for (Object fieldInfo : entryEntity) {
            DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
            LOG.info("AddSubAreaIndicatorEdit.afterBindData areaField :{}", (Object)areaField);
            if (!areaField.getBoolean("ismustinput")) continue;
            String fieldKey = fieldInfo.getString("areafield.number");
            LOG.info("AddSubAreaIndicatorEdit.afterBindData fieldKey :{},ignore: {}", (Object)fieldKey, (Object)AssessTableConfConstants.ADD_SUB_IGNORE_FIELD);
            if (this.isInIgnore(AssessTableConfConstants.ADD_SUB_IGNORE_FIELD, fieldKey)) continue;
            mustInputs.add(fieldKey);
        }
        StringBuffer mustInputsb = new StringBuffer();
        for (String must : mustInputs) {
            mustInputsb.append(must);
            mustInputsb.append(",");
        }
        String mustInputstr = mustInputsb.substring(0, mustInputsb.length() - 1);
        this.getPageCache().put(MUST_INPUT, mustInputstr);
        LOG.info("AddSubAreaIndicatorEdit.afterBindData mustInputs : {}", mustInputs);
    }

    private void setTitleText(OperationStatus status, DynamicObject conf) {
        String text = "";
        switch (status) {
            case ADDNEW: {
                text = ResManager.loadKDString((String)"\u6dfb\u52a0{0}\u6307\u6807", (String)"AddSubAreaIndicatorEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case EDIT: {
                text = ResManager.loadKDString((String)"\u7f16\u8f91{0}\u6307\u6807", (String)"AddSubAreaIndicatorEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
            case VIEW: {
                text = ResManager.loadKDString((String)"\u67e5\u770b{0}\u6307\u6807", (String)"AddSubAreaIndicatorEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("areacustname")});
                break;
            }
        }
        Label titleLabel = (Label)this.getControl("titlelabel");
        titleLabel.setText(text);
    }

    protected boolean checkActivityPermission() {
        AreaIndicatorPermissionServiceImpl areaIndicatorPermissionService = new AreaIndicatorPermissionServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)areaIndicatorPermissionService, AreaIndicatorPermissionService.class, (String)"kd.opmc.epa.formplugin.web.activity.extpoint.AreaIndicatorPermissionService#skipAreaIndicatorPermission", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(validate -> validate.skipAreaIndicatorPermission(this.getView()));
        if (results != null && !results.isEmpty() && results.get(0) != null && ((Boolean)results.get(0)).booleanValue()) {
            return true;
        }
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"AddSubAreaIndicatorEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        long id = this.getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            this.getPageCache().put("addflag", "true");
        } else {
            this.getPageCache().put("addflag", "false");
        }
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            String[] mustInputs;
            if (!this.checkActivityPermission()) {
                args.setCancel(true);
                return;
            }
            Object indicatorGroup = this.getView().getFormShowParameter().getCustomParam("indicatorgroup");
            if (this.indicatorService.isProcessOrDistrActevalObj(indicatorGroup)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u5bf9\u5e94\u4eba\u5458\u5df2\u7ecf\u5f00\u542f\u5236\u5b9a\u6d41\u7a0b/\u7edf\u4e00\u6d3e\u53d1\uff0c\u4e0d\u53ef\u7f16\u8f91\u6307\u6807\u3002", (String)"AddSubAreaIndicatorEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            IFormView objGenInstView = this.getView().getParentView();
            DynamicObject pDataEntity = objGenInstView.getModel().getDataEntity(true);
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Long cId = dataEntity.getLong("id");
            String mustInputstr = this.getPageCache().get(MUST_INPUT);
            for (String fieldKey : mustInputs = mustInputstr.split(",")) {
                String valueStr;
                Object value = dataEntity.get(fieldKey);
                LOG.info("AddSubAreaIndicatorEdit.beforeDoOperation: fieldKey: {},value: {}", (Object)fieldKey, value);
                if (value == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AddSubAreaIndicatorEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (value instanceof OrmLocaleValue) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                    boolean isEmpty = true;
                    Collection values = ormLocaleValue.values();
                    for (String ormLocaleValueStr : values) {
                        if (HRStringUtils.isEmpty((String)ormLocaleValueStr)) continue;
                        isEmpty = false;
                        break;
                    }
                    if (isEmpty) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AddSubAreaIndicatorEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                }
                if (!(value instanceof String) || !HRStringUtils.isEmpty((String)(valueStr = (String)value))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"AddSubAreaIndicatorEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String nameOri = dataEntity.getString("indctrname");
            String name = "";
            if (!HRStringUtils.isEmpty((String)nameOri)) {
                name = nameOri.trim();
            }
            if (!name.equals(nameOri)) {
                this.getModel().setValue("indctrname", (Object)name);
            }
            if (HRStringUtils.isEmpty((String)name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AddSubAreaIndicatorEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (HRObjectUtils.isEmpty((Object)dataEntity.get("addscoremax"))) {
                this.getModel().setValue("addscoremax", (Object)0);
            }
            if (HRObjectUtils.isEmpty((Object)dataEntity.get("subscoremin"))) {
                this.getModel().setValue("subscoremin", (Object)0);
            }
            DynamicObjectCollection entryentity = pDataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                if (cId.equals(0L)) {
                    if (!name.equals(dynamicObject.getString("indctrname"))) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AddSubAreaIndicatorEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                    args.setCancel(true);
                    return;
                }
                if (cId.equals((Long)dynamicObject.getPkValue()) || !name.equals(dynamicObject.getString("indctrname"))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u533a\u57df\u5df2\u6709\u201c{0}\u201d\u76f8\u540c\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AddSubAreaIndicatorEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
                args.setCancel(true);
                return;
            }
            long pId = pDataEntity.getLong("id");
            if (this.indicatorService.checkNameIndicatorAreaEntry(AssessRuleConstants.PLUS_MINUS_AREA_PK, Long.valueOf(pId), name)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u7ec4\u4e2d\u5df2\u6709\u5236\u5b9a\u5bf9\u8c61\u76f8\u540c\u540d\u79f0\u7684\u6307\u6807\uff0c\u4e0d\u80fd\u6dfb\u52a0/\u7f16\u8f91\u3002", (String)"AddSubAreaIndicatorEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!NumberValidateUtils.opValidate((IFormView)this.getView(), this.validateNumberFiled)) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean isSuccess = !ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess();
        String addflag = this.getPageCache().get("addflag");
        if (isSuccess && "save".equals(operateKey)) {
            if ("true".equals(addflag)) {
                long pId = this.getView().getParentView().getModel().getDataEntity().getLong("id");
                this.indicatorService.addObjIndicatorAreaEntry(AssessRuleConstants.PLUS_MINUS_AREA_PK, Long.valueOf(pId), this.getModel().getDataEntity());
            } else {
                this.indicatorService.updateObjIndicatorAreaEntry(AssessRuleConstants.PLUS_MINUS_AREA_PK, this.getModel().getDataEntity());
            }
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }

    private void initTips() {
        this.setTips("subscoremin");
        this.setTips("addscoremax");
        this.setTips("iseditable");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_addsubareaind", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }
}

