/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;

public class AssAcGroupAssFlowEdit
extends HRDataBaseEdit {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String ADD_ASS_FLOW_ENTRY = "addassflowentry";
    private static final String DELETE_ASS_FLOW_ENTRY = "deleteassflowentry";
    protected static final String RULE_ID = "ruleId";
    protected static final String FLOW_IDS = "flow_ids";
    private static final String EPA_ACTIVITY_GROUP_FLOW = "epa_addassgroupflow";
    protected static final String GROUP_ASS_FLOW = "groupassflow";
    protected static final String AF_IS_DEFAULT = "afisdefault";

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        super.propertyChanged(changedArgs);
        String fieldKey = changedArgs.getProperty().getName();
        if (AF_IS_DEFAULT.equals(fieldKey)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(GROUP_ASS_FLOW);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(GROUP_ASS_FLOW);
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (!((DynamicObject)entryEntity.get(i)).getBoolean(AF_IS_DEFAULT) || i == entryCurrentRowIndex) continue;
                this.getModel().setValue(AF_IS_DEFAULT, (Object)false, i);
            }
            model.endInit();
            this.getView().updateView(GROUP_ASS_FLOW);
            this.invokeSaveOp();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "addassflowentry": {
                this.showAssFlowPage(args);
                break;
            }
            case "deleteassflowentry": {
                this.deleteAssFlow(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (DELETE_ASS_FLOW_ENTRY.equals(source.getOperateKey())) {
            this.invokeSaveOp();
        }
    }

    private void invokeSaveOp() {
        this.getView().getPageCache().put("isInvokeOperation", "true");
        this.getView().invokeOperation("save");
    }

    private void deleteAssFlow(BeforeDoOperationEventArgs args) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(GROUP_ASS_FLOW);
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity(GROUP_ASS_FLOW).get(currentRowIndex);
        String activityStatus = this.getModel().getDataEntity().getString("activitystatus");
        if (ActivityStatusEnum.COMPLETED.getValue().equals(activityStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528", (String)"AssAcGroupAssFlowEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (ActivityStatusEnum.EXECUTING.getValue().equals(activityStatus) || ActivityStatusEnum.TO_BE_EXECUTE.getValue().equals(activityStatus)) {
            if (this.validateIsDefault(row)) {
                args.setCancel(true);
                return;
            }
            if (this.validateFlowIsRefer(row)) {
                args.setCancel(true);
            }
        } else if (this.validateIsDefault(row)) {
            args.setCancel(true);
        }
    }

    private boolean validateFlowIsRefer(DynamicObject row) {
        DynamicObject currAssGroupDy;
        Object activityId = this.getModel().getDataEntity().getPkValue();
        if (ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryAssFlowExistsByActivityId((Long)activityId, Long.valueOf((currAssGroupDy = this.getCurrAssGroupDy()).getLong("assgroup.id")), Long.valueOf(((DynamicObject)currAssGroupDy.getDynamicObjectCollection(GROUP_ASS_FLOW).get(this.getModel().getEntryCurrentRowIndex(GROUP_ASS_FLOW))).getDynamicObject("flowvid").getLong("id")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664", (String)"AssAcGroupAssFlowEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{row.getDynamicObject("flowvid").getString("name")}));
            return true;
        }
        return false;
    }

    private DynamicObject getCurrAssGroupDy() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection assGroupEntry = billObj.getDynamicObjectCollection("assgroupentry");
        return (DynamicObject)assGroupEntry.get(this.getAssGroupSelectRow());
    }

    private boolean validateIsDefault(DynamicObject row) {
        boolean isDefault = row.getBoolean(AF_IS_DEFAULT);
        if (isDefault) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u4e3a\u9ed8\u8ba4\u8bc4\u4f30\u6d41\u7a0b\uff0c\u4e0d\u53ef\u5220\u9664", (String)"AssAcGroupAssFlowEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{row.getDynamicObject("flowvid").getString("name")}));
            return true;
        }
        return false;
    }

    private int getAssGroupSelectRow() {
        CardEntry assGroupEntry = (CardEntry)this.getView().getControl("assgroupentry");
        int[] selectRows = assGroupEntry.getSelectRows();
        if (selectRows.length > 0) {
            return assGroupEntry.getSelectRows()[0];
        }
        return -1;
    }

    private void showAssFlowPage(BeforeDoOperationEventArgs args) {
        DynamicObject activity = this.getModel().getDataEntity();
        String activityStatus = activity.getString("activitystatus");
        if (HRStringUtils.isNotEmpty((String)activityStatus) && ActivityStatusEnum.COMPLETED.getValue().equals(activityStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528", (String)"AssAcGroupAssFlowEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(EPA_ACTIVITY_GROUP_FLOW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        Long ruleId = this.getModel().getDataEntity().getLong("rule.id");
        parameter.getCustomParams().put(RULE_ID, ruleId);
        DynamicObject currAssGroupDy = this.getCurrAssGroupDy();
        DynamicObjectCollection groupAssFlows = currAssGroupDy.getDynamicObjectCollection(GROUP_ASS_FLOW);
        List flowId = groupAssFlows.stream().map(x -> x.getLong("flowvid.id")).collect(Collectors.toList());
        parameter.getCustomParams().put(FLOW_IDS, flowId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPA_ACTIVITY_GROUP_FLOW));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (HRStringUtils.equals((String)actionId, (String)EPA_ACTIVITY_GROUP_FLOW) && returnData instanceof Map) {
            Map flowIdMap = (Map)returnData;
            DynamicObject currAssGroupDy = this.getCurrAssGroupDy();
            DynamicObjectCollection dynamicObjectCollection = currAssGroupDy.getDynamicObjectCollection(GROUP_ASS_FLOW);
            Set entryFlowIds = dynamicObjectCollection.stream().map(x -> x.getLong("flowvid.id")).collect(Collectors.toSet());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("flowid", new Object[0]);
            vs.addField("flowvid", new Object[0]);
            for (Map.Entry entry : flowIdMap.entrySet()) {
                if (entryFlowIds.contains(entry.getValue())) continue;
                vs.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            model.batchCreateNewEntryRow(GROUP_ASS_FLOW, vs);
            this.getView().updateView(GROUP_ASS_FLOW);
            model.endInit();
            this.getView().invokeOperation("save");
        }
    }
}

