/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.formplugin.web.scheme.AssessSchemeViewUtils;

public class AssessActivityConfEdit
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(AssessActivityConfEdit.class);
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private final ActivityEvaluationObjectApplicationService actEvalObjService = ActivityEvaluationObjectApplicationService.getInstance();
    private static final String[] WIZARDS = new String[]{"activityinfoap", "activityinfostep", "activityinfolab", "assgroupinfoap", "assgroupinfostep", "assgroupinfolab"};
    private static final Map<String, Integer> cycleTypeMonthMap = new HashMap<String, Integer>();
    private static final String IS_LOCKED = "isLocked";
    private static final String MODIFY = "modify";

    public void initialize() {
        super.initialize();
        this.addClickListeners(WIZARDS);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof TipsSupport)) {
            return;
        }
        String key = ((TipsSupport)source).getKey();
        String msg = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"AssessActivityConfEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        AssessSchemeViewUtils.wizardSwitch(key, WIZARDS, this.getView(), msg);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isCheckDataChange = this.getPageCache().get("isCheckDataChange");
        boolean notCheck = HRStringUtils.equals((String)"false", (String)isCheckDataChange);
        if (notCheck) {
            e.setCheckDataChange(false);
        }
    }

    public void pageRelease(EventObject e) {
        String isLocked = this.getView().getPageCache().get(IS_LOCKED);
        String activityStatus = this.getView().getPageCache().get("cuurentActivityStatus");
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!(HRStringUtils.equals((String)ActivityStatusEnum.COMPLETED.getValue(), (String)activityStatus) && HRStringUtils.equals((String)formId, (String)"epa_activity") || HRStringUtils.equals((String)"false", (String)isLocked))) {
            String lockId = this.getPageCache().get("id");
            MutexHelper.release((String)"epa_activity", (String)MODIFY, (String)lockId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String activityStatus = (String)this.getModel().getValue("activitystatus");
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!HRStringUtils.equals((String)ActivityStatusEnum.COMPLETED.getValue(), (String)activityStatus) || !HRStringUtils.equals((String)formId, (String)"epa_activity")) {
            this.setMutex();
        }
        this.initTips();
        this.getPageCache().put("cuurentActivityStatus", activityStatus);
        this.setPageEnable();
        if (!HRStringUtils.equals((String)activityStatus, (String)ActivityStatusEnum.STAGING.getValue())) {
            return;
        }
        DynamicObject schemeDy = (DynamicObject)this.getModel().getValue("scheme");
        if (!ObjectUtils.isEmpty((Object)schemeDy)) {
            long cycleSchemeId = schemeDy.getLong("cyclescheme.id");
            if (cycleSchemeId == 0L) {
                return;
            }
            DynamicObject cycleScheme = this.service.queryCycleScheme(cycleSchemeId);
            this.getModel().setValue("periodstartdate", (Object)this.formatPeriodDate(cycleScheme.getString("pperiodstart"), "1"));
            this.getModel().setValue("periodenddate", (Object)this.formatPeriodDate(cycleScheme.getString("pperiodend"), cycleScheme.getString("pperiodendyear")));
            this.getModel().setValue("timerule", (Object)"10");
        }
        this.initNodeTimePlanEntry();
        DynamicObjectCollection timePlanEntry = this.getModel().getEntryEntity("timeplanentry");
        if (timePlanEntry.size() > 0) {
            this.getModel().setValue("planstarttime", ((DynamicObject)timePlanEntry.get(0)).get("starttime"));
            this.getModel().setValue("planendtime", ((DynamicObject)timePlanEntry.get(timePlanEntry.size() - 1)).get("endtime"));
        }
        for (int i = 0; i < timePlanEntry.size(); ++i) {
            this.startTimeValidate(i, false);
            this.endTimeValidate(i, false);
        }
        this.getPageCache().put("isCheckDataChange", "false");
    }

    private void setMutex() {
        this.getPageCache().put("id", String.valueOf(this.getModel().getValue("id")));
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(this.getModel().getValue("id")), null, null, "epa_activity", MODIFY, true, "default");
        StringBuilder msg = new StringBuilder();
        boolean require = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)msg);
        if (!require) {
            this.getView().getPageCache().put(IS_LOCKED, "false");
            this.getView().getParentView().showTipNotification(msg.toString());
            this.getView().sendFormAction(this.getView().getParentView());
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void initNodeTimePlanEntry() {
        DynamicObject ruleDy = (DynamicObject)this.getModel().getValue("rule");
        if (!ObjectUtils.isEmpty((Object)ruleDy)) {
            Map<Long, DynamicObject> nodeMap = this.getNodeInfoOfScheme();
            DynamicObjectCollection nodeInfoCol = ruleDy.getDynamicObjectCollection("entryentity");
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("activity", new Object[0]);
            vs.addField("starttime", new Object[0]);
            vs.addField("endtime", new Object[0]);
            for (DynamicObject node : nodeInfoCol) {
                if (!node.getBoolean("isshow")) continue;
                Date startTime = null;
                Date endTime = null;
                DynamicObject nodeInfo = nodeMap.get(node.getLong("node.id"));
                if (!ObjectUtils.isEmpty((Object)nodeInfo)) {
                    startTime = this.formatPeriodDate(nodeInfo.getString("periodstart"), nodeInfo.getString("periodstartyear"));
                    endTime = this.formatPeriodDate(nodeInfo.getString("periodend"), nodeInfo.getString("periodendyear"));
                }
                vs.addRow(new Object[]{node.getLong("node.id"), startTime, endTime});
            }
            model.batchCreateNewEntryRow("timeplanentry", vs);
            model.endInit();
            this.getView().updateView("timeplanentry");
        }
    }

    private void setPageEnable() {
        Integer maxIndex;
        String cuurentActivityStatus = this.getPageCache().get("cuurentActivityStatus");
        if (HRStringUtils.equals((String)cuurentActivityStatus, (String)ActivityStatusEnum.EXECUTING.getValue())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield", "daterangefield1"});
        }
        if (HRStringUtils.equals((String)cuurentActivityStatus, (String)ActivityStatusEnum.STAGING.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"daterangefield"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"daterangefield"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"buttonclose"});
        if (HRStringUtils.equals((String)cuurentActivityStatus, (String)ActivityStatusEnum.COMPLETED.getValue())) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonsave"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonclose"});
        }
        DynamicObjectCollection timePlanEntry = this.getModel().getEntryEntity("timeplanentry");
        ArrayList<Integer> nodeIndex = new ArrayList<Integer>(16);
        for (int index = 0; index < timePlanEntry.size(); ++index) {
            nodeIndex.add(index + 1);
        }
        if (!ObjectUtils.isEmpty(nodeIndex) && !ObjectUtils.isEmpty((Object)(maxIndex = this.actEvalObjService.queryMaxProgressNodeStatusByActId(Long.valueOf(this.getModel().getDataEntity().getLong("id")), nodeIndex)))) {
            this.getView().setEnable(Boolean.FALSE, maxIndex - 1, new String[]{"starttime"});
            this.setTimePlanEnable(maxIndex - 1);
        }
    }

    private void setTimePlanEnable(int index) {
        for (int startIndex = index; startIndex >= 0; --startIndex) {
            if (startIndex >= index) continue;
            this.getView().setEnable(Boolean.FALSE, startIndex, new String[]{"starttime", "endtime"});
        }
    }

    private Map<Long, DynamicObject> getNodeInfoOfScheme() {
        Map<Long, Object> nodeMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject schemeDy = (DynamicObject)this.getModel().getValue("scheme");
        if (!ObjectUtils.isEmpty((Object)schemeDy)) {
            long cycleSchemeId = schemeDy.getLong("cyclescheme.id");
            if (cycleSchemeId == 0L) {
                return nodeMap;
            }
            DynamicObject cycleScheme = this.service.queryCycleScheme(cycleSchemeId);
            DynamicObjectCollection processInfos = cycleScheme.getDynamicObjectCollection("entryentity");
            nodeMap = processInfos.stream().collect(Collectors.toMap(processInfo -> processInfo.getDynamicObject("passessnode").getLong("id"), Function.identity(), (key1, key2) -> key1));
        }
        return nodeMap;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        this.validatePlanDate(args);
        this.validatePlaninitDate(args);
        String isCheckDataChange = this.getPageCache().get("isCheckDataChange");
        if (HRStringUtils.equals((String)"false", (String)isCheckDataChange)) {
            this.getPageCache().remove("isCheckDataChange");
        }
    }

    private void validatePlaninitDate(PropertyChangedArgs args) {
        DynamicObjectCollection timePlanEntry = this.getModel().getEntryEntity("timeplanentry");
        if (ObjectUtils.isEmpty((Object)timePlanEntry)) {
            return;
        }
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"planstarttime")) {
            Date planStartTime = (Date)this.getModel().getValue("planstarttime");
            Date startTime = ((DynamicObject)timePlanEntry.get(0)).getDate("starttime");
            if (planStartTime == null || startTime == null) {
                return;
            }
            if (planStartTime.after(startTime)) {
                this.getModel().setValue("planstarttime", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8003\u6838\u6267\u884c\u8d77\u59cb\u65e5\u671f\u201d\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u9996\u4e2a\u7ee9\u6548\u6d3b\u52a8\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)name, (String)"planendtime")) {
            Date planEndTime = (Date)this.getModel().getValue("planendtime");
            Date endTime = ((DynamicObject)timePlanEntry.get(timePlanEntry.size() - 1)).getDate("endtime");
            if (planEndTime == null || endTime == null) {
                return;
            }
            if (planEndTime.before(endTime)) {
                this.getModel().setValue("planendtime", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8003\u6838\u6267\u884c\u622a\u6b62\u65e5\u671f\u201d\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u6700\u6709\u4e00\u4e2a\u7ee9\u6548\u6d3b\u52a8\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validatePlanDate(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData changeInfo = args.getChangeSet()[0];
        int rowIndex = changeInfo.getRowIndex();
        if (HRStringUtils.equals((String)name, (String)"starttime")) {
            this.startTimeValidate(rowIndex, true);
        } else if (HRStringUtils.equals((String)name, (String)"endtime")) {
            this.endTimeValidate(rowIndex, true);
        }
    }

    private void endTimeValidate(int rowIndex, boolean showTips) {
        DynamicObjectCollection timePlanEntry = this.getModel().getEntryEntity("timeplanentry");
        Date endTime = (Date)this.getModel().getValue("endtime", rowIndex);
        DynamicObject activity = (DynamicObject)this.getModel().getValue("activity", rowIndex);
        Date planEndTime = (Date)this.getModel().getValue("planendtime");
        if (endTime == null || activity == null) {
            return;
        }
        Date startTime = (Date)this.getModel().getValue("starttime", rowIndex);
        String msg = null;
        if (rowIndex >= timePlanEntry.size() - 1) {
            if (planEndTime != null && endTime.after(planEndTime)) {
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u987b\u5c0f\u4e8e\u7b49\u4e8e\u7ee9\u6548\u6d41\u7a0b\u6267\u884c\u8ba1\u5212\u7684\u201c\u8003\u6838\u6267\u884c\u622a\u6b62\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue()});
            }
        } else {
            Date nextRowStartTime = (Date)this.getModel().getValue("starttime", rowIndex + 1);
            if (nextRowStartTime != null && !nextRowStartTime.after(endTime)) {
                DynamicObject preActivity = (DynamicObject)this.getModel().getValue("activity", rowIndex + 1);
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u987b\u5c0f\u4e8e{1}\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue(), preActivity.getLocaleString("name").getLocaleValue()});
            }
            if (startTime != null && !startTime.before(endTime)) {
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u987b\u5927\u4e8e\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue()});
            }
        }
        if (!HRStringUtils.isEmpty(msg)) {
            if (showTips) {
                this.getView().showTipNotification(msg);
            }
            this.getModel().setValue("endtime", null, rowIndex);
        }
    }

    private void startTimeValidate(int rowIndex, boolean showTips) {
        Date startTime = (Date)this.getModel().getValue("starttime", rowIndex);
        DynamicObject activity = (DynamicObject)this.getModel().getValue("activity", rowIndex);
        Date planStartTime = (Date)this.getModel().getValue("planstarttime");
        if (startTime == null || activity == null) {
            return;
        }
        Date endTime = (Date)this.getModel().getValue("endtime", rowIndex);
        String msg = null;
        if (rowIndex == 0) {
            if (planStartTime != null && planStartTime.after(startTime)) {
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u987b\u5927\u4e8e\u7b49\u4e8e\u7ee9\u6548\u6d41\u7a0b\u6267\u884c\u8ba1\u5212\u7684\u201c\u8003\u6838\u6267\u884c\u8d77\u59cb\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue()});
            }
        } else {
            Date preRowEndTime = (Date)this.getModel().getValue("endtime", rowIndex - 1);
            if (preRowEndTime != null && !preRowEndTime.before(startTime)) {
                DynamicObject preActivity = (DynamicObject)this.getModel().getValue("activity", rowIndex - 1);
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u987b\u5927\u4e8e{1}\u7684\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue(), preActivity.getLocaleString("name").getLocaleValue()});
            }
            if (endTime != null && !startTime.before(endTime)) {
                msg = ResManager.loadKDString((String)"{0}\u7684\u201c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u987b\u5c0f\u4e8e\u201c\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d", (String)"AssessActivityConfEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{activity.getLocaleString("name").getLocaleValue()});
            }
        }
        if (!HRStringUtils.isEmpty(msg)) {
            if (showTips) {
                this.getView().showTipNotification(msg);
            }
            this.getModel().setValue("starttime", null, rowIndex);
        }
    }

    private Date formatPeriodDate(String periodStartStr, String yearType) {
        String year = HRDateTimeUtils.format((Date)((Date)this.getModel().getValue("year")), (String)"yyyy");
        if (HRStringUtils.equals((String)yearType, (String)"2")) {
            year = HRDateTimeUtils.format((Date)HRDateTimeUtils.addYear((Date)new Date(), (int)1), (String)"yyyy");
        }
        try {
            Date date = HRDateTimeUtils.parseDate((String)(year + "-" + periodStartStr), (String)"yyyy-MM-dd");
            DynamicObject executeScheme = (DynamicObject)this.getModel().getValue("executescheme");
            DynamicObject timeTag = this.service.queryTimmTag(executeScheme.getDynamicObject("timetag").getLong("id"));
            int monthAdd = 0;
            if (!HRStringUtils.equals((String)timeTag.getString("number"), (String)"101010_S")) {
                String cycleType = timeTag.getDynamicObject("cycletype").getString("number");
                monthAdd = (Integer.parseInt(timeTag.getString("name").substring(1)) - 1) * cycleTypeMonthMap.get(cycleType);
            }
            date = AssessActivityConfEdit.calcInstanceDate(date, monthAdd);
            return date;
        }
        catch (ParseException exception) {
            LOG.error((Throwable)exception);
            return HRDateTimeUtils.truncateDate((Date)new Date());
        }
    }

    public static Date calcInstanceDate(Date date, int monthAdd) {
        if (monthAdd < 0) {
            return date;
        }
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, monthAdd);
        return instance.getTime();
    }

    private void initTips() {
        this.setTips("daterangefield1");
        this.setColumnTips("activity");
        this.setColumnTips("starttime");
        this.setColumnTips("endtime");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_activity", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }

    private void setColumnTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_activity", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("timeplanentry");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            HashMap<String, String> contentMap = new HashMap<String, String>(16);
            contentMap.put("zh_CN", tipContent);
            map.put("content", contentMap);
            map.put("type", "text");
            entryGrid.setColumnProperty(key, "tips", map);
        }
    }

    static {
        cycleTypeMonthMap.put("1010_S", 12);
        cycleTypeMonthMap.put("1020_S", 6);
        cycleTypeMonthMap.put("1030_S", 3);
        cycleTypeMonthMap.put("1040_S", 1);
    }
}

