/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activity;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.TextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.business.application.service.upgradeparam.UpgradeParamApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.entity.ActObjStatBo;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumDomainService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.business.task.AtivityPermUpdateTask;
import kd.opmc.epa.business.task.StartUpActivityAddActObjectTask;
import kd.opmc.epa.formplugin.web.utils.ActivityDispatchUtils;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;
import kd.opmc.pbs.business.domain.timetag.entityservice.TimeTagEntityService;

public class AssessActivityConfList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(AssessActivityConfList.class);
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final ActivityObjRecordEntityService ACTIVITY_OBJ_RECORD = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACT_EVAL_OBJ_ENTITY_SERVICE = ActivityEvaluationObjectEntityService.getInstance();
    private static final UpgradeParamApplicationService UPGRADE_PARAM_APPLICATION_SERVICE = UpgradeParamApplicationService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final PerfSumDomainService PERF_SUM_DOMAIN_SERVICE = PerfSumDomainService.getInstance();
    private static final TimeTagEntityService TIME_TAG_ENTITY_SERVICE = TimeTagEntityService.getInstance();
    private static final String BATCH_NEW = "batchnew";
    private static final String START_UP_ACTIVITY = "startupactivity";
    private static final String END_ACTIVITY = "endactivity";
    private static final String DELETE = "delete";
    private static final String ALL = "all";
    private static final String JOINED = "joined";
    private static final String HAVE_IN_HAND = "haveinhand";
    private static final String COMPLETED = "completed";
    private static final String DO_NOTHING_ADD = "donothing_add";
    private Map<Long, ActObjStatBo> actObjStatusMap = new HashMap<Long, ActObjStatBo>();
    private static final String ACTIVITY_LIST_EMP_PAGE = "activitylistemppage";
    private static final String END_ACTIVITY_EXECUTE = "end_activity_execute";
    private static final String CANCEL_START_UP = "cancel_start_up";
    private static final String CANCEL_END = "cancel_end";
    private static final String ACTIVITY_UPDATE = "activity_update";
    private static final String SYNC_MPRULE = "sync_mprule";
    private static final Long CYCLE_YEAR = 1363179570613844992L;

    public void preOpenForm(PreOpenFormEventArgs args) {
        QFilter activityQFilter;
        super.preOpenForm(args);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        String key = "isUpdateActivity" + RequestContext.get().getTenantId();
        try {
            if ("1".equals(cache.get(key))) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5b9e\u65bd\u90e8\u7f72\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u76ee\u6807\u7ee9\u6548\u4e91>\u4e2a\u4eba\u7ee9\u6548\u8003\u6838>\u57fa\u7840\u914d\u7f6e>\u7cfb\u7edf\u5347\u7ea7\u7ba1\u7406\u201d\u5347\u7ea7\u529f\u80fd\uff0c\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u540e\uff0c\u63d0\u793a\u5c06\u4e0d\u518d\u51fa\u73b0\u3002\u5982\u65e0\u201d\u5347\u7ea7\u529f\u80fd\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AssessActivityConfList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        catch (Exception e) {
            String errorMsg = "cache error, read error: " + e.getMessage();
            LOG.error(errorMsg, (Throwable)e);
        }
        DynamicObject upgradeParamObj = UPGRADE_PARAM_APPLICATION_SERVICE.getUpgradeParam();
        boolean isupgrade = upgradeParamObj.getBoolean("isupgrade");
        if (isupgrade && ACTIVITY_ENTITY.isExists(activityQFilter = new QFilter("dynamicpermission", "=", (Object)0L))) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u529f\u80fd\u5b9e\u65bd\u90e8\u7f72\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u76ee\u6807\u7ee9\u6548\u4e91>\u4e2a\u4eba\u7ee9\u6548\u8003\u6838>\u57fa\u7840\u914d\u7f6e>\u7cfb\u7edf\u5347\u7ea7\u7ba1\u7406\u201d\u5347\u7ea7\u529f\u80fd\uff0c\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u540e\uff0c\u63d0\u793a\u5c06\u4e0d\u518d\u51fa\u73b0\u3002\u5982\u65e0\u201d\u5347\u7ea7\u529f\u80fd\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AssessActivityConfList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = Arrays.asList("fseq", "number", "name");
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        ListSelectedRowCollection col = this.getSelectedRows();
        boolean isSuccess = !ObjectUtils.isEmpty((Object)args.getOperationResult()) && args.getOperationResult().isSuccess();
        switch (operateKey) {
            case "batchnew": {
                this.showBatchAddEvalActivity(isSuccess);
                break;
            }
            case "startupactivity": {
                this.showStartUpConfirmBox(isSuccess);
                break;
            }
            case "endactivity": {
                this.endActivity(col, isSuccess);
                break;
            }
            case "donothing_add": {
                this.showAddEvalActivity(isSuccess);
                break;
            }
            case "cancel_start_up": {
                if (!isSuccess) break;
                this.updataActivityStatus((Long)col.getPrimaryKeyValues()[0], ActivityStatusEnum.TO_BE_EXECUTE.getValue());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "cancel_end": {
                if (!isSuccess) break;
                this.updataActivityStatus((Long)col.getPrimaryKeyValues()[0], ActivityStatusEnum.EXECUTING.getValue());
                this.getView().invokeOperation("refresh");
                break;
            }
            case "sync_mprule": {
                if (!isSuccess) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u4f9d\u636e\u8003\u6838\u8ba1\u5212\u7684\u6c47\u603b\u89c4\u5219\u540c\u6b65\u81f3\u5f53\u524d\u8003\u6838\u6d3b\u52a8\uff0c\u540c\u6b65\u4e4b\u540e\u8003\u6838\u6d3b\u52a8\u4e0a\u539f\u6c47\u603b\u89c4\u5219\u4e0d\u53ef\u6062\u590d\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"AssessActivityConfList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(SYNC_MPRULE, (IFormPlugin)this));
                break;
            }
        }
    }

    private void updataActivityStatus(Long activityId, String status) {
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        if (HRStringUtils.equals((String)ActivityStatusEnum.TO_BE_EXECUTE.getValue(), (String)status)) {
            activityDynObj.set("startupdate", null);
        } else if (HRStringUtils.equals((String)ActivityStatusEnum.EXECUTING.getValue(), (String)status)) {
            activityDynObj.set("enddate", null);
        }
        activityDynObj.set("activitystatus", (Object)status);
        ASSESS_ACTIVITY_APPLICATION_SERVICE.updateActivityDynObj(activityDynObj);
    }

    private void endActivity(ListSelectedRowCollection col, boolean isSuccess) {
        if (isSuccess && HRStringUtils.isNotEmpty((String)this.getPageCache().get(END_ACTIVITY_EXECUTE))) {
            ASSESS_ACTIVITY_APPLICATION_SERVICE.endActivity((Long)col.getPrimaryKeyValues()[0]);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6210\u529f", (String)"AssessActivityConfList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
            this.getPageCache().remove(END_ACTIVITY_EXECUTE);
        }
    }

    private void showStartUpConfirmBox(boolean isSuccess) {
        if (!isSuccess) {
            return;
        }
        ListSelectedRowCollection col = this.getSelectedRows();
        if (this.isNotOnlyOneSelect(col)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(col.getPrimaryKeyValues()[0]);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_activitystartup");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity_id", col.getPrimaryKeyValues()[0]);
        showParameter.setCustomParam("periodstartdate", (Object)sdf.format(assessActivity.getDate("periodstartdate")));
        showParameter.setCustomParam("periodenddate", (Object)sdf.format(assessActivity.getDate("periodenddate")));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_activity"));
        this.getView().showForm(showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "name": {
                args.setCancel(true);
                if (this.checkMutex()) {
                    return;
                }
                if (!this.hasProcessManagePermission()) {
                    return;
                }
                this.showProcessManagePage(args);
                break;
            }
            case "joined": 
            case "haveinhand": 
            case "completed": {
                args.setCancel(true);
                if (!this.hasProcessManagePermission()) {
                    return;
                }
                String assessstaus = "10";
                if (HRStringUtils.equals((String)fieldName, (String)HAVE_IN_HAND)) {
                    assessstaus = "20";
                } else if (HRStringUtils.equals((String)fieldName, (String)COMPLETED)) {
                    assessstaus = "30";
                }
                this.showJoinPage("joinedap", "-6", assessstaus);
                break;
            }
        }
    }

    private boolean hasProcessManagePermission() {
        String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!hasPermission) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssessActivityConfList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption));
            return false;
        }
        return true;
    }

    private boolean checkMutex() {
        DataMutex dataMutex = DataMutex.create();
        Map lockInfo = dataMutex.getLockInfo(String.valueOf(this.getFocusRowPkId()), "default_netctrl", "epa_activity");
        if (lockInfo != null && lockInfo.size() > 0) {
            StringBuilder builder = new StringBuilder();
            Long userId = Long.valueOf((String)lockInfo.get("userid"));
            String client = (String)lockInfo.get("client");
            String sessionId = (String)lockInfo.get("GLOBALSESSION");
            if (userId == -1L) {
                builder.append("guest");
            } else {
                DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
                if (userObj != null) {
                    builder.append(userObj.getString("name"));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)client)) {
                builder.append(ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c", (String)"AssessActivityConfList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                builder.append(ResManager.loadKDString((String)"\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c", (String)"AssessActivityConfList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.equals((String)((String)lockInfo.get("userid")), (String)String.valueOf(RequestContext.get().getCurrUserId())) && HRStringUtils.equals((String)sessionId, (String)RequestContext.get().getGlobalSessionId())) {
                return false;
            }
            builder.append(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AssessActivityConfList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(builder.toString());
            return true;
        }
        return false;
    }

    private void showBatchAddEvalActivity(boolean isSuccess) {
        if (!isSuccess) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_batchaddactivity");
        showParameter.setCustomParam("schemeId", this.getView().getFormShowParameter().getCustomParam("schemeId"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_batchaddactivity"));
        this.getView().showForm(showParameter);
    }

    private void showAddEvalActivity(boolean isSuccess) {
        if (!isSuccess) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_addevalactivity");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_addevalactivity"));
        this.getView().showForm(showParameter);
    }

    private void startUpActivity(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection col = this.getSelectedRows();
        if (this.isNotOnlyOneSelect(col)) {
            return;
        }
        DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(col.getPrimaryKeyValues()[0]);
        if (HRObjectUtils.isEmpty((Object)assessActivity)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u5220\u9664", (String)"AssessActivityConfList_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (this.checkPermission(new DynamicObject[]{assessActivity})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (!HRStringUtils.equals((String)assessActivity.getString("activitystatus"), (String)ActivityStatusEnum.TO_BE_EXECUTE.getValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u542f\u52a8\u201c\u5f85\u6267\u884c\u201d\u7684\u6570\u636e\u3002", (String)"AssessActivityConfList_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean checkPermission(DynamicObject[] dys) {
        String pageId;
        String string = pageId = this.getView().getParentView() == null ? "" : this.getView().getParentView().getPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement")) {
            boolean scopeCheck;
            List ids = Arrays.stream(dys).map(obj -> (Long)obj.getDynamicObject("executescheme.assessscope").getPkValue()).collect(Collectors.toList());
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager) && !(scopeCheck = manager.getBoolean("isscopecheck"))) {
                DynamicObjectCollection scopes = manager.getDynamicObjectCollection("objectscope");
                List scopeIds = scopes.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                return !scopeIds.containsAll(ids);
            }
        }
        return false;
    }

    private void endActivityCheck() {
        ListSelectedRowCollection col = this.getSelectedRows();
        DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(col.getPrimaryKeyValues()[0]);
        if (this.isNotOnlyOneSelect(col) || HRObjectUtils.isEmpty((Object)assessActivity)) {
            return;
        }
        if (!HRStringUtils.equals((String)assessActivity.getString("activitystatus"), (String)ActivityStatusEnum.EXECUTING.getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u7ed3\u675f\u72b6\u6001\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u7684\u8003\u6838\u6d3b\u52a8", (String)"AssessActivityConfList_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
        } else if (ASSESS_ACTIVITY_APPLICATION_SERVICE.checkEndAssessStatus((Long)col.getPrimaryKeyValues()[0])) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u672a\u5b8c\u6210\u8003\u6838\uff0c\u4e0d\u53ef\u7ed3\u675f\u3002", (String)"AssessActivityConfList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.refreshActivityList();
        } else if (!ACTIVITY_EVALUATION_OBJECT_APPLICATION_SERVICE.isExistsEvalObj((Long)col.getPrimaryKeyValues()[0])) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u65e0\u53c2\u4e0e\u8003\u6838\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u662f\u5426\u7ee7\u7eed\u7ed3\u675f\uff1f", (String)"AssessActivityConfList_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(END_ACTIVITY, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5c06\u7ed3\u675f\uff0c\u7ee7\u7eed\u7ed3\u675f\u5417\uff1f", (String)"AssessActivityConfList_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(END_ACTIVITY, (IFormPlugin)this));
        }
    }

    private boolean isNotOnlyOneSelect(ListSelectedRowCollection col) {
        if (col.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AssessActivityConfList_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (col.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u6267\u884c1\u6761\u6570\u636e", (String)"AssessActivityConfList_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (!this.checkItemPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        switch (operateKey) {
            case "delete": {
                ListSelectedRowCollection col = this.getSelectedRows();
                List ids = col.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList());
                DynamicObject[] activitys = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryByIds(ids);
                if (!this.checkPermission(activitys)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "endactivity": {
                ListSelectedRowCollection rows = this.getSelectedRows();
                DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(rows.getPrimaryKeyValues()[0]);
                if (!HRObjectUtils.isEmpty((Object)assessActivity) && this.checkPermission(new DynamicObject[]{assessActivity})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!HRStringUtils.isEmpty((String)this.getPageCache().get(END_ACTIVITY_EXECUTE))) break;
                this.endActivityCheck();
                args.setCancel(true);
                break;
            }
            case "startupactivity": {
                this.startUpActivity(args);
                break;
            }
            case "cancel_start_up": {
                this.cancelStartUpActivity(args);
                break;
            }
            case "activity_update": {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("activity_id", this.getSelectedRows().getPrimaryKeyValues()[0]);
                ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, AtivityPermUpdateTask.class.getName(), ResManager.loadKDString((String)"\u542f\u52a8\u6d3b\u52a8", (String)"AssessActivityConfList_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, ACTIVITY_UPDATE);
                break;
            }
            case "sync_mprule": {
                this.checkCanUpdate(args);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkCanUpdate(BeforeDoOperationEventArgs args) {
        boolean completed;
        ListSelectedRowCollection rows = this.getSelectedRows();
        Long activityId = (Long)rows.getPrimaryKeyValues()[0];
        DynamicObject assessActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObject scheme = assessActivity.getDynamicObject("scheme");
        DynamicObject cycleType = scheme.getDynamicObject("cycleType");
        boolean isEnd = HRStringUtils.equals((String)assessActivity.getString("activitystatus"), (String)ActivityStatusEnum.COMPLETED.getValue());
        if (isEnd) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u65e0\u6cd5\u4f7f\u7528\u672c\u529f\u80fd\u3002", (String)"AssessActivityConfList_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean isneedmpgenway = scheme.getBoolean("isneedmpgenway");
        boolean isPeriodAssess = scheme.getBoolean("isperiodassess");
        boolean hasMpRule = scheme.get("mprule") != null && isneedmpgenway;
        DynamicObject excutescheme = assessActivity.getDynamicObject("executescheme");
        if (hasMpRule) {
            boolean isMpExcuteScheme;
            if (scheme.getDynamicObject("mpsoptimetag") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u5c1a\u672a\u914d\u7f6e\u672c\u8003\u6838\u5468\u671f\u201c\u5e74\u5ea6\u9700\u6c47\u603b\u201d\u6216\u201c\u751f\u6210\u5e74\u5ea6\u7ed3\u679c\u201d\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean bl = isMpExcuteScheme = excutescheme.getDynamicObject("timetag").getLong("id") == scheme.getDynamicObject("mpsoptimetag").getLong("ID");
            if (!isMpExcuteScheme) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u5c1a\u672a\u914d\u7f6e\u672c\u8003\u6838\u5468\u671f\u201c\u5e74\u5ea6\u9700\u6c47\u603b\u201d\u6216\u201c\u751f\u6210\u5e74\u5ea6\u7ed3\u679c\u201d\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else {
            boolean isMpExcuteScheme;
            DynamicObject[] timeTags = TIME_TAG_ENTITY_SERVICE.queryListByCycleType(Long.valueOf(cycleType.getLong("ID")));
            DynamicObject timeTagsDyn = timeTags[timeTags.length - 1];
            boolean bl = isMpExcuteScheme = excutescheme.getDynamicObject("timetag").getLong("id") == timeTagsDyn.getLong("ID");
            if (!isMpExcuteScheme) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u5c1a\u672a\u914d\u7f6e\u672c\u8003\u6838\u5468\u671f\u201c\u5e74\u5ea6\u9700\u6c47\u603b\u201d\u6216\u201c\u751f\u6210\u5e74\u5ea6\u7ed3\u679c\u201d\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && !isPeriodAssess) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u5c1a\u672a\u914d\u7f6e\u672c\u8003\u6838\u5468\u671f\u201c\u5e74\u5ea6\u9700\u6c47\u603b\u201d\u6216\u201c\u751f\u6210\u5e74\u5ea6\u7ed3\u679c\u201d\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean bl = completed = ACTIVITY_OBJ_RECORD.queryPerfSummaryedObjIdByActivityId(activityId).size() > 0;
        if (completed) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u5df2\u5b8c\u6210\u7ed3\u679c\u6c47\u603b\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("ressyncstatus", "=", (Object)"20");
        qFilter.and(new QFilter("activity", "=", (Object)activityId));
        boolean isResyncStatus = ACT_EVAL_OBJ_ENTITY_SERVICE.isExists(new QFilter[]{qFilter});
        if (isResyncStatus) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u5df2\u5f52\u6863\u7ed3\u679c\uff0c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u5931\u8d25\u3002", (String)"AssessActivityConfList_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void cancelStartUpActivity(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.isExitActivityObjByActivity((Long)rows.getPrimaryKeyValues()[0])) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4e2d\u5df2\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\uff0c\u53ef\u5220\u9664\u8bc4\u4f30\u5bf9\u8c61\u540e\u518d\u64a4\u9500\u542f\u52a8", (String)"AssessActivityConfList_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (!this.checkItemPermission()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (DELETE.equals(evt.getOperationKey())) {
            List ids;
            DynamicObject[] activityDynObjArr;
            ListSelectedRowCollection col = this.getSelectedRows();
            if (this.isNotOnlyOneSelect(col)) {
                evt.setCancel(true);
            }
            if (this.checkPermission(activityDynObjArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryByIds(ids = col.stream().map(obj -> (Long)obj.getPrimaryKeyValue()).collect(Collectors.toList())))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"AssessActivityConfList_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                for (DynamicObject activity : activityDynObjArr) {
                    if (!HRStringUtils.equals((String)activity.getString("activitystatus"), (String)ActivityStatusEnum.EXECUTING.getValue()) && !HRStringUtils.equals((String)activity.getString("activitystatus"), (String)ActivityStatusEnum.COMPLETED.getValue())) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u53ef\u5220\u9664\u72b6\u6001\u4e3a\u5f85\u6267\u884c\u7684\u6570\u636e", (String)"AssessActivityConfList_22", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    private void showProcessManagePage(HyperLinkClickArgs args) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_processmanage");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(this.getFocusRowPkId());
        baseShowParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId());
        String activityName = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo().getName();
        String caption = String.format(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406-%s", (String)"AssessActivityConfList_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]), activityName);
        baseShowParameter.setCaption(caption);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "epa_batchaddactivity": {
                if (returnData instanceof Map) {
                    Map returnDataMap = (Map)returnData;
                    if (Boolean.TRUE.toString().equals(returnDataMap.get("genActivitySuccess"))) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\u3002", (String)"AssessActivityConfList_24", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    }
                }
                this.refreshActivityList();
                break;
            }
            case "epa_addevalactivity": {
                this.showEvaluationActivity(closedCallBackEvent);
                break;
            }
            case "epa_evalactivity": {
                this.refreshActivityList();
                break;
            }
            case "auto_add_evaluation_objects": {
                if (returnData == null) {
                    return;
                }
                if (returnData instanceof Map) {
                    Map<String, Object> returnMap = this.getReturnMap(returnData);
                    if (!returnMap.containsKey("taskinfo")) {
                        return;
                    }
                    String taskInfoStr = (String)returnMap.get("taskinfo");
                    if (StringUtils.isBlank((CharSequence)taskInfoStr)) {
                        return;
                    }
                    TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                    if (!taskInfo.isTaskEnd()) {
                        return;
                    }
                    String data = taskInfo.getData();
                    if (HRStringUtils.isEmpty((String)data)) {
                        return;
                    }
                    JSONObject resultDate = JSONObject.parseObject((String)data);
                    if (!ObjectUtils.isEmpty((Object)resultDate)) {
                        String success = resultDate.get((Object)"sucess") + "";
                        String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6210\u529f\u6dfb\u52a0{1}\u6761\u3002", (String)"AssessActivityConfList_25", (String)"opmc-epa-formplugin", (Object[])new Object[]{success, success});
                        this.getView().showMessage(title, (String)this.getView().getFormShowParameter().getCustomParam("errorMessage"), MessageTypes.Default);
                    }
                }
                this.refreshActivityList();
                break;
            }
            case "epa_activity": {
                Map result = (Map)closedCallBackEvent.getReturnData();
                if (result == null) {
                    return;
                }
                Long activityId = (Long)result.get("activityId");
                DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
                activityDynObj.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
                activityDynObj.set("startupdate", (Object)new Date());
                ASSESS_ACTIVITY_APPLICATION_SERVICE.updateActivityDynObj(activityDynObj);
                if (HRStringUtils.equals((String)((String)result.get("data")), (String)"1")) {
                    this.startUpAddEvaluationObjects(activityId);
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6210\u529f\u3002", (String)"AssessActivityConfList_26", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.refreshActivityList();
                break;
            }
            case "activity_update": {
                DynamicObject updateActivityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(this.getSelectedRows().get(0).getPrimaryKeyValue());
                if (updateActivityDynObj.getDynamicObject("dynamicpermission") == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u5148\u5347\u7ea7\u65e7\u6743\u9650\u6570\u636e\u3002", (String)"AssessActivityConfList_27", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"AssessActivityConfList_28", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> getReturnMap(Object returnData) {
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            return result;
        }
        return new HashMap<String, Object>(16);
    }

    private void showEvaluationActivity(ClosedCallBackEvent closedCallBackEvent) {
        Object viewReturnData = closedCallBackEvent.getReturnData();
        if (viewReturnData instanceof Map) {
            Map closeCallBackPara = (Map)viewReturnData;
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_evalactivity");
            showParameter.setCustomParam("executescheme", closeCallBackPara.get("executescheme"));
            showParameter.setCustomParam("year", closeCallBackPara.get("year"));
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_evalactivity"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void refreshActivityList() {
        this.getView().invokeOperation("refresh");
        this.getView().sendFormAction(this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String actionId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult resultValue = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)resultValue)) {
            switch (actionId) {
                case "endactivity": {
                    this.getPageCache().put(END_ACTIVITY_EXECUTE, Boolean.TRUE.toString());
                    this.getView().invokeOperation(END_ACTIVITY);
                    this.getView().sendFormAction(this.getView());
                    break;
                }
                case "auto_add_evaluation_objects": {
                    ListSelectedRowCollection col = this.getSelectedRows();
                    long assessActivityPkId = (Long)col.getPrimaryKeyValues()[0];
                    DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)assessActivityPkId);
                    activityDynObj.set("activitystatus", (Object)ActivityStatusEnum.EXECUTING.getValue());
                    activityDynObj.set("startupdate", (Object)new Date());
                    ASSESS_ACTIVITY_APPLICATION_SERVICE.updateActivityDynObj(activityDynObj);
                    break;
                }
                case "sync_mprule": {
                    String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
                    long currUserId = RequestContext.get().getCurrUserId();
                    boolean hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"485L670VPK5Z");
                    if (!hasPermission) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u540c\u6b65\u6c47\u603b\u89c4\u5219\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AssessActivityConfList_29", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption));
                        return;
                    }
                    this.updateMPRule();
                    this.getView().invokeOperation("confirm");
                    break;
                }
            }
        }
    }

    private void updateMPRule() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(rows.get(0).getPrimaryKeyValue());
        DynamicObject scheme = activityDynObj.getDynamicObject("scheme");
        activityDynObj.set("isgenextmpsop", scheme.get("isgenextmpsop"));
        activityDynObj.set("mpsopcategory", scheme.get("mpsopcategory"));
        activityDynObj.set("mpgenway", scheme.get("mpgenway"));
        activityDynObj.set("isneedmpgenway", scheme.get("isneedmpgenway"));
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setEntryentities(entryentities);
        if (scheme.getBoolean("isneedmpgenway") && "1".equals(activityDynObj.getString("mpgenway"))) {
            Long ruleId = activityDynObj.getDynamicObject("scheme").getDynamicObject("mprule").getLong("id");
            DynamicObject mpRuleDyn = MP_RULE_ENTITY_SERVICE.queryOne(ruleId);
            MpRuleUtils.buildVoByMpRule(mpRuleDyn, mpRuleSetVO, entryentities);
            DynamicObject rule = MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(0L));
            activityDynObj.set("mprule", (Object)rule);
        } else {
            activityDynObj.set("mprule", null);
        }
        PERF_SUM_DOMAIN_SERVICE.clearPerfSumDataSyncScheme(Long.valueOf(activityDynObj.getLong("id")));
        ASSESS_ACTIVITY_APPLICATION_SERVICE.saveActivity(new DynamicObject[]{activityDynObj});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6c47\u603b\u89c4\u5219\u6210\u529f\u3002", (String)"AssessActivityConfList_30", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public void setFilter(SetFilterEvent evt) {
        HasPermOrgResult result;
        super.setFilter(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        String pageId = parentView.getPageId();
        if (pageId.contains("epa_schememanagement")) {
            boolean scopeCheck;
            List qFilters = evt.getQFilters();
            DynamicObject manager = this.getManagerData();
            if (!ObjectUtils.isEmpty((Object)manager) && !(scopeCheck = manager.getBoolean("isscopecheck"))) {
                DynamicObjectCollection scopes = manager.getDynamicObjectCollection("objectscope");
                List scopeIds = scopes.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("executescheme.assessscope", "in", scopeIds);
                qFilters.add(qFilter);
            }
        }
        if (!(result = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId())).hasAllOrgPerm()) {
            QFilter qFilter = new QFilter("scheme.org", "in", (Object)result.getHasPermOrgs());
            evt.getQFilters().add(qFilter);
        }
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        if (source instanceof TextColumnDesc && !ObjectUtils.isEmpty(this.actObjStatusMap)) {
            TextColumnDesc columnDesc = (TextColumnDesc)source;
            ActObjStatBo actObjStatBo = this.actObjStatusMap.get(event.getRowData().getLong("id"));
            if (!ObjectUtils.isEmpty((Object)actObjStatBo)) {
                switch (columnDesc.getKey()) {
                    case "all": {
                        event.setFormatValue((Object)actObjStatBo.getAll());
                        break;
                    }
                    case "joined": {
                        event.setFormatValue((Object)actObjStatBo.getJoined());
                        break;
                    }
                    case "haveinhand": {
                        event.setFormatValue((Object)actObjStatBo.getHaveInHand());
                        break;
                    }
                    case "completed": {
                        event.setFormatValue((Object)actObjStatBo.getCompleted());
                        break;
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)parentView.getFormShowParameter().getFormId(), (CharSequence)"epa_scheme")) {
            this.processEmptyDataPage();
        }
    }

    private void processEmptyDataPage() {
        long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Object[] activityDys = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryActivityBySchemeId(Long.valueOf(schemeId));
        if (ObjectUtils.isEmpty((Object[])activityDys)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billlistap"});
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_activitylistemppage");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("flexpanelap1");
            showParameter.setHasRight(true);
            this.getView().showForm(showParameter);
            this.getView().getPageCache().put(ACTIVITY_LIST_EMP_PAGE, showParameter.getPageId());
        } else {
            IFormView view;
            String empPageId = this.getView().getPageCache().get(ACTIVITY_LIST_EMP_PAGE);
            if (!StringUtils.isEmpty((CharSequence)empPageId) && (view = this.getView().getView(empPageId)) != null) {
                view.close();
                this.getView().sendFormAction(view);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"billlistap"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setListBgColor(this.getView(), "#f2f2f2");
    }

    private boolean checkItemPermission() {
        DynamicObject manager;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return true;
        }
        String pageId = parentView.getPageId();
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty((Object)(manager = this.getManagerData()))) {
            String manageItems = manager.getString("manageitems");
            return manageItems.contains("2");
        }
        return true;
    }

    private DynamicObject getManagerData() {
        long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(Long.valueOf(schemeId), sysUserId);
    }

    private void showJoinPage(String tabkey, String labid, String assessstaus) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_processmanage");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(this.getFocusRowPkId());
        baseShowParameter.setPageId(this.getFocusRowPkId().toString());
        baseShowParameter.setCustomParam("tabkey", (Object)tabkey);
        baseShowParameter.setCustomParam("labid", (Object)labid);
        baseShowParameter.setCustomParam("assessstaus", (Object)assessstaus);
        baseShowParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getFocusRowPkId());
        String activityName = ((BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo().getName();
        String caption = String.format(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406-%s", (String)"AssessActivityConfList_23", (String)"opmc-epa-formplugin", (Object[])new Object[0]), activityName);
        baseShowParameter.setCaption(caption);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageData = event.getPageData();
        List longList = pageData.stream().map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        this.actObjStatusMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.countActObjStatusByActivityIds(longList);
    }

    private void startUpAddEvaluationObjects(Long activityId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("activity_id", activityId);
        ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, StartUpActivityAddActObjectTask.class.getName(), ResManager.loadKDString((String)"\u542f\u52a8\u6d3b\u52a8", (String)"AssessActivityConfList_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "auto_add_evaluation_objects");
    }
}

